/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.token.KerberosServiceTicketImpl;
import com.ibm.ws.security.token.KerberosTokenImpl;
import com.ibm.ws.security.token.WSSMarkerObject;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSProtocolPolicyCallback;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.KerberosToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class wsMapCSIv2OutboundLoginModule
implements LoginModule {
    private Subject subject;
    private Subject invocation_subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private TokenHolder opaqueTokenHolder = null;
    private ContextManager contextManager;
    private AuthorizationToken authzToken = null;
    private SingleSignonToken ssoToken = null;
    private AuthenticationToken authToken = null;
    private KerberosToken kerberosToken = null;
    private CSIv2PerformPolicy csiv2PerformPolicy = null;
    protected boolean debug = false;
    protected boolean ssoEnabled = false;
    private boolean wssTokenPropagationEnabled = false;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private String OID = null;
    private static final TraceComponent tc = Tr.register(wsMapCSIv2OutboundLoginModule.class, null, "com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$token$WSSMarkerObject;

    public wsMapCSIv2OutboundLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "wsMapCSIv2OutboundLoginModule()");
            Tr.exit(tc, "wsMapCSIv2OutboundLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")");
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = map;
            this.options = map2;
            try {
                Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
                this.ssoEnabled = bl != null ? bl : false;
                this.OID = (String)SecurityConfig.getConfig().getValue("security.authMechOID");
                this.contextManager = ContextManagerFactory.getInstance();
                if (this.contextManager != null) {
                    this.contextManager.clearRootException();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.initialize", "159", this);
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception initializing wsMapCSIv2OutboundLoginModule.", new Object[]{exception});
            }
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        block32: {
            WSSMarkerObject wSSMarkerObject;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            if ((wSSMarkerObject = this.getWSSMarkerFromSubject(this.subject)) != null && wSSMarkerObject.isEnabled()) {
                this.wssTokenPropagationEnabled = true;
            }
            if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.wssTokenPropagationEnabled) {
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "Attribute propagation disabled locally.");
                }
                this.succeeded = true;
                return this.succeeded;
            }
            this.succeeded = false;
            if (this.commitSucceeded) {
                if (this.debug || tc.isDebugEnabled()) {
                    Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
                }
                this.cleanup();
            }
            Callback[] callbackArray = null;
            if (!this.sharedState.containsKey("Callback")) {
                if (this.callbackHandler == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                callbackArray = new Callback[]{new WSProtocolPolicyCallback("Protocol Policy Callback: ")};
                try {
                    this.callbackHandler.handle(callbackArray);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "236", this);
                    Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), iOException});
                    this.contextManager.setRootException(iOException);
                    this.succeeded = false;
                    throw new WSLoginFailedException("IOException: " + iOException.getMessage(), iOException);
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                    FFDCFilter.processException((Throwable)unsupportedCallbackException, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "244", this);
                    Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
                    this.contextManager.setRootException(unsupportedCallbackException);
                    this.succeeded = false;
                    throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + unsupportedCallbackException.getMessage(), unsupportedCallbackException);
                }
                this.sharedState.put("Callback", callbackArray);
            } else {
                callbackArray = (Callback[])this.sharedState.get("Callback");
            }
            this.csiv2PerformPolicy = (CSIv2PerformPolicy)((WSProtocolPolicyCallback)callbackArray[0]).getProtocolPolicy();
            try {
                if (this.wssTokenPropagationEnabled || this.csiv2PerformPolicy.performAuthorizationToken()) {
                    String string = null;
                    if (this.csiv2PerformPolicy != null) {
                        string = this.csiv2PerformPolicy.getServiceCfgList();
                    }
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(this.subject);
                    if ((this.wssTokenPropagationEnabled || string != null) && wSCredential != null && wSCredential.isForwardable()) {
                        Object object;
                        block31: {
                            if (this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "The following ServiceConfiguration list was received: " + string);
                            }
                            if (!wSCredential.isBasicAuth()) {
                                try {
                                    object = wSCredential;
                                    boolean bl = this.ssoEnabled;
                                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)object, bl){
                                        private final /* synthetic */ WSCredential val$wsCredPriv;
                                        private final /* synthetic */ boolean val$ssoEnabledPriv;
                                        {
                                            this.val$wsCredPriv = wSCredential;
                                            this.val$ssoEnabledPriv = bl;
                                        }

                                        public Object run() throws WSSecurityException, WSLoginFailedException, CredentialExpiredException {
                                            Object object;
                                            AuthorizationToken authorizationToken = SubjectHelper.getDefaultAuthzTokenFromSubject(wsMapCSIv2OutboundLoginModule.this.subject);
                                            AuthenticationToken authenticationToken = SubjectHelper.getDefaultAuthTokenFromSubject(wsMapCSIv2OutboundLoginModule.this.subject);
                                            SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(wsMapCSIv2OutboundLoginModule.this.subject);
                                            KerberosToken kerberosToken = SubjectHelper.getDefaultKerberosTokenFromSubject(wsMapCSIv2OutboundLoginModule.this.subject);
                                            if (authorizationToken == null) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Creating AuthorizationToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.authzToken = wsMapCSIv2OutboundLoginModule.this.contextManager.getWSCredTokenMapper().createAuthzTokenFromWSCredential(this.val$wsCredPriv);
                                            }
                                            if (authenticationToken == null && this.val$wsCredPriv.getCredentialToken() != null) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Creating AuthenticationToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.authToken = wsMapCSIv2OutboundLoginModule.this.contextManager.getWSCredTokenMapper().createAuthTokenFromWSCredential(this.val$wsCredPriv);
                                            }
                                            if (singleSignonToken == null && this.val$ssoEnabledPriv) {
                                                if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Creating SingleSignonToken for outbound request.");
                                                }
                                                wsMapCSIv2OutboundLoginModule.this.ssoToken = wsMapCSIv2OutboundLoginModule.this.contextManager.getWSCredTokenMapper().createSSOTokenFromWSCredential(this.val$wsCredPriv);
                                                object = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.processType");
                                                if (object != null && (((String)object).equals("ManagedProcess") || ((String)object).equals("UnManagedProcess"))) {
                                                    String string = (String)SecurityConfig.getConfig().getValue("process.serverName");
                                                    if (string != null) {
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("process.serverName", string);
                                                    } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Cannot add serverName to SSO token, config property is null.");
                                                    }
                                                    Properties properties = (Properties)SecurityConfig.getConfig().getValue("process.jmxConnectorProps");
                                                    if (properties != null) {
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("type", (String)properties.get("type"));
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("host", (String)properties.get("host"));
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("port", (String)properties.get("port"));
                                                    } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                        Tr.debug(tc, "Cannot add connectorProps to SSO token, config property is null.");
                                                    }
                                                    long l = this.val$wsCredPriv.getExpiration();
                                                    if (l <= 0L) {
                                                        Long l2 = (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate");
                                                        long l3 = l2 * 60L * 1000L;
                                                        l = System.currentTimeMillis() + l3;
                                                    }
                                                    wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("expire", Long.toString(l));
                                                    if (wsMapCSIv2OutboundLoginModule.this.kerberosToken != null) {
                                                        if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                            Tr.debug(tc, "gssCredential exists, mark SSO token");
                                                        }
                                                        wsMapCSIv2OutboundLoginModule.this.ssoToken.addAttribute("security.ltpa.sso.spnego", "true");
                                                    }
                                                } else if (wsMapCSIv2OutboundLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Not adding connector properties to SSO token, process type: " + (String)object);
                                                }
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.authzToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authzToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.authzToken);
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.authToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.authToken);
                                            }
                                            if (wsMapCSIv2OutboundLoginModule.this.ssoToken != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.ssoToken)) {
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.ssoToken);
                                            }
                                            if (kerberosToken != null) {
                                                object = new KerberosServiceTicketImpl((KerberosTokenImpl)kerberosToken, wsMapCSIv2OutboundLoginModule.this.csiv2PerformPolicy);
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(kerberosToken);
                                                wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(object);
                                            }
                                            return null;
                                        }
                                    });
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    FFDCFilter.processException(privilegedActionException.getException(), "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule", "393");
                                    if (!tc.isDebugEnabled()) break block31;
                                    Tr.debug(tc, "Error creating default authz and auth tokens.", new Object[]{privilegedActionException.getException()});
                                }
                            }
                        }
                        if ((object = (Object)WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(this.subject)) != null) {
                            this.opaqueTokenHolder = new TokenHolder((byte[])object, WSOpaqueTokenHelper.getInstance().getOpaqueTokenName(), WSOpaqueTokenHelper.getInstance().getOpaqueTokenVersion());
                            this.sharedState.put("WSOPAQUE", this.opaqueTokenHolder);
                            if (this.debug || tc.isEntryEnabled()) {
                                Tr.exit(tc, "Opaque token generated, propagating security attributes.");
                            }
                        } else if (this.debug || tc.isEntryEnabled()) {
                            Tr.exit(tc, "Opaque token is null, not propagating security attributes.");
                        }
                        break block32;
                    }
                    if (this.debug || tc.isEntryEnabled()) {
                        Tr.exit(tc, "Not processing the authz token.", new Object[]{string, wSCredential});
                    }
                    break block32;
                }
                if (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.csiv2PerformPolicy.performAuthorizationToken() && (this.debug || tc.isDebugEnabled())) {
                    Tr.debug(tc, "Target server does not support authorization token.");
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.login", "426", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "WSLoginFailedException creating SAP tokens from WSCredential.", new Object[]{wSLoginFailedException});
                }
                this.succeeded = false;
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.login", "433", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "Exception creating SAP tokens from WSCredential.", new Object[]{exception});
                }
                this.succeeded = false;
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login() succeeded.");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.wssTokenPropagationEnabled) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute propagation is disabled locally.");
            }
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "commit()");
            }
            this.commitSucceeded = true;
            return this.commitSucceeded;
        }
        if (WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() && !this.csiv2PerformPolicy.performAuthorizationToken() && !this.wssTokenPropagationEnabled) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute propagation is disabled remotely.");
            }
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "commit()");
            }
            this.commitSucceeded = true;
            return this.commitSucceeded;
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                if (this.opaqueTokenHolder == null) {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Authorization token is null, returning from commit.");
                    }
                    this.commitSucceeded = true;
                    return this.commitSucceeded;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                                if (wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder != null && !wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder)) {
                                    wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().add(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.commit", "536", this);
                        this.contextManager.setRootException(privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.commit", "551", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        this.authToken = null;
        this.authzToken = null;
        this.ssoToken = null;
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "abort()");
            }
            return true;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) {
            if (this.debug || tc.isEntryEnabled()) {
                Tr.exit(tc, "abort()");
            }
            return true;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.wssTokenPropagationEnabled = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing AuthorizationToken from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.opaqueTokenHolder);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.authToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.authToken);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.authzToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.authzToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.authzToken);
                    }
                    if (wsMapCSIv2OutboundLoginModule.this.ssoToken != null && wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().contains(wsMapCSIv2OutboundLoginModule.this.ssoToken)) {
                        wsMapCSIv2OutboundLoginModule.this.subject.getPrivateCredentials().remove(wsMapCSIv2OutboundLoginModule.this.ssoToken);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.cleanup", "717", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.opaqueTokenHolder = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private WSSMarkerObject getWSSMarkerFromSubject(final Subject subject) {
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject is null, so no WSSMarkerObject returned.");
            }
            return null;
        }
        WSSMarkerObject wSSMarkerObject = null;
        try {
            wSSMarkerObject = (WSSMarkerObject)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Iterator iterator;
                    Set set = subject.getPrivateCredentials(class$com$ibm$ws$security$token$WSSMarkerObject == null ? (class$com$ibm$ws$security$token$WSSMarkerObject = wsMapCSIv2OutboundLoginModule.class$("com.ibm.ws.security.token.WSSMarkerObject")) : class$com$ibm$ws$security$token$WSSMarkerObject);
                    if (set != null && set.size() > 0 && (iterator = set.iterator()).hasNext()) {
                        Object t = iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WSSMarkerObject present in Subject.");
                        }
                        return (WSSMarkerObject)t;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSSMarkerObject not present in Subject.");
                    }
                    return null;
                }
            });
            return wSSMarkerObject;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.server.lm.wsMapCSIv2OutboundLoginModule.getWSSMarkerFromSubject", "782");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting WSSMarkerObject from Subject.", new Object[]{exception});
            }
            return null;
        }
    }
}

