/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.security.spnego.FailoverException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.ietf.jgss.GSSCredential;

public class CredentialManager
implements HttpSessionListener {
    private static Hashtable table;
    private static final String ME;
    private static final Logger logger;

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "sessionCreated", httpSessionEvent.getSession().getId());
            logger.exiting(ME, "sessionCreated");
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "sessionDestroyed", httpSession);
        }
        String string = CredentialManager.removeDelegatedCredential(httpSession);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "sessionDestroyed", "Session id: " + string);
        }
    }

    public static String addDelegatedCredential(HttpSession httpSession, GSSCredential gSSCredential) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "addDelegatedCredential");
        }
        Long l = new Long(System.currentTimeMillis());
        String string = httpSession.getId();
        httpSession.setAttribute("com.ibm.ws.security.spnego.TimeOfStoredCredential", (Object)l);
        table.put(string, gSSCredential);
        String string2 = "TIMESTAMP" + string;
        table.put(string2, l);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "addDelegatedCredential", "Session id: " + string);
        }
        return string;
    }

    private static String removeDelegatedCredential(HttpSession httpSession) {
        String string = httpSession.getId();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "removeDelegatedCredential", string);
        }
        table.remove(string);
        String string2 = "TIMESTAMP" + string;
        table.remove(string2);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "removeDelegatedCredential");
        }
        return string;
    }

    public static GSSCredential getDelegatedCredential(HttpSession httpSession) throws FailoverException {
        String string = httpSession.getId();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getDelegatedCredential", string);
        }
        Long l = (Long)httpSession.getAttribute("com.ibm.ws.security.spnego.TimeOfStoredCredential");
        GSSCredential gSSCredential = (GSSCredential)table.get(string);
        if (gSSCredential == null || l == null) {
            CredentialManager.removeDelegatedCredential(httpSession);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "getDelegatedCredential", "No delegated credentials were found");
            }
            throw new FailoverException();
        }
        Long l2 = (Long)table.get("TIMESTAMP" + string);
        if (!l2.equals(l)) {
            CredentialManager.removeDelegatedCredential(httpSession);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "getDelegatedCredential", "Stale credentials were found");
            }
            throw new FailoverException();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "getDelegatedCredential", gSSCredential);
        }
        return gSSCredential;
    }

    static {
        ME = CredentialManager.class.getName();
        logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
        table = new Hashtable();
    }
}

