/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.security.spnego.CredentialManager;
import com.ibm.ws.security.spnego.FailoverException;
import com.ibm.ws.security.spnego.KerberosSSOException;
import com.ibm.ws.security.util.Base64Coder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class DelegatedCredentialExtractor {
    private static final Oid SPNEGOMECHOID;
    private static final Oid KRB5MECHANISMOID;
    private static String LtpaToken;
    private static final String ME;
    private static final Logger logger;

    private DelegatedCredentialExtractor() {
    }

    public static String getSpnegoAuthorizationToken(HttpSession httpSession, String string, String string2) throws KerberosSSOException, FailoverException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getSpnegoAuthorizationToken");
        }
        GSSCredential gSSCredential = CredentialManager.getDelegatedCredential(httpSession);
        String string3 = DelegatedCredentialExtractor.buildSpnegoAuthorizationString(gSSCredential, string, string2);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "getSpnegoAuthorizationToken", "Delegated credentials returned");
        }
        return string3;
    }

    private static String buildSpnegoAuthorizationString(GSSCredential gSSCredential, String string, String string2) throws KerberosSSOException {
        String string3;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "buildSpnegoAuthorizationString");
        }
        if (string == null || string2 == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "Unable to build SPN with null fields");
            }
            throw new KerberosSSOException("Unable to build SPN with null fields");
        }
        String string4 = "HTTP/" + string + "@" + string2;
        try {
            GSSManager gSSManager = GSSManager.getInstance();
            if (gSSManager == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "Unable to get Default GSSManager instance");
                }
                throw new KerberosSSOException("Unable to get Default GSSManager instance");
            }
            GSSName gSSName = gSSManager.createName(string4, GSSName.NT_USER_NAME);
            gSSName = gSSName.canonicalize(SPNEGOMECHOID);
            GSSContext gSSContext = gSSManager.createContext(gSSName, SPNEGOMECHOID, gSSCredential, Integer.MAX_VALUE);
            gSSContext.requestMutualAuth(true);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "GSSContext " + gSSContext);
            }
            byte[] byArray = null;
            byte[] byArray2 = null;
            int n = 0;
            byArray2 = gSSContext.initSecContext(byArray, 0, n);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "initSecContext done");
            }
            string3 = "Negotiate " + new String(Base64Coder.base64Encode(byArray2));
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "SPNEGO token\n" + string3);
            }
            gSSContext.dispose();
        }
        catch (GSSException gSSException) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "buildSpnegoAuthorizationString - GSSException received " + gSSException.getMessage());
            }
            throw new KerberosSSOException(gSSException.getMessage());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "buildSpnegoAuthorizationString", string3);
        }
        return string3;
    }

    public static void relogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "relogin");
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String string = null;
        String string2 = null;
        boolean bl = false;
        for (int i = 0; i < cookieArray.length; ++i) {
            object = cookieArray[i];
            String string3 = object.getName();
            if (!string3.equals(LtpaToken) || bl) continue;
            string = object.getPath();
            string2 = object.getDomain();
            bl = true;
        }
        Cookie cookie = new Cookie(LtpaToken, "");
        cookie.setMaxAge(0);
        cookie.setDomain(string2);
        cookie.setPath(string);
        httpServletResponse.addCookie(cookie);
        object = httpServletRequest.getRequestURL().toString();
        if (bl) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "relogin", "Redirect back to this ourselves, the TAI should be engaged now!" + (String)object);
            }
            httpServletResponse.sendRedirect((String)object);
        } else {
            logger.logp(Level.WARNING, ME, "relogin", "security.spnego.no.LtpaToken.found", new Object[]{httpServletRequest.getUserPrincipal()});
        }
    }

    static {
        LtpaToken = "LtpaToken";
        ME = DelegatedCredentialExtractor.class.getName();
        logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
        Oid oid = null;
        try {
            oid = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException gSSException) {
            oid = null;
        }
        KRB5MECHANISMOID = oid;
        try {
            oid = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gSSException) {
            oid = null;
        }
        SPNEGOMECHOID = oid;
    }
}

