/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

class PageLoader {
    private static final String ME = PageLoader.class.getName();
    private static final Logger logger = Logger.getLogger(PageLoader.class.getName(), "com.ibm.ws.security.spnego.resources.TAIMsgs");
    static String defaultContentEncoding = null;
    private static final String HTTP_CONTENT_ENCODING_MARKER = ";charset=";
    private final transient String id;
    private final transient String defaultPageContent;
    private transient String urlName;
    private transient String contentType;
    private transient String contentEncoding;
    transient String content;

    PageLoader(String string, String string2) {
        this.id = string;
        this.defaultPageContent = string2;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "PageLoader", this);
        }
    }

    public String toString() {
        return this.id;
    }

    void reset() {
        this.contentType = null;
        this.contentEncoding = null;
        this.urlName = null;
        this.content = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "reset", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadPage() {
        block35: {
            block31: {
                block34: {
                    block30: {
                        var1_1 = null;
                        var2_2 = null;
                        var3_3 = null;
                        try {
                            try {
                                if (PageLoader.logger.isLoggable(Level.FINER)) {
                                    PageLoader.logger.entering(PageLoader.ME, "loadPage", new Object[]{this, this.urlName});
                                }
                                if (this.urlName != null && (var5_6 = (var4_4 = new URL(this.urlName)).openConnection()) != null) {
                                    var1_1 = var5_6.getInputStream();
                                    this.contentType = var5_6.getContentType();
                                    if (PageLoader.logger.isLoggable(Level.FINER)) {
                                        PageLoader.logger.logp(Level.FINER, PageLoader.ME, "loadPage", "contentType: {0}", this.contentType);
                                    }
                                    if (this.contentType == null || "content/unknown".equalsIgnoreCase(this.contentType)) {
                                        this.contentType = "text/*";
                                    }
                                    this.contentEncoding = var5_6.getContentEncoding();
                                    if (this.contentEncoding == null) {
                                        this.contentEncoding = this.getContentEncodingFromHttpContentType(this.contentType);
                                    }
                                    if (this.contentEncoding == null) {
                                        this.contentEncoding = this.getDefaultContentEncoding();
                                    }
                                    if (PageLoader.logger.isLoggable(Level.FINEST)) {
                                        PageLoader.logger.logp(Level.FINEST, PageLoader.ME, "loadPage", "contentEncoding: {0}", this.contentEncoding);
                                    }
                                    var2_2 = new InputStreamReader(var1_1, this.contentEncoding);
                                    var3_3 = new BufferedReader(var2_2);
                                    var7_7 = new StringBuffer();
                                    while ((var6_8 = var3_3.readLine()) != null) {
                                        var7_7.append(var6_8);
                                        var7_7.append("\r\n");
                                    }
                                    this.content = var7_7.toString();
                                    var9_9 = null;
                                    break block30;
                                }
                                this.setDefaults();
                                break block31;
                            }
                            catch (Exception var4_5) {
                                block32: {
                                    FFDCFilter.processException((Throwable)var4_5, PageLoader.ME + ".loadPage", "175", this);
                                    PageLoader.logger.logp(Level.WARNING, PageLoader.ME, "loadPage", "security.spnego.no.content.loaded", new Object[]{this.urlName, var4_5});
                                    this.setDefaults();
                                    var9_11 = null;
                                    try {
                                        if (var3_3 != null) {
                                            var3_3.close();
                                        }
                                        if (var2_2 != null) {
                                            var2_2.close();
                                        }
                                        if (var1_1 != null) {
                                            var1_1.close();
                                        }
                                    }
                                    catch (IOException var10_15) {
                                        if (!PageLoader.logger.isLoggable(Level.FINE)) break block32;
                                        PageLoader.logger.logp(Level.FINE, PageLoader.ME, "loadPage", "failed to clean up a stream", var10_15);
                                    }
                                }
                                if (PageLoader.logger.isLoggable(Level.FINER) == false) return;
                                PageLoader.logger.exiting(PageLoader.ME, "loadPage");
                                return;
                            }
                        }
                        catch (Throwable var8_17) {
                            block33: {
                                var9_12 = null;
                                ** try [egrp 2[TRYBLOCK] [6 : 389->416)] { 
lbl62:
                                // 1 sources

                                if (var3_3 != null) {
                                    var3_3.close();
                                }
                                if (var2_2 != null) {
                                    var2_2.close();
                                }
                                if (var1_1 != null) {
                                    var1_1.close();
                                }
                                break block33;
lbl69:
                                // 1 sources

                                catch (IOException var10_16) {
                                    if (!PageLoader.logger.isLoggable(Level.FINE)) break block33;
                                    PageLoader.logger.logp(Level.FINE, PageLoader.ME, "loadPage", "failed to clean up a stream", var10_16);
                                }
                            }
                            if (PageLoader.logger.isLoggable(Level.FINER) == false) throw var8_17;
                            PageLoader.logger.exiting(PageLoader.ME, "loadPage");
                            throw var8_17;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 389->416)] { 
lbl78:
                    // 1 sources

                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    if (var1_1 != null) {
                        var1_1.close();
                    }
                    break block34;
lbl85:
                    // 1 sources

                    catch (IOException var10_13) {
                        if (!PageLoader.logger.isLoggable(Level.FINE)) break block34;
                        PageLoader.logger.logp(Level.FINE, PageLoader.ME, "loadPage", "failed to clean up a stream", var10_13);
                    }
                }
                if (PageLoader.logger.isLoggable(Level.FINER) == false) return;
                PageLoader.logger.exiting(PageLoader.ME, "loadPage");
                return;
            }
            var9_10 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 389->416)] { 
lbl95:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            if (var2_2 != null) {
                var2_2.close();
            }
            if (var1_1 != null) {
                var1_1.close();
            }
            break block35;
lbl102:
            // 1 sources

            catch (IOException var10_14) {
                if (!PageLoader.logger.isLoggable(Level.FINE)) break block35;
                PageLoader.logger.logp(Level.FINE, PageLoader.ME, "loadPage", "failed to clean up a stream", var10_14);
            }
        }
        if (PageLoader.logger.isLoggable(Level.FINER) == false) return;
        PageLoader.logger.exiting(PageLoader.ME, "loadPage");
    }

    private final String getContentEncodingFromHttpContentType(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.indexOf(HTTP_CONTENT_ENCODING_MARKER)) > -1 && n < string.length() - HTTP_CONTENT_ENCODING_MARKER.length() && !this.isValidEncoding(string2 = string.substring(n + HTTP_CONTENT_ENCODING_MARKER.length()))) {
            string2 = null;
        }
        return string2;
    }

    private final String getDefaultContentEncoding() {
        if (defaultContentEncoding == null) {
            this.synchGetDefaultContentEncoding();
        }
        return defaultContentEncoding;
    }

    private final synchronized void synchGetDefaultContentEncoding() {
        if (defaultContentEncoding == null && !this.isValidEncoding(defaultContentEncoding = System.getProperty("file.encoding"))) {
            defaultContentEncoding = null;
        }
        if (defaultContentEncoding == null) {
            defaultContentEncoding = "UTF-8";
        }
    }

    private final boolean isValidEncoding(String string) {
        return Charset.forName(string) != null;
    }

    private final void setDefaults() {
        this.urlName = null;
        this.content = this.defaultPageContent;
        this.contentType = "text/html";
        this.contentEncoding = "UTF-8";
    }

    private final void checkLoaded() {
        if (this.content == null) {
            this.loadPage();
        }
    }

    String getContentType() {
        this.checkLoaded();
        return this.contentType;
    }

    String getEncoding() {
        this.checkLoaded();
        return this.contentEncoding;
    }

    String getContent() {
        this.checkLoaded();
        return this.content;
    }

    String getUrlName() {
        return this.urlName;
    }

    void setUrlName(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setUrlName", new Object[]{this, string});
        }
        this.urlName = string;
    }
}

