/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.spnego.PageLoader;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.wsspi.security.spnego.SpnegoTAIFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class ServerConfig {
    private static final short STR_LENGTH = 200;
    private static final String _SPNEGO_NOT_SUPPORTED_DEFAULT = "<html><head><title>SPNEGO authentication is not supported.</title></head><body>SPNEGO authentication is not supported on this client.</body></html>";
    private static final String _SPNEGO_NOT_SUPPORTED_PAGE_CONTENT = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.AdminCommandText", "security.spnego.page.content.spnego.not.supported", new Object[0], "<html><head><title>SPNEGO authentication is not supported.</title></head><body>SPNEGO authentication is not supported on this client.</body></html>");
    private PageLoader spnegoNotSupportedPageLoader = new PageLoader("security.spnego.page.content.spnego.not.supported", _SPNEGO_NOT_SUPPORTED_PAGE_CONTENT);
    private static final String _NTLM_TOKEN_RECEIVED_DEFAULT = "<html><head><title>An NTLM Token was received.</title></head><body>Your browser configuration is correct, but you have not logged into a supported Windows Domain.<p>Please login to the application using the normal login page.</html>";
    private static final String _NTLM_TOKEN_RECEIVED_PAGE_CONTENT = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.AdminCommandText", "security.spnego.page.content.ntlm.token.received", new Object[0], "<html><head><title>An NTLM Token was received.</title></head><body>Your browser configuration is correct, but you have not logged into a supported Windows Domain.<p>Please login to the application using the normal login page.</html>");
    private PageLoader ntlmTokenReceivedPageLoader = new PageLoader("security.spnego.page.content.ntlm.token.received", _NTLM_TOKEN_RECEIVED_PAGE_CONTENT);
    private boolean enableCredDelegate;
    private String filter;
    private SpnegoTAIFilter filterClass;
    private Oid gssNameType;
    private int gssCredType;
    private int gssCredDuration;
    private String hostName;
    private String realm;
    private String serverName;
    private static final String ME = ServerConfig.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private boolean trimUserName;
    boolean useDefaultFilter = true;

    public ServerConfig() {
        logger.entering(ME, "<constructor>");
        this.enableCredDelegate = false;
        this.trimUserName = true;
        this.gssNameType = GSSName.NT_USER_NAME;
        this.gssCredType = 2;
        this.gssCredDuration = Integer.MAX_VALUE;
        this.spnegoNotSupportedPageLoader.reset();
        this.ntlmTokenReceivedPageLoader.reset();
        String string = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.spnego.useHttpFilterClass2");
        boolean bl = false;
        bl = new Boolean(string);
        if (bl) {
            this.useDefaultFilter = false;
        }
        logger.exiting(ME, "<constructor>: useDefaultFilter: " + this.useDefaultFilter);
    }

    public SpnegoTAIFilter getFilterClass() {
        return this.filterClass;
    }

    public int getGssCredDuration() {
        return this.gssCredDuration;
    }

    public int getGssCredType() {
        return this.gssCredType;
    }

    public Oid getGssNameType() {
        return this.gssNameType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getNTLMTokenReceivedPage() {
        return this.ntlmTokenReceivedPageLoader.getContent();
    }

    public String getRealm() {
        return this.realm;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getSpnegoNotSupportedPage() {
        return this.spnegoNotSupportedPageLoader.getContent();
    }

    public boolean isEnableCredDelegate() {
        return this.enableCredDelegate;
    }

    public boolean isTrimUserName() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isTrimUserName", "isTrimUserName = " + this.trimUserName);
        }
        return this.trimUserName;
    }

    public void setEnableCredDelegate(String string) {
        Boolean bl = Boolean.valueOf(string);
        this.enableCredDelegate = bl;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setEnableCredDelegate");
            logger.exiting(ME, "setEnableCredDelegate", bl);
        }
    }

    public void setFilter(String string, SpnegoTAIFilter spnegoTAIFilter) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setFilter", new Object[]{"filter string='" + string + "'", "filter class=" + spnegoTAIFilter});
        }
        if (string == null || string.length() == 0) {
            logger.logp(Level.FINER, ME, "setFilter", "Since no filter is defined, we force all requests to be processed");
            spnegoTAIFilter.setProcessAll(true);
        } else {
            spnegoTAIFilter.init(string);
        }
        this.filter = string;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setFilter");
        }
    }

    public void setFilterClass(String string) throws TAIConfigurationException {
        ExtClassLoader extClassLoader;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setFilterClass", string);
        }
        if (string == null || string.length() == 0) {
            string = !this.useDefaultFilter ? "com.ibm.ws.security.spnego.HTTPHeaderFilter2" : "com.ibm.ws.security.spnego.HTTPHeaderFilter";
        }
        if ((extClassLoader = ExtClassLoader.getInstance()) == null) {
            throw new TAIConfigurationException("Classloader initialization error");
        }
        try {
            Class<?> clazz = Class.forName(string, true, (ClassLoader)extClassLoader);
            this.filterClass = (SpnegoTAIFilter)clazz.newInstance();
            if (!(this.filterClass instanceof SpnegoTAIFilter)) {
                throw new TAIConfigurationException("Wrong FilterClass implementation");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TAIConfigurationException("FilterClass could not be found: " + string);
        }
        catch (Exception exception) {
            throw new TAIConfigurationException("Error initializing the FilterClass");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setFilterClass", "FilterClass set to " + this.filterClass.getClass());
        }
    }

    public void setGssCredDuration(String string) {
        String string2;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssCredDuration", string);
        }
        if (string.trim().equalsIgnoreCase("DEFAULT")) {
            this.gssCredDuration = 0;
            string2 = "GSSCredential.DEFAULT_LIFETIME";
        } else {
            this.gssCredDuration = Integer.MAX_VALUE;
            string2 = "GSSCredential.INDEFINITE_LIFETIME";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssCredDuration", "Credential duration set to " + string2);
        }
    }

    public void setGssCredType(String string) {
        String string2;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssCredType", string);
        }
        if ((string = string.trim()).equalsIgnoreCase("INITIATE")) {
            this.gssCredType = 1;
            string2 = "GSSCredential.INITIATE_ONLY";
        } else if (string.equalsIgnoreCase("BOTH")) {
            this.gssCredType = 0;
            string2 = "GSSCredential.INITIATE_AND_ACCEPT";
        } else {
            this.gssCredType = 2;
            string2 = "GSSCredential.ACCEPT_ONLY";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssCredType", "Credential type set to " + string2);
        }
    }

    public void setGssNameType(String string) {
        String string2;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssNameType", string);
        }
        if (string.trim().equalsIgnoreCase("NT_HOSTBASED_SERVICE")) {
            this.gssNameType = GSSName.NT_HOSTBASED_SERVICE;
            string2 = "GSSName.NT_HOSTBASED_SERVICE";
        } else {
            this.gssNameType = GSSName.NT_USER_NAME;
            string2 = "GSSName.NT_USER_NAME";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssNameType", "Credential name type set to " + string2);
        }
    }

    public void setNTLMTokenReceivedPage(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setNTLMTokenReceivedPage", string);
        }
        this.ntlmTokenReceivedPageLoader.setUrlName(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setNTLMTokenReceivedPage");
        }
    }

    public void setRealm(String string) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setRealm", string);
        }
        if (string == null) {
            throw new TAIConfigurationException("Kerberos Realm property is not set");
        }
        this.realm = string.toUpperCase().trim();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setRealm", "Kerberos realm set to " + this.realm);
        }
    }

    public void setServerName(String string) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setServerName", string);
        }
        if (string == null) {
            throw new TAIConfigurationException("Required property HostName is not set");
        }
        this.hostName = string = string.trim();
        this.serverName = string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.gssNameType == GSSName.NT_HOSTBASED_SERVICE) {
            stringBuffer.append("HTTP@");
            stringBuffer.append(string);
        } else if (this.gssNameType == GSSName.NT_USER_NAME) {
            stringBuffer.append("HTTP/");
            stringBuffer.append(string);
            stringBuffer.append("@");
            stringBuffer.append(this.realm);
        }
        this.serverName = stringBuffer.toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setServerName", "hostName = " + this.hostName + "; serverName = " + this.serverName);
        }
    }

    public void setSpnegoNotSupportedPage(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setSpnegoNotSupportedPage", string);
        }
        this.spnegoNotSupportedPageLoader.setUrlName(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setSpnegoNotSupportedPage");
        }
    }

    public void setTrimUserName(String string) {
        this.trimUserName = Boolean.valueOf(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setTrimUserName", string);
            logger.exiting(ME, "setTrimUserName");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = "com.ibm.ws.security.spnego.SPN";
        stringBuffer.append("\t").append("Server configuration:");
        stringBuffer.append("\n\tKerberos ServicePrincipalName=").append(this.getServerName());
        stringBuffer.append("\n\t").append(string + ".filter" + "=").append(this.filter);
        stringBuffer.append("\n\t").append(string + ".filterClass" + "=").append(this.getFilterClass());
        stringBuffer.append("\n\t").append(string + ".NTLMTokenReceivedPage" + "=").append(this.ntlmTokenReceivedPageLoader.getUrlName());
        stringBuffer.append("\n\t").append(string + ".spnegoNotSupportedPage" + "=").append(this.spnegoNotSupportedPageLoader.getUrlName());
        return stringBuffer.toString();
    }

    public String getNtlmTokenReceivedPageContentType() {
        String string = this.ntlmTokenReceivedPageLoader.getContentType();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getNtlmTokenReceivedPageContentType", "contentType: " + string);
        }
        return string;
    }

    public String getSpnegoNotSupportedPageContentType() {
        String string = this.spnegoNotSupportedPageLoader.getContentType();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getSpnegoNotSupportedPageContentType", "contentType: " + string);
        }
        return string;
    }
}

