/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.spnego.AllServerConfigs;
import com.ibm.ws.security.spnego.ServerConfig;
import com.ibm.ws.security.spnego.ServerCredentialsFactory;
import com.ibm.ws.security.spnego.SpnegoHandler;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.wsspi.security.spnego.SpnegoTAIFilter;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TrustAssociationInterceptorImpl
implements TrustAssociationInterceptor {
    private static final String VERSION = "Version 6.1.0";
    private AllServerConfigs config;
    private static final String ME = TrustAssociationInterceptorImpl.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");

    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WebTrustAssociationFailedException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "negotiateValidateandEstablishTrust");
        }
        TAIResult tAIResult = null;
        try {
            tAIResult = SpnegoHandler.handleRequest(httpServletRequest, httpServletResponse, this.config);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl.negotiateValidateandEstablishTrust", "73", this);
            logger.logp(Level.SEVERE, ME, "negotiateValidateandEstablishTrust", "security.spnego.unexpected.exception", new Object[]{throwable});
            tAIResult = TAIResult.create(403);
        }
        if (tAIResult != null && tAIResult.getStatus() == 200 && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "negotiateValidateandEstablishTrust", "Authenticated user: " + tAIResult.getAuthenticatedPrincipal() + " Subject: " + tAIResult.getSubject());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "negotiateValidateandEstablishTrust", tAIResult);
        }
        return tAIResult;
    }

    public boolean isTargetInterceptor(HttpServletRequest httpServletRequest) throws WebTrustAssociationException {
        Integer n;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isTargetInterceptor");
        }
        if (!this.config.isTAIEnabled()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "isTargetInterceptor: TrustAssociationInterceptorImpl is not enabled");
            }
            return false;
        }
        String string = httpServletRequest.getServerName();
        try {
            string = this.config.getCanonicalHostname(string);
        }
        catch (UnknownHostException unknownHostException) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "isTargetInterceptor: no credentials match");
            }
            return false;
        }
        if (this.config.isIncludePortInSPN() && (n = new Integer(httpServletRequest.getServerPort())) != 80) {
            string = string + ":" + n.toString();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isTargetInterceptor", "Checking host match for " + string);
        }
        if (this.config.isReloadEnabled() && this.config.isItTimeToReload()) {
            this.config.reload();
        }
        if (!ServerCredentialsFactory.hasServerCredentialsFor(string)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "isTargetInterceptor: no credentials match");
            }
            return false;
        }
        boolean bl = false;
        ServerConfig serverConfig = this.config.getServerConfig(string);
        if (serverConfig != null) {
            SpnegoTAIFilter spnegoTAIFilter;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "isTargetInterceptor", "Got a match for the server config");
            }
            bl = (spnegoTAIFilter = serverConfig.getFilterClass()) == null ? true : spnegoTAIFilter.isAccepted(httpServletRequest);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isTargetInterceptor", "Failed to get a match for the server config");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isTargetInterceptor: " + bl);
        }
        return bl;
    }

    public int initialize(Properties properties) {
        Locale locale;
        Locale locale2;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initialize");
        }
        try {
            this.config = new AllServerConfigs(properties);
        }
        catch (TAIConfigurationException tAIConfigurationException) {
            FFDCFilter.processException((Throwable)tAIConfigurationException, "com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl.initialize", "215", this);
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.init.failed", tAIConfigurationException.getLocalizedMessage());
            logger.exiting(ME, "initialize");
            return 1;
        }
        boolean bl = Boolean.getBoolean("com.ibm.ws.security.spnego.LocaleFix");
        if (bl && !(locale2 = Locale.getDefault()).equals(locale = new Locale("en", "US"))) {
            Locale.setDefault(locale);
            logger.logp(Level.WARNING, ME, "initialize", "security.spnego.fix.locale", new Object[]{locale2.toString(), locale.toString()});
        }
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initialize", "JGSS Initialization started. For detailed JGSS debug trace set JVM property com.ibm.security.jgss.debug=all");
            }
            SpnegoHandler.initializeServerCreds(this.config);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initialize", "JGSS Initialization completed.");
            }
        }
        catch (TAIConfigurationException tAIConfigurationException) {
            FFDCFilter.processException((Throwable)tAIConfigurationException, "com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl.initialize", "248", this);
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.init.failed", new Object[]{tAIConfigurationException.getMessage(), properties});
            return 1;
        }
        logger.logp(Level.INFO, ME, "initialize", "security.spnego.init.ok", new Object[]{this.config.toString()});
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initialize");
        }
        return 0;
    }

    public void cleanup() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "cleanup");
        }
        this.config.cleanup();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "cleanup");
        }
    }

    public String getVersion() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getVersion");
            logger.exiting(ME, "getVersion", VERSION);
        }
        return VERSION;
    }

    public String getType() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getType");
        }
        String string = this.getClass().getName();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "getType", string);
        }
        return string;
    }

    protected void setConfiguration(AllServerConfigs allServerConfigs) {
        this.config = allServerConfigs;
    }
}

