/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.filter;

import com.ibm.ws.security.spnego.filter.ContainsCondition;
import com.ibm.ws.security.spnego.filter.EqualCondition;
import com.ibm.ws.security.spnego.filter.FilterException;
import com.ibm.ws.security.spnego.filter.GreaterCondition;
import com.ibm.ws.security.spnego.filter.ICondition;
import com.ibm.ws.security.spnego.filter.IRequestInfo;
import com.ibm.ws.security.spnego.filter.IValue;
import com.ibm.ws.security.spnego.filter.LessCondition;
import com.ibm.ws.security.spnego.filter.NotContainsCondition;
import com.ibm.ws.security.spnego.filter.OrCondition;
import com.ibm.ws.security.spnego.filter.RealRequestInfo;
import com.ibm.ws.security.spnego.filter.ValueAddressRange;
import com.ibm.ws.security.spnego.filter.ValueIPAddress;
import com.ibm.ws.security.spnego.filter.ValueString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class HTTPHeaderFilterBase {
    private static final String ME = HTTPHeaderFilterBase.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private boolean processAll = false;
    protected List filterCondition = new LinkedList();

    public boolean init(String string) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "init", string);
        }
        if (string == null) {
            logger.logp(Level.SEVERE, ME, "init", "security.spnego.filter.init.null.string");
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        StringTokenizer stringTokenizer2 = null;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            stringTokenizer2 = new StringTokenizer(string2, "^=!<>%");
            String string3 = stringTokenizer2.nextToken();
            if (!stringTokenizer2.hasMoreTokens()) {
                logger.logp(Level.SEVERE, ME, "init", "security.spnego.malformed.filter.condition", new Object[]{string, string2, null});
                return false;
            }
            String string4 = stringTokenizer2.nextToken();
            String string5 = string2.substring(string3.length(), string2.length() - string4.length()).trim();
            boolean bl = false;
            if ("remote-address".equals(string3)) {
                bl = true;
            }
            logger.logp(Level.FINER, ME, "isValid", "Adding " + string3 + " " + string5 + " " + string4);
            try {
                ICondition iCondition = this.makeCondition(string3, string5, string4, bl);
                this.filterCondition.add(iCondition);
            }
            catch (FilterException filterException) {
                throw new RuntimeException(filterException);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "init", Boolean.toString(true));
        }
        return true;
    }

    private ICondition makeCondition(String string, String string2, String string3, boolean bl) throws FilterException {
        if (string2.equals("==")) {
            return new EqualCondition(string, this.makeValue(string3, bl));
        }
        if (string2.equals("!=")) {
            return new NotContainsCondition(string, this.makeValue(string3, bl));
        }
        if (string2.equals("^=")) {
            OrCondition orCondition = new OrCondition(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                orCondition.addValue(this.makeValue(string4, bl));
            }
            return orCondition;
        }
        if (string2.equals("%=")) {
            return new ContainsCondition(string, this.makeValue(string3, bl));
        }
        if (string2.equals("<")) {
            return new LessCondition(string, this.makeValue(string3, bl));
        }
        if (string2.equals(">")) {
            return new GreaterCondition(string, this.makeValue(string3, bl));
        }
        logger.logp(Level.SEVERE, ME, "init", "security.spnego.malformed.filter.operator", new Object[]{string2});
        throw new FilterException("malformed filter");
    }

    private IValue makeValue(String string, boolean bl) throws FilterException {
        if (bl) {
            return new ValueAddressRange(string);
        }
        return new ValueString(string);
    }

    public boolean isAccepted(HttpServletRequest httpServletRequest) {
        return this.isAccepted(new RealRequestInfo(httpServletRequest));
    }

    public boolean isAccepted(IRequestInfo iRequestInfo) {
        String string = "TAI will intercept request.";
        boolean bl = true;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isAccepted");
        }
        if (this.processAll) {
            string = "processAll is true, therefore we always intercept.";
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "isAccepted", bl + " " + string);
            }
            return true;
        }
        String string2 = null;
        Iterator iterator = this.filterCondition.iterator();
        while (iterator.hasNext()) {
            Object object;
            ICondition iCondition = (ICondition)iterator.next();
            string2 = iRequestInfo.getHeader(iCondition.getKey());
            boolean bl2 = false;
            if (string2 == null) {
                if (iCondition.getKey().equals("remote-address")) {
                    string2 = iRequestInfo.getRemoteAddr();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "HTTPheader obtained from 'remote-address' " + string2);
                    }
                    bl2 = true;
                } else if (iCondition.getKey().equals("request-url")) {
                    object = iRequestInfo.getQueryString();
                    string2 = object != null ? iRequestInfo.getRequestURL().toString() + "?" + (String)object : iRequestInfo.getRequestURL().toString();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "HTTPheader obtained from 'request-url' " + string2);
                    }
                } else {
                    if (iCondition instanceof NotContainsCondition) continue;
                    string = "No HTTPheader found, and no 'remote-address' or 'request-url' rule used - do not Intercept.";
                    bl = false;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.exiting(ME, "isAccepted", bl + " " + string);
                    }
                    return false;
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "isAccepted", "Checking condition {0} {1}.", new Object[]{iCondition, string2});
            }
            try {
                object = bl2 ? new ValueIPAddress(string2) : new ValueString(string2);
                boolean bl3 = iCondition.checkCondition((IValue)object);
                if (!bl3) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "check failed, returning false. TAI will not intercept");
                    }
                    return false;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.logp(Level.FINER, ME, "isAccepted", "check passed, continuing to next condition");
            }
            catch (FilterException filterException) {
                throw new RuntimeException(filterException);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isAccepted", "TAI will intercept request");
            logger.exiting(ME, "isAccepted", bl + " " + string);
        }
        return true;
    }

    public void setProcessAll(boolean bl) {
        this.processAll = bl;
    }
}

