/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.filter;

import com.ibm.ws.security.spnego.filter.FilterException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IPAddressRange {
    private static Logger log = Logger.getLogger(IPAddressRange.class.getName());
    InetAddress ipHigher;
    InetAddress ipLower;
    String ipRange;

    public IPAddressRange(String string) throws FilterException {
        this.ipRange = string;
        log.log(Level.FINE, "ip range is {0}", string);
        String string2 = new String();
        String string3 = new String();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".:", true);
        boolean bl = false;
        String string4 = "FFFF";
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string5.equals(":")) {
                string3 = string3 + string5;
                string2 = string2 + string5;
                continue;
            }
            String string6 = stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : "";
            string5 = string5.trim();
            if (".".equals(string6)) {
                string4 = "255";
            }
            if (bl) {
                if (!string5.equals("*")) {
                    throw new FilterException("Bad IP range. Must contain only wildcards after first range");
                }
                string3 = string3 + string4;
                string2 = string2 + "0";
            } else if (string5.startsWith("[") && string5.endsWith("]")) {
                int n = string5.indexOf(45);
                String string7 = string5.substring(1, n);
                string2 = string2 + string7;
                int n2 = string5.lastIndexOf(93);
                String string8 = string5.substring(n + 1, n2);
                string3 = string3 + string8;
                bl = true;
            } else if (string5.equals("*")) {
                string3 = string3 + string4;
                string2 = string2 + "0";
                bl = true;
            } else {
                string3 = string3 + string5;
                string2 = string2 + string5;
            }
            string3 = string3 + string6;
            string2 = string2 + string6;
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "upperAddr is " + string3);
            log.log(Level.FINEST, "lowerAddr is " + string2);
        }
        try {
            this.ipHigher = InetAddress.getByName(string3);
            this.ipLower = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new FilterException("impossible!!", unknownHostException);
        }
    }

    public boolean inRange(InetAddress inetAddress) {
        if (IPAddressRange.greaterThan(inetAddress, this.ipHigher)) {
            return false;
        }
        return !IPAddressRange.lessThan(inetAddress, this.ipLower);
    }

    public boolean aboveRange(InetAddress inetAddress) {
        return IPAddressRange.greaterThan(inetAddress, this.ipHigher);
    }

    public boolean belowRange(InetAddress inetAddress) {
        return IPAddressRange.lessThan(inetAddress, this.ipLower);
    }

    public static boolean greaterThan(InetAddress inetAddress, InetAddress inetAddress2) {
        return IPAddressRange.compare(inetAddress, inetAddress2) > 0;
    }

    public static boolean lessThan(InetAddress inetAddress, InetAddress inetAddress2) {
        return IPAddressRange.compare(inetAddress, inetAddress2) < 0;
    }

    public static int compare(InetAddress inetAddress, InetAddress inetAddress2) {
        int n;
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = inetAddress2.getAddress();
        int n2 = 0;
        int n3 = 0;
        if (byArray.length > byArray2.length) {
            n = byArray2.length;
            n2 = byArray.length - n;
            if (!IPAddressRange.isZeros(byArray, byArray.length - n)) {
                return 1;
            }
        } else if (byArray.length < byArray2.length) {
            n = byArray.length;
            n3 = byArray2.length - n;
            if (!IPAddressRange.isZeros(byArray2, byArray2.length - n)) {
                return -1;
            }
        } else {
            n = byArray.length;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[n2] != byArray2[n3]) {
                int n4;
                int n5 = byArray[n2];
                if (n5 < 0) {
                    n5 += 256;
                }
                if ((n4 = byArray2[n3]) < 0) {
                    n4 += 256;
                }
                if (n5 > n4) {
                    return 1;
                }
                return -1;
            }
            ++n2;
            ++n3;
        }
        return 0;
    }

    private static boolean isZeros(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.ipRange;
    }
}

