/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.filter;

import com.ibm.ws.security.spnego.filter.FilterException;
import com.ibm.ws.security.spnego.filter.IPAddressRange;
import com.ibm.ws.security.spnego.filter.IValue;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ValueIPAddress
implements IValue {
    InetAddress myIP;

    public ValueIPAddress(String string) throws FilterException {
        try {
            this.myIP = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new FilterException("Can't convert ip string to IP address", unknownHostException);
        }
    }

    public boolean equals(IValue iValue) {
        if (iValue.getClass() != ValueIPAddress.class) {
            return false;
        }
        return ((ValueIPAddress)iValue).getIP().equals(this.getIP());
    }

    public boolean greaterThan(IValue iValue) {
        if (iValue.getClass() != ValueIPAddress.class) {
            return false;
        }
        return IPAddressRange.greaterThan(this.getIP(), ((ValueIPAddress)iValue).getIP());
    }

    public boolean lessThan(IValue iValue) {
        if (iValue.getClass() != ValueIPAddress.class) {
            return false;
        }
        return IPAddressRange.lessThan(this.getIP(), ((ValueIPAddress)iValue).getIP());
    }

    public boolean containedBy(IValue iValue) {
        return this.equals(iValue);
    }

    public String toString() {
        return this.getIP().toString();
    }

    protected InetAddress getIP() {
        return this.myIP;
    }
}

