/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.AuthenticationToken;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.ietf.jgss.GSSCredential;

public class AuthenticationTokenImpl
extends AbstractTokenImpl
implements AuthenticationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private byte[] tokenBytes = null;
    private String LTPA_OID = "oid:1.3.18.0.2.30.2";
    private GSSCredential gssCred = null;
    private Hashtable kerberosData = null;
    private String KERBEROS_OID = "oid:1.2.840.113554.1.2.2";
    private ContextManager contextManager = null;
    private String tokenName;
    private boolean forwardable;
    private boolean isReadOnly = false;
    private Subject subjectReference = null;
    private short version = 1;
    private static final WebSphereRuntimePermission UPDATE_TOKEN = new WebSphereRuntimePermission("updateToken");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(AuthenticationTokenImpl.class, null, "com.ibm.ejs.resources.security");
    private static String factoryClass = null;
    static /* synthetic */ Class class$org$ietf$jgss$GSSCredential;

    public AuthenticationTokenImpl() {
        if (factoryClass == null) {
            factoryClass = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authenticationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "factoryClass:" + factoryClass);
            }
        }
    }

    public void initializeToken(String string, Token token) throws WSLoginFailedException {
        this.tokenName = string;
        final Token token2 = token;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                AuthenticationTokenImpl.this.setToken(token2);
                return null;
            }
        });
        this.token = token;
    }

    public void initializeToken(String string, byte[] byArray) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing authentication token.");
            }
            this.tokenName = string;
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "93", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
            this.contextManager.setRootException(exception);
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)exception;
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        if (byArray != null) {
            this.token = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using byte[] to create token for OID: " + this.tokenName);
                }
                if (factoryClass != null) {
                    try {
                        this.token = this.ltpaServer.validateToken(byArray, factoryClass);
                    }
                    catch (Exception exception) {
                        Tr.debug(tc, "Exception validating LTPA token by using factoryClass.", new Object[]{exception});
                    }
                }
                if (this.token == null) {
                    this.token = this.ltpaServer.validateToken(byArray);
                }
                final Token token = this.token;
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        AuthenticationTokenImpl.this.setToken(token);
                        return null;
                    }
                });
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.AuthenticationTokenImpl.initializeToken", "144", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{wSLoginFailedException});
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.AuthenticationTokenImpl.initializeToken", "151", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
        this.contextManager.setRootException(wSLoginFailedException);
        throw wSLoginFailedException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeToken(Subject subject, String string, byte[] byArray) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing authentication token.");
            }
            this.tokenName = string;
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "176", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
            this.contextManager.setRootException(exception);
            if (!(exception instanceof WSLoginFailedException)) throw new WSLoginFailedException(exception.getMessage(), exception);
            throw (WSLoginFailedException)exception;
        }
        if (byArray != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using byte[] to create token for OID: " + this.tokenName);
                }
                if (this.tokenName.equals(this.KERBEROS_OID)) {
                    this.gssCred = Krb5WSCredentialUtils.validateToken((byte[])byArray);
                    this.kerberosData = new Hashtable();
                    if (this.gssCred == null) return;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding GSSCredential to Subject.");
                    }
                    SubjectHelper.putGSSCredentialInSubject(this.gssCred, subject);
                    return;
                }
                final Token token = this.token = this.ltpaServer.validateToken(byArray);
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        AuthenticationTokenImpl.this.setToken(token);
                        return null;
                    }
                });
                return;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "228", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{wSLoginFailedException});
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "235", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        } else {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeToken(Subject subject, String string, GSSCredential gSSCredential) throws WSLoginFailedException {
        if (gSSCredential != null) {
            try {
                this.gssCred = gSSCredential;
                this.kerberosData = new Hashtable();
                if (this.gssCred == null) return;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding GSSCredential to Subject.");
                }
                SubjectHelper.putGSSCredentialInSubject(this.gssCred, subject);
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "270", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        } else {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
    }

    public void initializeToken(Subject subject, String string, String string2) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing authentication token.");
            }
            this.tokenName = string;
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "296", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
            this.contextManager.setRootException(exception);
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)exception;
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        if (string2 != null) {
            if (this.tokenName.equals(this.KERBEROS_OID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trying to login with just UID when using Kerberos auth mechanism, throwing WSLoginFailedException...");
                }
                throw new WSLoginFailedException("Cannot login with just UserID (no password) when using Kerberos auth mechanism.");
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                }
                securityManager.checkPermission(MAP_CREDENTIAL);
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using uid to create token using factroy: " + factoryClass);
                }
                final Token token = this.token = this.ltpaServer.createLTPAToken(string2, factoryClass);
                AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        AuthenticationTokenImpl.this.setToken(token);
                        return null;
                    }
                });
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "345", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{wSLoginFailedException});
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "352", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        } else {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
    }

    public boolean isValid() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            Date date = new Date();
            Date date2 = new Date(this.getExpiration());
            boolean bl = date.before(date2);
            return bl;
        }
        if (this.tokenName.equals(this.KERBEROS_OID)) {
            int n = 0;
            try {
                n = this.gssCred.getRemainingLifetime();
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{exception});
            }
            return n > 0;
        }
        return false;
    }

    public long getExpiration() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            return super.getExpiration();
        }
        if (this.tokenName.equals(this.KERBEROS_OID)) {
            int n = -1;
            try {
                n = this.gssCred.getRemainingLifetime();
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{exception});
            }
            return (long)(n * 1000) + System.currentTimeMillis();
        }
        return -1L;
    }

    public boolean isForwardable() {
        return this.tokenName.equals(this.LTPA_OID);
    }

    public String getPrincipal() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            String[] stringArray = this.getAttributes("u");
            if (stringArray != null && stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }
        if (this.tokenName.equals(this.KERBEROS_OID)) {
            String[] stringArray = this.getAttributes("u");
            if (stringArray != null && stringArray.length > 0) {
                return stringArray[0];
            }
            if (this.gssCred != null) {
                String string = null;
                try {
                    string = Krb5WSCredentialUtils.Krb5ToRegistryDN((String)((Object)this.gssCred.getName()).toString());
                    this.addAttribute("u", string);
                }
                catch (Exception exception) {
                    Tr.debug(tc, "Exception getting principal name from GSSCredential.", new Object[]{exception});
                }
                return string;
            }
            Tr.debug(tc, "GSSCredential is null, cannot get principal.");
        }
        return null;
    }

    public String getUniqueID() {
        String[] stringArray = this.getAttributes("com.ibm.wsspi.security.cred.cacheKey");
        if (stringArray != null && stringArray[0] != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found cache key in Authz token: " + stringArray[0]);
            }
            return stringArray[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No unique cache key found in token.");
        }
        return null;
    }

    public byte[] getBytes() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            try {
                return super.getBytes();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred getting bytes[] from token.", new Object[]{exception});
                }
                FFDCFilter.processException(exception, "com.ibm.ws.security.token.AbstractTokenImpl.getBytes", "527");
                return null;
            }
        }
        return new byte[0];
    }

    public String getName() {
        return this.tokenName;
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    public String[] getAttributes(String string) {
        if (this.tokenName.equals(this.LTPA_OID)) {
            return super.getAttributes(string);
        }
        String string2 = (String)this.kerberosData.get(string);
        if (string2 != null) {
            String[] stringArray = new String[]{string2};
            return stringArray;
        }
        return null;
    }

    public String[] addAttribute(String string, String string2) {
        Object object;
        if ((string.startsWith("com.ibm.wsspi.security") || string.startsWith("com.ibm.websphere.security")) && (object = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + UPDATE_TOKEN.toString());
            }
            ((SecurityManager)object).checkPermission(UPDATE_TOKEN);
        }
        if (!this.isReadOnly) {
            if (this.tokenName.equals(this.LTPA_OID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting attribute with key: " + string);
                }
                return super.addAttribute(string, string2);
            }
            object = this.kerberosData.put(string, string2);
            if (object != null) {
                String[] stringArray = new String[]{object};
                return stringArray;
            }
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            return super.getAttributeNames();
        }
        return this.kerberosData.keys();
    }

    public Object clone() {
        try {
            AuthenticationTokenImpl authenticationTokenImpl = new AuthenticationTokenImpl();
            this.token = (Token)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return AuthenticationTokenImpl.this.getToken();
                }
            });
            authenticationTokenImpl.initializeToken(this.tokenName, (Token)this.token.clone());
            return authenticationTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception creating clone of authentication token.", new Object[]{exception});
            FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAToken.clone", "684");
            return null;
        }
    }

    private void getGSSCredFromSubject() {
        if (this.subjectReference != null) {
            try {
                final Subject subject = this.subjectReference;
                this.gssCred = (GSSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        return (GSSCredential)subject.getPrivateCredentials(class$org$ietf$jgss$GSSCredential == null ? (class$org$ietf$jgss$GSSCredential = AuthenticationTokenImpl.class$("org.ietf.jgss.GSSCredential")) : class$org$ietf$jgss$GSSCredential).iterator().next();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.AuthenticationTokenImpl.getGSSCredFromSubject", "711", this);
            }
        }
    }
}

