/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.token.KerberosTokenImpl;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.KerberosToken;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosServiceTicketImpl
extends AbstractTokenImpl
implements KerberosToken {
    private byte[] tokenBytes = null;
    private GSSCredential gssCredential = null;
    private String KERBEROS_MECH = "1.2.840.113554.1.2.2";
    private String KERBEROS_OID = "oid:" + this.KERBEROS_MECH;
    private String targetServerName = null;
    private ContextManager contextManager = null;
    private String tokenName = "com.ibm.ws.security.token.KerberosServiceTicketImpl";
    private boolean forwardable = true;
    private boolean isReadOnly = false;
    private short version = 1;
    private static final TraceComponent tc = Tr.register(KerberosServiceTicketImpl.class, null, "com.ibm.ejs.resources.security");

    public KerberosServiceTicketImpl(KerberosTokenImpl kerberosTokenImpl, CSIv2PerformPolicy cSIv2PerformPolicy) {
        String string = cSIv2PerformPolicy.getTargetHostName();
        String string2 = cSIv2PerformPolicy.getTargetSecurityName();
        String string3 = RealmSecurityName.getSecurityName(string2);
        String string4 = RealmSecurityName.getRealm(string3);
        if (string4 == null) {
            throw new IllegalArgumentException("Failed to create targetService: hast: " + string + " targetSecurityName: " + string3);
        }
        this.targetServerName = string4 + "@" + string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KerberosServiceTicketImpl server = " + this.targetServerName);
        }
        this.gssCredential = kerberosTokenImpl.getGSSCredential();
        if (this.gssCredential == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Missing GSSCredential in KerberosTokenImpl object");
            }
            throw new NullPointerException("No GSSCredential");
        }
        if (!kerberosTokenImpl.isValid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expired GSSCredential in KerberosTokenImpl object");
            }
            throw new IllegalStateException("Expired GSSCredential");
        }
        this.tokenBytes = this.getServiceTicket();
    }

    public KerberosServiceTicketImpl(KerberosServiceTicketImpl kerberosServiceTicketImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KerberosServiceTicketImpl server = " + kerberosServiceTicketImpl.targetServerName);
        }
        this.targetServerName = kerberosServiceTicketImpl.targetServerName;
        this.gssCredential = kerberosServiceTicketImpl.gssCredential;
        if (this.gssCredential == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "gssCredential is null");
            }
            throw new NullPointerException("No GSSCredential");
        }
        if (!kerberosServiceTicketImpl.isValid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expired GSSCredential in KerberosServiceTicketImpl object");
            }
            throw new IllegalStateException("Expired GSSCredential");
        }
        this.tokenBytes = this.getServiceTicket();
    }

    private byte[] getServiceTicket() {
        byte[] byArray;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServiceTicket for service " + this.targetServerName);
            }
            GSSContext gSSContext = null;
            GSSManager gSSManager = GSSManager.getInstance();
            byArray = null;
            try {
                Oid oid = null;
                try {
                    oid = new Oid(this.KERBEROS_MECH);
                }
                catch (GSSException gSSException) {
                    Object[] objectArray = new Object[]{Oid.class, "Oid(\"" + this.KERBEROS_MECH + "\")", gSSException};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting OID: " + gSSException.getMessage());
                    }
                    throw gSSException;
                }
                GSSName gSSName = null;
                try {
                    gSSName = gSSManager.createName(this.targetServerName, GSSName.NT_HOSTBASED_SERVICE, oid);
                }
                catch (GSSException gSSException) {
                    Object[] objectArray = new Object[]{gSSManager, "createName()", gSSException};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling createName: " + gSSException.getMessage());
                    }
                    throw gSSException;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerName" + gSSName);
                }
                try {
                    gSSContext = gSSManager.createContext(gSSName, oid, this.gssCredential, 0);
                }
                catch (GSSException gSSException) {
                    Object[] objectArray = new Object[]{gSSManager, "createContext()", gSSException};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling createContext: " + gSSException.getMessage());
                    }
                    throw gSSException;
                }
                try {
                    gSSContext.requestCredDeleg(true);
                }
                catch (GSSException gSSException) {
                    Object[] objectArray = new Object[]{gSSContext, "requestCredDeleg(true)", gSSException};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling requestCredDeleg: " + gSSException.getMessage());
                    }
                    throw gSSException;
                }
                byte[] byArray2 = null;
                int n = 0;
                try {
                    byArray = gSSContext.initSecContext(byArray2, 0, n);
                    Tr.debug(tc, "Token = " + byArray.length + byArray);
                }
                catch (GSSException gSSException) {
                    Object[] objectArray = new Object[]{gSSContext, "initSecContext()", gSSException};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling initSecContext: " + gSSException.getMessage());
                    }
                    throw gSSException;
                }
                if (gSSContext.isEstablished()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "initSecContext: clientContext established successfully.");
                    }
                } else {
                    Object[] objectArray = new Object[]{gSSContext, this.targetServerName};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "initSecContext: clientContext not established.");
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.KerberosServiceTicketImpli.getServiceTicket", "1571", this);
                if (!tc.isEntryEnabled()) break block27;
                Tr.exit(tc, "Exception occurred getting service ticket.", new Object[]{exception});
            }
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInitialContextToken returns null.");
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceTicket returns a service ticket.");
        }
        return byArray;
    }

    public boolean isValid() {
        int n = 0;
        try {
            n = this.gssCredential.getRemainingLifetime();
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{exception});
        }
        return n > 0;
    }

    public long getExpiration() {
        int n = -1;
        try {
            n = this.gssCredential.getRemainingLifetime();
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{exception});
            return -1L;
        }
        return (long)(n * 1000) + System.currentTimeMillis();
    }

    public boolean isForwardable() {
        return true;
    }

    public String getPrincipal() {
        if (this.gssCredential != null) {
            String string = null;
            try {
                string = Krb5WSCredentialUtils.Krb5ToRegistryDN((String)((Object)this.gssCredential.getName()).toString());
                this.addAttribute("u", string);
            }
            catch (Exception exception) {
                Tr.debug(tc, "Exception getting principal name from GSSCredential.", new Object[]{exception});
            }
            return string;
        }
        Tr.debug(tc, "GSSCredential is null, cannot get principal.");
        return null;
    }

    public String getUniqueID() {
        return this.getPrincipal();
    }

    public byte[] getBytes() {
        return this.tokenBytes;
    }

    public String getName() {
        return this.tokenName;
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    public Object clone() {
        try {
            KerberosServiceTicketImpl kerberosServiceTicketImpl = new KerberosServiceTicketImpl(this);
            return kerberosServiceTicketImpl;
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception creating clone of Kerberos service ticket.", new Object[]{exception});
            FFDCFilter.processException(exception, "com.ibm.ws.security.token.KerberosServiceTicketImpl.clone", "662");
            return null;
        }
    }

    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }
}

