/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.security.PrivilegedAction;

public class SingleSignonTokenImpl
extends AbstractTokenImpl
implements SingleSignonToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private String name = "LtpaToken";
    private short version = (short)2;
    private static final TraceComponent tc = Tr.register(SingleSignonTokenImpl.class, null, "com.ibm.ejs.resources.security");
    private static String factoryClass = null;

    public SingleSignonTokenImpl() {
        if (factoryClass == null) {
            factoryClass = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.singleSignonTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "factoryClass:" + factoryClass);
            }
        }
    }

    public void initializeToken(byte[] byArray) throws WSLoginFailedException {
        try {
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            this.token = null;
            if (factoryClass != null) {
                try {
                    this.token = this.ltpaServer.validateToken(byArray, factoryClass);
                }
                catch (Exception exception) {
                    Tr.debug(tc, "Exception validating sso token by using factoryClass.", new Object[]{exception});
                }
            }
            if (this.token == null) {
                this.token = this.ltpaServer.validateToken(byArray);
            }
            final Token token = this.token;
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    SingleSignonTokenImpl.this.setToken(token);
                    return null;
                }
            });
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.SingleSignonTokenImpl.initializeToken", "86", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{wSLoginFailedException});
            this.contextManager.setRootException(wSLoginFailedException);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.SingleSignonTokenImpl.initializeToken", "93", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{exception});
            this.contextManager.setRootException(exception);
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public void initializeToken(Token token) throws WSLoginFailedException {
        final Token token2 = this.token = token;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                SingleSignonTokenImpl.this.setToken(token2);
                return null;
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public short getVersion() {
        return this.version;
    }

    public Object clone() {
        try {
            SingleSignonTokenImpl singleSignonTokenImpl = new SingleSignonTokenImpl();
            this.token = (Token)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return SingleSignonTokenImpl.this.getToken();
                }
            });
            singleSignonTokenImpl.initializeToken((Token)this.token.clone());
            return singleSignonTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception creating clone of single signon token.", new Object[]{exception});
            FFDCFilter.processException(exception, "com.ibm.ws.security.token.SingleSignonToken.clone", "157");
            return null;
        }
    }
}

