/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class AuthenLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    private ContextManager contextManager;
    private UserRegistry registry;
    protected boolean debug = false;
    private LTPAServerObject ltpaServer;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(AuthenLoginModule.class, null, "com.ibm.ejs.resources.security");

    public AuthenLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthenLoginModule()");
            Tr.exit(tc, "AuthenLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")");
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = map;
            this.options = map2;
            try {
                this.ltpaServer = LTPAServerObject.getLTPAServer();
            }
            catch (LTPAConfigException lTPAConfigException) {
                FFDCFilter.processException((Throwable)lTPAConfigException, "com.ibm.ws.security.web.AuthenLoginModule.initialize", "149", this);
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "ERROR: Failed to get the LTPA server object.");
            }
        }
        this.contextManager = ContextManagerFactory.getInstance();
        if (this.contextManager != null) {
            this.registry = this.contextManager.getRegistry(this.contextManager.getDefaultRealm());
            this.contextManager.clearRootException();
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        Serializable serializable;
        Object object;
        byte[] byArray;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        Callback[] callbackArray = null;
        if (!this.sharedState.containsKey("Callback")) {
            if (this.callbackHandler == null) {
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSServletRequestCallback("HttpServletRequest: "), new WSServletResponseCallback("HttpServletResponse: "), new WSAppContextCallback("ApplicationContextCallback: "), new WSTokenHolderCallback("Authz Token List: ")};
            try {
                this.callbackHandler.handle(callbackArray);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.web.AuthenLoginModule.login", "232", this);
                Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), iOException});
                this.contextManager.setRootException(iOException);
                throw new WSLoginFailedException("IOException: " + iOException.getMessage(), iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                FFDCFilter.processException((Throwable)unsupportedCallbackException, "com.ibm.ws.security.web.AuthenLoginModule.login", "238", this);
                Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
                this.contextManager.setRootException(unsupportedCallbackException);
                throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + unsupportedCallbackException.getMessage(), unsupportedCallbackException);
            }
            this.sharedState.put("Callback", callbackArray);
        } else {
            callbackArray = (Callback[])this.sharedState.get("Callback");
        }
        String string = null;
        String string2 = null;
        char[] cArray = null;
        byte[] byArray2 = null;
        List list = null;
        string = ((NameCallback)callbackArray[0]).getName();
        char[] cArray2 = ((PasswordCallback)callbackArray[1]).getPassword();
        if (cArray2 != null) {
            cArray = new char[cArray2.length];
            System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        if ((byArray = ((WSCredTokenCallbackImpl)callbackArray[2]).getCredToken()) != null) {
            byArray2 = CredentialsHelper.copyCredToken(byArray);
        }
        list = ((WSTokenHolderCallback)callbackArray[6]).getTokenHolderList();
        Hashtable hashtable = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (hashtable == null) {
            try {
                object = this.subject;
                hashtable = (Hashtable)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Subject)object){
                    private final /* synthetic */ Subject val$subjectPriv;
                    {
                        this.val$subjectPriv = subject;
                    }

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        Object[] objectArray = this.val$subjectPriv.getPublicCredentials().toArray();
                        if (AuthenLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in public cred list.");
                        }
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (AuthenLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in public list: " + objectArray[i]);
                            }
                            if (!(objectArray[i] instanceof Hashtable ? ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.uniqueId") != null : objectArray[i] instanceof HashMap && ((HashMap)objectArray[i]).get("com.ibm.wsspi.security.cred.uniqueId") != null)) continue;
                            return objectArray[i];
                        }
                        Object[] objectArray2 = this.val$subjectPriv.getPrivateCredentials().toArray();
                        if (AuthenLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in private cred list.");
                        }
                        for (int i = 0; i < objectArray2.length; ++i) {
                            if (AuthenLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in private list: " + objectArray2[i]);
                            }
                            if (!(objectArray2[i] instanceof Hashtable ? ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.uniqueId") != null : objectArray2[i] instanceof HashMap && ((HashMap)objectArray2[i]).get("com.ibm.wsspi.security.cred.uniqueId") != null)) continue;
                            return objectArray2[i];
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "334", this);
                this.contextManager.setRootException(privilegedActionException.getException());
                throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
            }
            if (hashtable != null) {
                this.sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", hashtable);
            }
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "uid = " + string);
            Tr.debug(tc, "realm = " + string2);
            Tr.debug(tc, "password = " + (cArray == null ? "<null>" : "XXXXXXXX"));
            Tr.debug(tc, "cred token = " + Util.toString(byArray2));
            Tr.debug(tc, "authz token list = " + list);
            Tr.debug(tc, "custom properties = " + hashtable);
        }
        if (hashtable != null) {
            this.succeeded = true;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.debug(tc, "Custom login module passing in group information.  Handling login outside this login module.");
                Tr.exit(tc, "login()");
            }
            return this.succeeded;
        }
        if ((WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) && list != null && (byArray2 != null || string != null)) {
            this.succeeded = true;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.debug(tc, "Security attribute propagation data has been received.  Handling login outside this login module.");
                Tr.exit(tc, "login()");
            }
            return this.succeeded;
        }
        if (string == null && cArray == null && byArray2 == null) {
            object = new WSLoginFailedException("No authentication data.");
            this.contextManager.setRootException((Throwable)object);
            throw object;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully gathered authentication information");
        }
        if (string != null && cArray != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using uid and password for authentication");
                object = new StringBuffer("Authenticating \"");
                ((StringBuffer)object).append(string2).append('/').append(string).append("\"");
                Tr.debug(tc, ((StringBuffer)object).toString());
            }
            object = new String(cArray);
            serializable = new BasicAuthData(string, (String)object);
            try {
                this.credential = this.ltpaServer.authenticate((BasicAuthData)serializable);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.web.AuthenLoginModule.login", "428", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login()", new Object[]{wSLoginFailedException});
                }
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.AuthenLoginModule.login", "435", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login()", new Object[]{exception});
                }
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        } else if (string != null) {
            object = System.getSecurityManager();
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                }
                ((SecurityManager)object).checkPermission(MAP_CREDENTIAL);
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using uid to mapCredential");
                serializable = new StringBuffer("Authenticating \"");
                ((StringBuffer)serializable).append(string2).append('/').append(string).append("\"");
                Tr.debug(tc, ((StringBuffer)serializable).toString());
            }
            try {
                if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(string, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                serializable = this.registry.createCredential(string);
                this.credential = this.ltpaServer.createLTPAToken((WSCredential)serializable);
            }
            catch (TokenCreationFailedException tokenCreationFailedException) {
                FFDCFilter.processException((Throwable)tokenCreationFailedException, "com.ibm.ws.security.web.AuthenLoginModule.login", "480", this);
                Tr.debug(tc, "Using uid to mapCredential");
                this.contextManager.setRootException(tokenCreationFailedException);
                throw new WSLoginFailedException(tokenCreationFailedException.getMessage(), tokenCreationFailedException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.AuthenLoginModule.login", "487", this);
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        } else if (byArray2 != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using credential token for authentication");
            }
            try {
                this.credential = this.ltpaServer.validate(byArray2);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.web.AuthenLoginModule.login", "504", this);
                this.contextManager.setRootException(wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.AuthenLoginModule.login", "510", this);
                this.contextManager.setRootException(exception);
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        } else {
            object = new WSLoginFailedException("AuthenLoginModule: No authentication data");
            this.contextManager.setRootException((Throwable)object);
            throw object;
        }
        if (this.credential == null) {
            object = new WSLoginFailedException("AuthenLoginModule: Credential returned from SAS authentication is null");
            this.contextManager.setRootException((Throwable)object);
            throw object;
        }
        object = null;
        try {
            this.principal = ContextManagerFactory.getInstance().createPrincipal(this.credential);
        }
        catch (WSSecurityException wSSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSecurityException caught creating a new principal.", new Object[]{wSSecurityException});
            }
            FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.web.AuthenLoginModule.login", "533", this);
            this.contextManager.setRootException(wSSecurityException);
            throw new WSLoginFailedException(wSSecurityException.getMessage(), wSSecurityException);
        }
        this.sharedState.put("WSPrincipal", this.principal);
        this.sharedState.put("WSCredential", this.credential);
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                this.principal = (WSPrincipal)this.sharedState.get("WSPrincipal");
                if (this.principal == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("AuthenLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                this.credential = (WSCredential)this.sharedState.get("WSCredential");
                if (this.credential == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("AuthenLoginModule: WSCredential is null in commit (phase 2) stage");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                if (!AuthenLoginModule.this.subject.getPrincipals().contains(AuthenLoginModule.this.principal)) {
                                    AuthenLoginModule.this.subject.getPrincipals().add(AuthenLoginModule.this.principal);
                                }
                                if (!AuthenLoginModule.this.subject.getPublicCredentials().contains(AuthenLoginModule.this.credential)) {
                                    AuthenLoginModule.this.credential.set("wssecurity.identity_name", "ClientAuthenticationToken");
                                    AuthenLoginModule.this.credential.set("wssecurity.identity_value", StringBytesConversion.getConvertedBytes(AuthenLoginModule.this.credential.getRealmSecurityName()));
                                    AuthenLoginModule.this.subject.getPublicCredentials().add(AuthenLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.web.AuthenLoginModule.commit", "669", this);
                        this.contextManager.setRootException(privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.AuthenLoginModule.commit", "679", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (AuthenLoginModule.this.principal != null && AuthenLoginModule.this.subject.getPrincipals().contains(AuthenLoginModule.this.principal)) {
                        AuthenLoginModule.this.subject.getPrincipals().remove(AuthenLoginModule.this.principal);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.AuthenLoginModule.run", "790", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                try {
                    if (AuthenLoginModule.this.credential != null && AuthenLoginModule.this.subject.getPublicCredentials().contains(AuthenLoginModule.this.credential)) {
                        AuthenLoginModule.this.subject.getPublicCredentials().remove(AuthenLoginModule.this.credential);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.AuthenLoginModule.run", "801", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                if (AuthenLoginModule.this.credential == null) {
                    // empty if block
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private void cleanupSharedState() {
        WSPrincipal wSPrincipal;
        WSCredential wSCredential;
        Callback[] callbackArray;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSharedState()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing Callbacks, WSPrincipal, and WSCredential from the shared state.");
        }
        if ((callbackArray = (Callback[])this.sharedState.get("Callback")) != null) {
            this.sharedState.remove("Callback");
        }
        if ((wSCredential = (WSCredential)this.sharedState.get("WSCredential")) != null) {
            this.sharedState.remove("WSCredential");
        }
        if ((wSPrincipal = (WSPrincipal)this.sharedState.get("WSPrincipal")) != null) {
            this.sharedState.remove("WSPrincipal");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSharedState()");
        }
    }
}

