/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class FormLoginExtensionProcessor
extends WebExtensionProcessor {
    private String loginPage = null;
    private String loginErrorPage = null;
    private static TraceComponent tc = Tr.register(FormLoginExtensionProcessor.class, "Security", "com.ibm.ejs.resources.security");
    private WebAttributes webAttrs = null;
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static AuditService auditService = null;

    public FormLoginExtensionProcessor(IServletContext iServletContext) throws Exception {
        super(iServletContext);
        try {
            Class<?> clazz;
            String string;
            WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
            WebModuleMetaData webModuleMetaData = webAppConfig.getMetaData();
            SecurityMetaData securityMetaData = (SecurityMetaData)webModuleMetaData.getSecurityMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create WebAttributes for this webApp.");
            }
            if (securityMetaData != null) {
                this.webAttrs = securityMetaData.getWebAttributes();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In FormLoginExtensionProcessor(), security MetaData is null.");
            }
            this.loginPage = this.webAttrs.getLoginURL();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login page is: " + this.loginPage);
            }
            this.loginErrorPage = this.webAttrs.getReloginURL();
            if (this.loginErrorPage != null && !this.loginErrorPage.startsWith("/")) {
                this.loginErrorPage = "/" + this.loginErrorPage;
            }
            if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) != null && (auditFactory = (J2EEAuditEventFactory)(auditHandler = (AuditHandlerImpl)auditService.newAuditHandler(string = "WAS.security", string)).getAuditEventFactory("J2EE")) != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                auditFactory = null;
            }
            if (auditService == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "AuditService was not initialized");
            }
            if (auditHandler == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "AuditHandler was not initialized");
            }
            if (auditFactory == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "J2EEAuditEventFactory was not initialized");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login error page is: " + this.loginErrorPage);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.FormLoginServlet.init", "166", (Object)this);
            Tr.error(tc, "security.web.form.noWebAppInfo", new Object[]{exception});
        }
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            this.formLogin(httpServletRequest, httpServletResponse);
        }
    }

    private void formLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        block65: {
            String string2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string3;
            String string4;
            CharSequence charSequence;
            boolean bl = false;
            WSCredential wSCredential = null;
            Subject subject = null;
            SecurityConfig securityConfig = SecurityConfig.getConfig();
            Boolean bl2 = (Boolean)securityConfig.getValue("com.ibm.ws.security.web.logoutOnHTTPSessionExpire");
            boolean bl3 = bl2;
            if (httpServletRequest.getRequestedSessionId() != null && !httpServletRequest.isRequestedSessionIdValid() && bl3) {
                httpServletRequest.getSession(true);
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "formLogin, WebAttributes: \n" + this.webAttrs.toString());
            }
            String string5 = null;
            if (this.loginErrorPage != null) {
                charSequence = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
                string4 = ((StringBuffer)charSequence).toString();
                String string6 = httpServletRequest.getContextPath();
                if (string6.equals("/")) {
                    string6 = "";
                }
                int n = string4.indexOf("//");
                n = string4.indexOf("/", n + 2);
                int n2 = string4.length();
                string5 = string6 + this.loginErrorPage;
                ((StringBuffer)charSequence).replace(n, n2, string5);
                string5 = ((StringBuffer)charSequence).toString();
            }
            charSequence = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
            string4 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig");
            boolean bl4 = false;
            Boolean bl5 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
            if (auditHandler != null) {
                auditHandler.setAppName(this.webAttrs.getWebAppName());
            }
            if (bl5.booleanValue() && !((Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled")).booleanValue()) {
                Tr.error(tc, "security.formlogin.badconfig", new Object[]{this.webAttrs.getWebAppName()});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configuration error.  SSO Not enabled when using FormLogin. Redirecting to error page: " + string5);
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string5));
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "INVALID_CONFIG", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.formlogin.badconfig.audit", new Object[]{this.webAttrs.getWebAppName()});
                }
                return;
            }
            String string7 = httpServletRequest.getParameter("j_username");
            String string8 = httpServletRequest.getParameter("j_password");
            if (string7 == null || string8 == null || string8.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "username and/or password are not present");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Redirecting to error page: " + string5);
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string5));
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "MISSING_UIDPSWD", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string7, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string5});
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Form based login: userid/password present in the form. User is: " + string7);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(2);
            try {
                hashMap.put("WebAppName", this.webAttrs.getWebAppName());
                hashMap.put("RedirectURL", string5);
                string3 = ContextManagerFactory.getInstance().getDefaultRealm();
                object4 = string7;
                string = string8;
                String string9 = string4;
                HttpServletRequest httpServletRequest2 = httpServletRequest;
                object3 = httpServletResponse;
                object2 = hashMap;
                object = new PrivilegedExceptionAction((String)object4, string, string9, httpServletRequest2, (HttpServletResponse)object3, (HashMap)object2){
                    private final /* synthetic */ String val$_username;
                    private final /* synthetic */ String val$_password;
                    private final /* synthetic */ String val$_custom_jaas_config;
                    private final /* synthetic */ HttpServletRequest val$_req;
                    private final /* synthetic */ HttpServletResponse val$_res;
                    private final /* synthetic */ HashMap val$_appcontext;
                    {
                        this.val$_username = string2;
                        this.val$_password = string32;
                        this.val$_custom_jaas_config = string4;
                        this.val$_req = httpServletRequest;
                        this.val$_res = httpServletResponse;
                        this.val$_appcontext = hashMap;
                    }

                    public Object run() throws Exception {
                        Subject subject = ContextManagerFactory.getInstance().login(string3, this.val$_username, this.val$_password, this.val$_custom_jaas_config, this.val$_req, this.val$_res, this.val$_appcontext);
                        return subject;
                    }
                };
                string2 = null;
                try {
                    subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)object);
                    if (subject != null) {
                        wSCredential = (WSCredential)subject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator().next();
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "308", (Object)this);
                    Tr.error(tc, "security.authn.error.foruser", new Object[]{string7});
                    try {
                        string2 = (String)hashMap.get("RedirectURL");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Updating the error page to: " + string2);
                        }
                    }
                    catch (Throwable throwable) {
                        string2 = null;
                        Tr.error(tc, "incorrect customized error page: ", new Object[]{throwable});
                    }
                    if (string2 != null && string2.length() > 0) {
                        string5 = string2;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Redirecting to error page: " + string5);
                    }
                    httpServletResponse.setStatus(401);
                    httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string5));
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                        auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), privilegedActionException, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string7, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string5});
                    }
                    return;
                }
                try {
                    string2 = (String)hashMap.get("RedirectURL");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating the error page to: " + string2);
                    }
                }
                catch (Throwable throwable) {
                    string2 = null;
                    Tr.error(tc, "incorrect customized error page: ", new Object[]{throwable});
                }
                if (string2 != null && string2.length() > 0) {
                    string5 = string2;
                }
                if (subject == null || wSCredential == null) {
                    Tr.audit(tc, "security.authn.failed.foruser", new Object[]{string7});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Redirecting to error page: " + string5);
                    }
                    httpServletResponse.setStatus(401);
                    httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string5));
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                        auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string7, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string5});
                    }
                    return;
                }
                ContextManagerFactory.getInstance().setInvocationSubject(subject);
                ContextManagerFactory.getInstance().setCallerSubject(subject);
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string7, providerName, true, subject, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.success.audit", null);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "400", (Object)this);
                Tr.error(tc, "security.authn.error.foruser", new Object[]{string7});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Redirecting to error page: " + string5);
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string5));
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), exception, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string7, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string5});
                }
                return;
            }
            WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "FORM");
            string3 = null;
            object4 = null;
            if (((String)charSequence).equals("SWAM")) {
                string3 = httpServletRequest.getSession(true);
                if (string3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Form based login: Store auth data in the HTTP Session");
                    }
                    if ((object4 = (FormLoginInfo)((IHttpSession)string3).getSecurityInfo()) == null) {
                        object4 = new FormLoginInfo(string7, string8);
                    } else {
                        ((FormLoginInfo)object4).setUsername(string7);
                        ((FormLoginInfo)object4).setPassword(string8);
                    }
                    ((IHttpSession)string3).putSecurityInfo(object4);
                }
                bl4 = false;
            } else {
                string = null;
                boolean bl6 = false;
                bl4 = false;
                boolean bl7 = false;
                if (this.webAttrs.isSSOEnabled()) {
                    bl7 = true;
                    if (this.webAttrs.isSecureSSO()) {
                        bl4 = httpServletRequest.getScheme().equalsIgnoreCase("https");
                        bl6 = true;
                    } else {
                        bl4 = true;
                    }
                }
                if (bl4) {
                    try {
                        object3 = WebAttributes.createCookies(httpServletRequest, subject);
                        this.clearCookie(httpServletRequest, httpServletResponse);
                        if (object3 != null) {
                            WebAttributes.addCookiesToResponse((List)object3, httpServletResponse);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "495", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Redirecting to error page: " + string5);
                        }
                        httpServletResponse.setStatus(401);
                        httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string5));
                        return;
                    }
                }
            }
            string = "";
            if (((String)charSequence).equals("SWAM")) {
                string = ((FormLoginInfo)object4).getRefererURL();
            } else {
                Cookie[] cookieArray = httpServletRequest.getCookies();
                string = WebAuthenticator.getCookieValue(cookieArray, "WASReqURL");
                if (string != null) {
                    String string10 = string;
                    string = string.replaceAll("%3B", ";");
                    if (string10 != (string = string.replaceAll("%25", "%")) && tc.isDebugEnabled()) {
                        Tr.debug(tc, "formLogin: changed input storedReq from " + string10 + " to " + string);
                    }
                    object3 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
                    object2 = ((StringBuffer)object3).toString();
                    if (!string.startsWith("/")) {
                        try {
                            object = new URL(string);
                            string2 = ((URL)object).getHost();
                            if (string2 == null || string2.length() == 0) {
                                URL uRL = new URL((String)object2);
                                String string11 = uRL.getHost();
                                int n = string.indexOf("//");
                                if (n != -1) {
                                    StringBuffer stringBuffer = new StringBuffer(string);
                                    stringBuffer.insert(n + 2, string11);
                                    string = stringBuffer.toString();
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WASReqURL is malformed. WASReqURL: " + string);
                                }
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "556", (Object)this);
                            if (!tc.isDebugEnabled()) break block65;
                            Tr.debug(tc, "WASReqURL or requested URL is malformed. WASReqURL: " + string + " RequestedURL: " + (String)object2);
                        }
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successful auth - redirecting to the original URL" + string);
        }
        if (string != null) {
            if (string.equals("/")) {
                string = "";
            } else if (string.startsWith("/")) {
                string = string.substring(1);
            }
        }
        if (string == null) {
            string = "";
        }
        httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string));
    }

    private Cookie createCookie(String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookie " + string + " " + string2);
        }
        Cookie cookie = new Cookie(string, string2);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        cookie.setSecure(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookie");
        }
        return cookie;
    }

    private void clearCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearCookie");
        }
        if ((string = WebAuthenticator.getCookieValue(cookieArray = httpServletRequest.getCookies(), "WASReqURL")) != null && string.length() > 0) {
            Cookie cookie = new Cookie("WASReqURL", "");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            httpServletResponse.addCookie(cookie);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleared REFERER_URL cookie. Original value was " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearCookie");
        }
    }
}

