/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FormLogoutExtensionProcessor
extends WebExtensionProcessor {
    private static TraceComponent tc = Tr.register(FormLogoutExtensionProcessor.class, null, "com.ibm.ejs.resources.security");
    protected static String DEFAULT_LOGOUT_MSG = "<!DOCTYPE HTML PUBLIC \"-//W3C/DTD HTML 4.0 Transitional//EN\"><HTML><TITLE>Default Logout Exit Page</TITLE><BODY><H2>Successful Logout</H2></BODY></HTML>";
    private WebAttributes _webAttrs = null;
    private String _authMechanism = null;
    boolean _securityEnabled = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static AuditService auditService = null;
    private static final String ADMIN_APP = "adminconsole";
    private static String ABSOLUTE_URI = "com.ibm.websphere.security.web.absoluteUri";
    private boolean _adminConsole = false;
    private boolean _absoluteUri = false;

    public FormLogoutExtensionProcessor(IServletContext iServletContext) {
        super(iServletContext);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "int, securityEnabled[" + this._securityEnabled + "]");
        }
        if (this._securityEnabled) {
            try {
                Class<?> clazz;
                String string;
                WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
                WebModuleMetaData webModuleMetaData = webAppConfig.getMetaData();
                SecurityMetaData securityMetaData = (SecurityMetaData)webModuleMetaData.getSecurityMetaData();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create WebAttributes for this webApp.");
                }
                if (securityMetaData != null) {
                    this._webAttrs = securityMetaData.getWebAttributes();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In FormLogoutExtensionProcessor(), security MetaData is null.");
                }
                if (this._webAttrs == null) {
                    Tr.error(tc, "security.web.form.createWebAttr");
                } else {
                    this._authMechanism = this._webAttrs.getAuthMechanism();
                    if (ADMIN_APP.equalsIgnoreCase(this._webAttrs.getWebAppName())) {
                        this._adminConsole = true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "securityEnabled[" + this._securityEnabled + "] " + "authMachism[" + this._authMechanism + "]");
                    }
                }
                String string2 = System.getProperty(ABSOLUTE_URI);
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    this._absoluteUri = true;
                }
                this._authMechanism = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) != null && (auditFactory = (J2EEAuditEventFactory)(auditHandler = (AuditHandlerImpl)auditService.newAuditHandler(string = "WAS.security", string)).getAuditEventFactory("J2EE")) != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                    auditFactory = null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.FormLogoutServlet.init", "103", (Object)this);
                Tr.error(tc, "security.web.form.noWebAppInfo", new Object[]{exception});
            }
        }
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (this._securityEnabled && servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            this.formLogout(httpServletRequest, httpServletResponse);
        }
    }

    private void formLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n;
        Object object;
        Object[] objectArray;
        String string;
        Object object2;
        block51: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "formLogout");
            }
            if (auditHandler != null && this._webAttrs != null) {
                auditHandler.setAppName(this._webAttrs.getWebAppName());
            }
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(11, 0)) {
                auditFactory.sendLogoutAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, ContextManagerFactory.getInstance().getDefaultRealm(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.logout.success.audit", null);
            }
            if (this._authMechanism.equals("LTPA")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LTPA Enabled, clearing LTPA Cookies");
                }
                this._webAttrs.createLogoutCookies(httpServletRequest, httpServletResponse);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LTPA and SSO NOT Enabled");
            }
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalidating existing HTTP Session");
                }
                httpSession.invalidate();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Existing HTTP Session does not exist, nothing to invalidate");
            }
            String string2 = httpServletRequest.getRemoteUser();
            if (string2 == null && (object2 = httpServletRequest.getUserPrincipal()) != null) {
                string2 = object2.getName();
            }
            if (string2 != null) {
                object2 = AuthCache.getInstance();
                try {
                    ((AuthCache)object2).removeEntry(null, string2);
                }
                catch (CacheException cacheException) {
                    if (!tc.isDebugEnabled()) break block51;
                    Tr.debug(tc, "Exception caught while trying to remove a cache entry: " + cacheException);
                }
            } else if (this._authMechanism.equals("LTPA")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user id is null, attempt to clear AuthCache entry by using LTPAToken cookie.");
                }
                object2 = this._webAttrs.getPreferredLTPACookieName();
                string = this._webAttrs.getLTPACookieName();
                objectArray = httpServletRequest.getCookies();
                if (objectArray != null) {
                    object = null;
                    object = WebAuthenticator.getCookieValues(objectArray, (String)object2);
                    if (object == null) {
                        object = WebAuthenticator.getCookieValues(objectArray, string);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cookie values: " + object);
                    }
                    if (object != null) {
                        for (n = 0; n < ((String[])object).length; ++n) {
                            Cookie cookie = object[n];
                            byte[] byArray = null;
                            if (cookie.length() <= 0 || (byArray = StringUtil.getBytes(Base64Coder.base64Decode((String)cookie))) == null || byArray.length <= 0) continue;
                            ByteArray byteArray = new ByteArray(byArray);
                            AuthCache authCache = AuthCache.getInstance();
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Cache Key: " + byteArray);
                                }
                                authCache.removeEntry(byteArray);
                                continue;
                            }
                            catch (CacheException cacheException) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Exception caught while trying to remove a cache entry by using token: " + cacheException);
                            }
                        }
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            object2 = httpServletRequest.getParameterNames();
            while (object2.hasMoreElements()) {
                string = (String)object2.nextElement();
                Tr.debug(tc, "paramName:" + string);
                objectArray = httpServletRequest.getParameterValues(string);
                if (objectArray.length == 1) {
                    object = objectArray[0];
                    if (((String)object).length() == 0) {
                        Tr.debug(tc, "paramValue:No Value");
                        continue;
                    }
                    Tr.debug(tc, "paramValue:" + (String)object);
                    continue;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    Tr.debug(tc, "paramValue:" + (String)objectArray[i]);
                }
            }
        }
        object2 = httpServletRequest.getParameter("logoutExitPage");
        boolean bl = false;
        try {
            boolean bl2 = SecurityConfig.getConfig().getBoolean("com.ibm.websphere.security.allowAnyLogoutExitPageHost");
            Tr.debug(tc, "com.ibm.websphere.security.allowAnyLogoutExitPageHost is set to: " + bl2);
            if (object2 != null && !bl2 && !((String)object2).equals("logon.jsp")) {
                bl = this.verifyLogoutURL(httpServletRequest, (String)object2);
                if (bl) {
                    Tr.debug(tc, "after verifyLogoutURL, logoutExitPage is valid: " + (String)object2);
                } else {
                    Tr.debug(tc, "after verifyLogoutURL, logoutExitPage is not valid: " + (String)object2);
                }
            } else {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "caught exception from calling: verifyLogoutURL: " + throwable.getMessage());
        }
        if (object2 != null && ((String)object2).length() != 0 && bl) {
            if (((String)object2).startsWith("//")) {
                object2 = ((String)object2).substring(1);
            }
            if (!WebContainerSystemProps.getSendRedirectCompatibilty()) {
                Tr.debug(tc, "Compatibility=false (default) redirect mode");
                if (this._absoluteUri && !this._adminConsole) {
                    if (((String)object2).equals("/")) {
                        object2 = "";
                    } else if (((String)object2).startsWith("/")) {
                        object2 = ((String)object2).substring(1);
                    }
                    Tr.debug(tc, "Logout exit page is not relative to Context Root.");
                } else if (((String)object2).startsWith("/")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    object = httpServletRequest.getContextPath();
                    if (object != null && ((String)object).endsWith("/")) {
                        n = ((String)object).lastIndexOf("/");
                        object = ((String)object).substring(0, n);
                    }
                    stringBuffer.append((String)object);
                    stringBuffer.append((String)object2);
                    object2 = stringBuffer.toString();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "logoutExitPage specified, redirecting to: " + (String)object2);
            }
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL((String)object2));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No logoutExitPage or invalid logoutExitPage specified");
            }
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println(DEFAULT_LOGOUT_MSG);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formLogout");
        }
    }

    private boolean verifyLogoutURL(HttpServletRequest httpServletRequest, String string) {
        boolean bl;
        block36: {
            String string2;
            Object object;
            CharSequence charSequence;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "verifyLogoutURL", string);
            }
            bl = false;
            InetAddress inetAddress = null;
            String string3 = null;
            try {
                Object object2;
                charSequence = SecurityConfig.getConfig().getProperty("com.ibm.websphere.security.logoutExitPageDomainList");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "List of configured domains for the logout exit page is: " + (String)charSequence);
                }
                object = null;
                string2 = null;
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "about to getLocalHost");
                }
                inetAddress = InetAddress.getLocalHost();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "return from getLocalHost: " + inetAddress);
                }
                object = inetAddress.getHostName();
                string2 = inetAddress.getHostAddress();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "short name of this host is: " + (String)object);
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "ip address of this host is: " + string2);
                }
                Object object3 = object;
                if (string2 != null) {
                    object3 = InetAddress.getByName(string2).getHostName();
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "this host full name is: " + (String)object3);
                    }
                }
                try {
                    object2 = new URL(string);
                    string3 = ((URL)object2).getHost();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "domain for exitPage url: " + string3);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught MalformedURLException getting url for exitPage: " + malformedURLException.getMessage());
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught exception getting url for exitPage: " + exception.getMessage());
                    }
                    bl = false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "specified name of the host for the url redirect is: " + string3);
                }
                object2 = "127.0.0.1";
                if (!bl && string3 != null && (string3.equalsIgnoreCase("localhost") || string3.equals(object2) || object3 != null && string3.equalsIgnoreCase((String)object3) || object != null && string3.equalsIgnoreCase((String)object) || string2 != null && string3.equals(string2))) {
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exitPage points to this host: all ok");
                    }
                } else if (!bl && string3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exitPage points to another host: verify that it is one on the list of allowed domains.");
                    }
                    if (charSequence != null && ((String)charSequence).length() > 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)charSequence, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string4 = stringTokenizer.nextToken();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "trying to match the domain for the exitPage : " + string3 + " to a domain name: " + string4 + " from the configured domain list");
                            }
                            if (!string4.equalsIgnoreCase(string3) && !string4.equalsIgnoreCase(string)) continue;
                            bl = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "matched a configured logout exit page domain: " + string4);
                            }
                            break;
                        }
                    }
                } else if (string3 == null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught an unknown exception: " + exception.getMessage());
                }
                bl = false;
            }
            if (!bl) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "about to attempt matching the logout exit url with the domain of the request.");
                    }
                    charSequence = httpServletRequest.getRequestURL();
                    object = new URL(new String((StringBuffer)charSequence));
                    string2 = ((URL)object).getHost();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " host of the request url is: " + string2 + " and the host of the logout URL is: " + string3);
                    }
                    if (string3 != null && string2 != null && string3.equalsIgnoreCase(string2)) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block36;
                    Tr.debug(tc, "caught Exception trying to form  request URL object: " + exception.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyLogoutURL", new Boolean(bl));
        }
        return bl;
    }
}

