/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.web.AmasWSAttributes;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import com.tivoli.pd.as.nls.AmasMsgHelper;
import com.tivoli.pd.as.util.MaskString;
import com.tivoli.pd.as.util.RWLock;
import com.tivoli.pd.jazn.PDAuthorizationContext;
import com.tivoli.pd.jazn.PDPrincipal;
import com.tivoli.pd.jutil.PDException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TAMTrustAssociationInterceptorPlus
implements TrustAssociationInterceptor {
    private static final String TAMTrustAssociationInterceptorPlus_java_sourceCodeID = "$Id: @(#)64  1.7 src/pdwas/com/ibm/ws5/security/web/TAMTrustAssociationInterceptorPlus.java, amemb.jacc.was, amemb600, 070522a 07/05/21 19:49:56 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    private static final String CLASSNAME = "com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlus";
    private static MaskString _trustPasswd;
    private static RWLock _trustPasswdLock;
    private Logger _logger;
    protected String[] ServerSources;
    protected String[] ID = null;
    protected String WebSealLoginID;
    protected boolean ignoreProxy;
    private static int sourceCnt;
    public String realm = "default";
    protected String WebSealUserID;
    protected boolean UsingLocallySpecifiedWebSealUser;
    protected String[] _propCredAttrs;
    protected PDAuthorizationContext _pdctx;
    protected Hashtable requests = new Hashtable();
    protected int _viaDepth = 1;
    protected Properties _wasProps;
    private long _ssoPwdExpiryTime = -1L;
    private long DEFAULT_PWD_EXPIRY = 600000L;
    private boolean _checkViaHeader;
    private String DEFAULT_CFG_URL = "file:///" + System.getProperty("java.home") + System.getProperty("file.separator") + "PdPerm.properties";

    public boolean isTargetInterceptor(HttpServletRequest httpServletRequest) throws WebTrustAssociationException {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "isTargetInterceptor(HttpServletRequest)");
        }
        boolean bl = false;
        boolean bl2 = true;
        int n = this.ID.length;
        for (int i = 0; i < n; ++i) {
            if (httpServletRequest.getHeader(this.ID[i]) != null || httpServletRequest.getHeader(this.ID[i] + "-segments") != null) continue;
            bl2 = false;
            if (!this._logger.isLoggable(Level.FINE)) break;
            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusisTargetInterceptor(HttpServletRequest) The ID header " + this.ID[i] + " was not present in the HttpServletRequest. Hence, it is not via WebSeal.");
            break;
        }
        if (this.ID.length <= 0 || !bl2) {
            if (this.ID.length <= 0 && this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusisTargetInterceptor(HttpServletRequest) There were no WebSeal ID property values. Hence, it is not via WebSeal.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "isTargetInterceptor(HttpServletRequest)", "false");
            }
            return false;
        }
        if (!this._checkViaHeader) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusisTargetInterceptor(HttpServletRequest) Check VIA header set to false.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "isTargetInterceptor(HttpServletRequest)", "true");
            }
            return true;
        }
        String string = httpServletRequest.getHeader("via");
        if (string != null) {
            bl = true;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusisTargetInterceptor(HttpServletRequest) VIA = " + string);
            }
            if ((string = string.trim()).length() > 0) {
                String[] stringArray = string.split(",");
                int n2 = stringArray.length;
                int n3 = this._viaDepth == 0 ? 0 : n2 - this._viaDepth;
                for (int i = n2 - 1; i >= n3 && i >= 0; --i) {
                    String string2 = stringArray[i];
                    if ((string2 = string2.trim()).length() <= 0 || this.ignoreProxy && string2.indexOf("roxy") != -1) continue;
                    String[] stringArray2 = string2.split(" ");
                    if (stringArray2.length > 1) {
                        String string3;
                        String string4;
                        string2 = stringArray2[1];
                        stringArray2 = (string2 = string2.trim()).split(":");
                        if (stringArray2.length > 1) {
                            string4 = stringArray2[0];
                            string3 = stringArray2[1];
                        } else {
                            string4 = string2;
                            string3 = "0";
                        }
                        if (this.checkVia(string4, string3)) continue;
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusisTargetInterceptor(HttpServletRequest) Host and port: " + string2 + " is not trusted.");
                        }
                        if (this._logger.isLoggable(Level.FINER)) {
                            this._logger.exiting(CLASSNAME, "isTargetInterceptor(HttpServletRequest)", "false");
                        }
                        return false;
                    }
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusisTargetInterceptor(HttpServletRequest) Incorrectly formatted via header entry encountered: " + string2);
                    }
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.exiting(CLASSNAME, "isTargetInterceptor(HttpServletRequest)", "false");
                    }
                    return false;
                }
            }
        } else if (this.ServerSources == null || this.ServerSources.length == 0) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusisTargetInterceptor(HttpServletRequest) No trusted sources in the list of trusted sources.");
            }
            bl = true;
        }
        if (!bl) {
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "isTargetInterceptor(HttpServletRequest)", "false");
            }
            return false;
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "isTargetInterceptor(HttpServletRequest)", "true");
        }
        return true;
    }

    private void validateEstablishedTrust(HttpServletRequest httpServletRequest) throws WebTrustAssociationFailedException {
        String string;
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "validateEstablishedTrust(HttpServletRequest)");
        }
        if ((string = httpServletRequest.getHeader("Authorization")) == null || !string.startsWith("Basic ")) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) Authentication method is not Basic Auth in HTTP request.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "validateEstablishedTrust(HttpServletRequest)");
            }
            throw new WebTrustAssociationFailedException("Basic Auth is expected in Trust Association mode.");
        }
        String[] stringArray = (string = Base64Coder.base64Decode(string.substring(6))).split(":");
        if (stringArray == null || stringArray.length != 2) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) Incorrect basic auth username:password format found.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "validateEstablishedTrust(HttpServletRequest)");
            }
            throw new WebTrustAssociationFailedException("Basic Auth username/password field is formatted incorrectly.");
        }
        String string2 = this.WebSealLoginID;
        if (string2 == null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) Null loginid username encountered.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "validateEstablishedTrust(HttpServletRequest)");
            }
            throw new WebTrustAssociationFailedException("Basic Authentication failed. Null loginid username.");
        }
        String string3 = stringArray[1];
        if (string3 == null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) Null password encountered.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "validateEstablishedTrust(HttpServletRequest)");
            }
            throw new WebTrustAssociationFailedException("Basic Authentication failed. Null password.");
        }
        boolean bl = false;
        if (_trustPasswd != null) {
            String string4 = _trustPasswd.getClearString();
            if (_trustPasswd.validPassword() && string4 != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) SSO password is cached. Attempting to authenticate " + string2);
                }
                if (string3 == null || !string3.equals(string4)) {
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) SSO password cached. Authentication failed.");
                    }
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.exiting(CLASSNAME, "validateEstablishedTrust(HttpServletRequest)");
                    }
                    throw new WebTrustAssociationFailedException("Basic Authentication failed.");
                }
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) SSO password not cached. Attempting to authenticate " + string2);
            }
            try {
                new PDPrincipal(this._pdctx, string2, string3.toCharArray());
            }
            catch (PDException pDException) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) Authentication failed: " + pDException.toString());
                }
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.exiting(CLASSNAME, "validateEstablishedTrust(HttpServletRequest)");
                }
                throw new WebTrustAssociationFailedException("Basic Authentication failed.");
            }
            this.setSSOPassword(string3.toCharArray());
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusvalidateEstablishedTrust(HttpServletRequest) Authentication succeeded.");
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "validateEstablishedTrust(HttpServletRequest)");
        }
    }

    private Subject buildSubject(PDPrincipal pDPrincipal) throws PDException, ClassNotFoundException {
        if (this._logger.isLoggable(Level.FINER)) {
            if (pDPrincipal != null) {
                this._logger.entering(CLASSNAME, "buildSubject(PDPrincipal prin, String cred)", pDPrincipal.getName());
            } else {
                this._logger.entering(CLASSNAME, "buildSubject(PDPrincipal prin, String cred)", null);
            }
        }
        AmasWSAttributes amasWSAttributes = new AmasWSAttributes();
        amasWSAttributes.initialize(this._pdctx);
        Hashtable hashtable = amasWSAttributes.getAttributes((Principal)pDPrincipal);
        HashSet<PDPrincipal> hashSet = new HashSet<PDPrincipal>();
        HashSet<Hashtable> hashSet2 = new HashSet<Hashtable>();
        HashSet hashSet3 = new HashSet();
        hashSet.add(pDPrincipal);
        hashSet2.add(hashtable);
        Subject subject = new Subject(false, hashSet, hashSet2, hashSet3);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "buildSubject(PDPrincipal, String)");
        }
        return subject;
    }

    private PDAuthorizationContext createPDContext(String string) throws PDException, MalformedURLException {
        URL uRL;
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "createPDContext(String configURL)", string);
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            string = "file:///" + string;
            uRL = new URL(string);
        }
        PDAuthorizationContext pDAuthorizationContext = new PDAuthorizationContext(uRL);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "createPDContext(String)");
        }
        return pDAuthorizationContext;
    }

    private PDPrincipal createPDPrincipal(String string) throws PDException {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "createPDPrincipal(String)");
        }
        PDPrincipal pDPrincipal = new PDPrincipal(this._pdctx, string.getBytes());
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "createPDPrincipal(String)");
        }
        return pDPrincipal;
    }

    public int initialize(Properties properties) throws WebTrustAssociationFailedException {
        this._logger = Logger.getLogger(CLASSNAME);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "initialize(Properties)");
        }
        if (properties == null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Properties object is null");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
            }
            return -1;
        }
        this._wasProps = properties;
        try {
            String[] stringArray;
            String[] stringArray2;
            CharSequence charSequence;
            String string;
            block107: {
                block106: {
                    block105: {
                        block104: {
                            block103: {
                                try {
                                    string = (String)properties.get("com.ibm.websphere.security.webseal.id");
                                    this.ID = this.getIDElements(string);
                                    if (this.ID == null) {
                                        if (this._logger.isLoggable(Level.INFO)) {
                                            this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatSingleParamMessage(929857544, "com.ibm.websphere.security.webseal.id"));
                                        }
                                        if (this._logger.isLoggable(Level.INFO)) {
                                            this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                                        }
                                        if (this._logger.isLoggable(Level.FINE)) {
                                            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Could not retrieve webseal.id Initialization has failed.");
                                        }
                                        if (this._logger.isLoggable(Level.FINER)) {
                                            this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                                        }
                                        return -1;
                                    }
                                }
                                catch (Exception exception) {
                                    if (this._logger.isLoggable(Level.INFO)) {
                                        this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatDoubleParamMessage(929857537, "com.ibm.websphere.security.webseal.id", exception.toString()));
                                    }
                                    if (this._logger.isLoggable(Level.INFO)) {
                                        this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                                    }
                                    if (this._logger.isLoggable(Level.FINE)) {
                                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Exception encountered when retrieving webseal.id : " + exception);
                                    }
                                    if (this._logger.isLoggable(Level.FINER)) {
                                        this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                                    }
                                    return -1;
                                }
                                try {
                                    string = (String)properties.get("com.ibm.websphere.security.webseal.checkViaHeader");
                                    if (string != null && string.equalsIgnoreCase("true")) {
                                        if (this._logger.isLoggable(Level.FINE)) {
                                            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Check VIA header has been set to true.");
                                        }
                                        this._checkViaHeader = true;
                                    } else {
                                        if (this._logger.isLoggable(Level.FINE)) {
                                            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Check VIA header has been set to false.");
                                        }
                                        this._checkViaHeader = false;
                                    }
                                }
                                catch (Exception exception) {
                                    if (!this._logger.isLoggable(Level.FINE)) break block103;
                                    charSequence = new StringBuffer();
                                    charSequence.append(CLASSNAME);
                                    charSequence.append("initialize(Properties) Exception encountered while retrieving webseal.checkViaHeader Check VIA header has been set to ");
                                    charSequence.append(this._checkViaHeader);
                                    charSequence.append(" : ");
                                    charSequence.append(exception);
                                    this._logger.fine(charSequence.toString());
                                }
                            }
                            try {
                                string = (String)properties.get("com.ibm.websphere.security.webseal.hostnames");
                                stringArray2 = this.getElements(string);
                                if (stringArray2 != null) break block104;
                                if (!this._checkViaHeader) {
                                    if (this._logger.isLoggable(Level.FINE)) {
                                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) There are no trusted hostnames configured but via header will not be checked anyway.");
                                    }
                                    break block104;
                                }
                                if (this._logger.isLoggable(Level.INFO)) {
                                    this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatSingleParamMessage(929857544, "com.ibm.websphere.security.webseal.hostnames"));
                                }
                                if (this._logger.isLoggable(Level.INFO)) {
                                    this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                                }
                                if (this._logger.isLoggable(Level.FINE)) {
                                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Could not retrieve webseal.hostnames and checkViaHeader is true. Initialization has failed.");
                                }
                                if (this._logger.isLoggable(Level.FINER)) {
                                    this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                                }
                                return -1;
                            }
                            catch (Exception exception) {
                                if (!this._checkViaHeader) {
                                    if (this._logger.isLoggable(Level.FINE)) {
                                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) There are no trusted hostnames configured but via header will not be checked anyway.");
                                    }
                                    stringArray2 = null;
                                }
                                if (this._logger.isLoggable(Level.INFO)) {
                                    this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatDoubleParamMessage(929857537, "com.ibm.websphere.security.webseal.hostnames", exception.toString()));
                                }
                                if (this._logger.isLoggable(Level.INFO)) {
                                    this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                                }
                                if (this._logger.isLoggable(Level.FINE)) {
                                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Exception encountered when retrieving webseal.hostnames : " + exception.toString());
                                }
                                if (this._logger.isLoggable(Level.FINER)) {
                                    this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                                }
                                return -1;
                            }
                        }
                        try {
                            string = (String)properties.get("com.ibm.websphere.security.webseal.ports");
                            stringArray = this.getElements(string);
                            if (stringArray != null) break block105;
                            if (!this._checkViaHeader) {
                                if (this._logger.isLoggable(Level.FINE)) {
                                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) There are no trusted host ports configured but via header will not be checked anyway.");
                                }
                                break block105;
                            }
                            if (this._logger.isLoggable(Level.INFO)) {
                                this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatSingleParamMessage(929857544, "com.ibm.websphere.security.webseal.ports"));
                            }
                            if (this._logger.isLoggable(Level.INFO)) {
                                this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                            }
                            if (this._logger.isLoggable(Level.FINE)) {
                                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Could not retrieve webseal.ports and checkViaHeader is true. Initialization has failed.");
                            }
                            if (this._logger.isLoggable(Level.FINER)) {
                                this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                            }
                            return -1;
                        }
                        catch (Exception exception) {
                            if (!this._checkViaHeader) {
                                if (this._logger.isLoggable(Level.FINE)) {
                                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) There are no trusted host ports configured but via header will not be checked anyway.");
                                }
                                stringArray = null;
                            }
                            if (this._logger.isLoggable(Level.INFO)) {
                                this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatDoubleParamMessage(929857537, "com.ibm.websphere.security.webseal.ports", exception.toString()));
                            }
                            if (this._logger.isLoggable(Level.INFO)) {
                                this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                            }
                            if (this._logger.isLoggable(Level.FINE)) {
                                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Exception encountered when retrieving webseal.ports : " + exception.toString());
                            }
                            if (this._logger.isLoggable(Level.FINER)) {
                                this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                            }
                            return -1;
                        }
                    }
                    try {
                        string = (String)properties.get("com.ibm.websphere.security.webseal.viaDepth");
                        this._viaDepth = Integer.parseInt(string);
                        if (this._viaDepth < 0 && this._checkViaHeader) {
                            if (this._logger.isLoggable(Level.INFO)) {
                                this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatSingleParamMessage(929857543, "com.ibm.websphere.security.webseal.viaDepth"));
                            }
                            if (this._logger.isLoggable(Level.INFO)) {
                                this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                            }
                            if (this._logger.isLoggable(Level.FINE)) {
                                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) webseal.viaDepth is an invalid value of less than 0. Initialization has failed.");
                            }
                            if (this._logger.isLoggable(Level.FINER)) {
                                this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                            }
                            return -1;
                        }
                    }
                    catch (Exception exception) {
                        this._viaDepth = 0;
                        if (!this._logger.isLoggable(Level.FINE)) break block106;
                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Exception encountered when retrieving webseal.viaDepth : " + exception.toString() + " VIA Depth has been set to default value of " + this._viaDepth);
                    }
                }
                try {
                    string = (String)properties.get("com.ibm.websphere.security.webseal.ssoPwdExpiry");
                    this._ssoPwdExpiryTime = Long.parseLong(string) * 1000L;
                    if (this._ssoPwdExpiryTime < 0L) {
                        if (this._logger.isLoggable(Level.INFO)) {
                            this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatSingleParamMessage(929857542, "com.ibm.websphere.security.webseal.ssoPwdExpiry"));
                        }
                        if (this._logger.isLoggable(Level.INFO)) {
                            this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                        }
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) webseal.ssoPwdExpiry is a negative value. Initialization has failed.");
                        }
                        if (this._logger.isLoggable(Level.FINER)) {
                            this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                        }
                        return -1;
                    }
                    if (this._ssoPwdExpiryTime == 0L && this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) webseal.ssoPwdExpiry value is 0. Cached SSO password will never expire.");
                    }
                }
                catch (Exception exception) {
                    this._ssoPwdExpiryTime = this.DEFAULT_PWD_EXPIRY;
                    if (!this._logger.isLoggable(Level.FINE)) break block107;
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Exception encountered when retrieving webseal.ssoPwdExpiry. Expiry time has been set to default " + this.DEFAULT_PWD_EXPIRY / 1000L + " seconds : " + exception.toString());
                }
            }
            try {
                this.WebSealLoginID = (String)properties.get("com.ibm.websphere.security.webseal.loginId");
                if (this.WebSealLoginID == null) {
                    if (this._logger.isLoggable(Level.INFO)) {
                        this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatSingleParamMessage(929857544, "com.ibm.websphere.security.webseal.loginId"));
                    }
                    if (this._logger.isLoggable(Level.INFO)) {
                        this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                    }
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Mandatory property webseal login id was not specified. Initialization has failed.");
                    }
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                    }
                    return -1;
                }
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) WebSeal Login ID has been set to configured login id.");
                }
            }
            catch (Exception exception) {
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatDoubleParamMessage(929857537, "com.ibm.websphere.security.webseal.loginId", exception.toString()));
                }
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857541, null));
                }
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Webseal login id property could not be retrieved.");
                }
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                }
                return -1;
            }
            try {
                string = (String)properties.get("com.ibm.websphere.security.webseal.configURL");
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) PDJRTE config URL = " + string);
                }
                this._pdctx = this.createPDContext(string);
            }
            catch (Exception exception) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Exception encountered while creating PDAuthorizationContext. Attempting to use default config URL " + this.DEFAULT_CFG_URL);
                }
                try {
                    this._pdctx = this.createPDContext(this.DEFAULT_CFG_URL);
                }
                catch (Exception exception2) {
                    if (this._logger.isLoggable(Level.INFO)) {
                        this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatSingleParamMessage(929857538, exception2.toString()));
                    }
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Exception encountered while creating PDAuthorizationContext: " + exception2.toString());
                    }
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
                    }
                    return -1;
                }
            }
            if (stringArray2 != null && stringArray2.length > 0 && stringArray != null && stringArray.length > 0) {
                this.ServerSources = new String[stringArray.length * stringArray2.length];
            } else if (stringArray2 != null && stringArray2.length > 0) {
                this.ServerSources = new String[stringArray2.length];
            }
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    string = stringArray2[i];
                    if (stringArray != null) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            charSequence = stringArray[j];
                            this.addASource(string, (String)charSequence);
                        }
                        continue;
                    }
                    this.addASource(string, "0");
                }
            }
            try {
                string = (String)properties.get("com.ibm.websphere.security.webseal.ignoreProxy");
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Ignore proxy = " + string);
                }
                this.ignoreProxy = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
            }
            catch (Exception exception) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Ignore proxy not defined, defaulting to " + this.ignoreProxy);
                }
                this.ignoreProxy = false;
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "initialize(Properties)", "0");
            }
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatMessage(929857540, null));
            }
            return 0;
        }
        catch (Exception exception) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) " + AmasMsgHelper.formatSingleParamMessage(929857539, exception.toString()));
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusinitialize(Properties) Exception encountered during initialization: " + exception.toString());
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "initialize(Properties)", "-1");
            }
            return -1;
        }
    }

    private void addASource(String string, String string2) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "addASource(String hostname, String port)", new String[]{string, string2});
        }
        if (string == null || string.length() == 0) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusaddASource(String, String) Attempting to add an invalid hostname.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "addASource(String, String)");
            }
            return;
        }
        try {
            Integer.decode(string2);
        }
        catch (Exception exception) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusaddASource(String, String) Attempting to add an invalid port.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "addASource(String, String)");
            }
            return;
        }
        this.ServerSources[TAMTrustAssociationInterceptorPlus.sourceCnt++] = string + ":" + string2;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusaddASource(String, String) Added source = " + string + ":" + string2);
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "addASource(String, String)");
        }
    }

    public void cleanup() {
    }

    private String[] getElements(String string) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "getElements(String strList)", string);
        }
        if (string != null && string.trim().length() > 0) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (!this._logger.isLoggable(Level.FINE)) continue;
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusgetElements(String) Added " + stringArray[i] + " to the list.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "getElements(String)");
            }
            return stringArray;
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "getElements(String)", "null");
        }
        return null;
    }

    private String[] getIDElements(String string) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "getIDElements(String strList)", string);
        }
        if (string != null && string.trim().length() > 0) {
            if (string.indexOf("iv-creds") == -1 && string.indexOf("IV-CREDS") == -1) {
                string = string.endsWith(",") ? string + "iv-creds" : string + ",iv-creds";
            }
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (!this._logger.isLoggable(Level.FINE)) continue;
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusgetIDElements(String) Added " + stringArray[i] + " to the list.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "getIDElements(String)");
            }
            return stringArray;
        }
        String[] stringArray = new String[]{"iv-creds"};
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusgetIDElements(String) Added iv-creds to the list.");
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "getIDElements(String)");
        }
        return stringArray;
    }

    private boolean checkVia(String string, String string2) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "checkVia(String host, String port)", new String[]{string, string2});
        }
        String string3 = string + ":0";
        String string4 = string + ":" + string2;
        if (this.ServerSources == null || this.ServerSources.length == 0) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPluscheckVia(String, String) Trusted sources list is empty.");
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "checkVia(String, String)", "true");
            }
            return true;
        }
        for (int i = 0; i < this.ServerSources.length; ++i) {
            String string5 = this.ServerSources[i];
            if (!string5.equalsIgnoreCase(string3) && !string5.equalsIgnoreCase(string4)) continue;
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.exiting(CLASSNAME, "checkVia(String, String)", "true");
            }
            return true;
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "checkVia(String, String)", "false");
        }
        return false;
    }

    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WebTrustAssociationFailedException {
        String string;
        Subject subject;
        block20: {
            PDPrincipal pDPrincipal;
            String string2;
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.entering(CLASSNAME, "negotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse)");
            }
            this.validateEstablishedTrust(httpServletRequest);
            subject = null;
            String string3 = httpServletRequest.getHeader("iv-creds");
            if ((string3 == null || string3.length() <= 0) && (string2 = httpServletRequest.getHeader("iv-creds-segments")) != null) {
                int n = Integer.parseInt(string2);
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = true;
                for (int i = 1; i <= n; ++i) {
                    String string4 = httpServletRequest.getHeader("iv-creds-" + i);
                    if (string4 == null) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusnegotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse) iv-creds-" + i + " header required but was not found in request");
                        }
                        string3 = null;
                        bl = false;
                        break;
                    }
                    stringBuffer.append(string4);
                }
                if (bl && n > 0) {
                    string3 = stringBuffer.toString();
                }
            }
            if (string3 == null || string3.length() <= 0) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusnegotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse) The credential in the HttpServletRequest was null.");
                }
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.exiting(CLASSNAME, "negotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse)");
                }
                throw new WebTrustAssociationFailedException("The credential in the HttpServletRequest was null.");
            }
            try {
                pDPrincipal = this.createPDPrincipal(string3);
            }
            catch (PDException pDException) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusnegotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse) Exception encountered while constructing PDPrincipal: " + pDException.toString());
                }
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.exiting(CLASSNAME, "negotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse)");
                }
                throw new WebTrustAssociationFailedException("Exception encountered while constructing PDPrincipal: " + pDException.toString());
            }
            try {
                string = pDPrincipal.getName();
            }
            catch (Exception exception) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusnegotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse) Exception encountered while extracting username from PDPrincipal: " + exception.toString());
                }
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.exiting(CLASSNAME, "negotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse)");
                }
                throw new WebTrustAssociationFailedException("Exception encountered while extracting username from PDPrincipal: " + exception.toString());
            }
            try {
                subject = this.buildSubject(pDPrincipal);
            }
            catch (Exception exception) {
                if (!this._logger.isLoggable(Level.FINE)) break block20;
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusnegotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse) Exception encountered while constructing subject: " + exception.toString());
            }
        }
        TAIResult tAIResult = subject != null ? TAIResult.create(200, string, subject) : TAIResult.create(200, string);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "negotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse)");
        }
        return tAIResult;
    }

    private void setSSOPassword(char[] cArray) {
        boolean bl;
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.entering(CLASSNAME, "setSSOPassword(char[])");
        }
        if (bl = _trustPasswdLock.getWriterLock()) {
            if (_trustPasswd == null) {
                _trustPasswd = new MaskString(cArray, this._ssoPwdExpiryTime);
            } else {
                _trustPasswd.setMaskedString(new String(cArray));
            }
            _trustPasswdLock.releaseLock();
            String string = this._ssoPwdExpiryTime > 0L ? new String("Expiry of cached WebSEAL SSO password set: " + this._ssoPwdExpiryTime) : new String("Cached WebSEAL SSO password does not expire");
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("com.ibm.ws.security.web.TAMTrustAssociationInterceptorPlusnegotiateValidateandEstablishTrust(HttpServletRequest, HttpServletResponse)" + string);
            }
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.exiting(CLASSNAME, "setSSOPassword(char[])");
        }
    }

    public String getVersion() {
        return TAMTrustAssociationInterceptorPlus_java_sourceCodeID;
    }

    public String getType() {
        return CLASSNAME;
    }

    static {
        _trustPasswdLock = new RWLock();
    }
}

