/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.net.InetAddress;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.webapplication.FormLoginConfig;
import org.eclipse.jst.j2ee.webapplication.LoginConfig;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class WebAttributes {
    private static final TraceComponent tc = Tr.register(WebAttributes.class, "Security", "com.ibm.ejs.resources.security");
    private static final TraceComponent zOS_tc = Tr.register("WebAttributes.class", null, "com.ibm.ejs.resources.ws390Messages");
    public static final String LOCALOS = "LOCALOS";
    public static final String LTPA = "LTPA";
    public static final String UNSUPPORTED = "UNSUPPORTED";
    private static Object lockObject = new Object();
    private static Cookie cookieAttrs;
    private static boolean secureSSO;
    private static boolean setSSODomain;
    private static String loginCookieName;
    private static String cookieSuffix;
    private static final String SSO_COOKIE_SUFFIX = "Token";
    private static String[] ltpaCookieNames;
    private static boolean isSecurityEnabled;
    private static boolean setHttpOnlyFlag;
    private static String authMechanism;
    private static final char CERTIFICATE_FLAG = 'C';
    private static final char COOKIE_FLAG = 'K';
    private static final char AUTHORIZATION_FLAG = 'A';
    private static String[] ssoDomainList;
    private static boolean useURLDomain;
    private static HashMap cookieStringCache;
    private static int MAX_COOKIE_STRING_ENTRIES;
    private boolean isProtected = true;
    private String realm = null;
    private String challengeType;
    private boolean useSSL = false;
    private boolean defaultToBasic = false;
    private String pluginCfg;
    private String loginURL = null;
    private String reloginURL = null;
    private String webAppName = null;
    private boolean _applicationSyncToOSThreadEnabled;

    public WebAttributes() {
        this.isProtected = false;
    }

    public WebAttributes(WebApp webApp) throws RuntimeException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebAttributes");
        }
        WebAttributes.initializeConfig();
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("com.ibm.ws.security.addHttpOnlyAttributeToCookies");
        if (bl != null) {
            setHttpOnlyFlag = bl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setHttpOnlyFlag =  " + setHttpOnlyFlag);
        }
        if ((string = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.web.failOverToBasicAuth")) != null && string.equalsIgnoreCase("true")) {
            this.defaultToBasic = true;
        }
        this._applicationSyncToOSThreadEnabled = this.getApplicationSyncToOSThread(webApp);
        try {
            LoginConfig loginConfig;
            this.webAppName = webApp.getDisplayName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Webattrs for webApp =  " + this.webAppName);
            }
            if ((loginConfig = webApp.getLoginConfig()) != null) {
                this.realm = loginConfig.getRealmName();
                int n = loginConfig.getAuthMethod().getValue();
                if (n == 1) {
                    this.challengeType = "BASIC";
                } else if (n == 4) {
                    this.challengeType = "CLIENT_CERT";
                } else if (n == 3) {
                    this.challengeType = "FORM";
                    FormLoginConfig formLoginConfig = loginConfig.getFormLoginConfig();
                    if (formLoginConfig != null) {
                        this.loginURL = formLoginConfig.getFormLoginPage();
                        this.reloginURL = formLoginConfig.getFormErrorPage();
                    }
                } else {
                    this.challengeType = n == 2 ? "DIGEST" : "BASIC";
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Login Config is not available for webApp " + this.webAppName + " Assuming Basic Authentication");
                }
                this.challengeType = "BASIC";
                this.realm = "Default Realm";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "realm is " + this.realm);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "use SSL is " + new Boolean(this.useSSL));
            }
            boolean bl2 = this.isProtected = !this.challengeType.equals("none");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "challenge type is " + this.challengeType);
            }
            StringBuffer stringBuffer = new StringBuffer(3);
            if (this.challengeType.equals("CLIENT_CERT")) {
                stringBuffer.append('C');
            }
            if (this.isSSOEnabled()) {
                stringBuffer.append('K');
            }
            if (this.defaultToBasic || this.challengeType.equals("BASIC")) {
                stringBuffer.append('A');
            }
            this.pluginCfg = stringBuffer.toString();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAttributes.WebAttributes", "230", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WebAttributes", exception);
            }
            Tr.error(tc, "security.webatts.exception", new Object[]{this.webAppName, exception});
            throw new RuntimeException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebAttributes");
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getChallengeType() {
        return this.challengeType;
    }

    public String getAuthMechanism() {
        return (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
    }

    public boolean isSSLEnabled() {
        return this.useSSL;
    }

    public boolean isSSOEnabled() {
        return (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
    }

    private static Iterator getSingleSignonTokensFromSubject(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSingleSignonTokensFromSubject");
        }
        try {
            ArrayList arrayList = new ArrayList();
            if (subject != null) {
                Set set = null;
                Set set2 = null;
                HashSet hashSet = new HashSet();
                try {
                    set = (Set)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                        public Object run() {
                            return subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = WebAttributes.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken);
                        }
                    });
                    if (set != null && set.size() > 0) {
                        hashSet.addAll(set);
                    }
                    if ((set2 = subject.getPublicCredentials(SingleSignonToken.class)) != null && set2.size() > 0) {
                        hashSet.addAll(set2);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSingleSignonTokensFromSubject");
                    }
                    return hashSet.iterator();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.security.WebAttributes.getSingleSignonToken", "325");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSingleSignonTokensFromSubject", new Object[]{exception});
                    }
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonTokensFromSubject: (null)");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.WebAttributes.getDefaultSingleSignonToken", "336");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonTokensFromSubject", new Object[]{exception});
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCookieToList(HttpServletRequest httpServletRequest, String string, byte[] byArray, ArrayList arrayList, boolean bl) {
        if (byArray != null || bl) {
            Object object;
            String string2 = "";
            if (!bl && (string2 = (String)cookieStringCache.get(new ByteArray(byArray))) == null) {
                string2 = Base64Coder.base64Encode(StringUtil.toString(byArray));
                object = cookieStringCache;
                synchronized (object) {
                    if (cookieStringCache.size() > MAX_COOKIE_STRING_ENTRIES) {
                        cookieStringCache.clear();
                    }
                    if (string2 != null) {
                        cookieStringCache.put(new ByteArray(byArray), string2);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSO cookie with name: " + string + " logout " + bl + ", value: " + string2);
            }
            if ((object = new Cookie(string, string2)) != null) {
                WebAttributes.copyIntoStatic(object, httpServletRequest);
                if (bl) {
                    object.setMaxAge(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cookie value: " + object.getValue());
                }
                arrayList.add(object);
            }
        }
    }

    public void createLogoutCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        WebAttributes.createLogoutCookiesStatic(httpServletRequest, httpServletResponse);
    }

    public static void createLogoutCookiesStatic(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLogoutCookiesStatic");
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String[] stringArray = WebAttributes.getAllLTPACookieNamesStatic();
        ArrayList arrayList = new ArrayList();
        if (cookieArray != null) {
            int n;
            for (n = 0; n < cookieArray.length; ++n) {
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!cookieArray[n].getName().equals(stringArray[i])) continue;
                        WebAttributes.addCookieToList(httpServletRequest, stringArray[i], null, arrayList, true);
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.security.web.WebAttributes.createLogoutCookiesStatic", "413");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception creating logout cookie.", new Object[]{throwable});
                }
            }
            cookieArray = arrayList.toArray(new Cookie[0]);
            for (n = 0; n < cookieArray.length; ++n) {
                try {
                    httpServletResponse.addCookie(cookieArray[n]);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.security.web.WebAttributes.createLogoutCookiesStatic", "426");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception adding logout cookie to response.", new Object[]{throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLogoutCookiesStatic");
        }
    }

    public static void addCookiesToResponse(List list, HttpServletResponse httpServletResponse) {
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Cookie cookie = (Cookie)listIterator.next();
                if (cookie == null) continue;
                if (setHttpOnlyFlag) {
                    StringBuffer stringBuffer = new StringBuffer(cookie.getName());
                    stringBuffer.append("=");
                    stringBuffer.append(cookie.getValue());
                    stringBuffer.append("; ");
                    if (cookie.getPath() != null && cookie.getPath().length() > 0) {
                        stringBuffer.append("path=");
                        stringBuffer.append(cookie.getPath());
                    } else {
                        stringBuffer.append("path=/");
                    }
                    if (cookie.getDomain() != null && cookie.getDomain().length() > 0) {
                        stringBuffer.append("; domain=");
                        stringBuffer.append(cookie.getDomain());
                    }
                    if (cookie.getSecure()) {
                        stringBuffer.append("; secure");
                    }
                    stringBuffer.append("; HttpOnly");
                    if (stringBuffer == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting cookie string into response: Set-Cookie: " + stringBuffer.toString());
                    }
                    httpServletResponse.addHeader("Set-Cookie", stringBuffer.toString());
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting cookie into response.");
                }
                httpServletResponse.addCookie(cookie);
            }
        }
    }

    public static ArrayList createCookies(HttpServletRequest httpServletRequest, Subject subject) {
        return WebAttributes.createCookiesStatic(httpServletRequest, subject);
    }

    public static ArrayList createCookiesStatic(HttpServletRequest httpServletRequest, Subject subject) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookiesStatic");
        }
        ArrayList arrayList = new ArrayList();
        Object object3 = null;
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        if (SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled").equals("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Propagation enabled, adding new cookie.");
            }
            object2 = WebAttributes.getSingleSignonTokensFromSubject(subject);
            while (object2.hasNext()) {
                object = (SingleSignonToken)object2.next();
                if (object == null) continue;
                byte[] byArray = object.getBytes();
                String string = object.getName();
                if (string.equals("LtpaToken")) {
                    object3 = object;
                }
                short s = object.getVersion();
                String string2 = string + new Short(s).toString();
                WebAttributes.addCookieToList(httpServletRequest, string2, byArray, arrayList, false);
            }
        }
        if (SecurityConfig.getConfig().getValue("com.ibm.ws.security.ssoInteropModeEnabled").equals("true") || SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled").equals("false") || arrayList.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding old cookie.");
            }
            object2 = null;
            object = WebAttributes.getLTPACookieNameStatic();
            if (wSCredential != null) {
                block12: {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Getting interop token from default SSO token previously found.");
                        }
                        object2 = wSCredential.getCredentialToken();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, "com.ibm.ws.security.web.WebAttributes.createCookiesStatic", "556");
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "Exception getting WSCredential token.", new Object[]{exception});
                    }
                }
                WebAttributes.addCookieToList(httpServletRequest, (String)object, (byte[])object2, arrayList, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookiesStatic: returning " + arrayList.size() + " cookie(s) to add to response.");
        }
        return arrayList;
    }

    public boolean isSecureSSO() {
        return secureSSO;
    }

    public boolean isDefaultToBasic() {
        return this.defaultToBasic;
    }

    public String getLTPACookieName() {
        return "LtpaToken";
    }

    public static String getLTPACookieNameStatic() {
        return "LtpaToken";
    }

    public String getPreferredLTPACookieName() {
        if (SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled").equals("true")) {
            return "LtpaToken2";
        }
        return "LtpaToken";
    }

    public String[] getAllLTPACookieNames() {
        return ltpaCookieNames;
    }

    public static String[] getAllLTPACookieNamesStatic() {
        return ltpaCookieNames;
    }

    public String getLoginCookieName() {
        return loginCookieName;
    }

    public String getCookieSuffix() {
        return cookieSuffix;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("webAppName[" + this.webAppName + "]");
        stringBuffer.append("\nisProtected[" + this.isProtected() + "]");
        stringBuffer.append("\nrealm[" + this.getRealm() + "]");
        stringBuffer.append("\nchallengeType[" + this.getChallengeType() + "]");
        stringBuffer.append("\nauthMechanism[" + this.getAuthMechanism() + "]");
        stringBuffer.append("\nSSLEnabled[" + this.isSSLEnabled() + "]");
        stringBuffer.append("\nSSOEnabled[" + this.isSSOEnabled() + "]");
        stringBuffer.append("\nsecureSSO[" + this.isSecureSSO() + "]");
        stringBuffer.append("\ndefaultToBasic[" + this.isDefaultToBasic() + "]");
        stringBuffer.append("\nLTPACookieName[" + this.getLTPACookieName() + "]");
        stringBuffer.append("\nloginCookieName[" + this.getLoginCookieName() + "]");
        stringBuffer.append("\nCookieSuffix[" + this.getCookieSuffix() + "]");
        return stringBuffer.toString();
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public String getReloginURL() {
        return this.reloginURL;
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public void copyInto(Cookie cookie, HttpServletRequest httpServletRequest) {
        WebAttributes.copyIntoStatic(cookie, httpServletRequest);
    }

    public static void copyIntoStatic(Cookie cookie, HttpServletRequest httpServletRequest) {
        if (setSSODomain) {
            String string = WebAttributes.getSSODomain(httpServletRequest);
            if (string.length() > 0) {
                cookie.setDomain(WebAttributes.getSSODomain(httpServletRequest));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSO domain setting is disabled ");
        }
        cookie.setMaxAge(cookieAttrs.getMaxAge());
        cookie.setPath(cookieAttrs.getPath());
        cookie.setSecure(cookieAttrs.getSecure());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeConfig() throws RuntimeException {
        Object object = lockObject;
        synchronized (object) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeConfig");
            }
            try {
                Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
                isSecurityEnabled = bl != null ? bl : false;
                Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
                if (bl2.booleanValue()) {
                    boolean bl3;
                    Boolean bl4 = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled");
                    boolean bl5 = bl3 = bl4 != null ? bl4 : false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSO is " + bl3);
                    }
                    if (bl3) {
                        String string = (String)SecurityConfig.getConfig().getValue("security.ltpa.sso.domain");
                        if (string == null) {
                            string = "";
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SSO Domain is " + string);
                        }
                        cookieAttrs = new Cookie("LtpaToken", null);
                        WebAttributes.setSSODomainList(string);
                        Boolean bl6 = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.ssl");
                        secureSSO = bl6 != null ? bl6 : false;
                        cookieAttrs.setSecure(secureSSO);
                        Boolean bl7 = (Boolean)SecurityConfig.getConfig().getValue("security.ltpa.setSSODomain");
                        if (bl7 != null) {
                            setSSODomain = bl7;
                        }
                        if (string.length() < 1) {
                            setSSODomain = false;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SSO is secure " + secureSSO);
                        }
                        cookieAttrs.setPath("/");
                        cookieAttrs.setMaxAge(-1);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.web.WebAttributes.initializeConfig", "780");
                Tr.warning(tc, "security.web.config.initerror", new Object[]{exception});
                throw new RuntimeException(exception.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeConfig");
            }
        }
    }

    private static void setSSODomainList(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSSODomainList");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Raw List: '" + string + "'");
        }
        if (string != null && ssoDomainList == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,|");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equalsIgnoreCase("UseDomainFromURL")) {
                    useURLDomain = true;
                    continue;
                }
                if (string2.length() <= 0) continue;
                if (string2.charAt(0) != '.') {
                    string2 = "." + string2;
                }
                vector.add(string2);
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Adding domain '" + string2 + "'");
            }
            ssoDomainList = vector.toArray(new String[0]);
        }
        if (tc.isEntryEnabled()) {
            WebAttributes.traceSSODomainParameters();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSSODomainList");
        }
    }

    public static String getSSODomain(HttpServletRequest httpServletRequest) {
        String string;
        boolean bl;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSSODomain");
            }
            if (tc.isEntryEnabled()) {
                WebAttributes.traceSSODomainParameters();
            }
            bl = false;
            String string2 = httpServletRequest.getRequestURL().toString();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "URL: " + string2);
            }
            string = "";
            try {
                String string3;
                URL uRL = new URL(string2);
                String string4 = uRL.getHost().trim();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Request host: " + string4);
                }
                try {
                    string3 = InetAddress.getByName(string4).getHostAddress().trim();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.security.web.WebAttributes.WebAttributes", "844");
                    Tr.debug(tc, "Exception in getting IP address for URL host, assuming URL host is not an IP", new Object[]{exception});
                    string3 = "";
                }
                if (tc.isEntryEnabled() && string4.equals(string3)) {
                    Tr.debug(tc, "URL host is an IP, no SSO domain will be set.");
                }
                if (string4.indexOf(".") == -1 || string4.equals(string3)) break block14;
                string = string4.substring(string4.indexOf("."));
                for (int i = 0; i < ssoDomainList.length; ++i) {
                    if (!string.endsWith(ssoDomainList[i])) continue;
                    string = ssoDomainList[i];
                    bl = true;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Domain match found: '" + string + "'");
                    }
                    break;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.web.WebAttributes.WebAttributes", "869");
                Tr.debug(tc, "Unexpected exception getting request host/SSO domain", new Object[]{exception});
            }
        }
        if (!bl && !useURLDomain) {
            string = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "SSO Domain is: '" + string + "'");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSODomain");
        }
        return string;
    }

    private static void traceSSODomainParameters() {
        if (ssoDomainList.length == 0) {
            Tr.debug(tc, "SSO Domain List is empty");
        } else {
            StringBuffer stringBuffer = new StringBuffer("SSO Domain List: ");
            for (int i = 0; i < ssoDomainList.length; ++i) {
                stringBuffer.append(ssoDomainList[i]);
                if (i >= ssoDomainList.length - 1) continue;
                stringBuffer.append(":");
            }
            Tr.debug(tc, stringBuffer.toString());
        }
        if (useURLDomain) {
            Tr.debug(tc, "Domain of host in URL will be used for SSO if a parent domain is not found in the list above.");
        } else {
            Tr.debug(tc, "SSO Domain will be set to an empty string if a parent domain is not found in the list above.");
        }
    }

    private boolean getApplicationSyncToOSThread(WebApp webApp) {
        EList eList;
        EnvEntry[] envEntryArray;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebAttributes.getApplicationSyncToOSThread: application = " + webApp.getDisplayName());
        }
        if ((envEntryArray = (eList = webApp.getEnvEntries()).toArray(new EnvEntry[eList.size()])) != null) {
            for (int i = 0; i < envEntryArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: application(" + webApp.getDisplayName() + ") environment entry: " + envEntryArray[i].getName() + " = " + envEntryArray[i].getValue());
                }
                if (!envEntryArray[i].getName().equals("com.ibm.websphere.security.SyncToOSThread")) continue;
                Boolean bl2 = Boolean.valueOf(envEntryArray[i].getValue());
                bl = bl2;
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: application = " + webApp.getDisplayName() + " has requested SyncToOSThread");
            }
            if (ContextManagerFactory.getInstance().getPlatformHelper().isZOS()) {
                WSLoginLocalOSExtension wSLoginLocalOSExtension = WSLoginLocalOSExtensionFactory.getInstance();
                if (!wSLoginLocalOSExtension.isApplicationSyncToOSThreadEnabled()) {
                    Tr.warning(zOS_tc, "BBOJ0084", webApp.getDisplayName());
                    bl = false;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: SyncToOSThread is enabled in this server");
                }
            } else {
                bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: SyncToOSThread setting is ignored.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WebAttributes.getApplicationSyncToOSThread: application = " + webApp.getDisplayName() + " has not requested SyncToOSThread");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebAttributes.getApplicationSyncToOSThread: rc = " + bl);
        }
        return bl;
    }

    public boolean isApplicationSyncToOSThreadEnabled() {
        return this._applicationSyncToOSThreadEnabled;
    }

    static {
        setSSODomain = true;
        loginCookieName = null;
        cookieSuffix = null;
        ltpaCookieNames = new String[]{"LtpaToken", "LtpaToken2"};
        setHttpOnlyFlag = false;
        ssoDomainList = null;
        useURLDomain = false;
        cookieStringCache = new HashMap(20);
        MAX_COOKIE_STRING_ENTRIES = 100;
    }
}

