/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.WebTrustAssociationUserException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.RestoreWASReqURL;
import com.ibm.ws.security.web.TAIWrapper;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.security.tai.TAIResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class WebAuthenticator {
    private static final TraceComponent tc = Tr.register(WebAuthenticator.class, null, "com.ibm.ejs.resources.security");
    private static WebAuthenticator webAuthInstance = null;
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final String nullString = "";
    private static final String[] nullStringArray = new String[0];
    private long cushion;
    private static AuthenticationResult AUTHN_FAILED_RESULT = new AuthenticationResult(2, "Authentication Failed");
    private static AuthenticationResult CRED_FAILED_RESULT = new AuthenticationResult(2, "credential validation failure");
    protected static TrustAssociationManager taManager = null;
    public static final String FormUserName = "__WAS_FORM_USERNAME";
    public static final String FormPassword = "__WAS_FORM_PASSWORD";
    private static String authMech = null;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static final boolean providerFailure = false;
    private static String BasicAuthEncoding = System.getProperty("com.ibm.websphere.security.BasicAuthEncoding");
    public static final String INITIAL_URL = "INITIAL_URL";
    public static final String PARAM_NAMES = "PARAM_NAMES";
    public static final String PARAM_VALUES = "PARAM_VALUES";
    private static HashMap cookieStringCache = new HashMap(20);
    private static int MAX_COOKIE_STRING_ENTRIES = 100;
    private static final String POSTPARAM_COOKIE = "WASPostParam";
    private static final String POSTPARAM_FAILED = "NO_PARAMETER";
    private static final String POSTPARAM_URL = "U";
    private static final String POSTPARAM_PARAM = "P";
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static String default_realm = null;

    public static WebAuthenticator create(String string, AuditHandlerImpl auditHandlerImpl, J2EEAuditEventFactory j2EEAuditEventFactory) {
        if (webAuthInstance == null) {
            webAuthInstance = new WebAuthenticator();
            authMech = string;
        }
        auditHandler = auditHandlerImpl;
        auditFactory = j2EEAuditEventFactory;
        default_realm = ContextManagerFactory.getInstance().getDefaultRealm();
        return webAuthInstance;
    }

    public static WebAuthenticator getInstance() {
        return webAuthInstance;
    }

    private WebAuthenticator() {
        this.initialize();
        TrustAssociationManager.create();
        taManager = TrustAssociationManager.getInstance();
    }

    protected WebAuthenticator(Object object) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthenticationResult handleTrustAssociation(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HashMap hashMap, boolean bl) throws Exception {
        block26: {
            Object object;
            String string;
            AuthenticationResult authenticationResult;
            Subject subject;
            String string2;
            TAIWrapper tAIWrapper;
            block25: {
                tAIWrapper = null;
                string2 = null;
                subject = null;
                authenticationResult = null;
                string = default_realm;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "handleTrustAssociation");
                }
                if ((tAIWrapper = taManager.getInterceptor(httpServletRequest, bl)) == null) return new AuthenticationResult(6, "TAI isn't available for this request.");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "TAI [" + tAIWrapper.getName() + "] is available for this request.");
                }
                try {
                    object = tAIWrapper.negotiateAndValidateEstablishedTrust(httpServletRequest, httpServletResponse);
                    int n = ((TAIResult)object).getStatus();
                    if (n == 200) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TAI [" + tAIWrapper.getName() + "] has been validated successfully.");
                        }
                        subject = ((TAIResult)object).getSubject();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Subject retrieved is [" + subject + "]");
                        }
                        string2 = ((TAIResult)object).getAuthenticatedPrincipal();
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Username retrieved from TAI is [" + string2 + "]");
                        }
                        break block25;
                    }
                    if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 5)) return new AuthenticationResult(5, "Challenge from TrustAssociation Interception: " + tAIWrapper.getName(), n);
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "TAI_CHALLENGE", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), null, tAIWrapper.getName(), true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.tai.challenge.audit", new Object[]{new Integer(n)});
                    return new AuthenticationResult(5, "Challenge from TrustAssociation Interception: " + tAIWrapper.getName(), n);
                }
                catch (WebTrustAssociationFailedException webTrustAssociationFailedException) {
                    FFDCFilter.processException((Throwable)webTrustAssociationFailedException, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "335", this);
                    Tr.error(tc, "security.web.ta.validationfailed", new Object[]{webTrustAssociationFailedException});
                    if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) return new AuthenticationResult(2, webTrustAssociationFailedException.getMessage());
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "TAI_VALIDATION_FAILED", httpServletRequest.getSession().getId(), webTrustAssociationFailedException, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), null, tAIWrapper.getName(), true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.web.ta.validationfailed", new Object[]{webTrustAssociationFailedException});
                    return new AuthenticationResult(2, webTrustAssociationFailedException.getMessage());
                }
                catch (WebTrustAssociationUserException webTrustAssociationUserException) {
                    FFDCFilter.processException((Throwable)webTrustAssociationUserException, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "349", this);
                    Tr.error(tc, "security.web.ta.userex");
                    if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 6)) return new AuthenticationResult(2, webTrustAssociationUserException.getMessage());
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.FAILURE, "PROVIDER_FAILURE", httpServletRequest.getSession().getId(), webTrustAssociationUserException, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), null, tAIWrapper.getName(), false, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.web.ta.userex", null);
                    return new AuthenticationResult(2, webTrustAssociationUserException.getMessage());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "372", this);
                    Tr.error(tc, "security.web.ta.genexc", new Object[]{exception});
                    if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 6)) return new AuthenticationResult(2, exception.getMessage());
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.FAILURE, "PROVIDER_FAILURE", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), null, tAIWrapper.getName(), false, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.web.ta.genexc", null);
                    return new AuthenticationResult(2, exception.getMessage());
                }
            }
            if (string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Map credentials for " + string2 + ".");
                }
                try {
                    object = null;
                    if (subject != null) {
                        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                        if (wSCredential != null && wSCredential.isCurrent()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Subject is already authenticated from TAI.");
                            }
                            object = subject;
                        } else if (wSCredential != null && !wSCredential.isCurrent()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Subject from TAI is expired for user: " + string2);
                            }
                            authenticationResult = AUTHN_FAILED_RESULT;
                            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "TAI_MAPPING_FAILED", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), string2, tAIWrapper.getName(), true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.tai.mapping.audit", null);
                            }
                            if (!tc.isEntryEnabled()) return authenticationResult;
                            Tr.exit(tc, "handleTrustAssociation: Subject in TAIResult is expired.");
                            return authenticationResult;
                        }
                    }
                    if (object == null) {
                        object = this.contextManager.login(string, string2, authMech, httpServletRequest, httpServletResponse, (Map)hashMap, subject);
                    }
                    authenticationResult = new AuthenticationResult(1, (Subject)object);
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                        auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), string2, tAIWrapper.getName(), true, (Subject)object, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.tai.success.audit", null);
                    }
                    WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", webAttributes.getChallengeType());
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Mapped credential for TrustAssociation was validated successfully.");
                    }
                    if (!tc.isEntryEnabled()) return authenticationResult;
                    Tr.exit(tc, "handleTrustAssociation: OK");
                    return authenticationResult;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", "464", this);
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Error in mapping credential for Trust Association:" + string2);
                    }
                    authenticationResult = AUTHN_FAILED_RESULT;
                    if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) break block26;
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "TAI_MAPPING_FAILED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), string2, tAIWrapper.getName(), true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.tai.mapping.audit", null);
                }
            }
        }
        if (!tc.isEntryEnabled()) return null;
        Tr.exit(tc, "handleTrustAssociation: (null user)");
        return null;
    }

    private AuthenticationResult handleSSO(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = webAttributes.getPreferredLTPACookieName();
        String string2 = webAttributes.getLTPACookieName();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        AuthenticationResult authenticationResult = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleSSO");
        }
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        Boolean bl = (Boolean)securityConfig.getValue("com.ibm.ws.security.web.logoutOnHTTPSessionExpire");
        boolean bl2 = bl;
        String string3 = webAttributes.getChallengeType();
        if (bl2 && httpServletRequest.getRequestedSessionId() != null && !httpServletRequest.isRequestedSessionIdValid() && string3.equalsIgnoreCase("FORM")) {
            WebAttributes.createLogoutCookiesStatic(httpServletRequest, httpServletResponse);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleSSO:HTTPSession expired, logging out.");
            }
            return null;
        }
        if (cookieArray != null) {
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < cookieArray.length; ++i) {
                if (string.equals(cookieArray[i].getName())) {
                    bl3 = true;
                }
                if (!string2.equals(cookieArray[i].getName())) continue;
                bl4 = true;
            }
            String string4 = null;
            try {
                if (bl3) {
                    string4 = string;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting primary cookie validation for: " + string);
                    }
                    authenticationResult = this.validateCookie(cookieArray, string, webAttributes, httpServletRequest, httpServletResponse);
                } else if (bl4) {
                    string4 = string2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting secondary cookie validation for: " + string2);
                    }
                    authenticationResult = this.validateCookie(cookieArray, string2, webAttributes, httpServletRequest, httpServletResponse);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find LTPA cookie(s) in request.");
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                String string5 = wSLoginFailedException.getMessage();
                if (string5 != null && string5.startsWith("within cushion window")) {
                    Object object;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "within cushion window, logging out.");
                    }
                    byte[] byArray = null;
                    String[] stringArray = WebAuthenticator.getCookieValues(cookieArray, string4);
                    if (stringArray != null) {
                        object = null;
                        for (int i = 0; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            if (((String)object).length() <= 0 || (byArray = (byte[])cookieStringCache.get(object)) != null) continue;
                            byArray = StringUtil.getBytes(Base64Coder.base64Decode((String)object));
                        }
                    }
                    object = AuthCache.getInstance();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getting subject from auth cache via ltpa token");
                        }
                        Subject subject = ((AuthCache)object).getSubject(byArray);
                        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                        ((AuthCache)object).removeEntry(null, wSCredential.getSecurityName());
                    }
                    catch (Exception exception) {
                        Tr.debug(tc, "Exception caught handling removal of subject from authcache: " + exception);
                    }
                    WebAttributes.createLogoutCookiesStatic(httpServletRequest, httpServletResponse);
                }
                return null;
            }
            if (authenticationResult != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleSSO: found cookie");
                }
                return authenticationResult;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleSSO: (null)");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleSSO: no cookies present in the request.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationResult validateCookie(Cookie[] cookieArray, String string, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WSLoginFailedException {
        AuthenticationResult authenticationResult = null;
        String[] stringArray = WebAuthenticator.getCookieValues(cookieArray, string);
        if (stringArray != null) {
            String string2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                if (string2.length() <= 0) continue;
                byte[] byArray = null;
                try {
                    byArray = (byte[])cookieStringCache.get(string2);
                    if (byArray == null) {
                        byArray = StringUtil.getBytes(Base64Coder.base64Decode(string2));
                        HashMap hashMap = cookieStringCache;
                        synchronized (hashMap) {
                            if (cookieStringCache.size() > MAX_COOKIE_STRING_ENTRIES) {
                                cookieStringCache.clear();
                            }
                            if (byArray != null) {
                                cookieStringCache.put(string2, byArray);
                            }
                        }
                    }
                    if ((authenticationResult = this.validate(default_realm, byArray, webAttributes, httpServletRequest, httpServletResponse)).getStatus() != 1) continue;
                    break;
                }
                catch (WSLoginFailedException wSLoginFailedException) {
                    String string3 = wSLoginFailedException.getMessage();
                    if (string3 == null || !string3.startsWith("within cushion window")) continue;
                    throw wSLoginFailedException;
                }
                catch (Exception exception) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Exception validating SSO token: ", new Object[]{exception});
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.handleSSO", "704", this);
                    authenticationResult = AUTHN_FAILED_RESULT;
                    if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) continue;
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "SSOTOKEN_VALIDATION_FAILED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), null, null, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.exception.audit", new Object[]{new String(byArray)});
                }
            }
            if (authenticationResult != null && authenticationResult.getStatus() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The LTPA token was valid.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleSSO", "successful ltpa token validation of " + string2);
                }
                WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", webAttributes.getChallengeType());
                return authenticationResult;
            }
            return null;
        }
        return null;
    }

    private AuthenticationResult handleCustomLogin(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
        String string;
        CharSequence charSequence;
        AuthenticationResult authenticationResult = null;
        String string2 = default_realm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleCustomLogin");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Form based login is configured for the resource");
        }
        StringBuffer stringBuffer = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
        String string3 = stringBuffer.toString();
        String string4 = httpServletRequest.getContextPath();
        if (string4.equals("/")) {
            string4 = nullString;
        }
        int n = string3.indexOf("//");
        n = string3.indexOf("/", n + 2);
        int n2 = string3.length();
        String string5 = webAttributes.getLoginURL();
        if (!string5.startsWith("/")) {
            string5 = "/" + string5;
        }
        string5 = string4 + string5;
        stringBuffer.replace(n, n2, string5);
        string5 = stringBuffer.toString();
        String string6 = webAttributes.getReloginURL();
        if (string6 != null) {
            n2 = string5.length();
            if (!string6.startsWith("/")) {
                string6 = "/" + string6;
            }
            string6 = string4 + string6;
            stringBuffer.replace(n, n2, string6);
            string6 = stringBuffer.toString();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "webAttr did not have redirect URL");
        }
        String string7 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        HttpSession httpSession = null;
        FormLoginInfo formLoginInfo = null;
        if (string7.equals("SWAM")) {
            httpSession = httpServletRequest.getSession(true);
            formLoginInfo = (FormLoginInfo)((IHttpSession)httpSession).getSecurityInfo();
            if (formLoginInfo != null) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Form based login: Using HTTP Sessions");
                }
                charSequence = formLoginInfo.getUsername();
                string = formLoginInfo.getPassword();
                if (charSequence != null && string != null) {
                    int n3;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Form based login: Userid/password present in the session");
                    }
                    if ((n3 = (authenticationResult = this.basicAuthenticate(string2, (String)charSequence, string, webAttributes, httpServletRequest, httpServletResponse)).getStatus()) == 2) {
                        authenticationResult = new AuthenticationResult(4, string6);
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                            auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "INVALID_UIDPSWD", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string7, webAttributes.getChallengeType(), (String)charSequence, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string6});
                        }
                    } else {
                        httpSession.removeAttribute("WASReqURL");
                    }
                    WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "FORM");
                    if (n3 != 2) {
                        this.restorePostParams(httpServletRequest, httpServletResponse);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleCustomLogin");
                    }
                    return authenticationResult;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Form based login: No HTTP Session");
            }
        } else {
            authenticationResult = this.handleSSO(webAttributes, httpServletRequest, httpServletResponse);
            if (authenticationResult != null) {
                if (authenticationResult.getStatus() != 2) {
                    this.restorePostParams(httpServletRequest, httpServletResponse);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleCustomLogin");
                }
                return authenticationResult;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Form based login: No or Bad ltpa cookie ");
            }
        }
        if (bl) {
            charSequence = httpServletRequest.getRequestURL();
            if (httpServletRequest.getQueryString() != null) {
                ((StringBuffer)charSequence).append("?");
                ((StringBuffer)charSequence).append(httpServletRequest.getQueryString());
            }
            string = ((StringBuffer)charSequence).toString();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Form based login: Stored original request : " + string);
            }
            authenticationResult = new AuthenticationResult(4, string5);
            this.savePostParams(httpServletRequest, httpServletResponse, authenticationResult);
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "SEND_LOGIN_FORM", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string7, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.redirect.audit", new Object[]{string5});
            }
            if (string7.equals("SWAM")) {
                if (formLoginInfo == null) {
                    formLoginInfo = new FormLoginInfo();
                }
                formLoginInfo.setRefererURL(string);
                ((IHttpSession)httpSession).putSecurityInfo((Object)formLoginInfo);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Form based login: Referer URL set  in session " + string);
                }
            } else {
                StringBuffer stringBuffer2;
                Object object;
                block40: {
                    Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.util.fullyQualifiedURL");
                    if (bl2 == null || bl2 != null && !bl2.booleanValue()) {
                        try {
                            object = new URL(string);
                            stringBuffer2 = new StringBuffer();
                            stringBuffer2.append(((URL)object).getProtocol());
                            stringBuffer2.append("://");
                            int n4 = ((URL)object).getPort();
                            if (n4 != -1) {
                                stringBuffer2.append(":");
                                stringBuffer2.append(n4);
                            }
                            string = stringBuffer2.toString() + string.substring(n);
                        }
                        catch (MalformedURLException malformedURLException) {
                            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.security.web.WebAuthenticator.handleCustomLogin", "941", this);
                            if (!tc.isDebugEnabled()) break block40;
                            Tr.debug(tc, "Requested URL is malformed. " + string);
                        }
                    }
                }
                object = string;
                string = string.replaceAll("%", "%25");
                if (object != (string = string.replaceAll(";", "%3B")) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Form based login: changed output storedReq from " + (String)object + " to " + string);
                }
                stringBuffer2 = new Cookie("WASReqURL", string);
                stringBuffer2.setPath("/");
                stringBuffer2.setMaxAge(-1);
                authenticationResult.setCookie((Cookie)stringBuffer2);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Form based login: Referer URL cookie set " + string);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleCustomLogin", "Redirecting to a login form" + string5);
            }
            return authenticationResult;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleCustomLogin", "enableRedirect is false. Returing with NULL");
        }
        return null;
    }

    private void savePostParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationResult authenticationResult) {
        block21: {
            String string = httpServletRequest.getRequestURI();
            String string2 = httpServletRequest.getMethod();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "savePostParams");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " method : " + string2 + " URL:" + string);
            }
            if (!(httpServletRequest instanceof SRTServletRequest)) {
                Tr.exit(tc, "savePostParams-No SRTServletRequest");
                return;
            }
            SRTServletRequest sRTServletRequest = (SRTServletRequest)httpServletRequest;
            try {
                HttpSession httpSession;
                if (!string2.equalsIgnoreCase("post")) break block21;
                int n = (Integer)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.util.postParamSaveMethod");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prop:" + n);
                }
                if (n == 0) {
                    ByteArrayOutputStream byteArrayOutputStream;
                    HashMap hashMap = sRTServletRequest.getInputStreamData();
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    if (hashMap == null) break block21;
                    hashtable.put(POSTPARAM_URL, string);
                    hashtable.put(POSTPARAM_PARAM, hashMap);
                    String string3 = null;
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(hashtable);
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        int n2 = (Integer)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.util.postParamMaxCookieSize");
                        if (tc.isDebugEnabled()) {
                            int n3 = 0;
                            if (byArray != null) {
                                n3 = byArray.length;
                            }
                            Tr.debug(tc, "length:" + n3 + "  maximum length:" + n2);
                        }
                        if (byArray != null && byArray.length < n2) {
                            byte[] byArray2 = Base64Coder.base64Encode(byArray);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "encoded length:" + byArray2.length);
                            }
                            string3 = StringUtil.toString(byArray2);
                        } else {
                            Tr.warning(tc, "Post parameters are null or too large to store into a cookie.");
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception storing POST parameters onto a cookie: ", new Object[]{exception});
                        }
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.savePostParams", "1050", this);
                    }
                    if (string3 != null) {
                        byteArrayOutputStream = new Cookie(POSTPARAM_COOKIE, string3);
                        byteArrayOutputStream.setMaxAge(-1);
                        byteArrayOutputStream.setPath(string);
                        authenticationResult.setCookie((Cookie)byteArrayOutputStream);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "encoded POST parameters: " + string3);
                    }
                    break block21;
                }
                if (n == 1 && (httpSession = httpServletRequest.getSession(true)) != null && httpServletRequest.getParameterNames() != null) {
                    HashMap hashMap = sRTServletRequest.getInputStreamData();
                    httpSession.setAttribute(INITIAL_URL, (Object)string);
                    httpSession.setAttribute(PARAM_NAMES, null);
                    httpSession.setAttribute(PARAM_VALUES, (Object)hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "URL saved : " + string.toString());
                    }
                }
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IO Exception storing POST parameters onto a cookie: ", new Object[]{iOException});
                }
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.web.WebAuthenticator.savePostParams", "1082", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePostParams");
        }
    }

    private void restorePostParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getMethod();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restorePostParams");
        }
        if (!(httpServletRequest instanceof SRTServletRequest)) {
            Tr.exit(tc, "restorePostParams-No SRTServletRequest");
            return;
        }
        SRTServletRequest sRTServletRequest = (SRTServletRequest)httpServletRequest;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " method : " + string2 + " URL:" + string);
        }
        if (string2.equalsIgnoreCase("get")) {
            HttpSession httpSession;
            int n = (Integer)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.util.postParamSaveMethod");
            if (n == 0) {
                byte[] byArray = sRTServletRequest.getCookieValueAsBytes(POSTPARAM_COOKIE);
                if (byArray != null) {
                    Object object;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found the cookie, restoring POST parameters: " + new String(byArray));
                    }
                    sRTServletRequest.setMethod("POST");
                    try {
                        object = Base64Coder.base64Decode(byArray);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
                        if (tc.isDebugEnabled() && hashtable != null) {
                            Tr.debug(tc, "Original URL:" + hashtable.get(POSTPARAM_URL));
                        }
                        if (hashtable != null && hashtable.get(POSTPARAM_URL).equals(string)) {
                            Map map = (Map)hashtable.get(POSTPARAM_PARAM);
                            sRTServletRequest.setInputStreamData((HashMap)map);
                            Tr.debug(tc, "restored POST paramameters");
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception restoring POST parameters from the cookie: ", new Object[]{exception});
                        }
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.restorePostParams", "1137", this);
                    }
                    object = new Cookie(POSTPARAM_COOKIE, POSTPARAM_FAILED);
                    object.setPath(string);
                    object.setMaxAge(0);
                    httpServletResponse.addCookie((Cookie)object);
                }
            } else if (n == 1 && (httpSession = httpServletRequest.getSession(false)) != null) {
                String string3 = (String)httpSession.getAttribute(INITIAL_URL);
                if (string3 != null && string3.equals(string)) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found the session, restoring POST parameters.");
                        }
                        sRTServletRequest.setMethod("POST");
                        Map map = (Map)httpSession.getAttribute(PARAM_VALUES);
                        if (map != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Restoring POST paramameters for URL : " + string);
                            }
                            sRTServletRequest.setInputStreamData((HashMap)map);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No parameters to restore for URL : " + string);
                        }
                    }
                    catch (IOException iOException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "IOException restoring POST parameters onto a cookie: ", new Object[]{iOException});
                        }
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.web.WebAuthenticator.savePostParams", "1173", this);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parameters NOT restored. Original URL : " + string3 + " req. URL : " + string);
                }
                httpSession.setAttribute(INITIAL_URL, null);
                httpSession.setAttribute(PARAM_NAMES, null);
                httpSession.setAttribute(PARAM_VALUES, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restorePostParams");
        }
    }

    private AuthenticationResult handleCertificates(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        AuthenticationResult authenticationResult;
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleCertificates");
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Challenge type used is CERT.");
            }
            String string = "CLIENT_CERT";
            authenticationResult = null;
            String string2 = default_realm;
            X509Certificate[] x509CertificateArray = null;
            String string3 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
            Subject subject = null;
            try {
                Serializable serializable;
                x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.net.ssl.peer_certificates");
                if (x509CertificateArray == null) {
                    if (!webAttributes.isDefaultToBasic()) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "No certificate provided and default to basic is false.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "handleCertificates");
                        }
                        return new AuthenticationResult(2, "No Client Certificate Available", null);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "No certificate was provided but defaulting to BASIC.");
                    }
                    string = "BASIC";
                }
                if (string.equalsIgnoreCase("BASIC")) break block26;
                byte[] byArray = x509CertificateArray[0].getEncoded();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Map credential for this certificate.");
                }
                String string4 = string2;
                X509Certificate[] x509CertificateArray2 = x509CertificateArray;
                String string5 = webAttributes.getWebAppName();
                String string6 = string;
                try {
                    serializable = new HashMap<String, String>(2);
                    serializable.put("WebAppName", string5);
                    serializable.put("RedirectURL", null);
                    subject = this.contextManager.login(string4, x509CertificateArray2, authMech, httpServletRequest, httpServletResponse, (Map)((Object)serializable));
                    if (subject != null) {
                        authenticationResult = new AuthenticationResult(1, subject);
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                            auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string4, string3, string6, x509CertificateArray[0].getIssuerDN().getName(), providerName, true, subject, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.cert.success.audit", null);
                        }
                    } else {
                        authenticationResult = AUTHN_FAILED_RESULT;
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                            auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string4, string3, string6, x509CertificateArray[0].getIssuerDN().getName(), providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.cert.mapping.audit", null);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.handleCertificates", "1275", this);
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Credential Mapping for Certificate failed.");
                    }
                    authenticationResult = AUTHN_FAILED_RESULT;
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                        auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string4, string3, string6, null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.cert.exception.audit", null);
                    }
                    throw exception;
                }
                serializable = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
                authenticationResult.clearCookieList();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Storing certificates in the credential");
                }
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(x509CertificateArray.length);
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    arrayList.add(x509CertificateArray[i]);
                }
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                CertPath certPath = certificateFactory.generateCertPath(arrayList);
                Subject subject2 = authenticationResult.getSubject();
                WSCredential wSCredential = (WSCredential)subject2.getPublicCredentials(WSCredential.class).iterator().next();
                if (wSCredential != null) {
                    wSCredential.set("wssecurity.setAttributForIdentityAssertion", certPath);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.handleCertificates", "1320", this);
                if (webAttributes.isDefaultToBasic()) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Exception occurred while processing certificate: " + exception.getMessage());
                        Tr.debug(tc, "Defaulting to Basic");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                        auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string3, string, null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.cert.default.audit", null);
                    }
                    string = "BASIC";
                }
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string3, string, null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.cert.exception.audit", null);
                }
                throw exception;
            }
        }
        WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "CLIENT_CERT");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleCertificates");
        }
        return authenticationResult;
    }

    static final String getHeader(HttpServletRequest httpServletRequest, String string) {
        Object object;
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        if (httpServletRequest2 instanceof HttpServletRequestWrapper) {
            object = (HttpServletRequestWrapper)httpServletRequest2;
            httpServletRequest2 = (HttpServletRequest)object.getRequest();
            while (httpServletRequest2 != null && httpServletRequest2 instanceof HttpServletRequestWrapper) {
                httpServletRequest2 = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest2).getRequest();
            }
        }
        if (httpServletRequest2 != null && httpServletRequest2 instanceof SRTServletRequest) {
            object = ((SRTServletRequest)httpServletRequest2).getHeaderDirect(string);
            return object;
        }
        return httpServletRequest.getHeader(string);
    }

    private AuthenticationResult handleBasicAuth(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleBasicAuth");
        }
        AuthenticationResult authenticationResult = null;
        Cookie cookie = null;
        String string2 = default_realm;
        String string3 = httpServletRequest.getHeader("Authorization");
        if (string3 == null || !string3.startsWith("Basic ")) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "basic 401");
            }
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "INVALID_UIDPSWD", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, null, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.challenge.audit", null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleBasicAuth");
            }
            return authenticationResult;
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Authorization: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BasicAuthEncoding:" + BasicAuthEncoding);
        }
        if (BasicAuthEncoding != null) {
            try {
                string3 = new String(Base64Coder.base64Decode(string3.substring(6).getBytes()), BasicAuthEncoding);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.handleBasicAuth", "1446", this);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error in using character encoder:" + BasicAuthEncoding + " Use system default encoder");
                }
                string3 = Base64Coder.base64Decode(string3.substring(6));
            }
        } else {
            string3 = Base64Coder.base64Decode(string3.substring(6));
        }
        if ((n = string3.indexOf(58)) < 0) {
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "INVALID_UIDPSWD", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, null, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.missing.audit", null);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Failed to find username/password info -- Sending 401.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleBasicAuth");
            }
            return authenticationResult;
        }
        String string4 = string3.substring(0, n);
        authenticationResult = this.basicAuthenticate(string2, string4, string = string3.substring(n + 1), webAttributes, httpServletRequest, httpServletResponse);
        int n2 = authenticationResult.getStatus();
        if ((n2 == 3 || n2 == 2) && n2 == 2) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Authentication failed after calling basicAuthenticate");
            }
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleBasicAuth");
        }
        return authenticationResult;
    }

    public AuthenticationResult authenticate(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
        return this.authenticate(webAttributes, httpServletRequest, httpServletResponse, bl, true);
    }

    public AuthenticationResult authenticate(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, boolean bl2) {
        Object object;
        block40: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "authenticate");
            }
            object = null;
            boolean bl3 = false;
            try {
                Object object2;
                Object object3;
                Boolean bl4 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
                boolean bl5 = bl4 == true && webAttributes.isSSOEnabled() && (!webAttributes.isSecureSSO() || webAttributes.isSecureSSO() && httpServletRequest.getScheme().equalsIgnoreCase("https"));
                Object var10_11 = null;
                String string = webAttributes.getChallengeType();
                object = null;
                HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
                if (taManager.isTrustAssociationEnabled()) {
                    object3 = null;
                    if (string.equalsIgnoreCase("FORM")) {
                        object2 = httpServletRequest.getContextPath();
                        if (((String)object2).equals("/")) {
                            object2 = nullString;
                        }
                        if ((object3 = webAttributes.getReloginURL()) != null) {
                            if (!((String)object3).startsWith("/")) {
                                object3 = "/" + (String)object3;
                            }
                            object3 = (String)object2 + (String)object3;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Default redirect URL: " + (String)object3);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "webAttr did not have redirect URL");
                        }
                    }
                    hashMap.put("WebAppName", webAttributes.getWebAppName());
                    hashMap.put("RedirectURL", object3);
                    if (bl) {
                        object = this.handleTrustAssociation(webAttributes, httpServletRequest, httpServletResponse, hashMap, true);
                        if (object != null && ((AuthenticationResult)object).getStatus() == 6) {
                            bl3 = true;
                            object = null;
                        }
                    } else {
                        Tr.debug(tc, "handleTrustAssociation was skipped (1)");
                    }
                }
                if (object == null) {
                    if (bl4.booleanValue() && webAttributes.isSSOEnabled() && (object = this.handleSSO(webAttributes, httpServletRequest, httpServletResponse)) != null) {
                        if (((AuthenticationResult)object).getStatus() != 2) {
                            this.restorePostParams(httpServletRequest, httpServletResponse);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "authenticate");
                        }
                        return object;
                    }
                    if (taManager.isTrustAssociationEnabled()) {
                        if (bl) {
                            object = this.handleTrustAssociation(webAttributes, httpServletRequest, httpServletResponse, hashMap, false);
                            if (object != null && ((AuthenticationResult)object).getStatus() == 6) {
                                bl3 = true;
                                object = null;
                            }
                        } else {
                            Tr.debug(tc, "handleTrustAssociation was skipped (2) .");
                        }
                    }
                }
                if (object == null) {
                    if (string.equalsIgnoreCase("FORM")) {
                        if (taManager.isTrustAssociationEnabled() && !bl3) {
                            object3 = (String)hashMap.get("RedirectURL");
                            if (object3 != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Redirect to the error page: " + (String)object3);
                                }
                                object = new AuthenticationResult(4, (String)object3);
                            } else {
                                object = this.handleCustomLogin(webAttributes, httpServletRequest, httpServletResponse, bl2);
                            }
                        } else {
                            object = this.handleCustomLogin(webAttributes, httpServletRequest, httpServletResponse, bl2);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "authenticate");
                        }
                        return object;
                    }
                    if (string.equalsIgnoreCase("CLIENT_CERT") && (object = this.handleCertificates(webAttributes, httpServletRequest, httpServletResponse)) != null) {
                        if (bl5) {
                            object3 = WebAttributes.createCookies(httpServletRequest, ((AuthenticationResult)object).getSubject());
                            if (object3 != null) {
                                ((AuthenticationResult)object).setCookieList((ArrayList)object3);
                            }
                        }
                        return object;
                    }
                    object = this.handleBasicAuth(webAttributes, httpServletRequest, httpServletResponse);
                }
                if (((AuthenticationResult)object).getStatus() == 1) {
                    object3 = ((AuthenticationResult)object).getSubject();
                    object2 = this.restoreWASReqURLValue(httpServletRequest, httpServletResponse);
                    if (object2 != null) {
                        object = object2;
                    }
                    WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "BASIC");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Successful authentication");
                    }
                    if (bl5) {
                        ArrayList arrayList = WebAttributes.createCookies(httpServletRequest, (Subject)object3);
                        if (arrayList != null) {
                            ((AuthenticationResult)object).setCookieList(arrayList);
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.authenticate", "1706", this);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Exception occurred: " + exception.getMessage());
                    Tr.debug(tc, "Authentication failed.");
                }
                object = new AuthenticationResult(2, exception.getMessage());
                if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) break block40;
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), null, null, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.exception.audit", null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate");
        }
        return object;
    }

    public AuthenticationResult authenticate(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.authenticate(webAttributes, httpServletRequest, httpServletResponse, true);
    }

    public static String getCookieValue(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValue", string);
        }
        String string2 = null;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                string2 = cookieArray[i].getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValue", string2);
        }
        return string2;
    }

    public static String[] getCookieValues(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValues", string);
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                vector.add(cookieArray[i].getValue());
                ++n;
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, cookieArray[i].getValue());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValues");
        }
        if (vector.size() > 0) {
            return vector.toArray(new String[n]);
        }
        return null;
    }

    public AuthenticationResult validate(String string, byte[] byArray, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WSLoginFailedException {
        AuthenticationResult authenticationResult;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            authenticationResult = null;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>(2);
                hashMap.put("WebAppName", webAttributes.getWebAppName());
                hashMap.put("RedirectURL", null);
                Subject subject = this.contextManager.login(string, byArray, authMech, httpServletRequest, httpServletResponse, hashMap);
                if (subject == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validate: Subject is null.");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                        auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "SSOTOKEN_VALIDATION_FAILED", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.invalid.audit", new Object[]{new String(byArray)});
                    }
                    return AUTHN_FAILED_RESULT;
                }
                authenticationResult = new AuthenticationResult(1, subject);
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), wSCredential.getSecurityName(), providerName, true, subject, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.validate.audit", new Object[]{new String(byArray)});
                }
            }
            catch (Exception exception) {
                String string2;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.validate", "1855", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validate", exception);
                }
                if (exception instanceof WSLoginFailedException && (string2 = exception.getMessage()) != null && string2.startsWith("within cushion window")) {
                    throw (WSLoginFailedException)exception;
                }
                authenticationResult = new AuthenticationResult(2, exception.getMessage());
                if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) break block10;
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.exception.audit", new Object[]{new String(byArray)});
            }
        }
        authenticationResult.realm = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return authenticationResult;
    }

    private void initialize() {
        this.cushion = AuthCache.getInstance().getCushion();
    }

    public AuthenticationResult basicAuthenticate(String string, String string2, String string3) {
        return this.basicAuthenticate(string, string2, string3, null, null, null);
    }

    public AuthenticationResult basicAuthenticate(String string, String string2, String string3, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AuthenticationResult authenticationResult;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "basicAuthenticate");
            }
            authenticationResult = null;
            try {
                Subject subject = null;
                if (webAttributes != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>(2);
                    hashMap.put("WebAppName", webAttributes.getWebAppName());
                    hashMap.put("RedirectURL", null);
                    subject = this.contextManager.login(default_realm, string2, string3, authMech, httpServletRequest, httpServletResponse, hashMap);
                } else {
                    subject = this.contextManager.login(default_realm, string2, string3, authMech, null, null, null);
                }
                if (subject == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "basicAuthenticate: authentication failed");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                        auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "INVALID_UIDPSWD", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), string2, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.error.audit", null);
                    }
                    return AUTHN_FAILED_RESULT;
                }
                authenticationResult = new AuthenticationResult(1, subject);
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), string2, providerName, true, subject, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.success.audit", null);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAuthenticator.basicAuthenticate", "1972", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "basicAuthenticate", exception);
                }
                authenticationResult = new AuthenticationResult(2, exception.getMessage());
                if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) break block11;
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), string2, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.exception.audit", null);
            }
        }
        authenticationResult.realm = string;
        authenticationResult.userName = string2;
        authenticationResult.passWord = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "basicAuthenticate");
        }
        return authenticationResult;
    }

    protected WSCredential setSasBasicAuth(String string, String string2, String string3) throws Exception {
        throw new RuntimeException("Not Implemented");
    }

    public Subject getPreferredSubject(Subject subject, Subject subject2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferredSubject");
        }
        return subject != null ? subject : subject2;
    }

    private AuthenticationResult restoreWASReqURLValue(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreWASReqURLValue");
        }
        AuthenticationResult authenticationResult = null;
        RestoreWASReqURL restoreWASReqURL = new RestoreWASReqURL();
        String string = restoreWASReqURL.restoreReqURL(httpServletRequest);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WASReqURL value: " + string);
        }
        String string2 = null;
        if (string != null && string.trim().length() > 0) {
            StringBuffer stringBuffer = httpServletRequest.getRequestURL();
            if (httpServletRequest.getQueryString() != null) {
                stringBuffer.append("?");
                stringBuffer.append(httpServletRequest.getQueryString());
            }
            string2 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "\nCurrentURL: " + string2 + "\nWasReqURL: " + string);
            }
            String string3 = WebCollaborator.getURI(httpServletRequest);
            if (string2 != null && string3 != null && string.toLowerCase().indexOf(string3.toLowerCase()) > 0 && !string.equalsIgnoreCase(string2)) {
                Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.alwaysRestoreOriginalURL");
                if (bl != null && bl.booleanValue()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Redirect a request to the original URL.");
                    }
                    authenticationResult = new AuthenticationResult(4, string);
                    Cookie cookie = new Cookie("WASReqURL", nullString);
                    cookie.setPath("/");
                    cookie.setMaxAge(0);
                    httpServletResponse.addCookie(cookie);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cleared WASReqURL cookie.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "skip redirecting to the original URL, since com.ibm.websphere.security.alwaysRestoreOriginalURL is set to false.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreWASReqURLValue result: " + authenticationResult);
        }
        return authenticationResult;
    }
}

