/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.NativeConfiguration;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.authz.AccessLevel;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationManager;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.security.auth.Subject;

public class TrustedIDEvaluatorImpl
implements TrustedIDEvaluator {
    private SAFAuthorizationManager authzMgr;
    private PlatformCredentialManager platformCredManager;
    private static final String className = "CBIND";
    private String resource = "";
    private String realm = "";
    private ContextManager contextManager = null;
    private static final TraceComponent tc = Tr.register(TrustedIDEvaluatorImpl.class, "Security", "com.ibm.ejs.resources.security");

    public TrustedIDEvaluatorImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.platformCredManager = PlatformCredentialManager.instance();
        this.authzMgr = SAFAuthorizationManager.instance();
        this.realm = this.getContextManager().getProperty("security.activeUserRegistry.realm");
        String string = this.getContextManager().getProperty("generic.server.short.name");
        String string2 = this.getContextManager().getProperty("security.zOS.domainName");
        String string3 = this.getContextManager().getProperty("security.zOS.domainType");
        this.resource = string3 != null && string3.equalsIgnoreCase("cellQualified") && string2 != null && string2.length() > 0 ? "CB.BIND." + string2 + "." + string : "CB.BIND." + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resource being checked is", this.resource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean isTrusted(String string) {
        boolean bl;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTrusted", string);
            }
            bl = false;
            PlatformCredential platformCredential = null;
            Subject subject = null;
            if (string.equals("*")) {
                bl = false;
            } else if (this.getContextManager().isInternalServerId(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using internally generated server ID", string);
                }
                platformCredential = this.platformCredManager.createServerCredential();
                bl = this.checkProfileAccess(platformCredential);
            } else {
                try {
                    subject = this.getContextManager().login(this.realm, string);
                    if (subject != null) {
                        platformCredential = this.getPlatformCredentialFromSubject(subject);
                        bl = this.checkProfileAccess(platformCredential);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not get subject");
                    }
                }
                catch (WSLoginFailedException wSLoginFailedException) {
                    FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl.isTrusted", "173", this);
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Login failed", wSLoginFailedException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrusted", new Boolean(bl));
        }
        return bl;
    }

    public boolean isTrusted(String string, String string2) {
        boolean bl;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTrusted", new Object[]{string, string2 != null ? "****" : null});
            }
            bl = false;
            PlatformCredential platformCredential = null;
            Subject subject = null;
            if (string.equals("*")) {
                bl = false;
            } else if (string2 == null || string2.equals("")) {
                bl = this.isTrusted(string);
            } else {
                try {
                    subject = this.getContextManager().login(this.realm, string, string2);
                    if (subject != null) {
                        platformCredential = this.getPlatformCredentialFromSubject(subject);
                        bl = this.checkProfileAccess(platformCredential);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not get subject");
                    }
                }
                catch (WSLoginFailedException wSLoginFailedException) {
                    FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl.isTrusted", "234", this);
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "Login failed", wSLoginFailedException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrusted", new Boolean(bl));
        }
        return bl;
    }

    public boolean isTrusted(X509Certificate[] x509CertificateArray) {
        boolean bl;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTrusted", x509CertificateArray);
            }
            bl = false;
            PlatformCredential platformCredential = null;
            Subject subject = null;
            try {
                subject = this.getContextManager().login(this.realm, x509CertificateArray);
                if (subject != null) {
                    platformCredential = this.getPlatformCredentialFromSubject(subject);
                    bl = this.checkProfileAccess(platformCredential);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not get subject");
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl.isTrusted", "284", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Login failed", wSLoginFailedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrusted", new Boolean(bl));
        }
        return bl;
    }

    public Boolean mutualAuthCBINDCheck(X509Certificate[] x509CertificateArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mutualAuthCBINDCheck", x509CertificateArray);
        }
        boolean bl = false;
        bl = NativeConfiguration.getConfig().isMutualAuthCBINDCheckEnabled() ? this.isTrusted(x509CertificateArray) : true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mutualAuthCBINDCheck", new Boolean(bl));
        }
        return new Boolean(bl);
    }

    private boolean checkProfileAccess(PlatformCredential platformCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkProfileAccess", platformCredential);
        }
        boolean bl = false;
        if (platformCredential != null) {
            try {
                bl = this.authzMgr.isAuthorized(platformCredential, className, this.resource, AccessLevel.CONTROL);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl.checkProfileAccess", "343", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to perform authorization check", exception);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Platform Credential for user is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProfileAccess", new Boolean(bl));
        }
        return bl;
    }

    private ContextManager getContextManager() {
        if (this.contextManager == null) {
            this.contextManager = ContextManagerFactory.getInstance();
        }
        return this.contextManager;
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential platformCredential;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
            }
            platformCredential = null;
            Iterator iterator = subject.getPrivateCredentials(PlatformCredential.class).iterator();
            if (iterator.hasNext()) {
                platformCredential = (PlatformCredential)iterator.next();
            }
            if (platformCredential == null) {
                WSCredential wSCredential = null;
                Iterator iterator2 = subject.getPublicCredentials(WSCredential.class).iterator();
                if (iterator2.hasNext()) {
                    wSCredential = (WSCredential)iterator2.next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential", wSCredential);
                }
                if (wSCredential != null) {
                    try {
                        final WSCredential wSCredential2 = wSCredential;
                        platformCredential = (PlatformCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return wSCredential2.get("com.ibm.ws.security.zos.PlatformCredential");
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Unable to get PlatformCredential", exception);
                    }
                }
            }
        }
        if (platformCredential == null) {
            platformCredential = this.platformCredManager.createDefaultCredential();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredentialFromSubject", platformCredential);
        }
        return platformCredential;
    }
}

