/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.authz;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.authz.AccessLevel;
import com.ibm.ws.security.zOS.authz.AuthorizationDeniedException;
import com.ibm.ws.security.zOS.authz.InactiveClassException;
import com.ibm.ws.security.zOS.authz.InvalidCredentialException;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationManager;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationOptions;
import com.ibm.ws.security.zOS.authz.SAFRoleMapperFactory;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.Subject;

public class SAFAuthorizationTableImpl
implements AuthorizationTable {
    private static final TraceComponent tc = Tr.register(SAFAuthorizationTableImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String SUBJECT_KEY = "AUTHZ_SUBJECT";
    private static boolean _roleClassInactive = false;
    private SAFRoleMapper _roleMapper = null;
    private boolean _suppressMessages = false;
    private boolean _suppressAdminMessages = true;
    private SAFAuthorizationOptions.LogOption _logOption = null;

    public SAFAuthorizationTableImpl() {
        Properties properties;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if ((string = (properties = (Properties)SecurityConfig.getConfig().getValue("security.toplevel.properties")).getProperty("com.ibm.security.SAF.Authz.Log.Option")) != null && string.length() > 0) {
            if (string.equals(SAFAuthorizationOptions.NONE.toString())) {
                this._logOption = SAFAuthorizationOptions.NONE;
            } else if (string.equals(SAFAuthorizationOptions.ASIS.toString())) {
                this._logOption = SAFAuthorizationOptions.ASIS;
            } else if (string.equals(SAFAuthorizationOptions.NOFAIL.toString())) {
                this._logOption = SAFAuthorizationOptions.NOFAIL;
            }
        }
        string = properties.getProperty("com.ibm.security.SAF.EJBROLE.Audit.Messages.Suppress");
        this._suppressMessages = "true".equalsIgnoreCase(string);
        string = properties.getProperty("com.ibm.security.SAF.EJBROLE.Audit.Messages.Suppress.Admin");
        if (this._logOption != null && string == null || string != null && "false".equalsIgnoreCase(string)) {
            this._suppressAdminMessages = false;
        }
        this._roleMapper = SAFRoleMapperFactory.getSAFRoleMapper();
        Tr.audit(tc, "security.zos.saf.authz.enabled");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", this);
        }
    }

    public boolean isEveryoneGranted(HashMap hashMap, String[] stringArray) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted", new Object[]{hashMap, stringArray});
        }
        boolean bl = SAFAuthorizationTableImpl.isRoleClassInactive();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted", new Boolean(bl));
        }
        return bl;
    }

    public boolean isGrantedRole(HashMap hashMap, String string, Principal principal) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRole", new Object[]{hashMap, string, principal});
        }
        String[] stringArray = new String[]{string};
        boolean bl = this.isGrantedAnyRole(hashMap, stringArray, principal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole", new Boolean(bl));
        }
        return bl;
    }

    public boolean isGrantedAnyRole(HashMap hashMap, String[] stringArray, Principal principal) throws SecurityProviderException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAnyRole", new Object[]{hashMap, stringArray, principal});
        }
        boolean bl = false;
        PlatformCredential platformCredential = null;
        try {
            object = (Subject)hashMap.get(SUBJECT_KEY);
            platformCredential = (PlatformCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Subject)object){
                private final /* synthetic */ Subject val$subject;
                {
                    this.val$subject = subject;
                }

                public Object run() throws Exception {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(this.val$subject);
                    Object object = null;
                    if (wSCredential != null) {
                        object = wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                    }
                    if (object == null) {
                        object = PlatformCredentialManager.instance().createDefaultCredential();
                    }
                    return object;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.zOS.authz.SAFAuthorizationTableImpl", "257", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to acquire credential for authorization", privilegedActionException.getException());
            }
            throw new SecurityProviderException("Unable to acquire credential for authorization", privilegedActionException.getException());
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Target role is required");
        }
        object = (String)hashMap.get("APPLICATION_NAME");
        boolean bl2 = "admin-authz".equals(object);
        String[] stringArray2 = this.getProfilesFromRoles(hashMap, stringArray);
        boolean bl3 = bl2 ? this._suppressAdminMessages : this._suppressMessages;
        bl = this.isCredentialInAnyRole(platformCredential, stringArray2, this._logOption, bl3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(bl));
        }
        return bl;
    }

    private boolean isCredentialInAnyRole(PlatformCredential platformCredential, String[] stringArray, SAFAuthorizationOptions.LogOption logOption, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCredentialInAnyRole", new Object[]{platformCredential, stringArray, logOption, new Boolean(bl)});
        }
        boolean bl2 = false;
        SAFAuthorizationManager sAFAuthorizationManager = SAFAuthorizationManager.instance();
        String string = "EJBROLE";
        for (int i = 0; i < stringArray.length && !bl2; ++i) {
            boolean bl3 = i == stringArray.length - 1;
            SAFAuthorizationOptions.LogOption logOption2 = logOption;
            if (logOption == null) {
                SAFAuthorizationOptions.LogOption logOption3 = logOption2 = bl3 ? SAFAuthorizationOptions.ASIS : SAFAuthorizationOptions.NOFAIL;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isLastProfile is " + bl3 + ", The log option is null so setting it to: " + logOption2);
                }
            }
            try {
                bl2 = sAFAuthorizationManager.checkAccess(platformCredential, string, stringArray[i], null, AccessLevel.READ, logOption2, bl, true);
                continue;
            }
            catch (AuthorizationDeniedException authorizationDeniedException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "This may be a normal exception. SAF has explicitly denied READ access to the profile " + stringArray[i] + " in the resource class  " + string + ".", authorizationDeniedException);
                continue;
            }
            catch (InactiveClassException inactiveClassException) {
                bl2 = true;
                SAFAuthorizationTableImpl.setRoleClassInactive();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The resource class " + string + " has not been activated.  As a result, access will be allowed.", inactiveClassException);
                continue;
            }
            catch (InvalidCredentialException invalidCredentialException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The Subject associated with the current thread of execution does not contain a valid PlatformCredential.", invalidCredentialException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCredentialInAnyRole", new Boolean(bl2));
        }
        return bl2;
    }

    protected int getLogOption() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLogOption");
        }
        int n2 = n = this._logOption == null ? 0 : this._logOption.getValue();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLogOption", new Integer(n));
        }
        return n;
    }

    protected String[] getProfilesFromRoles(HashMap hashMap, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProfilesFromRoles", new Object[]{hashMap, stringArray});
        }
        String[] stringArray2 = new String[stringArray.length];
        String string = (String)hashMap.get("APPLICATION_NAME");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this._roleMapper.getProfileFromRole(string, stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProfilesFromRoles", stringArray2);
        }
        return stringArray2;
    }

    private native int checkProfiles(PlatformCredential var1, String[] var2, int var3, int var4, boolean var5);

    private static synchronized void setRoleClassInactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRoleClassInactive");
        }
        if (!_roleClassInactive) {
            _roleClassInactive = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRoleClassInactive");
        }
    }

    private static boolean isRoleClassInactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRoleClassInactive");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRoleClassInactive", new Boolean(_roleClassInactive));
        }
        return _roleClassInactive;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(";_logOption=").append(this._logOption);
        stringBuffer.append(";_suppressMessages=").append(this._suppressMessages);
        stringBuffer.append(";_roleMapper=").append(this._roleMapper);
        stringBuffer.append(";_roleClassInactive").append(_roleClassInactive);
        return stringBuffer.toString();
    }
}

