/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.threadid;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.zOS.NativeConfiguration;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.SAFServiceResult;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import java.util.Iterator;
import javax.security.auth.Subject;

public final class ThreadIdentityManager
implements WSLoginLocalOSExtension {
    private static final TraceComponent tc = Tr.register(ThreadIdentityManager.class, "Security", "com.ibm.ejs.resources.security");
    private static final ThreadLocal _threadIdentity = new WSThreadLocal(){

        protected Object initialValue() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "_threadIdentity.initialValue");
            }
            PlatformCredential platformCredential = PlatformCredentialManager.instance().createServerCredential();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_threadIdentity.initialValue", platformCredential);
            }
            return platformCredential;
        }

        public String toString() {
            return this.get().toString();
        }
    };
    private static final ThreadLocal _appSyncData = new WSThreadLocal(){

        protected Object initialValue() {
            return new Boolean(false);
        }
    };
    private static ThreadIdentityManager _instance;
    private ContextManager _contextManager = null;
    private boolean _isSyncEnabled = false;
    private boolean _isAppSyncEnabled = false;
    private boolean _serverSecurityEnabled = false;
    private ComponentMetaDataAccessorImpl _cmda = null;
    private PlatformCredentialManager _platformCredManager;

    public static ThreadIdentityManager getThreadIdentityManager() {
        if (_instance == null) {
            _instance = new ThreadIdentityManager();
        }
        return _instance;
    }

    private ThreadIdentityManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this._contextManager = ContextManagerFactory.getInstance();
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("server.security.enabled");
        if (bl != null) {
            this._serverSecurityEnabled = bl;
        }
        NativeConfiguration nativeConfiguration = NativeConfiguration.getConfig();
        this._isSyncEnabled = nativeConfiguration.isConnectionManagementThreadIdentityEnabled();
        this._isAppSyncEnabled = nativeConfiguration.isApplicationSyncToThreadEnabled();
        this._platformCredManager = PlatformCredentialManager.instance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean isSyncToThreadEnabled() {
        return this._isSyncEnabled;
    }

    public boolean isApplicationSyncToOSThreadEnabled() {
        return this._isAppSyncEnabled;
    }

    public boolean isThreadLocalApplicationSyncEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isThreadLocalApplicationSyncEnabled");
        }
        Boolean bl = (Boolean)_appSyncData.get();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isThreadLocalApplicationSyncEnabled", bl);
        }
        return bl;
    }

    public void setThreadLocalApplicationSyncEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setThreadLocalApplicationSyncEnabled", new Boolean(bl));
        }
        _appSyncData.set(new Boolean(bl));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreadLocalApplicationSyncEnabled");
        }
    }

    public Subject getLocalOSInvocationSubject() throws IllegalStateException {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalOSInvocationSubject");
            }
            if ((subject = this.getInvocationSubject()) == null) {
                try {
                    subject = this._contextManager.getServerSubject();
                }
                catch (WSSecurityException wSSecurityException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Unable to get server subject", wSSecurityException);
                }
            }
        }
        subject = this.extractJ2CSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSInvocationSubject", subject);
        }
        return subject;
    }

    public Subject getLocalOSOwnSubject() {
        Subject subject;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalOSOwnSubject");
            }
            subject = null;
            if (this.isSyncToThreadEnabled()) {
                try {
                    subject = this.extractJ2CSubject(this._contextManager.getInvocationSubject());
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getLocalOSOwnSubject", exception);
                    }
                    break block8;
                }
            }
            try {
                subject = this._contextManager.getServerSubject();
                subject = this.extractJ2CSubject(subject);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "getLocalOSOwnSubject", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSOwnSubject", subject);
        }
        return subject;
    }

    public Subject getLocalOSPlatformCredSubject() {
        Subject subject;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalOSPlatformCredSubject");
            }
            subject = null;
            try {
                subject = this._contextManager.getServerSubject();
                subject = this.extractPlatformCredSubject(subject);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getLocalOSPlatformCredSubject", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSPlatformCredSubject", subject);
        }
        return subject;
    }

    private Subject extractJ2CSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractJ2CSubject", subject);
        }
        Subject subject2 = null;
        if (subject != null) {
            PlatformCredential platformCredential = this.getPlatformCredentialFromSubject(subject);
            if (platformCredential == null) {
                platformCredential = this._platformCredManager.createDefaultCredential();
            }
            subject2 = platformCredential.getJ2CSubject();
        } else {
            PlatformCredential platformCredential = this._platformCredManager.createServerCredential();
            subject2 = platformCredential.getJ2CSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractJ2CSubject", subject2);
        }
        return subject2;
    }

    private Subject extractPlatformCredSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractPlatformCredSubject", subject);
        }
        Subject subject2 = null;
        if (subject != null) {
            PlatformCredential platformCredential = this.getPlatformCredentialFromSubject(subject);
            if (platformCredential == null) {
                platformCredential = this._platformCredManager.createDefaultCredential();
            }
            subject2 = platformCredential.getPlatformCredSubject();
        } else {
            PlatformCredential platformCredential = this._platformCredManager.createServerCredential();
            subject2 = platformCredential.getPlatformCredSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractPlatformCredSubject", subject2);
        }
        return subject2;
    }

    public Object setLocalOSThreadID(Subject subject) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLocalOSThreadID", subject);
        }
        Object object = this.setLocalOSThreadID(subject, this._isSyncEnabled || this._isAppSyncEnabled);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLocalOSThreadID", object);
        }
        return object;
    }

    public Object setAppLocalOSThreadID(Subject subject) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAppLocalOSThreadID", subject);
        }
        Object object = this.setLocalOSThreadID(subject, this._isAppSyncEnabled);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAppLocalOSThreadID", object);
        }
        return object;
    }

    public void restoreLocalOSThreadID(Object object) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreLocalOSThreadID", object);
        }
        this.restoreLocalOSThreadID(object, this._isSyncEnabled || this._isAppSyncEnabled);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreLocalOSThreadID");
        }
    }

    public void restoreAppLocalOSThreadID(Object object) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreAppLocalOSThreadID", object);
        }
        this.restoreLocalOSThreadID(object, this._isAppSyncEnabled);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreAppLocalOSThreadID");
        }
    }

    private Object setLocalOSThreadID(Subject subject, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLocalOSThreadID", new Object[]{subject, new Boolean(bl)});
        }
        PlatformCredential platformCredential = (PlatformCredential)_threadIdentity.get();
        if (bl) {
            PlatformCredential platformCredential2 = null;
            if (subject != null) {
                platformCredential2 = this.getPlatformCredentialFromSubject(subject);
            }
            this.setThreadSecurityEnvironment(platformCredential2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLocalOSThreadID", platformCredential);
        }
        return platformCredential;
    }

    private void restoreLocalOSThreadID(Object object, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreLocalOSThreadID", new Object[]{object, new Boolean(bl)});
        }
        if (bl) {
            PlatformCredential platformCredential = (PlatformCredential)object;
            this.setThreadSecurityEnvironment(platformCredential);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreLocalOSThreadID");
        }
    }

    private boolean setThreadSecurityEnvironment(PlatformCredential platformCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setThreadSecurityEnvironment", platformCredential);
        }
        boolean bl = false;
        int n = -1;
        PlatformCredential platformCredential2 = (PlatformCredential)_threadIdentity.get();
        if (platformCredential == null) {
            platformCredential = this._platformCredManager.createServerCredential();
        }
        n = platformCredential2.equals(platformCredential) ? 0 : (platformCredential.getCredentialType() == PlatformCredential.SERVER ? ThreadIdentityManager.ntv_setThreadSecurityEnvironment(null) : ThreadIdentityManager.ntv_setThreadSecurityEnvironment(platformCredential));
        boolean bl2 = bl = n == 0;
        if (bl) {
            _threadIdentity.set(platformCredential);
        } else if (n == 44) {
            _threadIdentity.set(null);
            Tr.info(tc, "security.zos.saf.threadid.sync.not.allowed.info", new Object[]{platformCredential.getUserId()});
        } else {
            Tr.error(tc, "security.zos.saf.threadid.sync.error", new Object[]{platformCredential.getUserId(), SAFServiceResult.getSafServiceResult()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreadSecurityEnvironment", new Boolean(bl));
        }
        return bl;
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential platformCredential;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
            }
            platformCredential = null;
            Iterator iterator = subject.getPrivateCredentials(PlatformCredential.class).iterator();
            if (iterator.hasNext()) {
                platformCredential = (PlatformCredential)iterator.next();
            }
            if (platformCredential == null) {
                WSCredential wSCredential = null;
                Iterator iterator2 = subject.getPublicCredentials(WSCredential.class).iterator();
                if (iterator2.hasNext()) {
                    wSCredential = (WSCredential)iterator2.next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential", wSCredential);
                }
                if (wSCredential != null) {
                    try {
                        platformCredential = (PlatformCredential)wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Unexpected exception acquiring platform cred", exception);
                    }
                }
            }
        }
        if (platformCredential == null) {
            platformCredential = this._platformCredManager.createDefaultCredential();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredentialFromSubject", platformCredential);
        }
        return platformCredential;
    }

    private Subject getInvocationSubject() {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInvocationSubject");
            }
            subject = null;
            try {
                if (this._serverSecurityEnabled && (subject = this._contextManager.getInvocationSubject()) == null) {
                    subject = this._contextManager.getCallerSubject();
                }
            }
            catch (WSSecurityException wSSecurityException) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Exception acquring invocation subject", wSSecurityException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationSubject", subject);
        }
        return subject;
    }

    public boolean getAppSyncEnabledFromComponentMetaData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppSyncEnabledFromComponentMetaData");
        }
        boolean bl = false;
        if (this._isAppSyncEnabled) {
            ComponentMetaData componentMetaData = this.getMetaDataAccessor().getComponentMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current meta data", componentMetaData);
            }
            if (componentMetaData != null) {
                if (componentMetaData instanceof EJBComponentMetaData) {
                    EJBComponentMetaData eJBComponentMetaData = (EJBComponentMetaData)componentMetaData;
                    bl = eJBComponentMetaData.isApplicationSyncToOSThreadEnabled();
                } else if (componentMetaData instanceof WebComponentMetaData) {
                    WebComponentMetaData webComponentMetaData = (WebComponentMetaData)componentMetaData;
                    WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)webComponentMetaData.getModuleMetaData();
                    bl = webModuleMetaDataImpl.getWebAppConfig().isSyncToThreadEnabled();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unknown component metadata", componentMetaData);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppSyncEnabledFromComponentMetaData", new Boolean(bl));
        }
        return bl;
    }

    private ComponentMetaDataAccessorImpl getMetaDataAccessor() {
        if (this._cmda == null) {
            this._cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        }
        return this._cmda;
    }

    public String toString() {
        return super.toString() + ";_syncEnabled=" + this._isSyncEnabled + ",_appSyncEnabled=" + this._isAppSyncEnabled + ",_threadIdentity=" + _threadIdentity;
    }

    private static native int ntv_setThreadSecurityEnvironment(PlatformCredential var0);
}

