/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.sip.channel.SIPMessage;
import java.net.InetSocketAddress;

public class SIPParsingDiags {
    private static final TraceComponent tc = Tr.register(SIPParsingDiags.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private String previousMessage = null;
    private int savedPostion = 0;
    private InetSocketAddress remoteAddress = null;

    public synchronized void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        this.remoteAddress = inetSocketAddress;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Setting remote Address to " + inetSocketAddress);
        }
    }

    public synchronized void setMessage(SIPMessage sIPMessage) {
        if (tc.isEventEnabled()) {
            this.previousMessage = sIPMessage.getStringRepresentation();
        }
    }

    public synchronized void setSavedPostion(int n) {
        if (tc.isEventEnabled()) {
            this.savedPostion = n;
        }
    }

    public synchronized void printDiagInformation(WsByteBuffer wsByteBuffer) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "previous position = " + this.savedPostion + " current position = " + wsByteBuffer.position() + " limit = " + wsByteBuffer.limit());
            Tr.event(tc, SIPParsingDiags.showBufferContents(wsByteBuffer));
            if (this.previousMessage != null) {
                Tr.event(tc, "previous message from " + this.remoteAddress + " was:");
                Tr.event(tc, this.previousMessage);
            } else {
                Tr.event(tc, "previous message from " + this.remoteAddress + " was null");
            }
        }
    }

    private static String showBufferContents(WsByteBuffer wsByteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        if (wsByteBuffer != null) {
            stringBuffer.append("Contents: [");
            stringBuffer.append(WsByteBufferUtils.asString((WsByteBuffer)wsByteBuffer));
            stringBuffer.append("]\r\n");
        } else {
            stringBuffer.append("null Buffer");
        }
        return stringBuffer.toString();
    }
}

