/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.channel.impl.SIPParsingDiags;
import com.ibm.ws.sip.channel.protocol.impl.SIPMessageImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.OutboundProtocol;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.sip.channel.SIPConnectionContext;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.SIPMessageFactory;
import com.ibm.wsspi.sip.channel.SIPReadCallback;
import com.ibm.wsspi.sip.channel.SIPReadCallbackThreaded;
import com.ibm.wsspi.sip.channel.SIPReadRequestContext;
import com.ibm.wsspi.sip.channel.SIPWriteCallback;
import com.ibm.wsspi.sip.channel.SIPWriteRequestContext;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;

public class SIPTcpConnection
implements SIPConnectionContext,
OutboundProtocol {
    private static final TraceComponent tc = Tr.register(SIPTcpConnection.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private static final String DISPLAY_MESSAGES = "displaySIPChannelMessages";
    private static int BUFFER_SIZE = 2048;
    private static WsByteBufferPoolManager bufferPool = WsByteBufferPoolManagerImpl.getRef();
    private SIPReadHandler readContext;
    private SIPWriteHandler writeContext;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress;
    private TCPReadRequestContext tcpReadRequestContext;
    private TCPWriteRequestContext tcpWriteRequestContext;
    private WsByteBuffer readBuffer;
    private VirtualConnection virtualConnection;
    private TCPConnectionContext myTSC;
    private boolean displayMessages;
    private boolean tryToSetBuffer;
    private static PlatformHelper helper = null;
    private SIPParsingDiags sipParsingDiags;
    private boolean readActive;

    public SIPTcpConnection(TCPConnectionContext tCPConnectionContext, VirtualConnection virtualConnection) {
        block13: {
            this.readContext = null;
            this.writeContext = null;
            this.remoteAddress = null;
            this.localAddress = null;
            this.tcpReadRequestContext = null;
            this.tcpWriteRequestContext = null;
            this.readBuffer = null;
            this.virtualConnection = null;
            this.myTSC = null;
            this.displayMessages = false;
            this.tryToSetBuffer = true;
            this.sipParsingDiags = new SIPParsingDiags();
            this.readActive = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection - constructor: entry: id =" + this.hashCode());
            }
            this.virtualConnection = virtualConnection;
            this.myTSC = tCPConnectionContext;
            this.tcpReadRequestContext = tCPConnectionContext.getReadInterface();
            this.tcpWriteRequestContext = tCPConnectionContext.getWriteInterface();
            this.localAddress = new InetSocketAddress(tCPConnectionContext.getLocalAddress(), tCPConnectionContext.getLocalPort());
            this.remoteAddress = new InetSocketAddress(tCPConnectionContext.getRemoteAddress(), tCPConnectionContext.getRemotePort());
            this.sipParsingDiags.setRemoteAddress(this.remoteAddress);
            this.readBuffer = tCPConnectionContext.getReadInterface().getBuffer();
            if (System.getProperty(DISPLAY_MESSAGES) != null && System.getProperty(DISPLAY_MESSAGES).equalsIgnoreCase("true")) {
                this.displayMessages = true;
            }
            if (helper == null) {
                try {
                    helper = PlatformHelperFactory.getPlatformHelper();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Unable to determine local OS + ", exception);
                }
            }
        }
        if (helper.isZOS()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SIPTcpConnection: constuctor: Setting jit allocation size: id=" + this.hashCode());
            }
            this.tcpReadRequestContext.setJITAllocateSize(BUFFER_SIZE);
        }
        if (this.readBuffer != null) {
            if (this.readBuffer.position() != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIPTcpConnection: constuctor: Data is present in the buffer: id=" + this.hashCode());
                }
                this.readBuffer.flip();
            }
        } else if (!helper.isZOS()) {
            this.readBuffer = bufferPool.allocate(BUFFER_SIZE);
            this.tcpReadRequestContext.setBuffer(this.readBuffer);
            this.readBuffer.position(this.readBuffer.limit());
        }
        this.readContext = new SIPReadHandler();
        this.writeContext = new SIPWriteHandler();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpConnection - constructor: exit : id=" + this.hashCode());
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpConnection: destroy: id=" + this.hashCode());
        }
        if (!helper.isZOS() && this.readBuffer != null) {
            this.readBuffer.release();
            this.readBuffer = null;
        }
        this.readContext.cleanup(new IOException("Connection is destroyed"));
        this.writeContext.cleanup(new IOException("Connection is destroyed"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpConnection: destroy: id=" + this.hashCode());
        }
    }

    public SIPReadRequestContext getReadInterface() {
        if (tc.isDebugEnabled() && this.readContext == null) {
            Tr.debug(tc, "SIPTcpConnection: getReadInterface: Returning null readContext: id=" + this.hashCode());
        }
        return this.readContext;
    }

    public SIPWriteRequestContext getWriteInterface() {
        if (tc.isDebugEnabled() && this.writeContext == null) {
            Tr.debug(tc, "SIPTcpConnection: getWriteInterface: Returning null writeContext: id=" + this.hashCode());
        }
        return this.writeContext;
    }

    public InetSocketAddress getRemoteAddress() {
        if (tc.isDebugEnabled() && this.remoteAddress == null) {
            Tr.debug(tc, "SIPTcpConnection: getRemoteAddress:Returning null remoteAddress: id=" + this.hashCode());
        }
        return this.remoteAddress;
    }

    public String getRemoteUri() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        if (tc.isDebugEnabled() && this.localAddress == null) {
            Tr.debug(tc, "SIPTcpConnection: getLocalAddress:Returning null localAddress: id=" + this.hashCode());
        }
        return this.localAddress;
    }

    public String getLocalUri() {
        return null;
    }

    private void printBuffer(WsByteBuffer wsByteBuffer) {
        if (tc.isDebugEnabled()) {
            int n = wsByteBuffer.limit();
            int n2 = wsByteBuffer.position();
            byte[] byArray = new byte[n - n2];
            wsByteBuffer.get(byArray);
            Tr.debug(tc, "\r\n" + new String(byArray));
            wsByteBuffer.limit(n);
            wsByteBuffer.position(n2);
        }
    }

    public final TCPConnectionContext getTSC() {
        return this.myTSC;
    }

    public SSLConnectionContext getSSLContext() {
        return null;
    }

    public boolean isSecure() {
        return this.getTSC().getSSLContext() != null;
    }

    public String getProtocol() {
        return "SIP";
    }

    public class SIPWriteHandler
    implements SIPWriteRequestContext,
    TCPWriteCompletedCallback {
        private SIPMessageImpl writeMessage = null;
        private WsByteBuffer[] writeBuffers = null;
        private SIPWriteCallback writeCallback = null;
        private boolean writeActive = false;

        public synchronized VirtualConnection write(SIPWriteCallback sIPWriteCallback, int n, InetSocketAddress inetSocketAddress) throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection$SIPWriteHandler: write: entry: id=" + this.hashCode());
            }
            VirtualConnection virtualConnection = null;
            this.writeCallback = sIPWriteCallback;
            this.validateWriteRequest();
            try {
                this.writeBuffers = this.writeMessage.marshallMessage();
                if (tc.isDebugEnabled() && SIPTcpConnection.this.displayMessages) {
                    Tr.debug(tc, "SIPTcpConnection$SIPWriteHandler: write: OUTBOUND MESSAGE BEGIN: id=" + this.hashCode());
                    for (int i = 0; i < this.writeBuffers.length; ++i) {
                        SIPTcpConnection.this.printBuffer(this.writeBuffers[i]);
                    }
                    Tr.debug(tc, "SIPTcpConnection$SIPWriteHandler: write: OUTBOUND MESSAGE END: id=" + this.hashCode());
                }
                SIPTcpConnection.this.tcpWriteRequestContext.setBuffers(this.writeBuffers);
                virtualConnection = SIPTcpConnection.this.tcpWriteRequestContext.write(-1L, (TCPWriteCompletedCallback)this, false, -1);
                if (virtualConnection == null) {
                    this.writeActive = true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sip.channel.SIPTcpConnection$SIPWriteHandler.write", "1", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error writing SIP message because exception=" + exception + ".");
                }
                throw new IOException(exception.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPWriteHandler: write: exit: id=" + this.hashCode());
            }
            return virtualConnection;
        }

        private void validateWriteRequest() throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection$SIPWriteHandler: validateWriteRequest: entry: id=" + this.hashCode());
            }
            if (this.writeMessage == null) {
                throw new IOException("Write message is invalid");
            }
            if (this.writeActive) {
                throw new IOException("Write is already active");
            }
            if (this.writeCallback == null) {
                throw new IOException("Invalid write callback");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPWriteHandler: validateWriteRequest: exit: id=" + this.hashCode());
            }
        }

        public SIPMessage allocateMessage() {
            return SIPMessageFactory.getSIPMessage();
        }

        public void setMessage(SIPMessage sIPMessage) {
            assert (sIPMessage != null);
            this.writeMessage = (SIPMessageImpl)sIPMessage;
        }

        public SIPConnectionContext getInterface() {
            return SIPTcpConnection.this;
        }

        public SIPMessage getMessage() {
            if (tc.isDebugEnabled() && this.writeMessage == null) {
                Tr.debug(tc, "SIPTCPConnection$WriteHandler:getMessage: returning null message: id=" + this.hashCode());
            }
            return this.writeMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection$SIPWriteHandler:complete: entry: id=" + this.hashCode());
            }
            SIPWriteHandler sIPWriteHandler = this;
            synchronized (sIPWriteHandler) {
                this.writeActive = false;
            }
            if (this.writeCallback != null) {
                this.writeCallback.complete(virtualConnection, this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPWriteHandler:complete: exit: id=" + this.hashCode());
            }
        }

        public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection$SIPWriteHandler: error: id=" + this.hashCode());
            }
            this.cleanup(iOException);
            if (this.writeCallback != null) {
                this.writeCallback.error(virtualConnection, this, iOException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPWriteHandler: error: id=" + this.hashCode());
            }
        }

        protected synchronized void cleanup(IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection$SIPWriteHandler: cleanup: entry: id=" + this.hashCode());
            }
            if (this.writeActive) {
                this.writeActive = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPWriteHandler: cleanup: exit: id=" + this.hashCode());
            }
        }

        private void writeErrorMessage(SIPMessage sIPMessage) throws MessageSentException {
            VirtualConnection virtualConnection = null;
            sIPMessage.convertToResponse(SIPMessage.STATUS_BAD_REQUEST);
            SIPTcpConnection.this.writeContext.setMessage(sIPMessage);
            if (!((SIPTcpConnection)SIPTcpConnection.this).writeContext.writeActive) {
                this.writeCallback = null;
                this.writeBuffers = sIPMessage.marshallMessage();
                SIPTcpConnection.this.tcpWriteRequestContext.setBuffers(this.writeBuffers);
                virtualConnection = SIPTcpConnection.this.tcpWriteRequestContext.write(-1L, (TCPWriteCompletedCallback)this, false, -1);
                if (virtualConnection == null) {
                    this.writeActive = true;
                }
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to write error response because write is already active.");
            }
        }
    }

    public class SIPReadHandler
    implements SIPReadRequestContext,
    TCPReadCompletedCallback {
        private SIPMessageImpl readMessage = null;
        private SIPReadCallback readCallback = null;

        public synchronized VirtualConnection read(SIPReadCallback sIPReadCallback, int n) throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection$SIPReadHandler: read: entry: id=" + this.hashCode());
            }
            boolean bl = false;
            VirtualConnection virtualConnection = null;
            try {
                this.readCallback = sIPReadCallback;
                this.validateReadRequest();
                this.readMessage = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
                this.readMessage.setLocalAddress(SIPTcpConnection.this.localAddress);
                this.readMessage.setRemoteAddress(SIPTcpConnection.this.remoteAddress);
                while (!bl) {
                    boolean bl2 = false;
                    if (SIPTcpConnection.this.readBuffer == null) {
                        bl2 = true;
                    } else if (!SIPTcpConnection.this.readBuffer.hasRemaining()) {
                        bl2 = true;
                    }
                    if (bl2) {
                        if (SIPTcpConnection.this.readBuffer != null) {
                            SIPTcpConnection.this.readBuffer.clear();
                        }
                        if (helper.isZOS() && SIPTcpConnection.this.tryToSetBuffer) {
                            try {
                                SIPTcpConnection.this.tcpReadRequestContext.setBuffer(null);
                            }
                            catch (Exception exception) {
                                SIPTcpConnection.this.tryToSetBuffer = false;
                            }
                        }
                        if ((virtualConnection = SIPTcpConnection.this.tcpReadRequestContext.read(1L, (TCPReadCompletedCallback)this, false, 15000)) == null) break;
                        if (helper.isZOS()) {
                            SIPTcpConnection.this.readBuffer = SIPTcpConnection.this.tcpReadRequestContext.getBuffer();
                        }
                        SIPTcpConnection.this.readBuffer.flip();
                    }
                    SIPTcpConnection.this.sipParsingDiags.setSavedPostion(SIPTcpConnection.this.readBuffer.position());
                    bl = this.readMessage.parseMessage(SIPTcpConnection.this.readBuffer);
                }
                if (!bl) {
                    virtualConnection = null;
                    SIPTcpConnection.this.readActive = true;
                } else {
                    SIPTcpConnection.this.sipParsingDiags.setMessage(this.readMessage);
                    if (tc.isDebugEnabled() && SIPTcpConnection.this.displayMessages) {
                        Tr.debug(tc, "SIPTcpConnection$SIPReadHandler: read: INBOUND MESSAGE BEGIN: id=" + this.hashCode());
                        WsByteBuffer[] wsByteBufferArray = this.readMessage.marshallMessage();
                        for (int i = 0; i < wsByteBufferArray.length; ++i) {
                            SIPTcpConnection.this.printBuffer(wsByteBufferArray[i]);
                        }
                        Tr.debug(tc, "SIPTcpConnection$SIPReadHandler: read: INBOUND MESSAGE END: id=" + this.hashCode());
                    }
                    virtualConnection = SIPTcpConnection.this.virtualConnection;
                    this.validateSipMessage(this.readMessage);
                }
            }
            catch (Exception exception) {
                if (this.readMessage.isRequest()) {
                    try {
                        SIPTcpConnection.this.writeContext.writeErrorMessage(this.readMessage);
                    }
                    catch (MessageSentException messageSentException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Error sending BAD response to remote client.");
                        }
                        virtualConnection = null;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not send error response to client because it sort of looks like a response.");
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sip.channel.SIPTcpConnection$SIPReadHandler.read", "1", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error processing SIP message because exception=" + exception + ".");
                }
                SIPTcpConnection.this.sipParsingDiags.printDiagInformation(SIPTcpConnection.this.readBuffer);
                throw new IOException(exception.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPReadHandler: read: exit: id=" + this.hashCode());
            }
            return virtualConnection;
        }

        public void readAlways(SIPReadCallbackThreaded sIPReadCallbackThreaded, boolean bl) throws IOException {
            throw new IOException("method not supported");
        }

        private void validateReadRequest() throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection$SIPReadHandler: validateReadRequest: entry: id=" + this.hashCode());
            }
            if (SIPTcpConnection.this.readActive) {
                throw new IOException("Read is already active");
            }
            if (this.readCallback == null) {
                throw new IOException("Invalid read callback");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPReadHandler: validateReadReqeust: exit: id=" + this.hashCode());
            }
        }

        private void validateSipMessage(SIPMessage sIPMessage) throws IOException {
            if (sIPMessage.containsHeader(SIPMessage.HDR_CONTENT_LENGTH)) {
                Integer n = null;
                boolean bl = false;
                String string = null;
                try {
                    n = sIPMessage.getHeaderAsInteger(SIPMessage.HDR_CONTENT_LENGTH);
                }
                catch (NumberFormatException numberFormatException) {
                    string = "Invalid SIP Message header value: " + SIPMessage.HDR_CONTENT_LENGTH.getName() + ":" + sIPMessage.getHeaderAsString(SIPMessage.HDR_CONTENT_LENGTH);
                }
                if (n != null && n >= 0) {
                    bl = true;
                } else {
                    string = "Invalid SIP Message header value: " + SIPMessage.HDR_CONTENT_LENGTH.getName() + ":" + sIPMessage.getHeaderAsString(SIPMessage.HDR_CONTENT_LENGTH);
                }
                if (!bl) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, string);
                    }
                    sIPMessage.printMessage();
                    throw new IOException(string);
                }
            }
        }

        public SIPConnectionContext getInterface() {
            return SIPTcpConnection.this;
        }

        public SIPMessage getMessage() {
            if (tc.isDebugEnabled() && this.readMessage == null) {
                Tr.debug(tc, "SIPTcpConnection$ReadHandler: getMessage: returning null message: id=" + this.hashCode());
            }
            return this.readMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
            block20: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "SIPTcpConnection$SIPReadHandler: complete: entry: id=" + this.hashCode());
                }
                if (helper.isZOS()) {
                    SIPTcpConnection.this.readBuffer = SIPTcpConnection.this.tcpReadRequestContext.getBuffer();
                }
                SIPTcpConnection.this.readBuffer.flip();
                try {
                    SIPTcpConnection.this.sipParsingDiags.setSavedPostion(SIPTcpConnection.this.readBuffer.position());
                    if (this.readMessage.parseMessage(SIPTcpConnection.this.readBuffer)) {
                        SIPTcpConnection.this.printBuffer(SIPTcpConnection.this.readBuffer);
                        SIPReadHandler sIPReadHandler = this;
                        synchronized (sIPReadHandler) {
                            SIPTcpConnection.this.readActive = false;
                        }
                        this.readMessage.setRemoteAddress(SIPTcpConnection.this.remoteAddress);
                        this.readMessage.setLocalAddress(SIPTcpConnection.this.localAddress);
                        SIPTcpConnection.this.sipParsingDiags.setMessage(this.readMessage);
                        this.readCallback.messageReceived(virtualConnection, this);
                        break block20;
                    }
                    assert (!SIPTcpConnection.this.readBuffer.hasRemaining());
                    boolean bl = false;
                    while (!bl) {
                        SIPTcpConnection.this.readBuffer.clear();
                        if (helper.isZOS() && SIPTcpConnection.this.tryToSetBuffer) {
                            try {
                                SIPTcpConnection.this.tcpReadRequestContext.setBuffer(null);
                            }
                            catch (Exception exception) {
                                SIPTcpConnection.this.tryToSetBuffer = false;
                            }
                        }
                        if ((virtualConnection = SIPTcpConnection.this.tcpReadRequestContext.read(1L, (TCPReadCompletedCallback)this, false, 15000)) == null) break;
                        if (helper.isZOS()) {
                            SIPTcpConnection.this.readBuffer = SIPTcpConnection.this.tcpReadRequestContext.getBuffer();
                        }
                        SIPTcpConnection.this.readBuffer.flip();
                        SIPTcpConnection.this.printBuffer(SIPTcpConnection.this.readBuffer);
                        SIPTcpConnection.this.sipParsingDiags.setSavedPostion(SIPTcpConnection.this.readBuffer.position());
                        bl = this.readMessage.parseMessage(SIPTcpConnection.this.readBuffer);
                    }
                    if (!bl) break block20;
                    SIPReadHandler sIPReadHandler = this;
                    synchronized (sIPReadHandler) {
                        SIPTcpConnection.this.readActive = false;
                    }
                    this.readMessage.setRemoteAddress(SIPTcpConnection.this.remoteAddress);
                    this.readMessage.setLocalAddress(SIPTcpConnection.this.localAddress);
                    SIPTcpConnection.this.sipParsingDiags.setMessage(this.readMessage);
                    this.validateSipMessage(this.readMessage);
                    this.readCallback.messageReceived(virtualConnection, this);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sip.channel.SIPTcpConnection$SIPReadHandler.complete", "2", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Error processing SIP message because exception=" + exception + ".");
                    }
                    SIPTcpConnection.this.sipParsingDiags.printDiagInformation(SIPTcpConnection.this.readBuffer);
                    if (tc.isWarningEnabled()) {
                        Tr.warning(tc, "CWSPC0001W", SIPTcpConnection.this.remoteAddress.toString());
                    }
                    this.error(virtualConnection, SIPTcpConnection.this.tcpReadRequestContext, new IOException(exception.toString()));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPReadHandler: complete: exit: id=" + this.hashCode());
            }
        }

        public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
            if (iOException instanceof SocketTimeoutException) {
                VirtualConnection virtualConnection2 = SIPTcpConnection.this.tcpReadRequestContext.read(1L, (TCPReadCompletedCallback)this, false, 15000);
                if (virtualConnection2 != null) {
                    this.complete(virtualConnection2, tCPReadRequestContext);
                }
            } else {
                this.cleanup(iOException);
                if (this.readCallback != null) {
                    this.readCallback.error(virtualConnection, this, iOException);
                }
            }
        }

        protected synchronized void cleanup(IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpConnection$SIPReadHandler: cleanup: entry: id=" + this.hashCode());
            }
            if (SIPTcpConnection.this.readActive) {
                this.readMessage.release();
                SIPTcpConnection.this.readActive = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPTcpConnection$SIPReadHandler: cleanup: exit: id=" + this.hashCode());
            }
        }
    }
}

