/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.channel.protocol.impl.SIPMessageImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.sip.channel.SIPConnectionContext;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.SIPMessageFactory;
import com.ibm.wsspi.sip.channel.SIPReadCallback;
import com.ibm.wsspi.sip.channel.SIPReadCallbackThreaded;
import com.ibm.wsspi.sip.channel.SIPReadRequestContext;
import com.ibm.wsspi.sip.channel.SIPWriteCallback;
import com.ibm.wsspi.sip.channel.SIPWriteRequestContext;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.udp.channel.UDPBuffer;
import com.ibm.wsspi.udp.channel.UDPContext;
import com.ibm.wsspi.udp.channel.UDPReadCompletedCallback;
import com.ibm.wsspi.udp.channel.UDPReadCompletedCallbackThreaded;
import com.ibm.wsspi.udp.channel.UDPReadRequestContext;
import com.ibm.wsspi.udp.channel.UDPWriteCompletedCallback;
import com.ibm.wsspi.udp.channel.UDPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class SIPUdpConnection
implements SIPConnectionContext {
    private static final TraceComponent tc = Tr.register(SIPUdpConnection.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private static final int MAX_BUFFER_SIZE = 65536;
    private static final String DISPLAY_MESSAGES = "displaySIPChannelMessages";
    private static WsByteBufferPoolManager bufferPool = WsByteBufferPoolManagerImpl.getRef();
    private SIPReadHandler readContext = null;
    private SIPWriteHandler writeContext = null;
    private InetSocketAddress localSocketAddress = null;
    private InetAddress localAddress = null;
    private int localPort = 0;
    private UDPReadRequestContext udpReadRequestContext = null;
    private UDPWriteRequestContext udpWriteRequestContext = null;
    private VirtualConnection virtualConnection = null;
    private WsByteBuffer writeBuffer = null;
    private String channelType = null;
    private int writeCount = 0;
    private int readCount = 0;
    private boolean displayMessages = false;

    public SIPUdpConnection(UDPContext uDPContext, VirtualConnection virtualConnection, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpConnection: constructor: entry: id=" + this.hashCode());
        }
        assert (uDPContext != null);
        assert (uDPContext.getLocalAddress() != null);
        this.virtualConnection = virtualConnection;
        this.channelType = string;
        this.udpReadRequestContext = uDPContext.getReadInterface();
        this.udpWriteRequestContext = uDPContext.getWriteInterface();
        this.localAddress = uDPContext.getLocalAddress();
        this.localPort = uDPContext.getLocalPort();
        this.localSocketAddress = new InetSocketAddress(this.localAddress, this.localPort);
        this.writeBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(65536);
        this.readContext = new SIPReadHandler();
        this.writeContext = new SIPWriteHandler();
        if (System.getProperty(DISPLAY_MESSAGES) != null && System.getProperty(DISPLAY_MESSAGES).equalsIgnoreCase("true")) {
            this.displayMessages = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpConnection: constructor: exit: id=" + this.hashCode());
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpConnection: destroy: entry: id=" + this.hashCode());
        }
        this.readContext.cleanup(new IOException("Connection is destroyed"));
        this.writeContext.cleanup(new IOException("Connection is destroyed"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpConnection: destroy: exit: id=" + this.hashCode());
        }
    }

    public SIPReadRequestContext getReadInterface() {
        if (tc.isDebugEnabled() && this.readContext == null) {
            Tr.debug(tc, "SIPUdpConnection:getReadInterface: returning null context: id=" + this.hashCode());
        }
        return this.readContext;
    }

    public SIPWriteRequestContext getWriteInterface() {
        if (tc.isDebugEnabled() && this.readContext == null) {
            Tr.debug(tc, "SIPUdpConnection:getWriteInterface: returning null context: id=" + this.hashCode());
        }
        return this.writeContext;
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public String getRemoteUri() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localSocketAddress;
    }

    public String getLocalUri() {
        return null;
    }

    private void printBuffer(WsByteBuffer wsByteBuffer) {
        if (tc.isDebugEnabled()) {
            int n = wsByteBuffer.limit();
            int n2 = wsByteBuffer.position();
            byte[] byArray = new byte[n - n2];
            wsByteBuffer.get(byArray);
            Tr.debug(tc, "\r\n" + new String(byArray));
            wsByteBuffer.limit(n);
            wsByteBuffer.position(n2);
        }
    }

    public SSLConnectionContext getSSLContext() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public class SIPWriteHandler
    implements SIPWriteRequestContext,
    UDPWriteCompletedCallback {
        private SIPMessageImpl writeMessage = null;
        private WsByteBuffer[] writeBuffers = null;
        private SIPWriteCallback writeCallback = null;
        private boolean writeActive = false;

        public synchronized VirtualConnection write(SIPWriteCallback sIPWriteCallback, int n, InetSocketAddress inetSocketAddress) throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPWriteHandler: write: entry: id=" + this.hashCode());
            }
            VirtualConnection virtualConnection = null;
            WsByteBuffer wsByteBuffer = null;
            this.writeCallback = sIPWriteCallback;
            this.validateWriteRequest();
            try {
                int n2;
                this.writeBuffers = this.writeMessage.marshallMessage();
                if (tc.isDebugEnabled() && SIPUdpConnection.this.displayMessages) {
                    Tr.debug(tc, "SIPUdpConnection$SIPWriteHandler: write: OUTBOUND MESSAGE BEGIN: id=" + this.hashCode());
                    for (n2 = 0; n2 < this.writeBuffers.length; ++n2) {
                        SIPUdpConnection.this.printBuffer(this.writeBuffers[n2]);
                    }
                    Tr.debug(tc, "SIPUdpConnection$SIPWriteHandler: write: OUTBOUND MESSAGE END: id=" + this.hashCode());
                }
                if (this.writeBuffers.length > 1) {
                    SIPUdpConnection.this.writeBuffer.clear();
                    for (n2 = 0; n2 < this.writeBuffers.length; ++n2) {
                        SIPUdpConnection.this.writeBuffer.put(this.writeBuffers[n2]);
                    }
                    SIPUdpConnection.this.writeBuffer.flip();
                    wsByteBuffer = SIPUdpConnection.this.writeBuffer;
                } else {
                    wsByteBuffer = this.writeBuffers[0];
                }
                SIPUdpConnection.this.udpWriteRequestContext.setBuffer(wsByteBuffer);
                virtualConnection = SIPUdpConnection.this.udpWriteRequestContext.write(inetSocketAddress, this, false);
                if (virtualConnection == null) {
                    this.writeActive = true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sip.channel.SIPUdpConnection$SIPWriteHandler.write", "1", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error writing SIP message because exception=" + exception + ".");
                }
                throw new IOException(exception.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPWriteHandler: write: exit: id=" + this.hashCode());
            }
            return virtualConnection;
        }

        private void validateWriteRequest() throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPWriteHandler: validateWriteRequest: entry: id=" + this.hashCode());
            }
            if (this.writeMessage == null) {
                throw new IOException("Write message is invalid");
            }
            if (this.writeActive) {
                throw new IOException("Write is already active");
            }
            if (this.writeCallback == null) {
                throw new IOException("Invalid write callback");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPWriteHandler: validateWriteRequest: exit: id=" + this.hashCode());
            }
        }

        public SIPMessage allocateMessage() {
            return SIPMessageFactory.getSIPMessage();
        }

        public void setMessage(SIPMessage sIPMessage) {
            assert (sIPMessage != null);
            this.writeMessage = (SIPMessageImpl)sIPMessage;
        }

        public SIPConnectionContext getInterface() {
            return SIPUdpConnection.this;
        }

        public SIPMessage getMessage() {
            return this.writeMessage;
        }

        public synchronized void complete(VirtualConnection virtualConnection, UDPWriteRequestContext uDPWriteRequestContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPWriteHandler: complete: entry: id=" + this.hashCode());
            }
            this.writeActive = false;
            this.writeCallback.complete(virtualConnection, this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPWriteHandler: complete: exit: id=" + this.hashCode());
            }
        }

        public void error(VirtualConnection virtualConnection, UDPWriteRequestContext uDPWriteRequestContext, IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPWriteHandler: error: entry: id=" + this.hashCode());
            }
            this.cleanup(iOException);
            if (this.writeCallback != null) {
                this.writeCallback.error(virtualConnection, this, iOException);
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPWriteHandler: error: entry: id=" + this.hashCode());
            }
        }

        protected synchronized void cleanup(IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPWriteHandler: cleanup: entry: id=" + this.hashCode());
            }
            if (this.writeActive) {
                this.writeActive = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPWriteHandler: cleanup: exit: id=" + this.hashCode());
            }
        }

        private void writeErrorMessage(SIPMessage sIPMessage) throws MessageSentException {
            VirtualConnection virtualConnection = null;
            sIPMessage.convertToResponse(SIPMessage.STATUS_BAD_REQUEST);
            SIPUdpConnection.this.writeContext.setMessage(sIPMessage);
            if (!((SIPUdpConnection)SIPUdpConnection.this).writeContext.writeActive) {
                WsByteBuffer wsByteBuffer = null;
                this.writeCallback = null;
                this.writeBuffers = sIPMessage.marshallMessage();
                if (this.writeBuffers.length > 1) {
                    SIPUdpConnection.this.writeBuffer.clear();
                    for (int i = 0; i < this.writeBuffers.length; ++i) {
                        SIPUdpConnection.this.writeBuffer.put(this.writeBuffers[i]);
                    }
                    SIPUdpConnection.this.writeBuffer.flip();
                    wsByteBuffer = SIPUdpConnection.this.writeBuffer;
                } else {
                    wsByteBuffer = this.writeBuffers[0];
                }
                SIPUdpConnection.this.udpWriteRequestContext.setBuffer(wsByteBuffer);
                InetSocketAddress inetSocketAddress = sIPMessage.getRemoteAddress();
                if (inetSocketAddress != null) {
                    virtualConnection = SIPUdpConnection.this.udpWriteRequestContext.write(inetSocketAddress, this, false);
                    if (virtualConnection == null) {
                        this.writeActive = true;
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event(tc, "remoteAddress == null, can not send error response back.");
                }
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to write error response because write is already active.");
            }
        }
    }

    public class SIPReadHandler
    implements SIPReadRequestContext,
    UDPReadCompletedCallback,
    UDPReadCompletedCallbackThreaded {
        private SIPMessageImpl readMessage = null;
        private SIPReadCallback readCallback = null;
        private SIPReadCallbackThreaded readCallbackThreaded = null;
        private boolean readActive = false;

        public synchronized VirtualConnection read(SIPReadCallback sIPReadCallback, int n) throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPReadHandler: read: entry: id=" + this.hashCode());
            }
            WsByteBuffer wsByteBuffer = null;
            boolean bl = false;
            VirtualConnection virtualConnection = null;
            try {
                this.readCallback = sIPReadCallback;
                this.validateReadRequest();
                if (this.readMessage == null) {
                    wsByteBuffer = SIPUdpConnection.this.udpReadRequestContext.getUDPBuffer().getBuffer();
                }
                this.readMessage = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
                if (wsByteBuffer != null && wsByteBuffer.position() != 0) {
                    wsByteBuffer.flip();
                    this.readMessage.setRemoteAddress((InetSocketAddress)SIPUdpConnection.this.udpReadRequestContext.getUDPBuffer().getAddress());
                    this.readMessage.setLocalAddress(SIPUdpConnection.this.localSocketAddress);
                    bl = this.readMessage.parseMessage(wsByteBuffer);
                    assert (bl);
                    if (tc.isDebugEnabled() && SIPUdpConnection.this.displayMessages) {
                        Tr.debug(tc, "SIPUdpConnection$SIPReadHandler: read: INBOUND MESSAGE BEGIN: id=" + this.hashCode());
                        WsByteBuffer[] wsByteBufferArray = this.readMessage.marshallMessage();
                        for (int i = 0; i < wsByteBufferArray.length; ++i) {
                            this.printBuffer(wsByteBufferArray[i]);
                        }
                        Tr.debug(tc, "SIPUdpConnection$SIPReadHandler: read: INBOUND MESSAGE END: id=" + this.hashCode());
                    }
                    this.validateSipMessage(this.readMessage);
                    virtualConnection = SIPUdpConnection.this.virtualConnection;
                    wsByteBuffer.release();
                } else {
                    virtualConnection = SIPUdpConnection.this.udpReadRequestContext.read(this, false);
                    if (virtualConnection != null) {
                        wsByteBuffer = SIPUdpConnection.this.udpReadRequestContext.getUDPBuffer().getBuffer();
                        wsByteBuffer.flip();
                        this.readMessage.setRemoteAddress((InetSocketAddress)SIPUdpConnection.this.udpReadRequestContext.getUDPBuffer().getAddress());
                        this.readMessage.setLocalAddress(SIPUdpConnection.this.localSocketAddress);
                        bl = this.readMessage.parseMessage(wsByteBuffer);
                        assert (bl);
                        if (tc.isDebugEnabled() && SIPUdpConnection.this.displayMessages) {
                            Tr.debug(tc, "SIPUdpConnection$SIPReadHandler: read: INBOUND MESSAGE BEGIN: id=" + this.hashCode());
                            WsByteBuffer[] wsByteBufferArray = this.readMessage.marshallMessage();
                            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                                this.printBuffer(wsByteBufferArray[i]);
                            }
                            Tr.debug(tc, "SIPUdpConnection$SIPReadHandler: read: INBOUND MESSAGE END: id=" + this.hashCode());
                        }
                        this.validateSipMessage(this.readMessage);
                        virtualConnection = SIPUdpConnection.this.virtualConnection;
                        wsByteBuffer.release();
                    } else {
                        this.readActive = true;
                    }
                }
            }
            catch (Exception exception) {
                if (this.readMessage.isRequest()) {
                    try {
                        SIPUdpConnection.this.writeContext.writeErrorMessage(this.readMessage);
                    }
                    catch (MessageSentException messageSentException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Error sending BAD response to remote client.");
                        }
                        virtualConnection = null;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not send error response to client because it sort of looks like a response.");
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sip.channel.SIPUdpConnection$SIPReadHandler.read", "1", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error processing SIP message because exception=" + exception + ".");
                }
                if (tc.isWarningEnabled()) {
                    Tr.warning(tc, "CWSPC0001W", SIPUdpConnection.this.udpReadRequestContext.getUDPBuffer().getAddress().toString());
                }
                this.readMessage.clear();
                if (wsByteBuffer != null) {
                    wsByteBuffer.release();
                }
                SIPUdpConnection.this.udpReadRequestContext.read(this, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPReadHandler: read: exit: id=" + this.hashCode());
            }
            return virtualConnection;
        }

        public synchronized void readAlways(SIPReadCallbackThreaded sIPReadCallbackThreaded, boolean bl) throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPReadHandler: readAlways: entry: id=" + this.hashCode());
            }
            try {
                this.readCallbackThreaded = sIPReadCallbackThreaded;
                this.validateReadRequest();
                SIPUdpConnection.this.udpReadRequestContext.readAlways(this, bl);
                if (bl) {
                    this.readActive = true;
                } else {
                    this.readActive = false;
                    this.readCallbackThreaded = null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sip.channel.SIPUdpConnection$SIPReadHandler.readAlways", "1", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPReadHandler: readAlways: exit: id=" + this.hashCode());
            }
        }

        private void validateReadRequest() throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPReadHandler: validateReadRequest: entry: id=" + this.hashCode());
            }
            if (this.readActive) {
                throw new IOException("Read is already active");
            }
            if (this.readCallback == null && this.readCallbackThreaded == null) {
                throw new IOException("Invalid read callback");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPReadHandler: validateReadRequest: exit: id=" + this.hashCode());
            }
        }

        private void validateSipMessage(SIPMessage sIPMessage) throws IOException {
            if (sIPMessage.containsHeader(SIPMessage.HDR_CONTENT_LENGTH)) {
                Integer n = null;
                boolean bl = false;
                String string = null;
                try {
                    n = sIPMessage.getHeaderAsInteger(SIPMessage.HDR_CONTENT_LENGTH);
                }
                catch (NumberFormatException numberFormatException) {
                    string = "Invalid SIP Message header value: " + SIPMessage.HDR_CONTENT_LENGTH.getName() + ":" + sIPMessage.getHeaderAsString(SIPMessage.HDR_CONTENT_LENGTH);
                }
                if (n != null && n >= 0) {
                    bl = true;
                } else {
                    string = "Invalid SIP Message header value: " + SIPMessage.HDR_CONTENT_LENGTH.getName() + ":" + sIPMessage.getHeaderAsString(SIPMessage.HDR_CONTENT_LENGTH);
                }
                if (!bl) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, string);
                    }
                    sIPMessage.printMessage();
                    throw new IOException(string);
                }
            }
        }

        public SIPConnectionContext getInterface() {
            return SIPUdpConnection.this;
        }

        public SIPMessage getMessage() {
            return this.readMessage;
        }

        public synchronized void complete(VirtualConnection virtualConnection, UDPReadRequestContext uDPReadRequestContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPReadHandler: complete: entry: id=" + this.hashCode());
            }
            WsByteBuffer wsByteBuffer = uDPReadRequestContext.getUDPBuffer().getBuffer();
            wsByteBuffer.flip();
            try {
                this.readMessage.setRemoteAddress((InetSocketAddress)uDPReadRequestContext.getUDPBuffer().getAddress());
                this.readMessage.setLocalAddress(SIPUdpConnection.this.localSocketAddress);
                boolean bl = this.readMessage.parseMessage(wsByteBuffer);
                assert (bl);
                this.readActive = false;
                this.validateSipMessage(this.readMessage);
                this.readCallback.messageReceived(virtualConnection, this);
                wsByteBuffer.release();
            }
            catch (Exception exception) {
                if (this.readMessage.isRequest()) {
                    try {
                        SIPUdpConnection.this.writeContext.writeErrorMessage(this.readMessage);
                    }
                    catch (MessageSentException messageSentException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Error sending BAD response to remote client.");
                        }
                        virtualConnection = null;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not send error response to client because it sort of looks like a response.");
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sip.channel.SIPUdpConnection$SIPReadHandler.complete", "2", this);
                if (tc.isWarningEnabled()) {
                    Tr.warning(tc, "CWSPC0001W", uDPReadRequestContext.getUDPBuffer().getAddress().toString());
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error processing SIP message because exception=" + exception + ".");
                }
                if (this.readMessage != null) {
                    wsByteBuffer.release();
                    this.readMessage.clear();
                }
                uDPReadRequestContext.read(this, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPReadHandler: complete: exit: id=" + this.hashCode());
            }
        }

        public void complete(VirtualConnection virtualConnection, UDPBuffer uDPBuffer) {
            SIPMessageImpl sIPMessageImpl = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPReadHandler: (multhreaded) complete: entry: id=" + this.hashCode());
            }
            try {
                uDPBuffer.getBuffer().flip();
                sIPMessageImpl = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
                sIPMessageImpl.setRemoteAddress((InetSocketAddress)uDPBuffer.getAddress());
                sIPMessageImpl.setLocalAddress(SIPUdpConnection.this.localSocketAddress);
                boolean bl = sIPMessageImpl.parseMessage(uDPBuffer.getBuffer());
                assert (bl);
                this.validateSipMessage(sIPMessageImpl);
                this.readCallbackThreaded.messageReceivedThreaded(virtualConnection, this, sIPMessageImpl);
                uDPBuffer.getBuffer().release();
                uDPBuffer.release();
            }
            catch (Exception exception) {
                if (sIPMessageImpl != null) {
                    if (sIPMessageImpl.isRequest()) {
                        try {
                            SIPUdpConnection.this.writeContext.writeErrorMessage(sIPMessageImpl);
                        }
                        catch (MessageSentException messageSentException) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Error sending BAD response to remote client.");
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not send error response to client because it sort of looks like a response.");
                        }
                        sIPMessageImpl.release();
                    }
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sip.channel.SIPUdpConnection$SIPReadHandler.complete", "2", this);
                if (tc.isWarningEnabled()) {
                    Tr.warning(tc, "CWSPC0001W", SIPUdpConnection.this.udpReadRequestContext.getUDPBuffer().getAddress().toString());
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error processing SIP message because exception=" + exception + ".");
                }
                uDPBuffer.getBuffer().release();
                uDPBuffer.release();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPReadHandler: (multithreaded) complete: exit: id=" + this.hashCode());
            }
        }

        public void error(VirtualConnection virtualConnection, UDPReadRequestContext uDPReadRequestContext, IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPReadHandler: error: entry: id=" + this.hashCode());
            }
            this.cleanup(iOException);
            if (this.readCallback != null) {
                this.readCallback.error(virtualConnection, this, iOException);
            }
            if (this.readCallbackThreaded != null) {
                this.readCallbackThreaded.error(virtualConnection, this, iOException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPReadHandler: error: exit: id=" + this.hashCode());
            }
        }

        protected synchronized void cleanup(IOException iOException) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPReadHandler: cleanup: entry: id=" + this.hashCode());
            }
            if (this.readActive) {
                if (this.readMessage != null) {
                    this.readMessage.destroy();
                    this.readMessage = null;
                }
                this.readActive = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPReadHandler: cleanup: exit: id=" + this.hashCode());
            }
        }

        private void printBuffer(WsByteBuffer wsByteBuffer) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPUdpConnection$SIPReadHandler: printBuffer: entry: id=" + this.hashCode());
            }
            int n = wsByteBuffer.limit();
            int n2 = wsByteBuffer.position();
            System.out.println(new String(wsByteBuffer.array()));
            wsByteBuffer.limit(n);
            wsByteBuffer.position(n2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SIPUdpConnection$SIPReadHandler: shutdown: exit: id=" + this.hashCode());
            }
        }
    }
}

