/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sip.channel.inbound.impl.SIPTcpInboundConnLink;
import com.ibm.ws.sip.channel.protocol.impl.SIPMessageImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundProtocolChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.sip.channel.SIPConnectionContext;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.SIPMessageFactory;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SIPTcpInboundChannel
extends InboundProtocolChannel
implements Discriminator {
    private static final TraceComponent tc = Tr.register(SIPTcpInboundChannel.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private static final String AUTHORIZATION_REQUIRED = "authRequired";
    private static final String REASSEMBLY_REQUIRED = "reassemblyRequired";
    private static PlatformHelper platformHelper = null;
    private ThreadPool threadPool;
    private ChannelFramework channelFramework;
    private List channelManagementProfile;
    private String channelChainProtocolType;

    public SIPTcpInboundChannel(ChannelData channelData) {
        Map map;
        block9: {
            super(channelData);
            this.threadPool = null;
            this.channelFramework = null;
            this.channelManagementProfile = null;
            this.channelChainProtocolType = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SIPTcpInboundChannel:constructor: entry: id=" + ((Object)((Object)this)).hashCode());
            }
            this.channelFramework = channelData.getChannelFramework();
            if (platformHelper == null) {
                try {
                    platformHelper = PlatformHelperFactory.getPlatformHelper();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "constructor: Unable to determine local OS + ", exception);
                }
            }
        }
        if ((map = channelData.getPropertyBag()) != null) {
            for (String string : map.keySet()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key data being grabbed: " + string);
                }
                if (!string.equalsIgnoreCase("channelChainProtocolType")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting channelChainProtocolType to " + (String)map.get(string));
                }
                this.channelChainProtocolType = (String)map.get(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundChannel:constructor: exit: id=" + ((Object)((Object)this)).hashCode());
        }
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundChannel: descriminate: entry: id=" + ((Object)((Object)this)).hashCode());
        }
        int n = -1;
        WsByteBuffer[] wsByteBufferArray = (WsByteBuffer[])object;
        if (null == wsByteBufferArray || 0 == wsByteBufferArray.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No data provided, returning MAYBE");
            }
            return -1;
        }
        boolean bl = true;
        SIPMessageImpl sIPMessageImpl = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
        for (int i = 0; i < wsByteBufferArray.length && null != wsByteBufferArray[i] && bl; ++i) {
            object2 = wsByteBufferArray[i];
            int n2 = object2.limit();
            int n3 = object2.position();
            object2.flip();
            try {
                boolean bl2 = sIPMessageImpl.parseMessage((WsByteBuffer)object2);
                if (bl2) {
                    n = 1;
                    bl = false;
                }
            }
            catch (Exception exception) {
                n = 0;
                bl = false;
            }
            object2.limit(n2);
            object2.position(n3);
        }
        if (n == 1 && platformHelper.isZOS() && platformHelper.isServantJvm() && this.channelChainProtocolType != null) {
            Vector vector = sIPMessageImpl.getHeaderStringValues(SIPMessage.HDR_VIA);
            object2 = (String)vector.firstElement();
            if (((String)object2).contains("TCP")) {
                if (this.channelChainProtocolType.compareTo("TCP") != 0) {
                    n = 0;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIP TCP Channel Chain accepting new connection");
                }
            } else if (((String)object2).contains("UDP")) {
                if (this.channelChainProtocolType.compareTo("UDP") != 0) {
                    n = 0;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIP UDP Channel Chain accepting new connection");
                }
            } else if (((String)object2).contains("TLS")) {
                if (this.channelChainProtocolType.compareTo("TLS") != 0) {
                    n = 0;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIP TLS Channel Chain accepting new connection");
                }
            }
        }
        sIPMessageImpl.release();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundChannel: descriminate: exit: id=" + ((Object)((Object)this)).hashCode());
        }
        return n;
    }

    public Class getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.config.getDiscriminatorWeight();
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public Class getDiscriminatoryType() {
        return SIPMessage.class;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundChannel: getConnectionLink: entry: id=" + ((Object)((Object)this)).hashCode());
        }
        SIPTcpInboundConnLink sIPTcpInboundConnLink = new SIPTcpInboundConnLink(this.getDiscriminationProcess(), virtualConnection);
        sIPTcpInboundConnLink.init(virtualConnection);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundChannel: getConnectionLink: exit: id=" + ((Object)((Object)this)).hashCode());
        }
        return sIPTcpInboundConnLink;
    }

    public void start() throws ChannelException {
        if (tc.isInfoEnabled()) {
            Tr.info(tc, "CWSPC0002I");
        }
    }

    public void stop(long l) throws ChannelException {
        if (tc.isInfoEnabled()) {
            Tr.info(tc, "CWSPC0003I");
        }
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }

    public Class getApplicationInterface() {
        return SIPConnectionContext.class;
    }

    public Class getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public void update(ChannelData channelData) {
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
    }
}

