/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sip.channel.impl.SIPTcpConnection;
import com.ibm.ws.sip.channel.protocol.impl.SIPMessageImpl;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.InboundProtocolLink;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.SIPMessageFactory;
import com.ibm.wsspi.sip.channel.SIPReadCallback;
import com.ibm.wsspi.sip.channel.SIPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class SIPTcpInboundConnLink
extends InboundProtocolLink
implements SIPReadCallback {
    private static final TraceComponent tc = Tr.register(SIPTcpInboundConnLink.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private DiscriminationProcess discriminationProcess;
    private SIPTcpConnection sipConnection = null;
    private SIPMessageImpl readMessage = null;

    public SIPTcpInboundConnLink(DiscriminationProcess discriminationProcess, VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: constructor: entry: id=" + this.hashCode());
        }
        this.discriminationProcess = discriminationProcess;
        this.readMessage = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: constructor: exit: id=" + this.hashCode());
        }
    }

    public void destroy(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: destroy with exception: entry: id=" + this.hashCode());
        }
        super.destroy(exception);
        if (this.sipConnection != null) {
            this.sipConnection.destroy();
        }
        this.destroy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: destroy with exception: exit: id=" + this.hashCode());
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: destroy: entry: id=" + this.hashCode());
        }
        if (this.sipConnection != null) {
            this.sipConnection.destroy();
        }
        super.destroy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: destroy: exit: id=" + this.hashCode());
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: close: entry: id=" + this.hashCode());
        }
        if (this.getDeviceLink() != null) {
            this.getDeviceLink().close(virtualConnection, exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: close: exit: id=" + this.hashCode());
        }
    }

    public Object getChannelAccessor() {
        return this.sipConnection;
    }

    public void ready(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: ready: entry: id=" + this.hashCode());
        }
        try {
            TCPConnectionContext tCPConnectionContext = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
            this.sipConnection = new SIPTcpConnection(tCPConnectionContext, virtualConnection);
            VirtualConnection virtualConnection2 = this.sipConnection.getReadInterface().read(this, -1);
            if (virtualConnection2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIPTcpInboundConnection:ready: SIP vc was null: id=" + this.hashCode());
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIPTcpInboundConnection:ready: connection valid -init descriminate: id=" + this.hashCode());
                }
                this.initiateDiscriminate(virtualConnection2, this.sipConnection.getReadInterface().getMessage());
            }
        }
        catch (IOException iOException) {
            this.close(virtualConnection, iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: ready: exit: id=" + this.hashCode());
        }
    }

    public void messageReceived(VirtualConnection virtualConnection, SIPReadRequestContext sIPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: messageReceived: entry: id=" + this.hashCode());
        }
        this.initiateDiscriminate(virtualConnection, sIPReadRequestContext.getMessage());
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: messageReceived: exit: id=" + this.hashCode());
        }
    }

    public void error(VirtualConnection virtualConnection, SIPReadRequestContext sIPReadRequestContext, IOException iOException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: error: entry: id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SIPTcpInboundConnLink: error:Received error parsing message:id=" + this.hashCode());
        }
        this.sipConnection.destroy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: error: exit: id=" + this.hashCode());
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: error2: entry: id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SIPTcpInboundConnLink: error2 " + iOException + "id=" + this.hashCode());
        }
        this.readMessage.release();
        this.readMessage = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: error2: exit: id=" + this.hashCode());
        }
    }

    private void initiateDiscriminate(VirtualConnection virtualConnection, SIPMessage sIPMessage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPTcpInboundConnLink: initiateDiscriminate:entry: id=" + this.hashCode());
        }
        try {
            int n = this.discriminationProcess.discriminate(virtualConnection, (Object)this.readMessage, (ConnectionLink)this);
            if (n == 1) {
                this.getApplicationCallback().ready(virtualConnection);
            } else if (n == 2) {
                sIPMessage.destroy();
                VirtualConnection virtualConnection2 = this.sipConnection.getReadInterface().read(this, -1);
            } else {
                this.close(virtualConnection, null);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SIPTcpInboundConnLink: initiateDiscriminate: id=" + this.hashCode() + " :EXCEPTION: " + exception.toString());
            }
            this.close(virtualConnection, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: initiateDiscriminate: exit: id=" + this.hashCode());
        }
    }
}

