/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sip.channel.inbound.impl.SIPUdpInboundConnLink;
import com.ibm.ws.sip.channel.protocol.impl.SIPMessageImpl;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundProtocolChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.sip.channel.SIPConnectionContext;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.SIPMessageFactory;
import com.ibm.wsspi.udp.channel.UDPContext;
import java.util.List;
import java.util.Map;

public class SIPUdpInboundChannel
extends InboundProtocolChannel
implements Discriminator {
    private static final TraceComponent tc = Tr.register(SIPUdpInboundChannel.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private static final String AUTHORIZATION_REQUIRED = "authRequired";
    private static final String REASSEMBLY_REQUIRED = "reassemblyRequired";
    private ThreadPool threadPool = null;
    private ChannelFramework channelFramework = null;
    private List channelManagementProfile = null;

    public SIPUdpInboundChannel(ChannelData channelData) {
        super(channelData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundChannel: constructor: entry: id=" + ((Object)((Object)this)).hashCode());
        }
        this.channelFramework = channelData.getChannelFramework();
        Map map = channelData.getPropertyBag();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpInboundChannel: constructor: exit: id=" + ((Object)((Object)this)).hashCode());
        }
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundChannel: descriminate: entry: id=" + ((Object)((Object)this)).hashCode());
        }
        int n = -1;
        WsByteBuffer[] wsByteBufferArray = (WsByteBuffer[])object;
        if (null == wsByteBufferArray || 0 == wsByteBufferArray.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No data provided, returning MAYBE");
            }
            return -1;
        }
        boolean bl = true;
        SIPMessageImpl sIPMessageImpl = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
        for (int i = 0; i < wsByteBufferArray.length && null != wsByteBufferArray[i] && bl; ++i) {
            WsByteBuffer wsByteBuffer = wsByteBufferArray[i];
            int n2 = wsByteBuffer.limit();
            int n3 = wsByteBuffer.position();
            wsByteBuffer.flip();
            try {
                boolean bl2 = sIPMessageImpl.parseMessage(wsByteBuffer);
                if (bl2) {
                    n = 1;
                    bl = false;
                }
            }
            catch (Exception exception) {
                n = 0;
                bl = false;
            }
            wsByteBuffer.limit(n2);
            wsByteBuffer.position(n3);
        }
        sIPMessageImpl.release();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpInboundChannel: descriminate: exit: id=" + ((Object)((Object)this)).hashCode());
        }
        return n;
    }

    public Class getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.config.getDiscriminatorWeight();
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public Class getDiscriminatoryType() {
        return SIPMessage.class;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundChannel:getConnectionLink: entry: id=" + ((Object)((Object)this)).hashCode());
        }
        SIPUdpInboundConnLink sIPUdpInboundConnLink = new SIPUdpInboundConnLink(this.getDiscriminationProcess(), virtualConnection);
        sIPUdpInboundConnLink.init(virtualConnection);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpInboundChannel:getConnectionLink: exit: id=" + ((Object)((Object)this)).hashCode());
        }
        return sIPUdpInboundConnLink;
    }

    public void start() throws ChannelException {
        if (tc.isInfoEnabled()) {
            Tr.info(tc, "CWSPC0002I");
        }
    }

    public void stop(long l) throws ChannelException {
        if (tc.isInfoEnabled()) {
            Tr.info(tc, "CWSPC0003I");
        }
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }

    public Class getApplicationInterface() {
        return SIPConnectionContext.class;
    }

    public Class getDeviceInterface() {
        return UDPContext.class;
    }

    public void update(ChannelData channelData) {
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
    }
}

