/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.sip.channel.impl.SIPUdpConnection;
import com.ibm.ws.sip.channel.protocol.impl.SIPMessageImpl;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.InboundProtocolLink;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.SIPMessageFactory;
import com.ibm.wsspi.sip.channel.SIPReadCallback;
import com.ibm.wsspi.sip.channel.SIPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.udp.channel.UDPContext;
import java.io.IOException;

public class SIPUdpInboundConnLink
extends InboundProtocolLink
implements SIPReadCallback {
    private static final TraceComponent tc = Tr.register(SIPUdpInboundConnLink.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    public static WsByteBufferPoolManager bufferPool = WsByteBufferPoolManagerImpl.getRef();
    private DiscriminationProcess discriminationProcess;
    private SIPUdpConnection sipConnection = null;
    private SIPMessageImpl readMessage = null;

    public SIPUdpInboundConnLink(DiscriminationProcess discriminationProcess, VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: constructor: entry: id=" + this.hashCode());
        }
        this.discriminationProcess = discriminationProcess;
        this.readMessage = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: constructor: entry: id=" + this.hashCode());
        }
    }

    public Object getChannelAccessor() {
        return this.sipConnection;
    }

    public void ready(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: ready: entry: id=" + this.hashCode());
        }
        try {
            UDPContext uDPContext = (UDPContext)this.getDeviceLink().getChannelAccessor();
            this.sipConnection = new SIPUdpConnection(uDPContext, virtualConnection, "Inbound");
            VirtualConnection virtualConnection2 = this.sipConnection.getReadInterface().read(this, -1);
            if (virtualConnection2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIPUdpInboundConnection:ready: SIP vc was null: id=" + this.hashCode());
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIPTcpInboundConnection:ready: connection valid -init descriminate: id=" + this.hashCode());
                }
                this.initiateDiscriminate(virtualConnection2, this.sipConnection.getReadInterface().getMessage());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            virtualConnection.destroy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpInboundConnLink: ready: exit: id=" + this.hashCode());
        }
    }

    public void destroy(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: destroy: entry: id=" + this.hashCode());
        }
        if (this.sipConnection != null) {
            this.sipConnection.destroy();
        }
        super.destroy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpInboundConnLink: destroy: exit: id=" + this.hashCode());
        }
    }

    public void messageReceived(VirtualConnection virtualConnection, SIPReadRequestContext sIPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: messageReceived: entry: id=" + this.hashCode());
        }
        this.initiateDiscriminate(virtualConnection, sIPReadRequestContext.getMessage());
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: messageReceived: exit: id=" + this.hashCode());
        }
    }

    public void error(VirtualConnection virtualConnection, SIPReadRequestContext sIPReadRequestContext, IOException iOException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: error: entry: id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SIPUdpInboundConnLink: error:Received error parsing message:id=" + this.hashCode());
        }
        virtualConnection.destroy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpInboundConnLink: error: exit: id=" + this.hashCode());
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: error2: entry: id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SIPUdpInboundConnLink: error2 " + iOException + "id=" + this.hashCode());
        }
        this.readMessage.release();
        this.readMessage = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPTcpInboundConnLink: error2: exit: id=" + this.hashCode());
        }
    }

    private void initiateDiscriminate(VirtualConnection virtualConnection, SIPMessage sIPMessage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPUdpInboundConnLink: initiateDiscriminate: entry: id=" + this.hashCode());
        }
        try {
            int n = this.discriminationProcess.discriminate(virtualConnection, (Object)this.readMessage, (ConnectionLink)this);
            if (n == 1) {
                this.getApplicationCallback().ready(virtualConnection);
            } else if (n == 2) {
                sIPMessage.destroy();
                VirtualConnection virtualConnection2 = this.sipConnection.getReadInterface().read(this, -1);
            } else {
                this.close(virtualConnection, null);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SIPUdpInboundConnLink: initiateDiscriminate: id=" + this.hashCode() + " :EXCEPTION: " + exception.toString());
            }
            this.close(virtualConnection, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPUdpInboundConnLink: initiateDiscriminate: exit: id=" + this.hashCode());
        }
    }
}

