/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.protocol.impl;

import com.ibm.ws.sip.channel.protocol.impl.SIPMessageImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.SIPMessageFactory;
import com.ibm.wsspi.sip.channel.exception.InvalidSIPViaHeaderException;
import com.ibm.wsspi.sip.channel.protocol.SIPUtils;
import com.ibm.wsspi.sip.channel.protocol.ViaHeader;
import java.util.Properties;
import java.util.Random;

public class RegisterMessage {
    private static final String REG_EXPIRATION = "registrationExpiration";
    private static final String REGISTRATION_DOMAIN = "registrationDomain";
    private static final String MAX_FORWARDS = "maxForwards";
    private static final String SIP_TRANSPORT = "sipTransport";
    private static final String LOCAL_HOSTNAME = "localHostname";
    private static final String LOCAL_PORT = "localPort";
    private static final Random random = new Random(System.currentTimeMillis());
    private int callid;
    private String transport;
    private String contact;
    private String toUri;
    private String fromUri;
    private String requestURI;
    private String toTag;
    private String fromTag;
    private ViaHeader via;
    private int cseq = 1;
    Properties config = null;

    public RegisterMessage(String string, String string2, Properties properties) {
        assert (string != null);
        assert (string2 != null);
        assert (properties != null);
        this.callid = Math.abs(random.nextInt());
        this.toTag = Integer.toString(Math.abs(random.nextInt()));
        this.fromTag = Integer.toString(Math.abs(random.nextInt()));
        this.contact = string2;
        this.toUri = string;
        this.fromUri = string;
        this.config = properties;
        if (properties.containsKey(REGISTRATION_DOMAIN)) {
            this.requestURI = properties.getProperty(REGISTRATION_DOMAIN);
        }
    }

    public String getMessageAsString() {
        String string = null;
        try {
            string = new String();
            WsByteBuffer[] wsByteBufferArray = this.createRegisterMessage().marshallMessage();
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                byte[] byArray = new byte[wsByteBufferArray[i].limit()];
                wsByteBufferArray[i].get(byArray);
                string = string.concat(new String(byArray));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = null;
        }
        return string;
    }

    public SIPMessage getMessage() {
        SIPMessageImpl sIPMessageImpl = null;
        try {
            sIPMessageImpl = this.createRegisterMessage();
        }
        catch (InvalidSIPViaHeaderException invalidSIPViaHeaderException) {
            invalidSIPViaHeaderException.printStackTrace();
            sIPMessageImpl = null;
        }
        return sIPMessageImpl;
    }

    public ViaHeader getVia() {
        return this.via;
    }

    private SIPMessageImpl createRegisterMessage() throws InvalidSIPViaHeaderException {
        assert (this.requestURI != null);
        assert (this.toUri != null);
        assert (this.config.containsKey(REG_EXPIRATION));
        assert (this.callid != 0);
        assert (this.config.containsKey(LOCAL_HOSTNAME));
        assert (this.config.containsKey(MAX_FORWARDS));
        assert (this.config.containsKey(LOCAL_PORT));
        String string = this.config.getProperty(LOCAL_HOSTNAME);
        String string2 = this.config.getProperty(LOCAL_PORT);
        String string3 = this.config.getProperty(SIP_TRANSPORT);
        SIPMessageImpl sIPMessageImpl = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
        sIPMessageImpl.setRequest(true);
        sIPMessageImpl.setRequestMethod(SIPMessage.METHOD_REGISTER);
        sIPMessageImpl.setRequestUri(this.requestURI);
        if (this.toUri.indexOf(";tag") == -1) {
            this.toUri = this.toUri.concat(";tag=" + this.toTag);
            this.fromUri = this.fromUri.concat(";tag=" + this.fromTag);
        }
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_TO, this.toUri);
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_FROM, this.fromUri);
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_CALL_ID, Integer.toString(this.callid) + "@" + string);
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_CONTACT, this.contact);
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_CSEQ, Integer.toString(this.cseq) + " REGISTER");
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_MAX_FORWARDS, this.config.getProperty(MAX_FORWARDS));
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_EXPIRES, this.config.getProperty(REG_EXPIRATION));
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_ALLOW_EVENTS, "presence");
        sIPMessageImpl.setHeaderValue(SIPMessage.HDR_CONTENT_LENGTH, "0");
        this.via = new ViaHeader();
        if (string3.compareToIgnoreCase("TCP") == 0) {
            this.via.setProtocol("SIP/2.0/TCP");
        } else if (string3.compareToIgnoreCase("TLS") == 0) {
            this.via.setProtocol("SIP/2.0/TLS");
        } else {
            this.via.setProtocol("SIP/2.0/UDP");
        }
        this.via.setSentBy(this.config.getProperty(LOCAL_HOSTNAME) + ":" + this.config.getProperty(LOCAL_PORT));
        this.via.setBranchId(SIPUtils.generateBranchId(sIPMessageImpl));
        sIPMessageImpl.prependHeader((HeaderKeys)SIPMessage.HDR_VIA, this.via.marshallViaHeader());
        if (sIPMessageImpl.getNumberOfHeaderInstances(SIPMessage.HDR_VIA) == 1) {
            sIPMessageImpl.moveHeader(SIPMessage.HDR_VIA, 0);
        }
        return sIPMessageImpl;
    }

    public int getCallid() {
        return this.callid;
    }

    public void setCallid(int n) {
        this.callid = n;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String string) {
        this.contact = string;
    }

    public int getCseq() {
        return this.cseq;
    }

    public void setCseq(int n) {
        this.cseq = n;
    }

    public String getFromTag() {
        return this.fromTag;
    }

    public void setFromTag(String string) {
        this.fromTag = string;
    }

    public String getFromUri() {
        return this.fromUri;
    }

    public void setFromUri(String string) {
        this.fromUri = string;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String string) {
        this.requestURI = string;
    }

    public String getToTag() {
        return this.toTag;
    }

    public void setToTag(String string) {
        this.toTag = string;
    }

    public String getToUri() {
        return this.toUri;
    }

    public void setToUri(String string) {
        this.toUri = string;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String string) {
        this.transport = string;
    }

    public void setVia(ViaHeader viaHeader) {
        this.via = viaHeader;
    }
}

