/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.protocol.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sip.channel.protocol.impl.SIPMessageImpl;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channelutils.BNFHeaderKeys;
import com.ibm.wsspi.sip.channelutils.impl.BNFHeaderMatcherImpl;

public class SIPMessageFactoryImpl {
    private static TraceComponent tc = Tr.register(SIPMessageFactoryImpl.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private static SIPMessageFactoryImpl ofInstance = null;
    private static final int SIP_OBJ_SIZE = 100;
    private static final ObjectPool sipObjectPool = new ObjectPool("SIPMessageImpl", 100);
    BNFHeaderKeys msg = SIPMessage.HDR_ACCEPT;
    private static BNFHeaderMatcherImpl headerMatcher = BNFHeaderMatcherImpl.getRef();

    public static synchronized SIPMessageFactoryImpl getRef() {
        if (null == ofInstance) {
            ofInstance = new SIPMessageFactoryImpl();
        }
        return ofInstance;
    }

    public synchronized SIPMessage getObject() {
        SIPMessageImpl sIPMessageImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPMessageFactory:getObject: entry: id=" + this.hashCode());
        }
        if ((sIPMessageImpl = (SIPMessageImpl)sipObjectPool.remove()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SIPMessageFactory:allocating object");
            }
            sIPMessageImpl = new SIPMessageImpl(headerMatcher, 52, this);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SIPMessageFactory:object removed from object pool");
        }
        sIPMessageImpl.resetReleaseCalled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPMessageFactory:getObject: exit: id=" + this.hashCode());
        }
        return sIPMessageImpl;
    }

    public synchronized void releaseObject(SIPMessage sIPMessage) {
        this.release(sIPMessage);
    }

    protected synchronized void release(SIPMessage sIPMessage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SIPMessageFactory: releaseObject: entry: id=" + this.hashCode());
        }
        sIPMessage.clear();
        sipObjectPool.add(sIPMessage);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SIPMessageFactory:releaseObject added object to object pool");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SIPMessageFactory: releaseObject: exit: id=" + this.hashCode());
        }
    }
}

