/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.protocol.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.genericbnf.impl.GenericMessageImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.QuickHeaderMatcher;
import com.ibm.ws.sip.channel.protocol.impl.SIPMessageFactoryImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.sip.channel.SIPMessage;
import com.ibm.wsspi.sip.channel.SIPMessageFactory;
import com.ibm.wsspi.sip.channelutils.BNFHeaderKeys;
import com.ibm.wsspi.sip.channelutils.MethodMatcher;
import com.ibm.wsspi.sip.channelutils.MethodValue;
import com.ibm.wsspi.sip.channelutils.SchemeMatcher;
import com.ibm.wsspi.sip.channelutils.SchemeValues;
import com.ibm.wsspi.sip.channelutils.VersionMatcher;
import com.ibm.wsspi.sip.channelutils.VersionValues;
import com.ibm.wsspi.sip.channelutils.impl.MethodMatcherImpl;
import com.ibm.wsspi.sip.channelutils.impl.SchemeMatcherImpl;
import com.ibm.wsspi.sip.channelutils.impl.VersionMatcherImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Vector;

public class SIPMessageImpl
extends GenericMessageImpl
implements SIPMessage {
    private static TraceComponent tc = Tr.register(SIPMessageImpl.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private StringBuffer startLine = null;
    private byte[] firstToken = null;
    private String firstTokenString = null;
    private byte[] secondToken = null;
    private String secondTokenString = null;
    private byte[] thirdToken = null;
    private String thirdTokenString = "SIP/2.0";
    private Object opaqueData = null;
    private String protocolName = "SIP";
    protected MethodValue requestMethod = null;
    protected SchemeValues scheme = null;
    protected String query = null;
    protected VersionValues version = null;
    protected int statusCode = 0;
    protected String reason = null;
    protected MethodMatcher methodMatcher = MethodMatcherImpl.getRef();
    protected SchemeMatcher schemeMatcher = SchemeMatcherImpl.getRef();
    protected VersionMatcher versionMatcher = VersionMatcherImpl.getRef();
    protected boolean isRequest = false;
    protected QuickHeaderMatcher headerMatcher = null;
    protected WsByteBuffer[] marshalledObj = null;
    protected SIPMessageFactoryImpl factory = null;
    private WsByteBufferPoolManager bufferPool = WsByteBufferPoolManagerImpl.getRef();
    private WsByteBuffer bodyBuffer = null;
    private boolean firstTimeAttempted = true;
    private boolean previousHeaderIncomplete = false;
    private boolean isBodyComplete = false;
    private boolean firstValidCharacterReceived = false;
    private InetSocketAddress localAddress = null;
    private InetSocketAddress remoteAddress = null;
    protected boolean booleanReleaseCalled = false;

    public SIPMessageImpl(QuickHeaderMatcher quickHeaderMatcher, int n, SIPMessageFactoryImpl sIPMessageFactoryImpl) {
        super(quickHeaderMatcher, n);
        this.factory = sIPMessageFactoryImpl;
        this.headerMatcher = quickHeaderMatcher;
        this.startLine = new StringBuffer();
        BNFHeaderKeys bNFHeaderKeys = SIPMessage.HDR_ACCEPT;
    }

    public byte[] getFirstToken() {
        return this.getMarshalledFirstToken();
    }

    public String getFirstTokenAsString() {
        return this.firstTokenString;
    }

    public byte[] getSecondToken() {
        return this.getMarshalledSecondToken();
    }

    public String getSecondTokenAsString() {
        return this.secondTokenString;
    }

    public byte[] getThirdToken() {
        return this.getMarshalledThirdToken();
    }

    public String getThirdTokenAsString() {
        return this.thirdTokenString;
    }

    protected void setParsedFirstToken(byte[] byArray) {
        this.firstToken = byArray;
        this.firstTokenString = this.createString(byArray);
        this.startLine = new StringBuffer(this.firstTokenString + " ");
    }

    protected void setParsedSecondToken(byte[] byArray) {
        this.secondToken = byArray;
        this.secondTokenString = this.createString(byArray);
        this.startLine.append(this.secondTokenString + " ");
    }

    protected void setParsedThirdToken(byte[] byArray) {
        this.thirdToken = byArray;
        this.thirdTokenString = this.createString(byArray);
        this.startLine.append(this.thirdTokenString);
    }

    public void resetReleaseCalled() {
        this.booleanReleaseCalled = false;
    }

    public void dumpMessage() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.firstTokenString + " " + this.secondTokenString + " " + this.thirdTokenString);
        }
    }

    public boolean parseMessage(WsByteBuffer wsByteBuffer) throws Exception {
        int n;
        boolean bl = true;
        this.previousHeaderIncomplete = false;
        while (!this.firstValidCharacterReceived && wsByteBuffer.remaining() != 0) {
            n = wsByteBuffer.position();
            byte by = wsByteBuffer.get();
            if (by == 10 || by == 13) continue;
            this.firstValidCharacterReceived = true;
            wsByteBuffer.position(n);
        }
        if (wsByteBuffer.remaining() == 0) {
            return false;
        }
        bl = super.parseMessage(wsByteBuffer, true);
        if (bl) {
            block10: {
                n = 0;
                try {
                    n = new Integer(this.getHeaderAsString(HDR_CONTENT_LENGTH));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Caught number format exception with Content-Length = [" + this.getHeaderAsString(HDR_CONTENT_LENGTH) + "]");
                }
            }
            if (n < 0) {
                throw new IOException("Invalid Content length");
            }
            this.isBodyComplete = n > 0 ? this.storeBodyBuffer(wsByteBuffer, n) : true;
            if (!this.isBodyComplete) {
                bl = false;
            }
        } else {
            this.previousHeaderIncomplete = true;
        }
        return bl;
    }

    public WsByteBuffer[] marshallMessage() throws MessageSentException {
        WsByteBuffer[] wsByteBufferArray = super.marshallMessage();
        try {
            WsByteBuffer wsByteBuffer = this.getBodyBuffer();
            if (wsByteBuffer != null && wsByteBuffer.remaining() != 0) {
                wsByteBufferArray = WsByteBufferUtils.expandBufferArray((WsByteBuffer[])wsByteBufferArray, (WsByteBuffer)wsByteBuffer);
                wsByteBuffer.rewind();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return wsByteBufferArray;
    }

    public void lookForDuplicateHeaderValues(BNFHeaderKeys bNFHeaderKeys) {
        byte[] byArray;
        int n;
        Vector vector = new Vector();
        int n2 = this.getNumberOfHeaderInstances(bNFHeaderKeys);
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            byArray = this.getHeaderAsByteArray(bNFHeaderKeys, n);
            Vector vector2 = SIPMessageImpl.byteArrayTokenize(byArray, (byte)44);
            if (vector2.size() > 1) {
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found multiple Via header values");
                    Enumeration enumeration = vector2.elements();
                    int n3 = 0;
                    while (enumeration.hasMoreElements()) {
                        byte[] byArray2 = (byte[])enumeration.nextElement();
                        Tr.debug(tc, "Via [" + n3 + "] = [" + GenericUtils.getEnglishString(byArray2) + "]");
                        ++n3;
                    }
                }
            }
            vector.addAll(vector2);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found multiple Via header values removing and re-adding now.");
            }
            this.removeHeader(bNFHeaderKeys);
            for (n = 0; n < vector.size(); ++n) {
                byArray = (byte[])vector.get(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding Via header [" + n + "] value [" + GenericUtils.getEnglishString(byArray) + "]");
                }
                this.appendHeader((HeaderKeys)bNFHeaderKeys, byArray);
            }
        }
    }

    protected void parsingComplete() throws MalformedMessageException {
        if (this.firstTokenString.startsWith(this.protocolName)) {
            this.isRequest = false;
            this.version = this.versionMatcher.matchVersion(this.firstToken);
            if (this.version == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find version in response.");
                }
                throw new MalformedMessageException("Unable to find version in response.");
            }
            try {
                this.statusCode = Integer.parseInt(this.secondTokenString);
            }
            catch (NumberFormatException numberFormatException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught NumberFormatException while processing string: " + this.secondTokenString);
                }
                throw new MalformedMessageException("Bad status code for response: " + this.secondTokenString);
            }
        } else {
            if (!this.thirdTokenString.startsWith(this.protocolName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find version in request.");
                }
                throw new MalformedMessageException("Unable to find version in request.");
            }
            this.isRequest = true;
            this.requestMethod = this.methodMatcher.matchMethod(this.firstToken);
        }
    }

    public byte[] getMarshalledFirstToken() {
        if (this.firstToken == null && this.isRequest) {
            this.firstToken = this.requestMethod.getByteArray();
        }
        return this.firstToken;
    }

    public byte[] getMarshalledSecondToken() {
        if (this.secondToken == null) {
            try {
                this.secondToken = this.secondTokenString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.secondToken = new String("").getBytes();
            }
        }
        return this.secondToken;
    }

    public byte[] getMarshalledThirdToken() {
        try {
            if (this.thirdToken == null) {
                this.thirdToken = this.thirdTokenString.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.thirdToken = new String("").getBytes();
        }
        return this.thirdToken;
    }

    protected void preMarshallMessage() {
    }

    public void preMarshallHeaders() {
    }

    public void postMarshallHeaders() {
    }

    protected void postMarshallMessage() {
    }

    public WsByteBuffer getBodyBuffer() throws IOException {
        if (this.bodyBuffer != null && this.bodyBuffer.position() != 0) {
            throw new IOException("Body incomplete");
        }
        return this.bodyBuffer;
    }

    protected boolean storeBodyBuffer(WsByteBuffer wsByteBuffer, int n) {
        if (null != wsByteBuffer) {
            if (this.bodyBuffer == null) {
                this.bodyBuffer = this.bufferPool.allocate(n);
            }
            int n2 = wsByteBuffer.limit();
            int n3 = n - this.bodyBuffer.position();
            if (wsByteBuffer.limit() - wsByteBuffer.position() > n3) {
                wsByteBuffer.limit(wsByteBuffer.position() + n3);
            }
            this.bodyBuffer.put(wsByteBuffer);
            wsByteBuffer.limit(n2);
            if (this.bodyBuffer.position() == n) {
                this.bodyBuffer.flip();
                this.isBodyComplete = true;
                if (wsByteBuffer.position() + 2 <= wsByteBuffer.limit()) {
                    int n4 = wsByteBuffer.position();
                    byte by = wsByteBuffer.get();
                    byte by2 = wsByteBuffer.get();
                    if (by != 10 && by != 13 || by2 != 10 || by2 != 13) {
                        wsByteBuffer.position(n4);
                    }
                }
            } else {
                this.isBodyComplete = false;
            }
        }
        return this.isBodyComplete;
    }

    public WsByteBuffer[] getMarshalledHeaders() throws MessageSentException {
        return null;
    }

    public void destroy() {
        this.clearAllButHeaders();
    }

    private void clearAllButHeaders() {
        if (this.bodyBuffer != null) {
            this.bodyBuffer.release();
            this.bodyBuffer = null;
        }
        this.isRequest = false;
        this.isBodyComplete = false;
        this.firstTimeAttempted = true;
        this.firstValidCharacterReceived = false;
        this.statusCode = 0;
        this.localAddress = null;
        this.remoteAddress = null;
        this.startLine = null;
        this.firstToken = null;
        this.firstTokenString = null;
        this.secondToken = null;
        this.secondTokenString = null;
        this.thirdToken = null;
        this.thirdTokenString = "SIP/2.0";
    }

    public void clear() {
        this.clearAllButHeaders();
        super.clear();
    }

    public boolean isRequest() {
        return this.isRequest;
    }

    public void setRequest(boolean bl) {
        this.isRequest = bl;
    }

    public MethodValue getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(MethodValue methodValue) {
        this.requestMethod = methodValue;
    }

    public int getResponseStatusCode() {
        return this.statusCode;
    }

    protected void headerComplianceCheck() throws MessageSentException {
    }

    public void setFirstToken(byte[] byArray) {
        this.firstToken = byArray;
        this.firstTokenString = this.createString(byArray);
        this.startLine = null;
    }

    public void setSecondToken(byte[] byArray) {
        this.secondToken = byArray;
        this.secondTokenString = this.createString(byArray);
        this.startLine = null;
    }

    public void setThirdToken(byte[] byArray) {
        this.thirdToken = byArray;
        this.thirdTokenString = this.createString(byArray);
        this.startLine = null;
    }

    public String retrieveHeaderInUTF8Format(BNFHeaderKeys bNFHeaderKeys, int n) {
        String string;
        block3: {
            string = null;
            byte[] byArray = this.getHeaderAsByteArray(bNFHeaderKeys, n);
            try {
                if (byArray != null) {
                    string = new String(byArray, "UTF8");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "exception retrieving header  " + exception.getMessage());
            }
        }
        return string;
    }

    public void printMessage() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getStringRepresentation());
            Tr.debug(tc, "");
        }
    }

    public synchronized String getStringRepresentation() {
        String string;
        block3: {
            string = null;
            StringBuffer stringBuffer = new StringBuffer();
            WsByteBuffer[] wsByteBufferArray = null;
            try {
                wsByteBufferArray = this.marshallMessage();
                for (int i = 0; i < wsByteBufferArray.length; ++i) {
                    byte[] byArray = new byte[wsByteBufferArray[i].limit()];
                    wsByteBufferArray[i].getWrappedByteBuffer().get(byArray, 0, byArray.length);
                    stringBuffer.append(this.createString(byArray));
                    wsByteBufferArray[i].flip();
                }
                string = stringBuffer.toString();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "exception printing message" + exception.getMessage());
            }
        }
        return string;
    }

    public String createString(byte[] byArray) {
        String string;
        block2: {
            string = null;
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Unable to create string, exception = " + exception.toString());
            }
        }
        return string;
    }

    public SIPMessage getDuplicate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDuplicate");
        }
        SIPMessageImpl sIPMessageImpl = (SIPMessageImpl)SIPMessageFactory.getSIPMessage();
        super.duplicate(sIPMessageImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDuplicate");
        }
        return sIPMessageImpl;
    }

    public String getHeaderValue(BNFHeaderKeys bNFHeaderKeys) {
        return this.getHeaderAsString(bNFHeaderKeys);
    }

    public String getHeaderValue(String string) {
        return this.getHeaderAsString(string);
    }

    public void setHeaderValue(String string, String string2) {
        this.setHeader(string, string2);
    }

    public void setHeaderValue(BNFHeaderKeys bNFHeaderKeys, String string) {
        this.setHeader((HeaderKeys)bNFHeaderKeys, string);
    }

    public String getFrom() {
        return this.getHeaderAsString(HDR_FROM);
    }

    public String getTo() {
        return this.getHeaderAsString(HDR_TO);
    }

    public String getMethod() {
        String string = null;
        string = this.requestMethod != null ? this.requestMethod.getName() : this.getFirstTokenAsString();
        return string;
    }

    public String getRequestUri() {
        return this.secondTokenString;
    }

    public int getResultCode() {
        return this.statusCode;
    }

    public void setBodyBuffer(WsByteBuffer wsByteBuffer) {
        if (this.bodyBuffer != null) {
            this.bodyBuffer.release();
        }
        this.bodyBuffer = wsByteBuffer;
    }

    public void setFrom(String string) {
        this.setHeaderValue(HDR_FROM, string);
    }

    public void setMethod(String string) {
        this.firstTokenString = string;
    }

    public void setRequestUri(String string) {
        this.isRequest = true;
        this.secondTokenString = string;
    }

    public void setResultCode(int n) {
        this.statusCode = n;
    }

    public void setTo(String string) {
        this.setHeaderValue(HDR_TO, string);
    }

    public Object getOpaqueData() {
        return this.opaqueData;
    }

    public void setOpaqueData(Object object) {
        this.opaqueData = object;
    }

    public byte[] getStartLine() {
        byte[] byArray = null;
        if (this.startLine != null) {
            try {
                byArray = this.startLine.toString().getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = null;
            }
        } else {
            try {
                this.startLine = new StringBuffer(this.firstTokenString + " " + this.secondTokenString + " " + this.thirdTokenString);
                byArray = this.startLine.toString().getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = null;
            }
        }
        return byArray;
    }

    public void setStartLine(byte[] byArray) {
        this.startLine = new StringBuffer();
        this.startLine.append(new String(byArray));
        String[] stringArray = this.startLine.toString().split(" ");
        this.firstTokenString = stringArray[0];
        this.secondTokenString = stringArray[1];
        this.thirdTokenString = stringArray[2];
        try {
            this.firstToken = stringArray[0].getBytes("UTF8");
            this.secondToken = stringArray[1].getBytes("UTF8");
            this.thirdToken = stringArray[2].getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.firstToken = null;
            this.secondToken = null;
            this.thirdToken = null;
        }
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setLocalAddress(InetSocketAddress inetSocketAddress) {
        this.localAddress = inetSocketAddress;
    }

    public void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        this.remoteAddress = inetSocketAddress;
    }

    public void convertToResponse(StatusCodes statusCodes) {
        this.isRequest = false;
        this.setFirstToken(SIP_VERSION_20.getByteArray());
        this.setSecondToken(Integer.toString(statusCodes.getIntCode()).getBytes());
        this.setThirdToken(statusCodes.getDefaultPhraseBytes());
        this.setHeader((HeaderKeys)SIPMessage.HDR_CONTENT_LENGTH, "0");
        this.removeHeader(SIPMessage.HDR_CONTENT_TYPE);
        if (this.bodyBuffer != null) {
            this.bodyBuffer.release();
            this.bodyBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Throwable throwable = null;
        StackTraceElement[] stackTraceElementArray = null;
        if (tc.isDebugEnabled() && (stackTraceElementArray = (throwable = new Throwable()).getStackTrace()).length >= 2) {
            Tr.debug(tc, "SIPMESSAGE RELEASED: Calling Element: " + stackTraceElementArray[1] + " Main ID: none");
        }
        if (this.factory != null) {
            SIPMessageFactoryImpl sIPMessageFactoryImpl = this.factory;
            synchronized (sIPMessageFactoryImpl) {
                if (this.booleanReleaseCalled) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Attempt to release SIPMessage that was already released");
                    }
                    if (tc.isDebugEnabled()) {
                        String string = new String();
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            string = string.concat(stackTraceElementArray[i].toString());
                        }
                        Tr.debug(tc, "Stack Trace of extra release:\n" + string);
                    }
                    return;
                }
                this.booleanReleaseCalled = true;
                this.factory.release(this);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "release, factory == null");
        }
    }

    public static Vector byteArrayTokenize(byte[] byArray, byte by) {
        Vector<byte[]> vector = new Vector<byte[]>();
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 0;
        if (null != byArray && 0 != byArray.length) {
            for (int i = 0; i < byArray.length; ++i) {
                if (by == byArray[i]) {
                    if (0 < n2) {
                        byArray2 = new byte[n2];
                        System.arraycopy(byArray, n, byArray2, 0, n2);
                        vector.add(byArray2);
                    }
                    n2 = 0;
                    n = i + 1;
                    continue;
                }
                ++n2;
            }
            if (0 < n2) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                vector.add(byArray2);
            }
        }
        return vector;
    }
}

