/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl;

import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.sip.channel.resolver.dns.impl.Dns;
import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.ResourceRecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.SOARecord;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsMessage {
    private Header _header;
    private Vector<Question> _questions;
    private Vector<ResourceRecord> _answers;
    private Vector<ResourceRecord> _authority;
    private Vector<ResourceRecord> _additional;
    private static int _idVal = 1;
    private static int NAME_ERROR = 3;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public DnsMessage(short s, String string) {
        this._header = new Header();
        if (_idVal == 65535) {
            _idVal = 1;
        }
        this._header.identification = DnsMessage._idVal++;
        this._header.numQuestions = (short)1;
        this._header.numAnswers = (short)0;
        this._header.numAuthority = (short)0;
        this._header.numAdditional = (short)0;
        this._header.flags = (short)256;
        this._header.bitSetFlags.set(7);
        Name name2 = new Name(string);
        Question question = new Question(s, name2);
        this._questions = new Vector(1);
        this._questions.add(question);
        this._answers = new Vector(0);
        this._additional = new Vector(0);
        this._authority = new Vector(0);
    }

    public int getId() {
        return this._header.identification;
    }

    public short getQclass() {
        return this._questions.firstElement().qclass;
    }

    public short getQtype() {
        return this._questions.firstElement().qtype;
    }

    public WsByteBuffer toBuffer() {
        Class clazz;
        Object object;
        WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(1024);
        wsByteBuffer.mark();
        wsByteBuffer.put((byte)(this._header.identification >>> 8 & 0xFF));
        wsByteBuffer.put((byte)(this._header.identification & 0xFF));
        this._header.bitSetToShort();
        wsByteBuffer.putShort(this._header.flags);
        wsByteBuffer.putShort(this._header.numQuestions);
        wsByteBuffer.putShort(this._header.numAnswers);
        wsByteBuffer.putShort(this._header.numAuthority);
        wsByteBuffer.putShort(this._header.numAdditional);
        Enumeration<Object> enumeration = this._questions.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ((Question)object).qname.toBuffer(wsByteBuffer);
            wsByteBuffer.putShort(((Question)object).qtype);
            wsByteBuffer.putShort(((Question)object).qclass);
        }
        enumeration = this._answers.elements();
        while (enumeration.hasMoreElements()) {
            object = (ResourceRecord)enumeration.nextElement();
            try {
                clazz = ((ResourceRecord)object).className();
                clazz.cast(object);
                ((ResourceRecord)object).toBuffer(wsByteBuffer);
            }
            catch (Exception exception) {}
        }
        enumeration = this._authority.elements();
        while (enumeration.hasMoreElements()) {
            object = (SOARecord)enumeration.nextElement();
            ((SOARecord)object).toBuffer(wsByteBuffer);
        }
        enumeration = this._additional.elements();
        while (enumeration.hasMoreElements()) {
            object = (ResourceRecord)enumeration.nextElement();
            try {
                clazz = ((ResourceRecord)object).className();
                clazz.cast(object);
                ((ResourceRecord)object).toBuffer(wsByteBuffer);
            }
            catch (Exception exception) {}
        }
        wsByteBuffer.limit(wsByteBuffer.position());
        wsByteBuffer.reset();
        return wsByteBuffer;
    }

    public DnsMessage(DnsMessage dnsMessage) throws Exception {
        try {
            this._questions = new Vector(1);
            this._answers = new Vector(4);
            this._authority = new Vector(4);
            this._additional = new Vector(4);
            this._header = new Header();
            this._header.identification = dnsMessage._header.identification;
            this._header.bitSetFlags.set(0);
            this._header.bitSetFlags.set(5);
            this._header.bitSetFlags.set(14);
            this._header.bitSetFlags.set(15);
            Question question = new Question();
            question.qname = new Name(dnsMessage._questions.firstElement().qname.toString());
            question.qtype = dnsMessage._questions.firstElement().qtype;
            question.qclass = dnsMessage._questions.firstElement().qclass;
            this._questions.add(question);
            Header.access$108(this._header);
        }
        catch (Exception exception) {
            System.out.println("DnsMessage:  Exception = " + exception);
            throw exception;
        }
    }

    public DnsMessage(WsByteBuffer wsByteBuffer) throws Exception {
        int n;
        this._header = new Header();
        this._header.parse(wsByteBuffer);
        this._questions = new Vector(this._header.numQuestions);
        this._answers = new Vector(this._header.numAnswers);
        this._authority = new Vector(this._header.numAuthority);
        this._additional = new Vector(this._header.numAdditional);
        for (int i = 0; i < this._header.numQuestions; ++i) {
            Question question = new Question(wsByteBuffer);
            this._questions.add(question);
        }
        ResourceRecord resourceRecord = null;
        for (n = 0; n < this._header.numAnswers; ++n) {
            resourceRecord = ResourceRecord.createRecord(wsByteBuffer);
            this._answers.add(n, resourceRecord);
        }
        for (n = 0; n < this._header.numAuthority; ++n) {
            resourceRecord = ResourceRecord.createRecord(wsByteBuffer);
            this._authority.add(n, resourceRecord);
        }
        for (n = 0; n < this._header.numAdditional; ++n) {
            resourceRecord = ResourceRecord.createRecord(wsByteBuffer);
            this._additional.add(n, resourceRecord);
        }
    }

    public void addQuestion(ResourceRecord resourceRecord) {
        this._answers.add(resourceRecord);
        Header.access$108(this._header);
    }

    public void addAnswer(ResourceRecord resourceRecord) {
        this._answers.add(resourceRecord);
        Header.access$208(this._header);
    }

    public void addAuthority(ResourceRecord resourceRecord) {
        this._authority.add(resourceRecord);
        Header.access$308(this._header);
    }

    public void addAdditional(ResourceRecord resourceRecord) {
        this._additional.add(resourceRecord);
        Header.access$408(this._header);
    }

    public Name getQname() {
        return this._questions.firstElement().qname;
    }

    public short numAnswers() {
        return this._header.numAnswers;
    }

    public Vector<ResourceRecord> getAnswers() {
        return this._answers;
    }

    public Vector<ResourceRecord> getAdditional() {
        return this._additional;
    }

    protected void flagstoBitSetFlags() {
        for (int i = 0; i < 16; ++i) {
            if ((this._header.flags & 1 << 15 - i) == 0) continue;
            this._header.bitSetFlags.set(i);
        }
    }

    protected boolean getQR() {
        return this._header.bitSetFlags.get(0);
    }

    protected void setQR() {
        this._header.bitSetFlags.set(0);
    }

    protected boolean getAA() {
        return this._header.bitSetFlags.get(5);
    }

    protected void setAA() {
        this._header.bitSetFlags.set(5);
    }

    protected boolean getTC() {
        return this._header.bitSetFlags.get(6);
    }

    protected void setTC() {
        this._header.bitSetFlags.set(6);
    }

    protected boolean getRD() {
        return this._header.bitSetFlags.get(7);
    }

    protected void setRD() {
        this._header.bitSetFlags.set(7);
    }

    protected boolean getRA() {
        return this._header.bitSetFlags.get(8);
    }

    protected void setRA() {
        this._header.bitSetFlags.set(8);
    }

    protected int getRCODE() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this._header.bitSetFlags.get(i + 12)) continue;
            n |= 1 << 3 - i;
        }
        return n;
    }

    public void setRCODE(byte by) {
        for (int i = 0; i < 4; ++i) {
            if ((by & 1 << 3 - i) > 0) {
                this._header.bitSetFlags.set(i + 12);
                continue;
            }
            this._header.bitSetFlags.clear(i + 12);
        }
    }

    public String toString() {
        Class clazz;
        ResourceRecord resourceRecord;
        String string = new String();
        string = this._header.toString();
        string = string + this._questions.firstElement().toString();
        Enumeration<ResourceRecord> enumeration = null;
        enumeration = this._answers.elements();
        while (enumeration.hasMoreElements()) {
            string = string + " Answer\n";
            resourceRecord = enumeration.nextElement();
            try {
                clazz = resourceRecord.className();
                clazz.cast(resourceRecord);
                string = string + resourceRecord.toString();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("DnsMessage::toString ClassNotFoundException" + classNotFoundException.toString());
            }
        }
        enumeration = this._authority.elements();
        while (enumeration.hasMoreElements()) {
            string = string + " Authority\n";
            resourceRecord = enumeration.nextElement();
            try {
                clazz = resourceRecord.className();
                clazz.cast(resourceRecord);
                string = string + resourceRecord.toString();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("DnsMessage::toString ClassNotFoundException" + classNotFoundException.toString());
            }
        }
        enumeration = this._additional.elements();
        while (enumeration.hasMoreElements()) {
            string = string + " Additional\n";
            resourceRecord = enumeration.nextElement();
            try {
                clazz = resourceRecord.className();
                clazz.cast(resourceRecord);
                string = string + resourceRecord.toString();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("DnsMessage::toString ClassNotFoundException" + classNotFoundException.toString());
            }
        }
        return string;
    }

    public String toHexString() {
        WsByteBuffer wsByteBuffer = this.toBuffer();
        String string = new String();
        for (int i = 0; i < 512; ++i) {
            byte by = wsByteBuffer.get();
            char c = HEX[(by & 0xF0) >> 4];
            string = string + c;
            char c2 = HEX[by & 0xF];
            string = string + c2;
        }
        return string;
    }

    public boolean isRCODEError() {
        boolean bl = false;
        int n = this._header.getRCODE();
        if (n == NAME_ERROR) {
            bl = true;
        }
        return bl;
    }

    class Question {
        private Name qname;
        private short qtype;
        private short qclass;

        protected Question(short s, Name name2) {
            this.qname = name2;
            this.qtype = s;
            this.qclass = 1;
        }

        protected Question() {
            this.qname = null;
            this.qtype = 0;
            this.qclass = 1;
        }

        protected Question(WsByteBuffer wsByteBuffer) {
            this.qname = new Name(wsByteBuffer);
            this.qtype = wsByteBuffer.getShort();
            this.qclass = wsByteBuffer.getShort();
        }

        public String toString() {
            String string = new String();
            string = " Question\n  qname: " + this.qname.toString() + "\n" + "  qtype: " + new Short(this.qtype).toString() + "(" + Dns.TYPESTRING[this.qtype].toString() + ")" + "\n" + "  qclass:" + new Short(this.qclass).toString() + "\n";
            return string;
        }
    }

    class Header {
        private int identification;
        private short flags;
        private short numQuestions;
        private short numAnswers;
        private short numAuthority;
        private short numAdditional;
        private BitSet bitSetFlags = new BitSet(16);

        protected Header() {
        }

        protected void parse(WsByteBuffer wsByteBuffer) {
            this.identification = wsByteBuffer.getShort() & 0xFFFF;
            this.flags = wsByteBuffer.getShort();
            this.numQuestions = wsByteBuffer.getShort();
            this.numAnswers = wsByteBuffer.getShort();
            this.numAuthority = wsByteBuffer.getShort();
            this.numAdditional = wsByteBuffer.getShort();
            for (int i = 0; i < 16; ++i) {
                if ((this.flags & 1 << 15 - i) == 0) continue;
                this.bitSetFlags.set(i);
            }
        }

        protected void bitSetToShort() {
            for (int i = 0; i < 16; ++i) {
                if (!this.bitSetFlags.get(i)) continue;
                this.flags = (short)(this.flags | 1 << 15 - i);
            }
        }

        protected int getRCODE() {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                if (!this.bitSetFlags.get(i + 12)) continue;
                n |= 1 << 3 - i;
            }
            return n;
        }

        public String toString() {
            String string = new String();
            string = "Dns Message: " + Dns.TYPESTRING[((Question)DnsMessage.this._questions.firstElement()).qtype].toString() + " ";
            string = this.bitSetFlags.get(0) ? string + "Response\n" : string + "Query\n";
            string = string + " Header\n  identification: " + new Integer(this.identification).toString() + "\n" + "  Flags \n" + "    QR: " + this.bitSetFlags.get(0) + "\n";
            short s = 0;
            if (this.bitSetFlags.get(1)) {
                s = (short)(s | 0x1000);
            }
            if (this.bitSetFlags.get(2)) {
                s = (short)(s | 0x100);
            }
            if (this.bitSetFlags.get(3)) {
                s = (short)(s | 0x10);
            }
            if (this.bitSetFlags.get(4)) {
                s = (short)(s | 1);
            }
            string = string + "    opcode: " + new Short(s).toString() + "\n" + "    AA: " + this.bitSetFlags.get(5) + "\n" + "    TC: " + this.bitSetFlags.get(6) + "\n" + "    RD: " + this.bitSetFlags.get(7) + "\n" + "    RA: " + this.bitSetFlags.get(8) + "\n";
            s = 0;
            if (this.bitSetFlags.get(9)) {
                s = (short)(s | 0x100);
            }
            if (this.bitSetFlags.get(10)) {
                s = (short)(s | 0x10);
            }
            if (this.bitSetFlags.get(11)) {
                s = (short)(s | 1);
            }
            string = string + "    zero: " + new Short(s).toString() + "\n";
            string = string + "    rcode: " + new Integer(this.getRCODE()).toString() + "\n";
            string = string + "  num Questions : " + new Short(this.numQuestions).toString() + "\n" + "  num Answers   : " + new Short(this.numAnswers).toString() + "\n" + "  num Authority : " + new Short(this.numAuthority).toString() + "\n" + "  num Additional: " + new Short(this.numAdditional).toString() + "\n";
            return string;
        }

        static /* synthetic */ short access$108(Header header2) {
            short s = header2.numQuestions;
            header2.numQuestions = (short)(s + 1);
            return s;
        }

        static /* synthetic */ short access$208(Header header2) {
            short s = header2.numAnswers;
            header2.numAnswers = (short)(s + 1);
            return s;
        }

        static /* synthetic */ short access$308(Header header2) {
            short s = header2.numAuthority;
            header2.numAuthority = (short)(s + 1);
            return s;
        }

        static /* synthetic */ short access$408(Header header2) {
            short s = header2.numAdditional;
            header2.numAdditional = (short)(s + 1);
            return s;
        }
    }
}

