/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl;

import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.ResourceRecord;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public class NAPTRRecord
extends ResourceRecord {
    private short _order;
    private short _preference;
    private String _flags;
    private String _service;
    private String _regexp;
    private Name _replacement;

    protected NAPTRRecord() {
        this._order = 0;
        this._preference = 0;
        this._flags = new String();
        this._service = new String();
        this._regexp = new String();
        this._replacement = null;
    }

    protected NAPTRRecord(WsByteBuffer wsByteBuffer) {
        super(wsByteBuffer);
        this._order = wsByteBuffer.getShort();
        this._preference = wsByteBuffer.getShort();
        byte by = wsByteBuffer.get();
        byte[] byArray = new byte[by];
        wsByteBuffer.get(byArray);
        this._flags = new String(byArray);
        by = wsByteBuffer.get();
        byArray = new byte[by];
        wsByteBuffer.get(byArray);
        this._service = new String(byArray);
        by = wsByteBuffer.get();
        byArray = new byte[by];
        wsByteBuffer.get(byArray);
        this._regexp = new String(byArray);
        this._replacement = new Name(wsByteBuffer);
    }

    protected void toBuffer(WsByteBuffer wsByteBuffer) {
        super.toBuffer(wsByteBuffer);
        wsByteBuffer.putShort(this._order);
        wsByteBuffer.putShort(this._preference);
        wsByteBuffer.put((byte)this._flags.length());
        wsByteBuffer.putString(this._flags);
        wsByteBuffer.put((byte)this._service.length());
        wsByteBuffer.putString(this._service);
        wsByteBuffer.put((byte)this._regexp.length());
        wsByteBuffer.putString(this._regexp);
        this._replacement.toBuffer(wsByteBuffer);
    }

    public void setOrder(short s) {
        this._order = s;
    }

    public Short getOrder() {
        return this._order;
    }

    public void setPreference(short s) {
        this._preference = s;
    }

    public Short getPreference() {
        return this._preference;
    }

    public void setFlags(String string) {
        this._flags = string;
    }

    public void setService(String string) {
        this._service = string;
    }

    public String getService() {
        return this._service;
    }

    public void setRegexp(String string) {
        this._regexp = string;
    }

    public void setReplacement(Name name2) {
        this._replacement = name2;
    }

    public Name getReplacement() {
        return this._replacement;
    }

    public short calcrdLength() {
        int n = 0;
        n = 5 + this._flags.length() + 1 + this._service.length() + 1 + this._regexp.length() + this._replacement.length();
        return (short)n;
    }

    public String toString() {
        String string = new String();
        string = string + super.toString();
        string = string + "        order: " + new Short(this._order).toString() + "\n" + "        preference: " + new Short(this._preference).toString() + "\n" + "        flags: " + this._flags.toString() + "\n" + "        service: " + this._service.toString() + "\n" + "        regexp: " + this._regexp.toString() + "\n" + "        replacement: " + this._replacement.toString() + "\n";
        return string;
    }
}

