/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl;

import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public class Name {
    private String _name;
    private String[] _nameArray;
    private static int MAX_NUMBER_LABELS = 255;

    public Name(String string) {
        this._name = string;
    }

    protected Name(WsByteBuffer wsByteBuffer) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(1024);
        this._nameArray = new String[MAX_NUMBER_LABELS];
        this.readLabel(wsByteBuffer, n);
        int n2 = 0;
        while (this._nameArray[n2] != null) {
            String string = this._nameArray[n2];
            stringBuffer.append(string + ".");
            ++n2;
        }
        this._name = stringBuffer.toString();
    }

    private void readLabel(WsByteBuffer wsByteBuffer, int n) {
        byte by = 0;
        while ((by = wsByteBuffer.get()) != 0) {
            int n2 = wsByteBuffer.position();
            if (this.compressionCheck(wsByteBuffer, by)) {
                this.readLabel(wsByteBuffer, n);
                wsByteBuffer.position(n2 + 1);
                break;
            }
            byte[] byArray = new byte[by];
            wsByteBuffer.get(byArray);
            this._nameArray[n++] = new String(byArray);
        }
    }

    private boolean compressionCheck(WsByteBuffer wsByteBuffer, byte by) {
        int n = 0;
        if ((by & 0xFFFFFFC0) == -64) {
            byte by2 = wsByteBuffer.get();
            n |= (by & 0x3F) << 8;
            wsByteBuffer.position(n |= by2 & 0xFF);
            return true;
        }
        return false;
    }

    protected void toBuffer(WsByteBuffer wsByteBuffer) {
        String[] stringArray = this._name.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            wsByteBuffer.put((byte)stringArray[i].length());
            wsByteBuffer.putString(stringArray[i]);
        }
        wsByteBuffer.put((byte)0);
    }

    public String getString() {
        return this._name;
    }

    protected short length() {
        int n = 0;
        String[] stringArray = this._name.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            n += 1 + stringArray[i].length();
        }
        return (short)(++n);
    }

    public String toString() {
        return this._name.toString();
    }
}

