/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl;

import com.ibm.ws.sip.channel.resolver.dns.impl.Dns;
import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.lang.reflect.Constructor;

public class ResourceRecord {
    private Name _name;
    private short _type;
    private short _class;
    private int _ttl;
    private short _rdLength;
    private static final String ARECORD = "ARecord";
    private static final String NSRECORD = "NSRecord";
    private static final String CNAMERECORD = "CNAMERecord";
    private static final String SOARECORD = "SOARecord";
    private static final String PTRRECORD = "PTRRecord";
    private static final String AAAARECORD = "AAAARecord";
    private static final String SRVRECORD = "SRVRecord";
    private static final String NAPTRRECORD = "NAPTRRecord";

    protected ResourceRecord() {
        this._name = null;
        this._type = 0;
        this._class = 0;
        this._ttl = 0;
        this._rdLength = 0;
    }

    protected ResourceRecord(WsByteBuffer wsByteBuffer) {
        this._class = wsByteBuffer.getShort();
        this._ttl = wsByteBuffer.getInt();
        this._rdLength = wsByteBuffer.getShort();
    }

    public static ResourceRecord createRecord(Short s) {
        try {
            Class clazz = ResourceRecord.className(s);
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            ResourceRecord resourceRecord = (ResourceRecord)constructor.newInstance(new Object[0]);
            resourceRecord.setType(s);
            resourceRecord.setClassType((short)1);
            return resourceRecord;
        }
        catch (Exception exception) {
            System.out.println("ResourceRecord::createRecord Exception: " + exception.getMessage());
            return null;
        }
    }

    protected static ResourceRecord createRecord(WsByteBuffer wsByteBuffer) {
        Name name2 = new Name(wsByteBuffer);
        short s = wsByteBuffer.getShort();
        try {
            Class clazz = ResourceRecord.className(s);
            ResourceRecord resourceRecord = null;
            if (s != 33) {
                Constructor constructor = clazz.getDeclaredConstructor(WsByteBuffer.class);
                resourceRecord = (ResourceRecord)constructor.newInstance(wsByteBuffer);
            } else {
                Constructor constructor = clazz.getDeclaredConstructor(WsByteBuffer.class, Name.class);
                resourceRecord = (ResourceRecord)constructor.newInstance(wsByteBuffer, name2);
            }
            resourceRecord.setName(name2);
            resourceRecord.setType(s);
            return resourceRecord;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void toBuffer(WsByteBuffer wsByteBuffer) {
        this._name.toBuffer(wsByteBuffer);
        wsByteBuffer.putShort(this._type);
        wsByteBuffer.putShort(this._class);
        wsByteBuffer.putInt(this._ttl);
        wsByteBuffer.putShort(this._rdLength);
    }

    public Name getName() {
        return this._name;
    }

    public void setName(Name name2) {
        this._name = name2;
    }

    public short getType() {
        return this._type;
    }

    public void setType(short s) {
        this._type = s;
    }

    public short getClassType() {
        return this._class;
    }

    public void setClassType(short s) {
        this._class = s;
    }

    public int getTTL() {
        return this._ttl;
    }

    public void setTTL(int n) {
        this._ttl = n;
    }

    public short getrdLength() {
        return this._rdLength;
    }

    public void setrdLength(short s) {
        this._rdLength = s;
    }

    protected static String classNameAsString(Short s) {
        String string = null;
        switch (s) {
            case 1: {
                string = ARECORD;
                break;
            }
            case 2: {
                string = NSRECORD;
                break;
            }
            case 5: {
                string = CNAMERECORD;
                break;
            }
            case 6: {
                string = SOARECORD;
                break;
            }
            case 12: {
                string = PTRRECORD;
                break;
            }
            case 28: {
                string = AAAARECORD;
                break;
            }
            case 33: {
                string = SRVRECORD;
                break;
            }
            case 35: {
                string = NAPTRRECORD;
                break;
            }
        }
        return string;
    }

    protected String classNameAsString() {
        String string = null;
        switch (this._type) {
            case 1: {
                string = ARECORD;
                break;
            }
            case 2: {
                string = NSRECORD;
                break;
            }
            case 5: {
                string = CNAMERECORD;
                break;
            }
            case 6: {
                string = SOARECORD;
                break;
            }
            case 12: {
                string = PTRRECORD;
                break;
            }
            case 28: {
                string = AAAARECORD;
                break;
            }
            case 33: {
                string = SRVRECORD;
                break;
            }
            case 35: {
                string = NAPTRRECORD;
                break;
            }
        }
        return string;
    }

    public static Class className(Short s) throws ClassNotFoundException {
        String string = "com.ibm.ws.sip.channel.resolver.dns.impl.";
        Class<?> clazz = null;
        string = string + ResourceRecord.classNameAsString(s);
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("className exception" + classNotFoundException.getMessage());
        }
        return clazz;
    }

    protected Class className() throws ClassNotFoundException {
        String string = "com.ibm.ws.sip.channel.resolver.dns.impl.";
        string = string + this.classNameAsString();
        return Class.forName(string);
    }

    public String toString() {
        String string = new String();
        string = "    Resource Record: " + Dns.TYPESTRING[this._type] + "\n";
        string = string + "      domain name: " + this._name.toString() + "\n" + "      type:  " + new Short(this._type).toString() + "(" + Dns.TYPESTRING[this._type] + ")" + "\n" + "      class:  " + new Short(this._class).toString() + "\n" + "      ttl:  " + new Integer(this._ttl).toString() + "\n" + "      rdlength:  " + new Short(this._rdLength).toString() + "\n";
        return string;
    }
}

