/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl;

import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.ResourceRecord;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public class SOARecord
extends ResourceRecord {
    private Name _mname;
    private Name _rname;
    private int _serial;
    private int _refresh;
    private int _retry;
    private int _expire;
    private int _minTTL;

    protected SOARecord() {
        this._mname = null;
        this._rname = null;
        this._serial = 0;
        this._refresh = 0;
        this._retry = 0;
        this._expire = 0;
        this._minTTL = 0;
    }

    protected SOARecord(WsByteBuffer wsByteBuffer) {
        super(wsByteBuffer);
        this._mname = new Name(wsByteBuffer);
        this._rname = new Name(wsByteBuffer);
        this._serial = wsByteBuffer.getInt();
        this._refresh = wsByteBuffer.getInt();
        this._retry = wsByteBuffer.getInt();
        this._expire = wsByteBuffer.getInt();
        this._minTTL = wsByteBuffer.getInt();
    }

    protected void toBuffer(WsByteBuffer wsByteBuffer) {
        super.toBuffer(wsByteBuffer);
        this._mname.toBuffer(wsByteBuffer);
        this._rname.toBuffer(wsByteBuffer);
        wsByteBuffer.putInt(this._serial);
        wsByteBuffer.putInt(this._refresh);
        wsByteBuffer.putInt(this._retry);
        wsByteBuffer.putInt(this._expire);
        wsByteBuffer.putInt(this._minTTL);
    }

    public void setMname(Name name2) {
        this._mname = name2;
    }

    public void setRname(Name name2) {
        this._rname = name2;
    }

    public void setSerial(int n) {
        this._serial = n;
    }

    public void setRefresh(int n) {
        this._refresh = n;
    }

    public void setRetry(int n) {
        this._retry = n;
    }

    public void setExpire(int n) {
        this._expire = n;
    }

    public void setMinTTL(int n) {
        this._minTTL = n;
    }

    public short calcrdLength() {
        int n = 0;
        n = this._mname.length() + this._rname.length() + 4 + 4 + 4 + 4 + 4;
        return (short)n;
    }

    public Name getMname() {
        return this._mname;
    }

    public Name getRname() {
        return this._rname;
    }

    public String toString() {
        String string = new String();
        string = super.toString();
        string = string + "      mname: " + this._mname.toString() + "\n" + "      rname: " + this._rname.toString() + "\n" + "      serial: " + this._serial + "\n" + "      refresh: " + this._refresh + "\n" + "      retry: " + this._retry + "\n" + "      expire: " + this._expire + "\n" + "      minimum TTL: " + this._minTTL + "\n";
        return string;
    }
}

