/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl;

import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.ResourceRecord;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public class SRVRecord
extends ResourceRecord {
    private String _service;
    private String _protocol;
    private String _name;
    private short _priority;
    private short _weight;
    private short _port;
    private Name _target;

    protected SRVRecord() {
        this._service = null;
        this._protocol = null;
        this._name = null;
        this._priority = 0;
        this._weight = 0;
        this._port = 0;
        this._target = null;
    }

    protected SRVRecord(WsByteBuffer wsByteBuffer, Name name2) {
        super(wsByteBuffer);
        String[] stringArray = name2.getString().split("\\.");
        this._service = stringArray[0];
        this._protocol = stringArray[1];
        this._name = "";
        for (int i = 2; i < stringArray.length; ++i) {
            this._name = this._name + stringArray[i] + ".";
        }
        this._priority = wsByteBuffer.getShort();
        this._weight = wsByteBuffer.getShort();
        this._port = wsByteBuffer.getShort();
        this._target = new Name(wsByteBuffer);
    }

    public void setService(String string) {
        this._service = string;
    }

    public void setProtocol(String string) {
        this._protocol = string;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setPriority(short s) {
        this._priority = s;
    }

    public Short getPriority() {
        return this._priority;
    }

    public void setWeight(short s) {
        this._weight = s;
    }

    public Short getWeight() {
        return this._weight;
    }

    public void setPort(short s) {
        this._port = s;
    }

    public short getPort() {
        return this._port;
    }

    public String getService() {
        return this._service;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getSrvName() {
        return this._name;
    }

    public void setTarget(Name name2) {
        this._target = name2;
    }

    public Name getTarget() {
        return this._target;
    }

    protected void toBuffer(WsByteBuffer wsByteBuffer) {
        super.toBuffer(wsByteBuffer);
        wsByteBuffer.putShort(this._priority);
        wsByteBuffer.putShort(this._weight);
        wsByteBuffer.putShort(this._port);
        this._target.toBuffer(wsByteBuffer);
    }

    public short calcrdLength() {
        int n = 0;
        n = 6 + this._target.length();
        return (short)n;
    }

    public String toString() {
        String string = new String();
        string = super.toString();
        string = string + "      service: " + this._service.toString() + "\n" + "      protocol: " + this._protocol.toString() + "\n" + "      name: " + this._name.toString() + "\n" + "      priority: " + new Short(this._priority).toString() + "\n" + "      weight: " + new Short(this._weight).toString() + "\n" + "      port: " + new Short(this._port).toString() + "\n" + "      target: " + this._target.toString() + "\n";
        return string;
    }
}

