/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sip.channel.resolver.dns.impl.DnsMessage;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverEvent;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverListener;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverTcpTransport;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverTransportListener;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipResolver
implements SipResolverTransportListener {
    private static final TraceComponent tc = Tr.register(SipResolver.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    public static final int MAX_REQUEST_CACHE_SIZE = 5000;
    public static final int TRANSPORT_RETRY_INTERVAL = 5000;
    private static SipResolver _resolver;
    private static SipResolverTcpTransport _tcpTransport;
    private boolean _shutdown = false;
    private Timer _timer = null;
    private Hashtable<Integer, SipResolverListener> _requestPending = new Hashtable();

    public static synchronized SipResolver createResolver(Vector<InetSocketAddress> vector, Timer timer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolver: createResolver: entry");
        }
        if (_resolver == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SipResolver: createResolver: instantiate the SipResolver");
            }
            _resolver = new SipResolver(timer);
            _tcpTransport = new SipResolverTcpTransport(vector, _resolver);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolver: createResolver: exit");
        }
        return _resolver;
    }

    protected SipResolver(Timer timer) {
        this._timer = timer;
    }

    protected Hashtable getRequestPending() {
        return this._requestPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void shutdown() {
        if (!this._shutdown) {
            Hashtable<Integer, SipResolverListener> hashtable = this._requestPending;
            synchronized (hashtable) {
                this._requestPending.clear();
            }
            _tcpTransport.shutdown();
            _resolver = null;
            this._shutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SipResolverEvent resolve(DnsMessage dnsMessage, SipResolverListener sipResolverListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolver: resolve: entry id=" + this.hashCode());
        }
        SipResolverEvent sipResolverEvent = null;
        if (this._requestPending.size() > 5000) {
            IllegalStateException illegalStateException = new IllegalStateException("Request Cache overflowed. Shutdown SIP Resolver service.");
            this.transportFailed(illegalStateException);
            throw illegalStateException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolver: resolve: dns request = " + dnsMessage.toString());
        }
        try {
            Hashtable<Integer, SipResolverListener> hashtable = this._requestPending;
            synchronized (hashtable) {
                this._requestPending.put(new Integer(dnsMessage.getId()), sipResolverListener);
            }
            _tcpTransport.writeRequest(dnsMessage.toBuffer());
        }
        catch (IOException iOException) {
            Hashtable<Integer, SipResolverListener> hashtable = this._requestPending;
            synchronized (hashtable) {
                this._requestPending.remove(new Integer(dnsMessage.getId()));
            }
            this.transportError(iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolver: resolve: exit id=" + this.hashCode());
        }
        return sipResolverEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived(WsByteBuffer wsByteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolver: responseReceived: entry id=" + this.hashCode());
        }
        try {
            DnsMessage dnsMessage = new DnsMessage(wsByteBuffer);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SipResolver: responseReceived: dns response = " + dnsMessage.toString());
            }
            SipResolverListener sipResolverListener = null;
            Object object = this._requestPending;
            synchronized (object) {
                sipResolverListener = this._requestPending.remove(new Integer(dnsMessage.getId()));
            }
            if (sipResolverListener != null) {
                object = new SipResolverEvent();
                if (dnsMessage.isRCODEError()) {
                    ((SipResolverEvent)object).setType((short)2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SipResolver: responseReceived: RCODE ERROR");
                    }
                } else {
                    ((SipResolverEvent)object).setType((short)1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SipResolver: responseReceived: Successful Response");
                    }
                }
                ((SipResolverEvent)object).setResponse(dnsMessage);
                sipResolverListener.handleSipResolverEvent((SipResolverEvent)object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SipResolver: responseReceived: no matching dns request for response");
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "SipResolver: responseReceived: Error: " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolver: responseReceived: exit id=" + this.hashCode());
        }
    }

    @Override
    public void transportError(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolver: transportError: entry id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolver: transportError: Wait 5000 ms before try new transport.");
        }
        try {
            Enumeration<SipResolverListener> enumeration = this._requestPending.elements();
            while (enumeration.hasMoreElements()) {
                SipResolverListener sipResolverListener = enumeration.nextElement();
                SipResolverEvent sipResolverEvent = new SipResolverEvent();
                sipResolverEvent.setType((short)3);
                sipResolverEvent.setResponse(null);
                sipResolverListener.handleSipResolverEvent(sipResolverEvent);
            }
        }
        catch (Exception exception2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SipResolverTimerTask: run: Catastrophic failure");
            }
            this.transportFailed(exception2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolver: transportError: exit id=" + this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(DnsMessage dnsMessage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolver: cancelRequest: entry id=" + this.hashCode());
        }
        Hashtable<Integer, SipResolverListener> hashtable = this._requestPending;
        synchronized (hashtable) {
            this._requestPending.remove(new Integer(dnsMessage.getId()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolver: cancelRequest: exit id=" + this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportFailed(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolver: transportFailed: entry id=" + this.hashCode());
        }
        Object object = this._requestPending.elements();
        while (object.hasMoreElements()) {
            SipResolverListener sipResolverListener = object.nextElement();
            SipResolverEvent sipResolverEvent = new SipResolverEvent();
            sipResolverEvent.setType((short)4);
            sipResolverEvent.setResponse(null);
            sipResolverListener.handleSipResolverEvent(sipResolverEvent);
        }
        object = this._requestPending;
        synchronized (object) {
            this._requestPending.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolver: transportFailed: exit id=" + this.hashCode());
        }
    }
}

