/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sip.channel.resolver.impl.SipResolver;
import com.ibm.ws.sip.channel.resolver.impl.SipURILookupImpl;
import com.ibm.wsspi.sip.channel.protocol.SIPUri;
import com.ibm.wsspi.sip.channel.resolver.SipURILookup;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupCallback;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipResolverService {
    private static final TraceComponent tc = Tr.register(SipResolverService.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private static boolean initialized = false;
    private static SipResolver sipResolver = null;
    private static Timer resolverTimer = null;
    private static Hashtable<SIPUri, SipURILookupImpl> lookupCache = new Hashtable();
    private static final String SIP_RFC3263_PROPERTY = "SIP_RFC3263_nameserver";

    public static synchronized void initialize(Vector<InetSocketAddress> vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverService: initialize: entry");
        }
        if (!initialized) {
            initialized = true;
            if (vector == null || vector.size() == 0) {
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "CWSPC0017I");
                }
                initialized = false;
                return;
            }
            resolverTimer = new Timer();
            sipResolver = SipResolver.createResolver(vector, resolverTimer);
            if (tc.isInfoEnabled()) {
                InetSocketAddress inetSocketAddress;
                InetSocketAddress inetSocketAddress2 = vector.firstElement();
                Tr.info(tc, "CWSPC0016I", inetSocketAddress2.getAddress().getHostAddress() + "@" + inetSocketAddress2.getPort());
                if (vector.size() > 1 && (inetSocketAddress = vector.elementAt(1)) != null) {
                    Tr.info(tc, "CWSPC0016I", inetSocketAddress.getAddress().getHostAddress() + "@" + inetSocketAddress.getPort());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverService: initialize: exit");
        }
    }

    public static synchronized void initialize(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverService: initialize: entry");
        }
        if (!initialized) {
            initialized = true;
            String string = properties.getProperty(SIP_RFC3263_PROPERTY);
            if (string == null) {
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "CWSPC0017I");
                }
                initialized = false;
                return;
            }
            Vector<InetSocketAddress> vector = SipResolverService.serverStringtoVector(string);
            if (vector.isEmpty()) {
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "CWSPC0017I");
                }
                initialized = false;
                return;
            }
            sipResolver = SipResolver.createResolver(vector, resolverTimer);
            resolverTimer = new Timer();
            if (tc.isInfoEnabled()) {
                InetSocketAddress inetSocketAddress;
                InetSocketAddress inetSocketAddress2 = vector.firstElement();
                Tr.info(tc, "CWSPC0016I", inetSocketAddress2.getAddress().getHostAddress() + "@" + inetSocketAddress2.getPort());
                if (vector.size() > 1 && (inetSocketAddress = vector.elementAt(1)) != null) {
                    Tr.info(tc, "CWSPC0016I", inetSocketAddress.getAddress().getHostAddress() + "@" + inetSocketAddress.getPort());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverService: initialize: exit");
        }
    }

    private static Vector<InetSocketAddress> serverStringtoVector(String string) {
        Vector<InetSocketAddress> vector = new Vector<InetSocketAddress>();
        Pattern pattern = Pattern.compile("\\s+");
        String[] stringArray = pattern.split(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolverService: serverStringtoVector split.length" + stringArray.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2;
            block7: {
                String[] stringArray2 = stringArray[i].split("\\@");
                string2 = stringArray2[0];
                n = 53;
                if (stringArray2.length > 1) {
                    try {
                        n = Integer.parseInt(stringArray2[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!tc.isDebugEnabled()) break block7;
                        Tr.debug(tc, "SipResolverService: serverStringtoVector " + numberFormatException);
                    }
                }
            }
            try {
                if (string2 == null || string2 == "") continue;
                vector.add(new InetSocketAddress(InetAddress.getByName(string2), n));
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "SipResolverService: serverStringtoVector " + unknownHostException);
            }
        }
        return vector;
    }

    public static synchronized void shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverService: shutdown: entry");
        }
        if (initialized) {
            initialized = false;
            resolverTimer.cancel();
            sipResolver.shutdown();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverService: shutdown: exit");
        }
    }

    public static SipURILookup getInstance(SipURILookupCallback sipURILookupCallback, SIPUri sIPUri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverService: getInstance: entry");
        }
        if (initialized) {
            SipURILookup sipURILookup = lookupCache.get(sIPUri);
            if (sipURILookup == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SipResolverService: getInstance: new SipURILookupImpl for " + sIPUri.getBaseSIPUri());
                }
                sipURILookup = new SipURILookupImpl(sipURILookupCallback, sIPUri, resolverTimer, lookupCache);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SipResolverService: getInstance: cached SipURILookupImpl for: " + sipURILookup.getSipURI().getHost() + ":" + sipURILookup.getSipURI().getPort());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SipResolverService: getInstance: exit");
            }
            return sipURILookup;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolverService: getInstance: Illegal State: exit");
        }
        throw new IllegalStateException("SipResolverService not initialized.");
    }

    public static SipResolver getResolver() {
        if (sipResolver == null) {
            throw new IllegalStateException("Sip Resolver has not been created.");
        }
        return sipResolver;
    }
}

