/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverTransport;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverTransportListener;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ChannelFrameworkProvider;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContextFactory;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SipResolverTcpTransport
implements ConnectionReadyCallback,
TCPReadCompletedCallback,
TCPWriteCompletedCallback,
SipResolverTransport {
    private static final TraceComponent tc = Tr.register(SipResolverTcpTransport.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private static final int READ_TIMEOUT = 1500;
    private static final int WRITE_TIMEOUT = 5000;
    private static final int MAX_READ_TIMEOUT_COUNT = 5;
    private static final int MAX_WRITE_QUEUE_SIZE = 5000;
    private static final int WRITE_STATE_DISCONNECTED = 0;
    private static final int WRITE_STATE_CONNECTING = 1;
    private static final int WRITE_STATE_IDLE = 2;
    private static final int WRITE_STATE_WRITE_ACTIVE = 3;
    private static final int WRITE_STATE_SHUTDOWN = 4;
    private static final int READ_STATE_READING_LENGTH = 0;
    private static final int READ_STATE_READING_BODY = 1;
    private static final int READ_STATE_DISCONNECTED = 2;
    private static final int READ_STATE_SHUTDOWN = 3;
    private static final int MAX_FAILED_CONNECTONS = 1;
    private static String CHAINNAME = "SipResolver-tcp-outbound";
    private static ChannelFramework _framework;
    private static boolean _channelInitialized;
    private boolean _shutdown = false;
    private Vector<InetSocketAddress> _nameServers = null;
    private Iterator<InetSocketAddress> _nameServerIterator = null;
    private Queue<WsByteBuffer> _requestQueue = new LinkedList<WsByteBuffer>();
    private WsByteBuffer[] _bufferArray = new WsByteBuffer[2];
    private WsByteBuffer _lengthBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(2);
    private int _outstandingRequestCount = 0;
    private int _readTimeoutCount = 0;
    private int _connectionFailedCount = 1;
    private TCPWriteRequestContext _writer = null;
    private TCPReadRequestContext _reader = null;
    private SipResolverTransportListener _transportListener = null;
    private OutboundVirtualConnection _outboundVirtualContext;
    private int _writeState = 0;
    private int _readState = 2;
    private InetSocketAddress _currentSocketAddress = null;

    protected static synchronized void initialize() {
        if (!_channelInitialized) {
            block7: {
                try {
                    ChannelFramework channelFramework = ChannelFrameworkProvider.getChannelFramework();
                    channelFramework.addChannel(CHAINNAME, WSTCPChannelFactory.class, null, 10);
                    String[] stringArray = new String[]{CHAINNAME};
                    channelFramework.addChain(CHAINNAME, FlowType.OUTBOUND, stringArray);
                    _framework = (ChannelFrameworkImpl)channelFramework;
                }
                catch (ChannelException channelException) {
                    if (tc.isWarningEnabled()) {
                        Tr.warning(tc, "Resolver channel exception during init: " + channelException.getMessage());
                    }
                }
                catch (ChainException chainException) {
                    if (tc.isWarningEnabled()) {
                        Tr.warning(tc, "Resolver channel exception during init: " + chainException.getMessage());
                    }
                }
                catch (ChannelFrameworkException channelFrameworkException) {
                    if (!tc.isWarningEnabled()) break block7;
                    Tr.warning(tc, "Resolver channel exception during init: " + channelFrameworkException.getMessage());
                }
            }
            _channelInitialized = true;
        }
    }

    protected SipResolverTcpTransport(Vector<InetSocketAddress> vector, SipResolverTransportListener sipResolverTransportListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverTcpTransport: constructor: entry: id=" + this.hashCode());
        }
        SipResolverTcpTransport.initialize();
        this._nameServers = vector;
        this._nameServerIterator = this._nameServers.iterator();
        this._transportListener = sipResolverTransportListener;
        this.connect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: constructor: entry: id=" + this.hashCode());
        }
    }

    protected synchronized void shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverTcpTransport: shutdown: entry: id=" + this.hashCode());
        }
        this._shutdown = true;
        this._requestQueue.clear();
        this._writeState = 4;
        this._readState = 3;
        if (this._outboundVirtualContext != null) {
            this._outboundVirtualContext.close((Exception)new IOException("SIP Resolver is being shutdown"));
            this._outboundVirtualContext = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: shutdown: exit: id=" + this.hashCode());
        }
    }

    @Override
    public synchronized void writeRequest(WsByteBuffer wsByteBuffer) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverTcpTransport: writeRequest: entry: id=" + this.hashCode());
        }
        if (this._shutdown) {
            throw new IllegalStateException("SIP TCP Resolver transport is shutdown.");
        }
        switch (this._writeState) {
            case 4: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "SipResolverTcpTransport:writeRequest: WRITE_STATE_SHUTDOWN");
                break;
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SipResolverTcpTransport:writeRequest: WRITE_STATE_IDLE");
                }
                this._lengthBuffer.clear();
                this._lengthBuffer.limit(2);
                this._lengthBuffer.putShort((short)wsByteBuffer.limit());
                this._lengthBuffer.position(0);
                this._bufferArray[0] = this._lengthBuffer;
                this._bufferArray[1] = wsByteBuffer;
                this._writer.setBuffers(this._bufferArray);
                ++this._outstandingRequestCount;
                if (this._writer.write(-1L, (TCPWriteCompletedCallback)this, false, 5000) != null) break;
                this._writeState = 3;
                break;
            }
            case 3: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SipResolverTcpTransport:writeRequest: WRITE_STATE_WRITE_ACTIVE");
                }
                if (this._requestQueue.size() > 5000) {
                    throw new IOException("Maximum write queue size is being exceeded");
                }
                this._requestQueue.add(wsByteBuffer);
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SipResolverTcpTransport:writeRequest: WRITE_STATE_CONNECTING");
                }
                this._requestQueue.add(wsByteBuffer);
                break;
            }
            case 0: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SipResolverTcpTransport:writeRequest: WRITE_STATE_DISCONNECTED");
                }
                this._requestQueue.add(wsByteBuffer);
                this.connect();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: writeRequest: exit: id=" + this.hashCode());
        }
    }

    private synchronized void connect() {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SipResolverTcpTransport: connect: entry: id=" + this.hashCode());
            }
            if (this._outboundVirtualContext != null) {
                this._outboundVirtualContext.close((Exception)new IOException("Connection not responding properly"));
                this._outboundVirtualContext = null;
            }
            if (this._connectionFailedCount >= 1) {
                this._connectionFailedCount = 0;
                if (!this._nameServerIterator.hasNext()) {
                    this._nameServerIterator = this._nameServers.iterator();
                    this._currentSocketAddress = this._nameServerIterator.next();
                } else {
                    this._currentSocketAddress = this._nameServerIterator.next();
                }
            }
            try {
                this._writeState = 1;
                this._readState = 2;
                this._outstandingRequestCount = 0;
                this._readTimeoutCount = 0;
                VirtualConnectionFactory virtualConnectionFactory = _framework.getOutboundVCFactory(CHAINNAME);
                this._outboundVirtualContext = (OutboundVirtualConnection)virtualConnectionFactory.createConnection();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SipResolverTcpTransport:connect: SIP Resolver is connecting to: " + this._currentSocketAddress.getHostName() + ":" + this._currentSocketAddress.getPort());
                }
                TCPConnectRequestContext tCPConnectRequestContext = TCPConnectRequestContextFactory.getRef().createTCPConnectRequestContext(this._currentSocketAddress.getHostName(), this._currentSocketAddress.getPort(), 10);
                this._reader = ((TCPConnLink)this._outboundVirtualContext.getChannelAccessor()).getReadInterface();
                this._writer = ((TCPConnLink)this._outboundVirtualContext.getChannelAccessor()).getWriteInterface();
                this._outboundVirtualContext.connectAsynch((Object)tCPConnectRequestContext, (ConnectionReadyCallback)this);
            }
            catch (ChannelException channelException) {
                if (tc.isWarningEnabled()) {
                    Tr.warning(tc, "Resolver channel exception during connect: " + channelException.getMessage());
                }
            }
            catch (ChainException chainException) {
                if (!tc.isWarningEnabled()) break block11;
                Tr.warning(tc, "Resolver chain exception during connect: " + chainException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: connect: exit: id=" + this.hashCode());
        }
    }

    public void ready(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverTcpTransport: ready: entry: id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolverTcpTransport:ready: socket is ready");
        }
        if (tc.isInfoEnabled()) {
            Tr.info(tc, "CWSPC0015I", this._currentSocketAddress.toString());
        }
        this._connectionFailedCount = 0;
        this._readState = 0;
        this._reader.setJITAllocateSize(2);
        this._reader.setBuffer(null);
        this._reader.read(2L, (TCPReadCompletedCallback)this, true, 1500);
        this.drainRequestQueue();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: ready: exit: id=" + this.hashCode());
        }
    }

    public void destroy(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverTcpTransport: destroy: entry: id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolverTcpTransport: Connection failed to establish: " + exception + " id=" + this.hashCode());
        }
        if (tc.isWarningEnabled()) {
            Tr.warning(tc, "CWSPC0013W", this._currentSocketAddress.toString());
        }
        ++this._connectionFailedCount;
        this._writeState = 0;
        this._outboundVirtualContext = null;
        this._requestQueue.clear();
        if (this._connectionFailedCount >= 1) {
            this._transportListener.transportFailed(exception);
        } else {
            this._transportListener.transportError(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: destroy: exit: id=" + this.hashCode());
        }
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverTcpTransport: complete: entry: id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolverTcpTransport: complete: read completed succesfully: " + this.hashCode());
        }
        this._readTimeoutCount = 0;
        boolean bl = false;
        while (!bl) {
            switch (this._readState) {
                case 0: {
                    this._reader.getBuffer().flip();
                    short s = this._reader.getBuffer().getShort();
                    this._readState = 1;
                    this._reader.setJITAllocateSize((int)s);
                    this._reader.setBuffer(null);
                    if (this._reader.read((long)s, (TCPReadCompletedCallback)this, false, 1500) != null) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (this._outstandingRequestCount != 0) {
                        --this._outstandingRequestCount;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SipResolverTcpTransport: complete: error: outstandingRequestCount can't decrement past 0");
                    }
                    this._reader.getBuffer().flip();
                    this._transportListener.responseReceived(this._reader.getBuffer());
                    this._readState = 0;
                    this._reader.setJITAllocateSize(2);
                    this._reader.setBuffer(null);
                    if (this._reader.read(2L, (TCPReadCompletedCallback)this, false, 1500) != null) break;
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    bl = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: complete: exit: id=" + this.hashCode());
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (!this._shutdown) {
            if (iOException instanceof SocketTimeoutException || iOException instanceof AsyncTimeoutException) {
                if (this._outstandingRequestCount > 0 || this._readTimeoutCount > 5 || this._readState == 1) {
                    if (tc.isWarningEnabled() && this._outstandingRequestCount > 0) {
                        Tr.warning(tc, "CWSPC0014W", this._currentSocketAddress.toString());
                    }
                    IOException iOException2 = new IOException("Server stopped responding. Closing connection.");
                    this._outboundVirtualContext.close((Exception)iOException2);
                    this._outboundVirtualContext = null;
                    if (this._outstandingRequestCount > 0 || this._readState == 1) {
                        ++this._connectionFailedCount;
                    }
                    this._readState = 2;
                    this._writeState = 0;
                    this._requestQueue.clear();
                    this._transportListener.transportError(iOException2);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SipResolverTcpTransport: error: incrementing readTimeoutCount: " + this._readTimeoutCount);
                    }
                    ++this._readTimeoutCount;
                    this._reader.read(2L, (TCPReadCompletedCallback)this, true, 1500);
                }
            } else {
                this._readState = 2;
                this._writeState = 0;
                this._requestQueue.clear();
                this._transportListener.transportError(iOException);
            }
        }
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverTcpTransport: complete: write complete id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolverTcpTransport: complete: write completed sucessfully: " + this.hashCode());
        }
        this.drainRequestQueue();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: complete: write complete id=" + this.hashCode());
        }
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipResolverTcpTransport: error: write error id=" + this.hashCode());
        }
        if (this._shutdown) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipResolverTcpTransport: error: write failed: " + this.hashCode());
        }
        this._requestQueue.clear();
        this._writeState = 0;
        this._transportListener.transportError(iOException);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: error: write error id=" + this.hashCode());
        }
    }

    private synchronized void drainRequestQueue() {
        block5: {
            WsByteBuffer wsByteBuffer;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SipResolverTcpTransport: drainRequestQueue: entry: id=" + this.hashCode());
            }
            while ((wsByteBuffer = this._requestQueue.poll()) != null) {
                this._lengthBuffer.clear();
                this._lengthBuffer.limit(2);
                this._lengthBuffer.putShort((short)wsByteBuffer.limit());
                this._lengthBuffer.position(0);
                this._bufferArray[0] = this._lengthBuffer;
                this._bufferArray[1] = wsByteBuffer;
                this._writer.setBuffers(this._bufferArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SipResolverTcpTransport:drainRequestQueue: writing new message, length = " + wsByteBuffer.limit());
                }
                ++this._outstandingRequestCount;
                VirtualConnection virtualConnection = this._writer.write(-1L, (TCPWriteCompletedCallback)this, false, 60000);
                if (virtualConnection != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SipResolverTcpTransport:drainRequestQueue: waiting for write to complete");
                }
                this._writeState = 3;
                break block5;
            }
            this._writeState = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipResolverTcpTransport: drainRequestQueue: exit: id=" + this.hashCode());
        }
    }

    static {
        _channelInitialized = false;
    }
}

