/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.sip.channel.resolver.dns.impl.DnsMessage;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.udp.channel.UDPReadCompletedCallback;
import com.ibm.wsspi.udp.channel.UDPReadRequestContext;
import com.ibm.wsspi.udp.channel.UDPWriteCompletedCallback;
import com.ibm.wsspi.udp.channel.UDPWriteRequestContext;
import java.io.IOException;
import java.net.InetSocketAddress;

class SipResolverUdpTransport
implements ConnectionReadyCallback,
UDPReadCompletedCallback,
UDPWriteCompletedCallback {
    private static String CHAINNAME = "SipResolver";
    private static ChannelFrameworkImpl _framework;
    private static InetSocketAddress _socketAddress;
    private UDPReadRequestContext _reader;
    private UDPWriteRequestContext _writer;
    private boolean _readOutstanding = false;
    private boolean _writeOutstanding = false;

    protected SipResolverUdpTransport() {
    }

    protected void initialize(String string, int n) {
        try {
            _socketAddress = new InetSocketAddress(string, n);
            System.setProperty("com.ibm.wsspi.runtime.ThreadPoolRepositoryName", "com.ibm.ws.runtime.WSThreadPoolRepository");
            System.out.println(System.getProperty("traceSettingsFile"));
            ChannelFrameworkImpl channelFrameworkImpl = new ChannelFrameworkImpl();
            String[] stringArray = new String[]{"udp"};
            channelFrameworkImpl.addChain(CHAINNAME, FlowType.OUTBOUND, stringArray);
            _framework = channelFrameworkImpl;
            VirtualConnectionFactory virtualConnectionFactory = _framework.getOutboundVCFactory(CHAINNAME);
            OutboundVirtualConnection outboundVirtualConnection = (OutboundVirtualConnection)virtualConnectionFactory.createConnection();
        }
        catch (ChannelException channelException) {
        }
        catch (ChainException chainException) {
            System.out.println(chainException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WsByteBuffer read() {
        UDPReadRequestContext uDPReadRequestContext = this._reader;
        synchronized (uDPReadRequestContext) {
            VirtualConnection virtualConnection = null;
            WsByteBuffer wsByteBuffer = null;
            virtualConnection = this._reader.read(this, false);
            if (virtualConnection != null) {
                this.dispatchMessage(this._reader.getUDPBuffer().getBuffer());
            } else {
                this._readOutstanding = true;
            }
            return wsByteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(WsByteBuffer wsByteBuffer) {
        UDPWriteRequestContext uDPWriteRequestContext = this._writer;
        synchronized (uDPWriteRequestContext) {
            VirtualConnection virtualConnection = null;
            this._writer.setBuffer(wsByteBuffer);
            virtualConnection = this._writer.write(_socketAddress, this, false);
            this._writeOutstanding = virtualConnection == null;
        }
    }

    protected boolean readOutstanding() {
        return this._readOutstanding;
    }

    public void ready(VirtualConnection virtualConnection) {
    }

    public void destroy(Exception exception) {
        System.out.println("Connection to be destroyed: " + exception);
        if (exception != null) {
            System.out.println("Destory error: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection virtualConnection, UDPReadRequestContext uDPReadRequestContext) {
        UDPReadRequestContext uDPReadRequestContext2 = this._reader;
        synchronized (uDPReadRequestContext2) {
            this._readOutstanding = false;
            this.dispatchMessage(uDPReadRequestContext.getUDPBuffer().getBuffer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection virtualConnection, UDPReadRequestContext uDPReadRequestContext, IOException iOException) {
        UDPReadRequestContext uDPReadRequestContext2 = this._reader;
        synchronized (uDPReadRequestContext2) {
            this._readOutstanding = false;
            System.out.println("IOException on callback: " + iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection virtualConnection, UDPWriteRequestContext uDPWriteRequestContext) {
        UDPWriteRequestContext uDPWriteRequestContext2 = this._writer;
        synchronized (uDPWriteRequestContext2) {
            this._writeOutstanding = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection virtualConnection, UDPWriteRequestContext uDPWriteRequestContext, IOException iOException) {
        UDPWriteRequestContext uDPWriteRequestContext2 = this._writer;
        synchronized (uDPWriteRequestContext2) {
            this._writeOutstanding = false;
        }
    }

    private void dispatchMessage(WsByteBuffer wsByteBuffer) {
        wsByteBuffer.position(0);
        wsByteBuffer.mark();
        try {
            DnsMessage dnsMessage = new DnsMessage(wsByteBuffer);
            System.out.println(dnsMessage.toString());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

