/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.ws.sip.channel.resolver.impl.SipResolverService;
import com.ibm.wsspi.sip.channel.protocol.SIPUri;
import com.ibm.wsspi.sip.channel.resolver.SipURILookup;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupCallback;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class SipURILookupExample
implements SipURILookupCallback,
Runnable {
    private Hashtable<Integer, SipURILookup> _requestTable = new Hashtable();

    private SipURILookupExample() {
    }

    public static void main(String[] stringArray) {
        SipURILookupExample sipURILookupExample = new SipURILookupExample();
        new Thread(sipURILookupExample).start();
    }

    private void resolveUri(SIPUri sIPUri) {
        SipURILookup sipURILookup = SipResolverService.getInstance(this, sIPUri);
        try {
            if (sipURILookup.lookup()) {
                this.handleSuccessfulResolution(sipURILookup);
            } else {
                this._requestTable.put(new Integer(sipURILookup.hashCode()), sipURILookup);
            }
        }
        catch (SipURILookupException sipURILookupException) {
            System.out.println(sipURILookupException.getMessage());
        }
    }

    public void complete(SipURILookup sipURILookup) {
        this.handleSuccessfulResolution(sipURILookup);
        this._requestTable.remove(new Integer(sipURILookup.hashCode()));
    }

    public void error(SipURILookup sipURILookup, SipURILookupException sipURILookupException) {
        SIPUri sIPUri = null;
        sIPUri = sipURILookup.getSipURI();
        System.out.println(sIPUri.getHost() + ": " + sipURILookupException.getMessage());
        this._requestTable.remove(new Integer(sipURILookup.hashCode()));
    }

    private void handleSuccessfulResolution(SipURILookup sipURILookup) {
        ArrayList<SIPUri> arrayList = null;
        Iterator<SIPUri> iterator = null;
        SIPUri sIPUri3 = null;
        SIPUri sIPUri2 = null;
        sIPUri2 = sipURILookup.getSipURI();
        System.out.println("SIPUri sip:user@" + sIPUri2.getHost() + " resolved to");
        arrayList = sipURILookup.getAnswer();
        for (SIPUri sIPUri3 : arrayList) {
            System.out.println("Transport: " + sIPUri3.getTransport() + "\n" + "Address: " + sIPUri3.getHost() + "\n" + "Port: " + sIPUri3.getPort());
        }
    }

    public void run() {
        System.out.println("Entering SipResolverExample::run");
        SIPUri sIPUri = SIPUri.createSIPUri(null);
        sIPUri.setHost("example.com");
        sIPUri.setTransport(null);
        sIPUri.setPortInt(-1);
        this.resolveUri(sIPUri);
        SIPUri sIPUri2 = SIPUri.createSIPUri(null);
        sIPUri2.setHost("another.com");
        sIPUri2.setTransport(null);
        sIPUri2.setPortInt(-1);
        this.resolveUri(sIPUri2);
        SIPUri sIPUri3 = SIPUri.createSIPUri(null);
        sIPUri3.setHost("doesnotresolve.com");
        sIPUri3.setTransport(null);
        sIPUri3.setPortInt(-1);
        this.resolveUri(sIPUri3);
        System.out.println("Exiting SipResolverExample::run");
    }
}

