/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sip.channel.resolver.dns.impl.AAAARecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.ARecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.Dns;
import com.ibm.ws.sip.channel.resolver.dns.impl.DnsMessage;
import com.ibm.ws.sip.channel.resolver.dns.impl.NAPTRRecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.ResourceRecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.SRVRecord;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverEvent;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverListener;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverService;
import com.ibm.wsspi.sip.channel.protocol.SIPUri;
import com.ibm.wsspi.sip.channel.resolver.SipURILookup;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupCallback;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipURILookupImpl
implements SipURILookup,
SipResolverListener {
    private static final TraceComponent tc = Tr.register(SipURILookupImpl.class, "WebSphere SIP Channel", "com.ibm.ws.sip.channel.resources.sipchannel");
    private ArrayList<SIPUri> _answerList;
    private SIPUri _suri;
    private String _target;
    private int _port;
    private String _transport;
    private String _scheme;
    private SipURILookupCallback _sll;
    private Timer _timer;
    private StateMachine _fsm;
    private static long MESSAGE_TIMEOUT_INTERVAL = 10000L;
    private static final short TARGET_NUMERIC = 0;
    private static final short TARGET_HOSTNAME = 1;
    private static final short TARGET_INVALID = 255;
    private static final short PORT_NOT_SET = 0;
    private static final short PORT_SET = 1;
    private static final short SIP_SCHEME = 0;
    private static final short SIPS_SCHEME = 1;
    private static final short TRANSPORT_NOT_SET = 0;
    private static final short TRANSPORT_SET = 1;
    private static final int DEFAULT_PORT = 5060;
    private static final int DEFAULT_SEC_PORT = 5061;
    public static final String TCP = "tcp";
    public static final String UDP = "udp";
    public static final String SCTP = "sctp";
    public static final String SIP = "sip";
    public static final String SIPS = "sips";
    private RequestTimeoutTimerTask _timeoutTask = null;
    private Hashtable<SIPUri, SipURILookupImpl> _lookupCache = null;
    private static final int MAX_CACHE_ENTRIES = 5000;

    protected SipURILookupImpl(SipURILookupCallback sipURILookupCallback, SIPUri sIPUri, Timer timer, Hashtable<SIPUri, SipURILookupImpl> hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipURILookupImpl: constructor: entry: id=" + this.hashCode());
        }
        this._answerList = new ArrayList();
        this._suri = sIPUri;
        this._sll = sipURILookupCallback;
        this._lookupCache = hashtable;
        this._timer = timer;
        this._fsm = new StateMachine(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipURILookupImpl: constructor: exit: id=" + this.hashCode());
        }
    }

    @Override
    public SIPUri getSipURI() {
        return this._suri;
    }

    @Override
    public synchronized boolean lookup() throws SipURILookupException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipURILookupImpl: lookup: entry: id=" + this.hashCode());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "A Sip URI Lookup is being performed for " + this._suri.getBaseSIPUri());
        }
        boolean bl = false;
        if (this._fsm.currentState == 0) {
            Object object;
            this.validateSipURI();
            short s = this.rulesMatrix();
            if (s != 0 && s != 6) {
                this._timeoutTask = new RequestTimeoutTimerTask();
                object = new Date();
                this._timer.schedule((TimerTask)this._timeoutTask, new Date(((Date)object).getTime() + MESSAGE_TIMEOUT_INTERVAL));
            }
            this._fsm.runMachine(s, null);
            if (this._fsm.currentState == 5) {
                bl = true;
                object = new UriExpirationTimerTask();
                Date date = new Date();
                this._timer.schedule((TimerTask)object, new Date(date.getTime() + 43200000L));
                if (this._lookupCache.size() < 5000) {
                    this._lookupCache.put(this.getSipURI(), this);
                }
            } else if (this._fsm.currentState == 6) {
                bl = false;
                throw new SipURILookupException(SipURILookupException.DEFAULTMSG);
            }
        } else if (this._fsm.currentState == 5) {
            bl = true;
        } else {
            throw new SipURILookupException(SipURILookupException.LOOKUP_IN_PROGRESS);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipURILookupImpl: lookup: exit: id=" + this.hashCode());
        }
        return bl;
    }

    private void validateSipURI() throws SipURILookupException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipURILookupImpl: validateSipUri: entry: id=" + this.hashCode());
        }
        if (this._suri == null) {
            throw new SipURILookupException(SipURILookupException.SIPURI_NULL);
        }
        this._target = this._suri.getMaddr();
        if (this._target == null) {
            this._target = this._suri.getHost();
            if (this._target == null) {
                throw new SipURILookupException(SipURILookupException.TARGET_UNDEFINED);
            }
        }
        this._port = this._suri.getPortInt();
        if (this._port > 65535) {
            throw new SipURILookupException(SipURILookupException.PORT_INVALID + this._port);
        }
        this._transport = this._suri.getTransport();
        if (!(this._transport == null || this._transport.equalsIgnoreCase(TCP) || this._transport.equalsIgnoreCase(UDP) || this._transport.equalsIgnoreCase(SCTP))) {
            throw new SipURILookupException(SipURILookupException.TRANSPORT_INVALID + this._transport);
        }
        this._scheme = this._suri.getScheme();
        if (this._scheme == null) {
            throw new SipURILookupException(SipURILookupException.SCHEME_UNDEFINED);
        }
        if (!this._scheme.equalsIgnoreCase(SIP) && !this._scheme.equalsIgnoreCase(SIPS)) {
            throw new SipURILookupException(SipURILookupException.SCHEME_INVALID + this._scheme);
        }
        if (this._transport != null && this._scheme != null && (this._scheme.equals(SIP) && this._transport.equalsIgnoreCase(SCTP) || this._scheme.equals(SIPS) && this._transport.equalsIgnoreCase(UDP))) {
            throw new SipURILookupException(SipURILookupException.TRANSPORT_SCHEME_INVALID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipURILookupImpl: validateSipUri: exit: id=" + this.hashCode());
        }
    }

    private short rulesMatrix() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipURILookupImpl: rulesMatrix: entry: id=" + this.hashCode());
        }
        short s = 0;
        short s2 = 0;
        SIPUri sIPUri = null;
        int n = this.checkTarget();
        int n2 = this.checkTransport();
        int n3 = this.checkPort();
        int n4 = this.checkScheme();
        if (n == 255) {
            s2 = 6;
            this._fsm.initAction = s2;
            return s2;
        }
        if (n == 1 && !new Character('.').equals(Character.valueOf(this._target.charAt(this._target.length() - 1)))) {
            this._target = this._target + ".";
        }
        s = (short)(n << 3 | n2 << 2 | n3 << 1 | n4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SipURILookupImpl: rulesMatrix: truthTableAction = " + s);
        }
        switch (s) {
            case 0: {
                sIPUri = SIPUri.createSIPUri(this._suri.getURI());
                sIPUri.setScheme(this._scheme);
                sIPUri.setHost(this._target);
                sIPUri.setPortInt(5060);
                sIPUri.setTransport(UDP);
                this._answerList.add(sIPUri);
                s2 = 0;
                break;
            }
            case 1: {
                sIPUri = SIPUri.createSIPUri(this._suri.getURI());
                sIPUri.setScheme(this._scheme);
                sIPUri.setHost(this._target);
                sIPUri.setTransport(TCP);
                sIPUri.setPortInt(5061);
                this._answerList.add(sIPUri);
                s2 = 0;
                break;
            }
            case 2: {
                sIPUri = SIPUri.createSIPUri(this._suri.getURI());
                sIPUri.setScheme(this._scheme);
                sIPUri.setHost(this._target);
                sIPUri.setPortInt(this._port);
                sIPUri.setTransport(UDP);
                this._answerList.add(sIPUri);
                s2 = 0;
                break;
            }
            case 3: {
                sIPUri = SIPUri.createSIPUri(this._suri.getURI());
                sIPUri.setScheme(this._scheme);
                sIPUri.setHost(this._target);
                sIPUri.setPortInt(this._port);
                sIPUri.setTransport(TCP);
                this._answerList.add(sIPUri);
                s2 = 0;
                break;
            }
            case 4: {
                sIPUri = SIPUri.createSIPUri(this._suri.getURI());
                sIPUri.setScheme(this._scheme);
                sIPUri.setHost(this._target);
                sIPUri.setTransport(this._transport);
                sIPUri.setPortInt(5060);
                this._answerList.add(sIPUri);
                s2 = 0;
                break;
            }
            case 5: {
                sIPUri = SIPUri.createSIPUri(this._suri.getURI());
                sIPUri.setScheme(this._scheme);
                sIPUri.setHost(this._target);
                sIPUri.setTransport(this._transport);
                sIPUri.setPortInt(5061);
                this._answerList.add(sIPUri);
                s2 = 0;
                break;
            }
            case 6: 
            case 7: {
                sIPUri = SIPUri.createSIPUri(this._suri.getURI());
                sIPUri.setScheme(this._scheme);
                sIPUri.setHost(this._target);
                sIPUri.setPortInt(this._port);
                sIPUri.setTransport(this._transport);
                this._answerList.add(sIPUri);
                s2 = 0;
                break;
            }
            case 8: 
            case 9: {
                s2 = 1;
                break;
            }
            case 10: {
                this._transport = UDP;
                s2 = 3;
                break;
            }
            case 11: {
                this._transport = TCP;
                s2 = 3;
                break;
            }
            case 12: 
            case 13: {
                s2 = 2;
                break;
            }
            case 14: 
            case 15: {
                s2 = 3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipURILookupImpl: rulesMatrix: exit: id=" + this.hashCode());
        }
        this._fsm.initAction = s2;
        return s2;
    }

    private int checkTarget() {
        int n = 0;
        String[] stringArray = this._target.split("\\:");
        if (stringArray.length == 1) {
            String[] stringArray2 = this._target.split("\\.");
            if (stringArray2.length == 4) {
                n = 0;
                for (int i = 0; i < stringArray2.length; ++i) {
                    try {
                        Integer.parseInt(stringArray2[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 1;
                        break;
                    }
                }
                try {
                    if (n == 0) {
                        InetAddress.getByName(this._target);
                    }
                }
                catch (Exception exception) {
                    n = 255;
                }
            } else {
                n = 1;
            }
        } else if (stringArray[0].equals("") || Character.digit(stringArray[0].charAt(0), 16) <= 15 || new Character('[').equals(Character.valueOf(stringArray[0].charAt(0)))) {
            try {
                InetAddress.getByName(this._target);
            }
            catch (Exception exception) {
                n = 255;
            }
            n = 0;
        } else {
            n = 255;
        }
        return n;
    }

    private int checkPort() {
        int n = 0;
        n = this._port < 0 || this._port == 0 ? 0 : 1;
        return n;
    }

    private int checkScheme() {
        int n = 0;
        if (this._scheme.equalsIgnoreCase(SIP)) {
            n = 0;
        } else if (this._scheme.equalsIgnoreCase(SIPS)) {
            n = 1;
        }
        return n;
    }

    private int checkTransport() {
        int n = 0;
        n = this._transport != null && (this._transport.equalsIgnoreCase(TCP) || this._transport.equalsIgnoreCase(UDP) || this._transport.equalsIgnoreCase(SCTP)) ? 1 : 0;
        return n;
    }

    @Override
    public ArrayList<SIPUri> getAnswer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipURILookupImpl: getAnswer: entry: id=" + this.hashCode());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipURILookupImpl: getAnswer: exit: id=" + this.hashCode());
        }
        return this._answerList;
    }

    @Override
    public void handleSipResolverEvent(SipResolverEvent sipResolverEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SipURILookupImpl: handleSipResolverEvent: entry: id=" + this.hashCode());
        }
        switch (sipResolverEvent.getType()) {
            case 1: 
            case 2: {
                this._fsm.handleEvent(sipResolverEvent);
                if (this._fsm.currentState == 5) {
                    this._timeoutTask.cancel();
                    int n = this._fsm.getTTL();
                    if (n > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SipURILookupImpl: handleSipResolverEvent: ttl(seconds) = " + n + " caching results");
                        }
                        UriExpirationTimerTask uriExpirationTimerTask = new UriExpirationTimerTask();
                        Date date = new Date();
                        this._timer.schedule((TimerTask)uriExpirationTimerTask, new Date(date.getTime() + (long)(n * 1000)));
                        if (this._lookupCache.size() < 5000) {
                            this._lookupCache.put(this.getSipURI(), this);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SipURILookupImpl: handleSipResolverEvent: ttl = 0, not caching lookup");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SipURILookupImpl: handleSipResolverEvent: sll.complete()");
                    }
                    if (!this._answerList.isEmpty()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SipURILookupImpl: handleSipResolverEvent: sll.complete()");
                        }
                        this._sll.complete(this);
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SipURILookupImpl: handleSipResolverEvent: sll.error()");
                    }
                    this._sll.error(this, new SipURILookupException(SipURILookupException.NAMING_ERROR));
                    break;
                }
                if (this._fsm.currentState != 6) break;
                this._sll.error(this, new SipURILookupException(SipURILookupException.NAMING_ERROR));
                break;
            }
            case 4: {
                this._timeoutTask.cancel();
                this._sll.error(this, new SipURILookupException(SipURILookupException.DEFAULTMSG));
                break;
            }
            case 3: {
                this._timeoutTask.cancel();
                this._fsm.reset();
                try {
                    this.lookup();
                }
                catch (SipURILookupException sipURILookupException) {
                    this._sll.error(this, sipURILookupException);
                }
                break;
            }
            default: {
                this._timeoutTask.cancel();
                this._sll.error(this, new SipURILookupException(SipURILookupException.NAMING_ERROR));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SipURILookupImpl: handleSipResolverEvent: exit: id=" + this.hashCode());
        }
    }

    class StateMachine {
        private int previousState;
        private int currentState;
        private int initAction;
        private static final int INITIAL = 0;
        private static final int NAPTR_PEND = 1;
        private static final int SRV_PEND = 2;
        private static final int A_PEND = 3;
        private static final int AAAA_PEND = 4;
        private static final int COMPLETE = 5;
        private static final int ERROR = 6;
        private static final short FINISHED = 0;
        private static final short SEND_NAPTR_REQUEST = 1;
        private static final short SEND_SRV_REQUEST = 2;
        private static final short SEND_A_REQUEST = 3;
        private static final short SEND_AAAA_REQUEST = 4;
        private static final short NAPTR_RESP = 5;
        private static final short NAPTR_ERROR = 6;
        private static final short NOOP = 13;
        private String SIP_D2T;
        private String SIPS_D2T;
        private String SIP_D2U;
        private String SIP_D2S;
        private String[] mapper;
        private SipURILookupImpl _simpl;
        private Class c;
        private Method CHKANS;
        private Method CHKERR;
        private Method SNAPTR;
        private Method SSRV;
        private Method SA;
        private Method SAAAA;
        private Method ANSWER;
        private Method NONE;
        private Vector<DnsMessage> _dnsRequests;
        private Vector<NAPTRRecord> _NAPTRResponses;
        private Vector<SRVRecord>[] _SRVResponses;
        private Hashtable<String, Vector> _AResponses;
        private Hashtable<String, Vector> _AAAAResponses;
        private e[][] lookup_stateMachine;

        StateMachine(SipURILookupImpl sipURILookupImpl2) {
            block2: {
                this.previousState = 0;
                this.currentState = 0;
                this.initAction = 13;
                this.SIP_D2T = "SIP+D2T";
                this.SIPS_D2T = "SIPS+D2T";
                this.SIP_D2U = "SIP+D2U";
                this.SIP_D2S = "SIPS+D2S";
                this.mapper = new String[]{"PH0", "PH1", "PH2", "PH3", "PH4", "NAPTR", "PH5", "SRV", "PH6", "A", "PH7", "AAAA"};
                this.c = StateMachine.class;
                try {
                    this._simpl = sipURILookupImpl2;
                    this.CHKANS = this.c.getMethod("checkAnswer", DnsMessage.class);
                    this.CHKERR = this.c.getMethod("checkError", new Class[0]);
                    this.SNAPTR = this.c.getMethod("sendNAPTR", new Class[0]);
                    this.SSRV = this.c.getMethod("sendSRV", new Class[0]);
                    this.SA = this.c.getMethod("sendA", new Class[0]);
                    this.SAAAA = this.c.getMethod("sendAAAA", new Class[0]);
                    this.ANSWER = this.c.getMethod("constructAnswer", new Class[0]);
                    this.NONE = this.c.getMethod("none", new Class[0]);
                    this._dnsRequests = new Vector();
                    this._NAPTRResponses = new Vector();
                    this._SRVResponses = null;
                    this._AResponses = new Hashtable();
                    this._AAAAResponses = new Hashtable();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug(tc, "StateMachine: StateMachine exception " + exception);
                }
            }
            this.lookup_stateMachine = new e[][]{{new e(this.ANSWER, 5), new e(this.SNAPTR, 1), new e(this.SSRV, 2), new e(this.SA, 3), new e(this.SAAAA, 4), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 0)}, {new e(this.ANSWER, 5), new e(this.NONE, 6), new e(this.SSRV, 2), new e(this.SA, 2), new e(this.SAAAA, 4), new e(this.CHKANS, 1), new e(this.SSRV, 2), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 1)}, {new e(this.ANSWER, 5), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.SA, 3), new e(this.SAAAA, 4), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.CHKANS, 2), new e(this.CHKERR, 2), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 2)}, {new e(this.ANSWER, 5), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.SAAAA, 4), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.CHKANS, 3), new e(this.CHKERR, 3), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 3)}, {new e(this.ANSWER, 5), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.CHKANS, 4), new e(this.CHKERR, 4), new e(this.NONE, 4)}, {new e(this.NONE, 5), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 5)}, {new e(this.ANSWER, 5), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6), new e(this.NONE, 6)}};
        }

        private synchronized void runMachine(int n, DnsMessage dnsMessage) {
            block9: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "StateMachine: runMachine: entry: id=" + this.hashCode());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: runMachine: before the state machine current state = " + this.currentState + " input = " + n);
                }
                e e2 = this.lookup_stateMachine[this.currentState][n];
                this.previousState = this.currentState;
                this.currentState = e2.nextState;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "StateMachine: runMachine: after the state machine current action method = " + e2.action.getName());
                    }
                    if (dnsMessage != null && !dnsMessage.isRCODEError()) {
                        Object[] objectArray = new Object[]{dnsMessage};
                        e2.action.invoke((Object)this, objectArray);
                    } else {
                        e2.action.invoke((Object)this, (Object[])null);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "StateMachine: runMachine: state machine error " + exception);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "StateMachine: runMachine: after state machine current state = " + this.currentState);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: runMachine: exit: id=" + this.hashCode());
            }
        }

        private boolean checkSRVAdditional(DnsMessage dnsMessage) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkSRVAdditional: entry: id=" + this.hashCode());
            }
            boolean bl = false;
            this.checkSRV(dnsMessage.getAdditional());
            this.checkA(dnsMessage.getAdditional());
            this.checkAAAA(dnsMessage.getAdditional());
            if (this.haveSRVResponses() && (!this._AResponses.isEmpty() || !this._AAAAResponses.isEmpty()) && this._dnsRequests.isEmpty()) {
                bl = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkSRVAdditional: exit: id=" + this.hashCode());
            }
            return bl;
        }

        public void checkAError(DnsMessage dnsMessage) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkAError: entry: id=" + this.hashCode());
            }
            if (this._dnsRequests.isEmpty()) {
                this.sendAAAA();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkAError: exit: id=" + this.hashCode());
            }
        }

        private boolean checkA(Vector vector) {
            boolean bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkA: entry: id=" + this.hashCode());
            }
            Vector<ARecord> vector2 = null;
            Vector vector3 = vector;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "StateMachine: checkAAnswer: answer size " + vector3.size());
            }
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                ResourceRecord resourceRecord = (ResourceRecord)enumeration.nextElement();
                if (resourceRecord.getType() != 1) continue;
                vector2 = this._AResponses.get(resourceRecord.getName().getString());
                if (vector2 == null) {
                    vector2 = new Vector<ARecord>();
                }
                boolean bl2 = false;
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    ARecord aRecord = (ARecord)enumeration2.nextElement();
                    if (!aRecord.getName().toString().equals(resourceRecord.getName().toString())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "duplicate record found for " + resourceRecord.getName().toString());
                    }
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adding record for " + resourceRecord.getName().toString());
                    }
                    vector2.add((ARecord)resourceRecord);
                    bl = true;
                }
                if (this._AResponses.contains(resourceRecord.getName().getString())) continue;
                this._AResponses.put(resourceRecord.getName().getString(), vector2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkA: exit: id=" + this.hashCode());
            }
            return bl;
        }

        private boolean checkAAAA(Vector vector) {
            boolean bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkAAAA: entry: id=" + this.hashCode());
            }
            Vector<AAAARecord> vector2 = null;
            Vector vector3 = vector;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkAAAA: answer size " + vector3.size());
            }
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                ResourceRecord resourceRecord = (ResourceRecord)enumeration.nextElement();
                if (resourceRecord.getType() != 28) continue;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "StateMachine: checkAAAA: found AAAA record");
                }
                if ((vector2 = this._AAAAResponses.get(resourceRecord.getName().getString())) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "StateMachine: checkAAAA: create new Vector");
                    }
                    vector2 = new Vector<AAAARecord>();
                }
                boolean bl2 = false;
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    AAAARecord aAAARecord = (AAAARecord)enumeration2.nextElement();
                    if (!aAAARecord.getName().toString().equals(resourceRecord.getName().toString())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "StateMachine: checkAAAA: add record " + resourceRecord.getName().getString());
                    }
                    vector2.add((AAAARecord)resourceRecord);
                    bl = true;
                }
                if (this._AAAAResponses.contains(resourceRecord.getName().getString())) continue;
                this._AAAAResponses.put(resourceRecord.getName().getString(), vector2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkAAAA: exit: id=" + this.hashCode());
            }
            return bl;
        }

        private boolean checkAAAAAdditional(DnsMessage dnsMessage) {
            boolean bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkAAAAAdditional: entry: id=" + this.hashCode());
            }
            bl = this.checkAAAA(dnsMessage.getAdditional());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkAAAAAdditional: exit: id=" + this.hashCode());
            }
            return bl;
        }

        public void sendReq(DnsMessage dnsMessage) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: sendReq: entry: id=" + this.hashCode());
            }
            this._dnsRequests.add(dnsMessage);
            SipResolverEvent sipResolverEvent = SipResolverService.getResolver().resolve(dnsMessage, this._simpl);
            if (sipResolverEvent != null && !sipResolverEvent.successfulResolution()) {
                SipURILookupImpl.this._timeoutTask.cancel();
                SipURILookupImpl.this._sll.error(this._simpl, new SipURILookupException(SipURILookupException.DEFAULTMSG));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: sendReq: exit: id=" + this.hashCode());
            }
        }

        public void sendNAPTR() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: sendNAPTR: entry: id=" + this.hashCode());
            }
            DnsMessage dnsMessage = new DnsMessage(35, SipURILookupImpl.this._target);
            this.sendReq(dnsMessage);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: sendNAPTR: exit: id=" + this.hashCode());
            }
        }

        public void sendSRV() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: sendSRV: entry: id=" + this.hashCode());
            }
            if (this._NAPTRResponses.size() > 0) {
                Enumeration<NAPTRRecord> enumeration = this._NAPTRResponses.elements();
                while (enumeration.hasMoreElements()) {
                    NAPTRRecord nAPTRRecord = enumeration.nextElement();
                    DnsMessage dnsMessage = new DnsMessage(33, nAPTRRecord.getReplacement().getString());
                    this.sendReq(dnsMessage);
                }
            } else if (this.previousState == 1) {
                String string = null;
                String string2 = null;
                if (SipURILookupImpl.this._scheme.equalsIgnoreCase(SipURILookupImpl.SIP)) {
                    string = "_sip._udp." + SipURILookupImpl.this._target;
                    string2 = "_sip._tcp." + SipURILookupImpl.this._target;
                } else if (SipURILookupImpl.this._scheme.equalsIgnoreCase(SipURILookupImpl.SIPS)) {
                    string = "_sips._tcp." + SipURILookupImpl.this._target;
                }
                DnsMessage dnsMessage = new DnsMessage(33, string);
                this.sendReq(dnsMessage);
                if (string2 != null) {
                    DnsMessage dnsMessage2 = new DnsMessage(33, string2);
                    this.sendReq(dnsMessage2);
                }
            } else {
                Object object;
                String string = null;
                String string3 = SipURILookupImpl.this._suri.getTransport();
                if (string3.equalsIgnoreCase(SipURILookupImpl.UDP)) {
                    string = "_sip._udp." + SipURILookupImpl.this._target;
                } else if (string3.equalsIgnoreCase(SipURILookupImpl.TCP)) {
                    object = SipURILookupImpl.this._suri.getScheme();
                    if (((String)object).equalsIgnoreCase(SipURILookupImpl.SIP)) {
                        string = "_sip._tcp." + SipURILookupImpl.this._target;
                    } else if (((String)object).equalsIgnoreCase(SipURILookupImpl.SIPS)) {
                        string = "_sips._tcp." + SipURILookupImpl.this._target;
                    }
                } else if (string3.equalsIgnoreCase(SipURILookupImpl.SCTP)) {
                    string = "_sips._sctp." + SipURILookupImpl.this._target;
                }
                object = new DnsMessage(33, string);
                this.sendReq((DnsMessage)object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: sendSRV: exit: id=" + this.hashCode());
            }
        }

        public void sendA() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: sendA: entry: id=" + this.hashCode());
            }
            if (this.previousState == 2 && this.currentState == 3 && this.haveSRVResponses()) {
                for (int i = 0; i < this._SRVResponses.length; ++i) {
                    Vector<SRVRecord> vector = this._SRVResponses[i];
                    Enumeration<SRVRecord> enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        SRVRecord sRVRecord = enumeration.nextElement();
                        DnsMessage dnsMessage = new DnsMessage(1, sRVRecord.getTarget().toString());
                        this.sendReq(dnsMessage);
                    }
                }
            } else {
                DnsMessage dnsMessage = new DnsMessage(1, SipURILookupImpl.this._target);
                this.sendReq(dnsMessage);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: sendA: exit: id=" + this.hashCode());
            }
        }

        public void sendAAAA() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: sendAAAA: entry: id=" + this.hashCode());
            }
            if (this.haveSRVResponses()) {
                for (int i = 0; i < this._SRVResponses.length; ++i) {
                    Vector<SRVRecord> vector = this._SRVResponses[i];
                    Enumeration<SRVRecord> enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        SRVRecord sRVRecord = enumeration.nextElement();
                        DnsMessage dnsMessage = new DnsMessage(28, sRVRecord.getTarget().toString());
                        this.sendReq(dnsMessage);
                    }
                }
            } else {
                DnsMessage dnsMessage = new DnsMessage(28, SipURILookupImpl.this._target);
                this.sendReq(dnsMessage);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: sendAAAA: exit: id=" + this.hashCode());
            }
        }

        public void none() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: none: entry: id=" + this.hashCode());
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: none: exit: id=" + this.hashCode());
            }
        }

        private void reset() {
            this.previousState = 0;
            this.currentState = 0;
            Enumeration<DnsMessage> enumeration = this._dnsRequests.elements();
            while (enumeration.hasMoreElements()) {
                DnsMessage dnsMessage = enumeration.nextElement();
                SipResolverService.getResolver().cancelRequest(dnsMessage);
            }
            this._dnsRequests.clear();
            this._NAPTRResponses.clear();
            this._SRVResponses = null;
            this._AResponses.clear();
            this._AAAAResponses.clear();
        }

        private void fillSRVAnswer() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: fillSRVAnswer: entry: id=" + this.hashCode());
            }
            if (this.haveSRVResponses()) {
                Vector<SRVRecord>[] vectorArray = this._SRVResponses;
                for (int i = 0; i < vectorArray.length; ++i) {
                    float f = this.calcTotalWeight(vectorArray[i]);
                    Enumeration<SRVRecord> enumeration = vectorArray[i].elements();
                    while (enumeration.hasMoreElements()) {
                        Object object;
                        SRVRecord sRVRecord = enumeration.nextElement();
                        Vector vector = this.fillSipUri(sRVRecord);
                        if (vector.isEmpty()) continue;
                        float f2 = sRVRecord.getWeight().shortValue();
                        if (f2 > 0.0f && f - f2 != 0.0f) {
                            for (float f3 = 0.0f; f3 < f2 / (f - f2); f3 += 1.0f) {
                                object = vector.elements();
                                while (object.hasMoreElements()) {
                                    SIPUri sIPUri = (SIPUri)object.nextElement();
                                    SipURILookupImpl.this._answerList.add(sIPUri);
                                }
                            }
                            continue;
                        }
                        Enumeration enumeration2 = vector.elements();
                        while (enumeration2.hasMoreElements()) {
                            object = (SIPUri)enumeration2.nextElement();
                            SipURILookupImpl.this._answerList.add(object);
                        }
                    }
                }
            } else {
                this.fillAError();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "StateMachine: fillSRVAnswer: _answerList.size()" + SipURILookupImpl.this._answerList.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: fillSRVAnswer: exit: id=" + this.hashCode());
            }
        }

        private void fillAAnswer() {
            SIPUri sIPUri;
            ResourceRecord resourceRecord;
            Enumeration enumeration;
            Vector vector;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: fillAAnswer: entry: id=" + this.hashCode());
            }
            Enumeration<Vector> enumeration2 = this._AResponses.elements();
            while (enumeration2.hasMoreElements()) {
                vector = enumeration2.nextElement();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    resourceRecord = (ARecord)enumeration.nextElement();
                    sIPUri = SIPUri.createSIPUri(SipURILookupImpl.this._suri.getURI());
                    sIPUri.setScheme(SipURILookupImpl.this._scheme);
                    sIPUri.setHost(((ARecord)resourceRecord).getAddress().getHostAddress());
                    sIPUri.setTransport(SipURILookupImpl.this._transport);
                    sIPUri.setPortInt(SipURILookupImpl.this._port);
                    SipURILookupImpl.this._answerList.add(sIPUri);
                }
            }
            enumeration2 = this._AAAAResponses.elements();
            while (enumeration2.hasMoreElements()) {
                vector = enumeration2.nextElement();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    resourceRecord = (AAAARecord)enumeration.nextElement();
                    sIPUri = SIPUri.createSIPUri(SipURILookupImpl.this._suri.getURI());
                    sIPUri.setScheme(SipURILookupImpl.this._scheme);
                    sIPUri.setHost(((AAAARecord)resourceRecord).getAddress().getHostAddress());
                    sIPUri.setTransport(SipURILookupImpl.this._transport);
                    sIPUri.setPortInt(SipURILookupImpl.this._port);
                    SipURILookupImpl.this._answerList.add(sIPUri);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: fillAAnswer: exit: id=" + this.hashCode());
            }
        }

        private void fillAError() {
            SIPUri sIPUri;
            ResourceRecord resourceRecord;
            Enumeration enumeration;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: fillAError: entry: id=" + this.hashCode());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "StateMachine: fillAError: _target = " + SipURILookupImpl.this._target);
            }
            Vector vector = null;
            vector = this._AResponses.get(SipURILookupImpl.this._target);
            if (vector != null) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    resourceRecord = (ARecord)enumeration.nextElement();
                    sIPUri = SIPUri.createSIPUri(SipURILookupImpl.this._suri.getURI());
                    sIPUri.setScheme(SipURILookupImpl.this._scheme);
                    sIPUri.setHost(((ARecord)resourceRecord).getAddress().getHostAddress());
                    if (SipURILookupImpl.this._scheme.equals(SipURILookupImpl.SIP)) {
                        if (SipURILookupImpl.this._transport == null) {
                            sIPUri.setTransport(SipURILookupImpl.UDP);
                        }
                        sIPUri.setPortInt(5060);
                    } else {
                        if (SipURILookupImpl.this._transport == null) {
                            sIPUri.setTransport(SipURILookupImpl.TCP);
                        }
                        sIPUri.setPortInt(5061);
                    }
                    SipURILookupImpl.this._answerList.add(sIPUri);
                }
            }
            if ((vector = this._AAAAResponses.get(SipURILookupImpl.this._target)) != null) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    resourceRecord = (AAAARecord)enumeration.nextElement();
                    sIPUri = SIPUri.createSIPUri(SipURILookupImpl.this._suri.getURI());
                    sIPUri.setScheme(SipURILookupImpl.this._scheme);
                    sIPUri.setHost(((AAAARecord)resourceRecord).getAddress().getHostAddress());
                    if (SipURILookupImpl.this._scheme.equals(SipURILookupImpl.SIP)) {
                        if (SipURILookupImpl.this._transport == null) {
                            sIPUri.setTransport(SipURILookupImpl.UDP);
                        }
                        sIPUri.setPortInt(5060);
                    } else {
                        if (SipURILookupImpl.this._transport == null) {
                            sIPUri.setTransport(SipURILookupImpl.TCP);
                        }
                        sIPUri.setPortInt(5061);
                    }
                    SipURILookupImpl.this._answerList.add(sIPUri);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: fillAError: exit: id=" + this.hashCode());
            }
        }

        private float calcTotalWeight(Vector vector) {
            float f = 0.0f;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SRVRecord sRVRecord = (SRVRecord)enumeration.nextElement();
                f += (float)sRVRecord.getWeight().shortValue();
            }
            return f;
        }

        private Vector fillSipUri(SRVRecord sRVRecord) {
            SIPUri sIPUri;
            ResourceRecord resourceRecord;
            Enumeration enumeration;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: fillSipUri: entry: id=" + this.hashCode());
            }
            Vector<SIPUri> vector = new Vector<SIPUri>();
            Vector vector2 = null;
            vector2 = this._AResponses.get(sRVRecord.getTarget().toString());
            if (vector2 != null) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    resourceRecord = (ARecord)enumeration.nextElement();
                    sIPUri = SIPUri.createSIPUri(SipURILookupImpl.this._suri.getBaseSIPUri());
                    sIPUri.setHost(((ARecord)resourceRecord).getAddress().getHostAddress());
                    sIPUri.setPort(new Integer(sRVRecord.getPort()).toString());
                    sIPUri.setTransport(sRVRecord.getProtocol().substring(1));
                    sIPUri.setScheme(sRVRecord.getService().substring(1));
                    vector.add(sIPUri);
                }
            }
            if ((vector2 = this._AAAAResponses.get(sRVRecord.getTarget().toString())) != null) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    resourceRecord = (AAAARecord)enumeration.nextElement();
                    sIPUri = SIPUri.createSIPUri(SipURILookupImpl.this._suri.getBaseSIPUri());
                    sIPUri.setHost(((AAAARecord)resourceRecord).getAddress().getHostAddress());
                    sIPUri.setPort(new Integer(sRVRecord.getPort()).toString());
                    sIPUri.setTransport(sRVRecord.getProtocol().substring(1));
                    sIPUri.setScheme(sRVRecord.getService().substring(1));
                    vector.add(sIPUri);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: fillSipUri: exit: id=" + this.hashCode());
            }
            return vector;
        }

        private int getTTL() {
            ResourceRecord resourceRecord;
            Enumeration enumeration;
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: getTTL: entry: id=" + this.hashCode());
            }
            int n = Integer.MAX_VALUE;
            Enumeration<Object> enumeration2 = this._NAPTRResponses.elements();
            while (enumeration2.hasMoreElements()) {
                object = enumeration2.nextElement();
                if (((ResourceRecord)object).getTTL() >= n) continue;
                n = ((ResourceRecord)object).getTTL();
            }
            if (this.haveSRVResponses()) {
                for (int i = 0; i < this._SRVResponses.length; ++i) {
                    if (this._SRVResponses[i].isEmpty() || ((ResourceRecord)(object = this._SRVResponses[i].firstElement())).getTTL() >= n) continue;
                    n = ((ResourceRecord)object).getTTL();
                }
            }
            enumeration2 = this._AResponses.elements();
            while (enumeration2.hasMoreElements()) {
                object = (Vector)enumeration2.nextElement();
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    resourceRecord = (ARecord)enumeration.nextElement();
                    if (resourceRecord.getTTL() >= n) continue;
                    n = resourceRecord.getTTL();
                }
            }
            enumeration2 = this._AAAAResponses.elements();
            while (enumeration2.hasMoreElements()) {
                object = (Vector)enumeration2.nextElement();
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    resourceRecord = (AAAARecord)enumeration.nextElement();
                    if (resourceRecord.getTTL() >= n) continue;
                    n = resourceRecord.getTTL();
                }
            }
            if (n == Integer.MAX_VALUE) {
                n = 0;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: getTTL: exit: id=" + this.hashCode());
            }
            return n;
        }

        public void checkAnswer(DnsMessage dnsMessage) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkAnswer: entry: id=" + this.hashCode());
            }
            int n = 13;
            switch (this.currentState) {
                case 1: {
                    this.checkNAPTRAnswer(dnsMessage);
                    this.checkAdditional(dnsMessage);
                    if (this.currentState == 5) break;
                    n = 2;
                    break;
                }
                case 2: {
                    this.checkSRV(dnsMessage.getAnswers());
                    this.checkAdditional(dnsMessage);
                    if (!this._dnsRequests.isEmpty() || this.currentState == 5) break;
                    n = 3;
                    break;
                }
                case 3: {
                    this.checkA(dnsMessage.getAnswers());
                    this.checkAdditional(dnsMessage);
                    if (!this._dnsRequests.isEmpty() || this.currentState == 5) break;
                    n = 4;
                    break;
                }
                case 4: {
                    this.checkAAAA(dnsMessage.getAnswers());
                    if (!this._dnsRequests.isEmpty() || this.currentState == 5) break;
                    n = 0;
                    break;
                }
            }
            this.runMachine(n, null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkAnswer: exit: id=" + this.hashCode());
            }
        }

        public void checkAdditional(DnsMessage dnsMessage) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkAdditional: entry: id=" + this.hashCode());
            }
            int n = 13;
            switch (this.currentState) {
                case 1: {
                    if (!this.checkSRVAdditional(dnsMessage)) break;
                    n = 0;
                    break;
                }
                case 2: {
                    if (!this.checkSRVAdditional(dnsMessage)) break;
                    n = 0;
                    break;
                }
                case 3: {
                    if (!this.checkAAAAAdditional(dnsMessage)) break;
                    n = 0;
                    break;
                }
                case 4: {
                    break;
                }
            }
            this.runMachine(n, null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkAdditional: exit: id=" + this.hashCode());
            }
        }

        public void checkError() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkError: entry: id=" + this.hashCode());
            }
            int n = 13;
            switch (this.currentState) {
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    if (!this._dnsRequests.isEmpty()) break;
                    n = 3;
                    break;
                }
                case 3: {
                    if (!this._dnsRequests.isEmpty()) break;
                    n = 4;
                    break;
                }
                case 4: {
                    if (!this._dnsRequests.isEmpty()) break;
                    n = 0;
                    break;
                }
            }
            this.runMachine(n, null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkError: exit: id=" + this.hashCode());
            }
        }

        protected boolean checkNAPTRAnswer(DnsMessage dnsMessage) {
            Vector<ResourceRecord> vector;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkNAPTRAnswer: entry: id=" + this.hashCode());
            }
            if ((vector = dnsMessage.getAnswers()) != null) {
                Enumeration<ResourceRecord> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    NAPTRRecord nAPTRRecord;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "StateMachine: checkNAPTRAnswer: v size " + vector.size());
                    }
                    if (this.validateNAPTRService(nAPTRRecord = (NAPTRRecord)enumeration.nextElement())) continue;
                    if (this._NAPTRResponses.isEmpty()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "StateMachine: checkNAPTRAnswer: insert into empty list");
                        }
                        this._NAPTRResponses.insertElementAt(nAPTRRecord, 0);
                        continue;
                    }
                    int n = 0;
                    Enumeration<NAPTRRecord> enumeration2 = this._NAPTRResponses.elements();
                    while (enumeration2.hasMoreElements()) {
                        NAPTRRecord nAPTRRecord2 = enumeration2.nextElement();
                        n = this._NAPTRResponses.indexOf(nAPTRRecord2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "StateMachine: checkNAPTRAnswer: after existing ");
                        }
                        if (nAPTRRecord.getOrder() == nAPTRRecord2.getOrder()) {
                            if (nAPTRRecord.getPreference() >= nAPTRRecord2.getPreference()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "StateMachine: checkNAPTRAnswer: answers same Order higer pref ");
                                }
                                this._NAPTRResponses.insertElementAt(nAPTRRecord, n);
                                break;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "StateMachine: checkNAPTRAnswer: same Order lower pref ");
                            }
                            this._NAPTRResponses.insertElementAt(nAPTRRecord, n + 1);
                            break;
                        }
                        if (nAPTRRecord.getOrder() >= nAPTRRecord2.getOrder()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "StateMachine: checkNAPTRAnswer: lower order");
                        }
                        this._NAPTRResponses.insertElementAt(nAPTRRecord, n);
                        break;
                    }
                    if (this._NAPTRResponses.contains(nAPTRRecord)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "StateMachine: checkNAPTRAnswer: insert at the end of list");
                    }
                    this._NAPTRResponses.insertElementAt(nAPTRRecord, n + 1);
                }
            }
            boolean bl = false;
            if (this._NAPTRResponses.isEmpty()) {
                bl = false;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: checkNAPTRAnswer: setting up SRVResponses");
                }
                this._SRVResponses = new Vector[this._NAPTRResponses.size()];
                for (int i = 0; i < this._NAPTRResponses.size(); ++i) {
                    this._SRVResponses[i] = new Vector();
                }
                bl = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkNAPTRAnswer: exit: id=" + this.hashCode());
            }
            return bl;
        }

        private boolean validateNAPTRService(NAPTRRecord nAPTRRecord) {
            boolean bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: validateNAPTRService: entry: id=" + this.hashCode());
            }
            String string = nAPTRRecord.getService();
            if (SipURILookupImpl.this._scheme.startsWith(SipURILookupImpl.SIPS) && !string.startsWith("SIPS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: validateNAPTRService: Non-Secure service");
                }
                bl = true;
            } else if (!(string.equals(this.SIP_D2T) || string.equals(this.SIPS_D2T) || string.equals(this.SIP_D2U))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: validateNAPTRService: Unsupported service " + string);
                }
                bl = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: validateNAPTRService: exit: id=" + this.hashCode());
            }
            return bl;
        }

        private void mapNAPTRtransportToSRVprotocol(NAPTRRecord nAPTRRecord, SRVRecord sRVRecord) {
            String string = nAPTRRecord.getService();
            if (string.equals(this.SIP_D2U)) {
                sRVRecord.setProtocol("_udp");
            } else if (string.equals(this.SIPS_D2T)) {
                sRVRecord.setProtocol("_tcp");
            } else if (string.equals(this.SIP_D2T)) {
                sRVRecord.setProtocol("_tcp");
            } else if (string.equals(this.SIP_D2S)) {
                sRVRecord.setProtocol("_sctp");
            }
        }

        protected boolean checkSRV(Vector vector) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: checkSRV: entry: id=" + this.hashCode());
            }
            Vector vector2 = vector;
            if (this._SRVResponses == null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "StateMachine: checkSRV: setting up SRVResponses");
                }
                this._SRVResponses = new Vector[1];
                this._SRVResponses[0] = new Vector();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "StateMachine: checkSRV: vAnswer size " + vector2.size());
            }
            Enumeration enumeration = vector2.elements();
            block0: while (enumeration.hasMoreElements()) {
                Object object;
                Object object2;
                ResourceRecord resourceRecord = (ResourceRecord)enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: checkSRV: type " + resourceRecord.getType());
                }
                if (resourceRecord.getType() != 33) continue;
                SRVRecord sRVRecord = (SRVRecord)resourceRecord;
                if (!this._NAPTRResponses.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "StateMachine: checkSRV: have Naptr ");
                    }
                    Enumeration<NAPTRRecord> enumeration2 = this._NAPTRResponses.elements();
                    while (enumeration2.hasMoreElements()) {
                        object2 = enumeration2.nextElement();
                        object = ((NAPTRRecord)object2).getReplacement();
                        String string = sRVRecord.getService() + "." + sRVRecord.getProtocol() + "." + sRVRecord.getSrvName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "StateMachine: checkSRV: replacement " + ((Name)object).getString());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "StateMachine: checkSRV: srv " + string);
                        }
                        if (!string.equals(((Name)object).getString())) continue;
                        this.mapNAPTRtransportToSRVprotocol((NAPTRRecord)object2, sRVRecord);
                        if (this._SRVResponses[this._NAPTRResponses.indexOf(object2)].isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "StateMachine: checkSRV: insert into empty list");
                            }
                            this._SRVResponses[this._NAPTRResponses.indexOf(object2)].insertElementAt(sRVRecord, 0);
                            continue block0;
                        }
                        int n = 0;
                        Enumeration<SRVRecord> enumeration3 = this._SRVResponses[this._NAPTRResponses.indexOf(object2)].elements();
                        while (enumeration3.hasMoreElements()) {
                            SRVRecord sRVRecord2 = enumeration3.nextElement();
                            n = this._SRVResponses[this._NAPTRResponses.indexOf(object2)].indexOf(sRVRecord2);
                            if (sRVRecord.getPriority() == sRVRecord2.getPriority()) {
                                if (sRVRecord.getWeight() >= sRVRecord2.getWeight()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "StateMachine: checkSRV: insert same pri higher weight");
                                    }
                                    this._SRVResponses[this._NAPTRResponses.indexOf(object2)].insertElementAt(sRVRecord, n);
                                    break;
                                }
                                this._SRVResponses[this._NAPTRResponses.indexOf(object2)].insertElementAt(sRVRecord, n + 1);
                                if (!tc.isDebugEnabled()) break;
                                Tr.debug(tc, "StateMachine: checkSRV: insert same pri lower weight");
                                break;
                            }
                            if (sRVRecord.getPriority() >= sRVRecord2.getPriority()) continue;
                            this._SRVResponses[this._NAPTRResponses.indexOf(object2)].insertElementAt(sRVRecord, n);
                            break;
                        }
                        if (this._SRVResponses[this._NAPTRResponses.indexOf(object2)].contains(sRVRecord)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "StateMachine: checkSRV: insert at the end of list");
                        }
                        this._SRVResponses[this._NAPTRResponses.indexOf(object2)].insertElementAt(sRVRecord, n + 1);
                    }
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: checkSRV: checking SRV with NO NAPTR");
                }
                if (this.validateSRVServiceAndProtocol(sRVRecord)) continue;
                if (this._SRVResponses[0].isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "StateMachine: checkSRV: no NAPTR insert into empty list");
                    }
                    this._SRVResponses[0].insertElementAt(sRVRecord, 0);
                    continue;
                }
                int n = 0;
                object2 = this._SRVResponses[0].elements();
                while (object2.hasMoreElements()) {
                    object = (SRVRecord)object2.nextElement();
                    n = this._SRVResponses[0].indexOf(object);
                    if (sRVRecord.getPriority() == ((SRVRecord)object).getPriority()) {
                        if (sRVRecord.getWeight() >= ((SRVRecord)object).getWeight()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "StateMachine: checkSRV: same pri higher weight");
                            }
                            this._SRVResponses[0].insertElementAt(sRVRecord, n);
                            break;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "StateMachine: checkSRV: same pri lower weight");
                        }
                        this._SRVResponses[0].insertElementAt(sRVRecord, n + 1);
                        break;
                    }
                    if (sRVRecord.getPriority() >= ((SRVRecord)object).getPriority()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "StateMachine: checkSRV: lower priority");
                    }
                    this._SRVResponses[0].insertElementAt(sRVRecord, n);
                    break;
                }
                if (this._SRVResponses[0].contains(sRVRecord)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: checkSRV: insert at the end of list");
                }
                this._SRVResponses[0].insertElementAt(sRVRecord, n + 1);
            }
            boolean bl = false;
            bl = this._dnsRequests.isEmpty();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: checkSRV: exit: id=" + this.hashCode());
            }
            return bl;
        }

        private boolean validateSRVServiceAndProtocol(SRVRecord sRVRecord) {
            String string;
            String string2;
            boolean bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: validateSRVServiceAndProtocol: entry: id=" + this.hashCode());
            }
            if (!(string2 = sRVRecord.getService()).startsWith("_sip") && !string2.startsWith("_sips")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: validateSRVServiceAndProtocol: Invalid service " + string2);
                }
                bl = true;
            }
            if (SipURILookupImpl.this._scheme.startsWith(SipURILookupImpl.SIPS) && !string2.startsWith("_sips")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: validateSRVServiceAndProtocol: Non-Secure service");
                }
                bl = true;
            }
            if (!((string = sRVRecord.getProtocol()).equals("_udp") || string.equals("_tcp") || string.equals("_sctp"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "StateMachine: validateSRVServiceAndProtocol: Invalid protocol " + string);
                }
                bl = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: validateSRVServiceAndProtocol: exit: id=" + this.hashCode());
            }
            return bl;
        }

        private void handleEvent(SipResolverEvent sipResolverEvent) {
            DnsMessage dnsMessage = sipResolverEvent.getResponse();
            DnsMessage dnsMessage2 = this.getDnsRequest(dnsMessage);
            if (dnsMessage2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "StateMachine: handleSipResolverEvent: exit: No matching request id=" + this.hashCode());
                }
                return;
            }
            this._dnsRequests.remove(dnsMessage2);
            int n = 0;
            for (int i = 0; i < this.mapper.length; ++i) {
                if (!Dns.TYPESTRING[dnsMessage.getQtype()].equals(this.mapper[i])) continue;
                n = i;
                break;
            }
            if (dnsMessage.isRCODEError()) {
                ++n;
            }
            this.runMachine(n, dnsMessage);
        }

        protected DnsMessage getDnsRequest(DnsMessage dnsMessage) {
            DnsMessage dnsMessage2 = null;
            Enumeration<DnsMessage> enumeration = this._dnsRequests.elements();
            while (enumeration.hasMoreElements() && (dnsMessage2 = enumeration.nextElement()).getId() != dnsMessage.getId()) {
            }
            return dnsMessage2;
        }

        protected void cancelRequests() {
            Enumeration<DnsMessage> enumeration = this._dnsRequests.elements();
            while (enumeration.hasMoreElements()) {
                DnsMessage dnsMessage = enumeration.nextElement();
                SipResolverService.getResolver().cancelRequest(dnsMessage);
            }
        }

        public void constructAnswer() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StateMachine: constructAnswer: entry: id=" + this.hashCode());
            }
            switch (((SipURILookupImpl)SipURILookupImpl.this)._fsm.initAction) {
                case 0: {
                    break;
                }
                case 1: {
                    SipURILookupImpl.this._fsm.fillSRVAnswer();
                    break;
                }
                case 2: {
                    SipURILookupImpl.this._fsm.fillSRVAnswer();
                    break;
                }
                case 3: {
                    SipURILookupImpl.this._fsm.fillAAnswer();
                    break;
                }
            }
            if (tc.isDebugEnabled()) {
                ListIterator listIterator = SipURILookupImpl.this._answerList.listIterator();
                while (listIterator.hasNext()) {
                    SIPUri sIPUri = (SIPUri)listIterator.next();
                    Tr.debug(tc, "StateMachine: completeAnswer: SIPUri number  " + (listIterator.nextIndex() - 1));
                    Tr.debug(tc, "StateMachine: completeAnswer: SIPUri " + sIPUri.getScheme() + ":" + sIPUri.getUserInfo() + "@" + sIPUri.getHost() + ":" + sIPUri.getPort() + ";" + sIPUri.getTransport());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StateMachine: completeAnswer: exit: id=" + this.hashCode());
            }
        }

        private boolean haveSRVResponses() {
            boolean bl = false;
            if (this._SRVResponses != null && !this._SRVResponses[0].isEmpty()) {
                bl = true;
            }
            return bl;
        }

        class e {
            Method action;
            int nextState;

            e(Method method2, int n) {
                this.action = method2;
                this.nextState = n;
            }
        }
    }

    private class UriExpirationTimerTask
    extends TimerTask {
        private UriExpirationTimerTask() {
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UriExpirationTimerTask: run: entry: id=" + this.hashCode());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UriExpirationTimerTask: run: Removing request " + SipURILookupImpl.this._suri.getBaseSIPUri() + " from the SipUResolverLookupCache");
            }
            SipURILookupImpl.this._lookupCache.remove(SipURILookupImpl.this.getSipURI());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "UriExpirationTimerTask: run: exit: id=" + this.hashCode());
            }
        }
    }

    private class RequestTimeoutTimerTask
    extends TimerTask {
        private RequestTimeoutTimerTask() {
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RequestTimeoutTimerTask: run: entry: id=" + this.hashCode());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestTimeoutTimerTask: run: Message timeout occurred. Cancelling request for " + SipURILookupImpl.this._suri.getBaseSIPUri());
            }
            SipURILookupImpl.this._fsm.cancelRequests();
            SIPUri sIPUri = SipURILookupImpl.this.getSipURI();
            SipURILookupImpl.this._sll.error(SipURILookupImpl.this, new SipURILookupException(SipURILookupException.LOOKUP_TIMEOUT + sIPUri.getBaseSIPUri()));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RequestTimeoutTimerTask: run: exit: id=" + this.hashCode());
            }
        }
    }
}

