/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.quorum;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sip.quorum.SIPQuorumGroupCallback;
import com.ibm.ws.sip.quorum.SIPQuorumStateListener;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.FileNotFoundException;
import java.util.HashMap;
import org.eclipse.emf.ecore.resource.Resource;

public class SIPQuorumComponentImpl
extends WsComponentImpl {
    private static final TraceComponent tc = Tr.register(SIPQuorumComponentImpl.class, "SIPQuorum", "com.ibm.ws.sip.quorum.resources.sipquorum");
    protected static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    public HAGroup quorumHAGroup = null;
    private SIPQuorumGroupCallback grpCallback = null;
    public static boolean quorumSupportEnabled = false;
    private String _processType = null;
    private String _serverType = null;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (isZOS) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize() not supported on zOS.");
            }
            return;
        }
        String string = Config.getCoreGroupProperty("SIP_QUORUM_ENABLED");
        if (null != string) {
            quorumSupportEnabled = new Boolean(string);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        this._processType = adminService.getProcessType();
        this._serverType = adminService.getServerType();
        if (quorumSupportEnabled) {
            block12: {
                block11: {
                    if (tc.isInfoEnabled()) {
                        Tr.info(tc, "CWSQ0001I");
                    }
                    try {
                        WsServiceRegistry.addService((Object)this, (Class)SIPQuorumComponentImpl.class);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "initialize", "1010");
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Caught:  " + exception);
                    }
                }
                try {
                    SIPQuorumComponentImpl sIPQuorumComponentImpl = (SIPQuorumComponentImpl)WsServiceRegistry.getService((Object)this, (Class)SIPQuorumComponentImpl.class);
                    if (tc.isDebugEnabled() && null == sIPQuorumComponentImpl) {
                        Tr.debug(tc, "Test failed to access SIPQuorum after addservice.");
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Test failed to access SIPQuorum after addservice. Caught: " + exception);
                }
            }
            this.grpCallback = new SIPQuorumGroupCallback(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize() Process: " + this._processType + "  Server: " + this._serverType);
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        block31: {
            GroupName groupName;
            GroupManager groupManager;
            block30: {
                String string;
                CoreStack coreStack;
                block29: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "start()");
                    }
                    if (isZOS) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "start() not supported on zOS.");
                        }
                        return;
                    }
                    if (!quorumSupportEnabled) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "start() Quorum support not enabled.");
                        }
                        return;
                    }
                    if (!this._processType.equals("ManagedProcess")) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "start()  " + this._processType + " does not participate in Quorum.");
                        }
                        return;
                    }
                    coreStack = null;
                    groupManager = null;
                    groupName = null;
                    string = null;
                    try {
                        string = !this._serverType.equals("PROXY_SERVER") && !this._serverType.equals("ONDEMAND_ROUTER") ? this.lookupAppServerCluster() : this.lookupProxyServerCluster();
                        if (null != string) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "SIP Quorum cluster: " + string);
                            }
                            break block29;
                        }
                        if (tc.isInfoEnabled()) {
                            Tr.warning(tc, "CWSQ0003W");
                        }
                        return;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "start", "1020");
                        if (!tc.isDebugEnabled()) break block29;
                        Tr.debug(tc, "Caught:  " + exception);
                    }
                }
                try {
                    coreStack = (CoreStack)WsServiceRegistry.getService((Object)this, (Class)CoreStack.class);
                    if (coreStack != null) {
                        groupManager = coreStack.getGroupManager();
                        if (groupManager != null) {
                            HashMap<String, String> hashMap = new HashMap<String, String>(2);
                            hashMap.put("IBM_hc", string);
                            hashMap.put("policy", "AllActiveQuorumPolicy");
                            hashMap.put("type", "SIP_QUORUM");
                            groupName = groupManager.createGroupName(hashMap);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "GroupManager is null. Unable to create a group.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CoreStack is null. Unable to create a group.");
                    }
                }
                catch (HAException hAException) {
                    FFDCFilter.processException(hAException, SIPQuorumComponentImpl.class.getName() + "start", "1030");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HA Manager exception when creating group.\n Caught: " + hAException);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "start", "1040");
                    if (!tc.isDebugEnabled()) break block30;
                    Tr.debug(tc, "Caught: " + exception);
                }
            }
            try {
                if (groupManager != null && groupName != null) {
                    this.quorumHAGroup = groupManager.joinGroup(groupName, new HashMap(), this.grpCallback);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Joined the HAGroup successfully\n                                    " + this.quorumHAGroup.toString());
                    }
                }
            }
            catch (HAException hAException) {
                FFDCFilter.processException(hAException, SIPQuorumComponentImpl.class.getName() + "start", "1050");
                if (tc.isErrorEnabled()) {
                    Tr.warning(tc, "HA Manager exception when joining group.\n Caused= " + hAException);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "start", "1060");
                if (!tc.isErrorEnabled()) break block31;
                Tr.error(tc, "Attempted to join group and caught:  " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start() success");
        }
    }

    public void stop() {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stop");
            }
            if (isZOS) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stop() not supported on zOS.");
                }
                return;
            }
            if (!quorumSupportEnabled) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stop() Quorum support not enabled.");
                }
                return;
            }
            if (!this._processType.equals("ManagedProcess")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stop()  " + this._processType + " does not participate in Quorum.");
                }
                return;
            }
            try {
                if (this.quorumHAGroup != null) {
                    this.quorumHAGroup.leave();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "quorumHAGroup is null.");
                }
            }
            catch (HAException hAException) {
                FFDCFilter.processException(hAException, SIPQuorumComponentImpl.class.getName() + "stop", "1070");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Group membership not removed properly.\n Caught: " + hAException);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "stop", "1080");
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Unable to leave group.\n Caught: " + exception);
            }
        }
        this.quorumHAGroup = null;
        if (this.grpCallback != null) {
            this.grpCallback.stop();
            this.grpCallback = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destory() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    private String lookupAppServerCluster() {
        String string;
        block9: {
            Repository repository2;
            Resource resource;
            String string2;
            block8: {
                string = null;
                string2 = null;
                resource = null;
                repository2 = null;
                try {
                    repository2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "lookupAppServerCluster", "1100");
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "SIPQuorumComponent Registry getService Failed :" + exception);
                    return string;
                }
            }
            try {
                if (string2 == null) {
                    resource = repository2.getConfigRoot().getResource(2, "cluster.xml");
                    ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
                    string = serverCluster.getName();
                } else {
                    string = string2;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                string = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIPQuorumComponent:  Application Server cluster not found in configuration: " + fileNotFoundException);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "lookupAppServerCluster", "1110");
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Caught:  " + exception);
            }
        }
        return string;
    }

    private String lookupProxyServerCluster() {
        Resource resource;
        String string;
        block8: {
            string = null;
            resource = null;
            Repository repository2 = null;
            try {
                repository2 = (Repository)WsServiceRegistry.getService((Object)this, (Class)Repository.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "lookupProxyServerCluster", "1120");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIPQuorumComponent Registry getService Failed :" + exception);
                }
                return string;
            }
            try {
                resource = repository2.getConfigRoot().getResource(2, "cluster.xml");
            }
            catch (FileNotFoundException fileNotFoundException) {
                resource = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SIPQuorumComponent:  Proxy Server cluster not found in configuration: " + fileNotFoundException);
                }
            }
            catch (Exception exception) {
                resource = null;
                FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "lookupProxyServerCluster", "1130");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "SIPQuorumComponent:  Proxy cluster lookup caught: " + exception);
            }
        }
        if (resource != null) {
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            string = serverCluster.getName();
        }
        return string;
    }

    public boolean isMemberActive() {
        block6: {
            if (isZOS || !quorumSupportEnabled) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Return TRUE; Is ZOS, or Quorum support is not enabled.");
                }
                return true;
            }
            try {
                if (quorumSupportEnabled && this.grpCallback != null) {
                    return this.grpCallback.isMemberActive();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, SIPQuorumComponentImpl.class.getName() + "isProxyMemberActive", "1150");
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Caught:  " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Return FALSE; Quorum GroupCallback is not available.");
        }
        return false;
    }

    public void registerQuorumStateListener(SIPQuorumStateListener sIPQuorumStateListener) {
        if (this.grpCallback != null) {
            this.grpCallback.registerQSListener(sIPQuorumStateListener);
        }
    }
}

