/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.quorum;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.quorum.SIPQuorumComponentImpl;
import com.ibm.ws.sip.quorum.SIPQuorumStateListener;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import java.util.Enumeration;
import java.util.Vector;

public class SIPQuorumGroupCallback
implements HAGroupCallback {
    private static final TraceComponent tc = Tr.register(SIPQuorumGroupCallback.class, "SIPQuorum", "com.ibm.ws.sip.quorum.resources.sipquorum");
    private SIPQuorumComponentImpl quorum = null;
    private boolean _isHealthy = true;
    private boolean _hasBeenActivated = false;
    private Vector qslListeners = null;
    private Object qslMutex;

    public SIPQuorumGroupCallback(SIPQuorumComponentImpl sIPQuorumComponentImpl) {
        this.quorum = sIPQuorumComponentImpl;
        this.qslListeners = new Vector(5);
        this.qslMutex = new Object();
    }

    public boolean isAlive(GroupName groupName) {
        return this._isHealthy;
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        block3: {
            try {
                asynchOperationComplete.success(object, null);
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                this._isHealthy = false;
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Member Deactivation did not complete. GroupName: " + groupName);
            }
        }
        this._hasBeenActivated = false;
        if (tc.isInfoEnabled()) {
            Tr.info(tc, "CWSQ0004I", groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        int n;
        block17: {
            n = 0;
            try {
                Object object2 = this.qslMutex;
                synchronized (object2) {
                    if (!this.qslListeners.isEmpty()) {
                        Enumeration enumeration = this.qslListeners.elements();
                        while (enumeration.hasMoreElements()) {
                            SIPQuorumStateListener sIPQuorumStateListener = (SIPQuorumStateListener)enumeration.nextElement();
                            this._isHealthy = sIPQuorumStateListener.quorumActivated();
                            if (!this._isHealthy) {
                                ++n;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Activation notification for Listener: " + sIPQuorumStateListener.toString());
                        }
                    }
                }
            }
            catch (Exception exception) {
                this._isHealthy = false;
                FFDCFilter.processException(exception, SIPQuorumGroupCallback.class.getName() + "memberIsActivated", "1000");
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "memberIsActivated - Caught: " + exception);
            }
        }
        try {
            if (this._isHealthy && n == 0) {
                asynchOperationComplete.success(object, null);
                this._hasBeenActivated = true;
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "CWSQ0002I", groupName);
                }
            } else {
                asynchOperationComplete.failed(object, "Activation failed to complete.", null);
                this._hasBeenActivated = false;
                if (tc.isInfoEnabled()) {
                    Tr.info(tc, "CWSQ0006W", groupName);
                }
            }
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            if (tc.isDebugEnabled() && this._isHealthy) {
                Tr.debug(tc, "memberIsActivated.success() rejected parameter. GroupName: " + groupName);
            } else {
                Tr.debug(tc, "memberIsActivated.failed() rejected parameter. GroupName: " + groupName);
            }
            this._isHealthy = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "memberIsActivated");
        }
    }

    public void memberMayActivate(GroupName groupName) {
    }

    public void memberMayActivateCancelled(GroupName groupName) {
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Membership has changed. Quorum should be recalculated.\nGroupName: " + groupName);
        }
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
    }

    public boolean isMemberActive() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SIP Quorum member active? " + new Boolean(this._hasBeenActivated).toString());
        }
        return this._hasBeenActivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQSListener(SIPQuorumStateListener sIPQuorumStateListener) {
        Object object = this.qslMutex;
        synchronized (object) {
            this.qslListeners.add(sIPQuorumStateListener);
        }
    }

    public void stop() {
        this.quorum = null;
    }
}

