/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.validation.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.validation.bundling.ValidationMessage;
import com.ibm.ws.sm.validation.CompositeValidator;
import com.ibm.ws.sm.validation.ContextValidationMessages;
import com.ibm.ws.sm.validation.DocumentValidationMessages;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManager;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.validation.ValidationPolicy;
import com.ibm.ws.sm.validation.impl.ValidationHelperImpl;
import com.ibm.ws.sm.validation.impl.ValidationManagerImpl;
import com.ibm.ws.sm.validation.impl.ValidatorValidationMessagesImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class CompositeValidatorImpl
implements CompositeValidator {
    public static final String pgmVersion = "1.11";
    public static final String pgmUpdate = "2/7/06";
    protected static TraceComponent tc = ValidationHelperImpl.register(CompositeValidatorImpl.class);
    protected Properties workSpaceProperties;
    protected WorkSpace workSpace;
    protected ValidationPolicy validationPolicy;
    protected ValidationManagerRegistry validationManagerRegistry;
    protected ValidationManager validationManager;
    protected IReporter reporter;
    protected ContextValidationMessages allMessages;

    protected CompositeValidatorImpl(Properties properties) {
        this.workSpaceProperties = properties;
        this.workSpace = null;
        this.validationPolicy = null;
        this.validationManagerRegistry = null;
        this.validationManager = null;
        this.reporter = null;
        this.allMessages = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateInto(IReporter iReporter) throws WorkSpaceException, ValidationManagerException {
        this.prepareWorkSpace();
        try {
            this.prepareManager();
            try {
                this.performValidation(iReporter);
                this.transferMessages(iReporter);
            }
            finally {
                this.completeManager();
            }
        }
        finally {
            this.completeWorkSpace();
        }
    }

    protected void prepareWorkSpace() throws WorkSpaceException {
        Object object;
        Enumeration<?> enumeration = this.workSpaceProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.transferProperty((String)object, this.workSpaceProperties);
        }
        object = WorkSpaceManagerFactory.getManager();
        this.workSpace = object.getWorkSpace("CMP_VMGR");
    }

    protected boolean transferProperty(String string, Properties properties) {
        String string2;
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "Property for composite validation:", string);
        }
        if ((string2 = (String)properties.get(string)) != null) {
            if (bl) {
                Tr.debug(tc, "Setting property value: ", string2);
            }
            System.setProperty(string, string2);
            return true;
        }
        if (bl) {
            Tr.debug(tc, "No override of property value.");
        }
        return false;
    }

    protected void completeWorkSpace() throws WorkSpaceException {
        this.workSpace.release();
        this.workSpace = null;
    }

    protected void prepareRegistry() throws ValidationManagerException {
        this.validationManagerRegistry = ValidationHelper.getRegistry();
    }

    protected void completeRegistry() {
        this.validationManagerRegistry = null;
    }

    protected void preparePolicy() throws ValidationManagerException {
        this.validationPolicy = ValidationHelper.createPolicy();
        this.validationPolicy.setIncludeCross(true);
        this.validationPolicy.setIncludeExtracted(false);
        this.validationPolicy.setIncludeParentChain(false);
        this.validationPolicy.setIncludeLocalSiblings(false);
        this.validationPolicy.setIncludeAll(false);
    }

    protected void completePolicy() {
        this.validationPolicy = null;
    }

    protected void prepareManager() throws ValidationManagerException {
        this.prepareRegistry();
        this.preparePolicy();
        this.validationManager = this.validationManagerRegistry.getValidationManager(this.workSpace, this.validationPolicy, true);
    }

    protected void completeManager() {
        this.validationManagerRegistry.release(this.validationManager);
        this.completePolicy();
        this.completeRegistry();
    }

    protected void performValidation(IReporter iReporter) {
        try {
            this.validationPolicy.setIncludeAll(true);
            this.validationPolicy.affectUpdate();
        }
        catch (ValidationManagerException validationManagerException) {
            this.handleValidationError(iReporter, validationManagerException);
        }
    }

    protected void handleValidationError(IReporter iReporter, ValidationManagerException validationManagerException) {
        String string;
        try {
            string = validationManagerException.toString();
        }
        catch (Exception exception) {
            string = validationManagerException.getClass().getName() + ": " + exception.getClass().getName();
        }
        String[] stringArray = new String[]{string};
        Tr.error(tc, "WSVM1041E", stringArray);
        ValidationMessage validationMessage = new ValidationMessage("com.ibm.ws.sm.validation.impl.ValidationManagerImplNLS", 1, "WSVM1041E", stringArray, null);
        iReporter.addMessage(null, (IMessage)validationMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferMessages(IReporter iReporter) {
        this.reporter = iReporter;
        try {
            this.allMessages = this.validationManager.getResults();
            try {
                this.transfer(this.workSpace.getRootContext());
            }
            finally {
                this.allMessages = null;
            }
        }
        finally {
            this.reporter = null;
        }
    }

    protected void transfer(RepositoryContext repositoryContext) {
        this.transferLocal(repositoryContext);
        this.transferChildren(repositoryContext);
    }

    protected void transferChildren(RepositoryContext repositoryContext) {
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            this.transfer(repositoryContext2);
        }
    }

    protected void transferLocal(RepositoryContext repositoryContext) {
        Iterator iterator = ValidationManagerImpl.getValidatableFiles(repositoryContext).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            this.transfer(workSpaceFile);
        }
    }

    protected void transfer(WorkSpaceFile workSpaceFile) {
        DocumentValidationMessages documentValidationMessages;
        boolean bl = tc.isDebugEnabled();
        String string = workSpaceFile.getURI();
        if (bl) {
            Tr.debug(tc, "Transferring messages for: ", string);
        }
        if ((documentValidationMessages = this.allMessages.getDocumentMessages(string)) == null) {
            return;
        }
        Iterator iterator = documentValidationMessages.getValidatorClassNames();
        while (iterator.hasNext()) {
            ValidatorValidationMessagesImpl validatorValidationMessagesImpl;
            String string2 = (String)iterator.next();
            if (bl) {
                Tr.debug(tc, "Transferring messages for validator: ", string2);
            }
            if ((validatorValidationMessagesImpl = (ValidatorValidationMessagesImpl)documentValidationMessages.getValidatorMessages(string2)) == null) continue;
            IValidator iValidator = validatorValidationMessagesImpl.getValidator();
            Iterator iterator2 = validatorValidationMessagesImpl.getMessages();
            while (iterator2.hasNext()) {
                IMessage iMessage = (IMessage)iterator2.next();
                this.reporter.addMessage(iValidator, iMessage);
            }
        }
    }
}

