/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.sm.workspace.impl.RepositoryContextAdapter;
import com.ibm.ws.sm.workspace.impl.RepositoryContextPluggable;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import java.util.HashMap;

public class RepositoryContextAdapterManager {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(RepositoryContextAdapterManager.class);
    private static ClassLoader classLoader = null;
    private static RepositoryContextAdapterManager manager = null;
    private HashMap maps;

    public static RepositoryContextAdapterManager getManager() {
        if (manager == null) {
            manager = new RepositoryContextAdapterManager();
        }
        return manager;
    }

    public RepositoryContextAdapter getAdapter(RepositoryContextPluggable repositoryContextPluggable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdapter, Context: " + repositoryContextPluggable);
        }
        this.initMap(repositoryContextPluggable.getWorkSpace().getMetaData());
        String string = (String)this.maps.get(repositoryContextPluggable.getType());
        RepositoryContextAdapter repositoryContextAdapter = null;
        if (string != null) {
            repositoryContextAdapter = this.createAdapter(string);
        }
        if (repositoryContextAdapter == null) {
            repositoryContextAdapter = this.getDefaultAdapter();
        }
        repositoryContextAdapter.setContext(repositoryContextPluggable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdapter, Context: " + repositoryContextPluggable + ", Adapter: " + repositoryContextAdapter);
        }
        return repositoryContextAdapter;
    }

    private void initMap(RepositoryMetaData repositoryMetaData) {
        if (this.maps == null) {
            this.maps = new HashMap();
        }
    }

    private RepositoryContextAdapter getDefaultAdapter() {
        return new RepositoryContextAdapter();
    }

    private RepositoryContextAdapter createAdapter(String string) {
        try {
            return (RepositoryContextAdapter)this.getInstanceOfType(string);
        }
        catch (Exception exception) {
            Tr.debug(tc, "unable to instantiate adapter class", exception);
            return null;
        }
    }

    private ClassLoader getClassLoader() {
        if (classLoader == null) {
            classLoader = ExtClassLoader.getInstance();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    Class getClassOfType(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassOfType", new Object[]{string});
        }
        Class<?> clazz = null;
        clazz = Class.forName(string, true, this.getClassLoader());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassOfType");
        }
        return clazz;
    }

    private Object getInstanceOfType(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstanceOfType", new Object[]{string});
        }
        Class clazz = this.getClassOfType(string);
        Object t = clazz.newInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstanceOfType", t);
        }
        return t;
    }
}

