/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.ConflictState;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceContextState;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.ZosValidationException;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextAdapter;
import com.ibm.ws.sm.workspace.impl.RepositoryContextAdapterManager;
import com.ibm.ws.sm.workspace.impl.RepositoryContextPluggable;
import com.ibm.ws.sm.workspace.impl.SystemModifiedFiles;
import com.ibm.ws.sm.workspace.impl.WorkSpaceCatalogManager;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceEventImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceFileImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.impl.WorkSpacePersistentObjectImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceResourceSet;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.migration.MOFContextImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class RepositoryContextImpl
extends MOFContextImpl
implements RepositoryContextPluggable,
WorkSpaceConstant,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(RepositoryContextImpl.class);
    private ResourceBundle resBundle = ResourceBundle.getBundle("com.ibm.ws.sm.workspace.impl.workspace_NLS");
    private WorkSpacePersistentObjectImpl data;
    private String relativeURI;
    private String fullPath;
    private String fullURI;
    private boolean needTrace = true;
    private int childTypesToLoad = 0;
    protected RepositoryContextType type;
    protected RepositoryContext parent = null;
    protected WorkSpaceImpl workSpace = null;
    protected RepositoryContextAdapter adapter = null;
    private boolean fullFileList = false;
    protected HashMap files = new HashMap();
    protected HashMap childTypeMap = new HashMap();
    protected List children = new ArrayList();

    public RepositoryContextImpl(WorkSpace workSpace, RepositoryContextType repositoryContextType, String string, RepositoryContext repositoryContext) {
        super(workSpace);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RepositoryContextImpl", new Object[]{workSpace, repositoryContextType, string, repositoryContext});
        }
        this.workSpace = (WorkSpaceImpl)workSpace;
        this.type = repositoryContextType;
        this.setParent(repositoryContext);
        this.data = new WorkSpacePersistentObjectImpl(string);
        this.setState(WorkSpaceContextState.UPDATED_UNLOADED);
        this.initChildTypesToLoad();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RepositoryContextImpl");
        }
    }

    private void loadContext() throws WorkSpaceException {
        RepositoryContextType repositoryContextType = null;
        if (this.getState().equals(WorkSpaceContextState.UPDATED_UNLOADED)) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "> loadContext, all types, Context: (" + this.getState() + ") " + this.getURI());
            }
            Iterator iterator = this.getType().getChildContextTypes().iterator();
            while (iterator.hasNext()) {
                repositoryContextType = (RepositoryContextType)iterator.next();
                this.loadContext(repositoryContextType, false);
            }
            if (repositoryContextType == null && this.childTypesToLoad == 0) {
                this.setState(WorkSpaceContextState.UPDATED_LOADED);
            }
            this.save(false, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "< loadContext, all types, Context: (" + this.getState() + ") " + this.getURI());
            }
        }
    }

    private void loadContext(RepositoryContextType repositoryContextType, boolean bl) throws WorkSpaceException {
        ChildrenMap childrenMap = this.getChildTypeMap(repositoryContextType.getName());
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "> loadContext,type: " + repositoryContextType.getName() + " (" + childrenMap.full + "), Context: (" + this.getState() + ") " + this.getURI() + " [" + this.childTypesToLoad + "]");
        }
        if (this.getState().equals(WorkSpaceContextState.UPDATED_UNLOADED) && !childrenMap.full) {
            Map map = this.getAdapter().getChildContextsInRepository(repositoryContextType);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                RepositoryContextImpl repositoryContextImpl = this.loadLocal(repositoryContextType, string, string2, false);
            }
            this.setChildTypeToLoaded(childrenMap);
            if (bl) {
                this.save(false, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "< loadContext,type: " + repositoryContextType.getName() + " (" + childrenMap.full + "), Context: (" + this.getState() + ") " + this.getURI() + " [" + this.childTypesToLoad + "]");
        }
    }

    private void disableSave() {
        this.workSpace.disableSave();
    }

    private void enableSave() {
        this.workSpace.enableSave();
    }

    private boolean isEnableSave() {
        return this.workSpace.isEnableSave();
    }

    public Map checkSynchState() throws WorkSpaceException {
        WorkSpaceRepositoryAdapter workSpaceRepositoryAdapter = this.getRepositoryAdapter();
        if (workSpaceRepositoryAdapter instanceof WorkSpaceMasterRepositoryAdapter && ((WorkSpaceMasterRepositoryAdapter)workSpaceRepositoryAdapter).isSelfCorrection()) {
            Collection collection = this.findContext(this.workSpace.getMetaData().getContextType("servers"));
            Collection collection2 = this.findContext(this.workSpace.getMetaData().getContextType("deployments"));
        }
        return this.checkSynchState(false);
    }

    public Map checkSynchStateForRefresh() throws WorkSpaceException {
        WorkSpaceRepositoryAdapter workSpaceRepositoryAdapter = this.getRepositoryAdapter();
        if (workSpaceRepositoryAdapter instanceof WorkSpaceMasterRepositoryAdapter && ((WorkSpaceMasterRepositoryAdapter)workSpaceRepositoryAdapter).isSelfCorrection()) {
            Collection collection = this.findContext(this.workSpace.getMetaData().getContextType("servers"));
            Collection collection2 = this.findContext(this.workSpace.getMetaData().getContextType("deployments"));
        }
        return this.checkSynchStateForRefresh(false);
    }

    Map checkSynchState(boolean bl) throws WorkSpaceException {
        this.workSpace.checkValid();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Object[] objectArray = this.getAllFiles().iterator();
        while (objectArray.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)objectArray.next();
            Integer n = this.checkSynchState(workSpaceFileImpl);
            if (n == ConflictState.UN_MODIFIED) continue;
            hashMap.put(workSpaceFileImpl.getURI(), n);
        }
        objectArray = this.children.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Map map = ((RepositoryContextImpl)objectArray[i]).checkSynchState(bl);
            if (map.size() <= 0) continue;
            hashMap.putAll(map);
        }
        return hashMap;
    }

    Map checkSynchStateForRefresh(boolean bl) throws WorkSpaceException {
        this.workSpace.checkValid();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Object[] objectArray = this.getAllFiles().iterator();
        while (objectArray.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)objectArray.next();
            Integer n = this.checkSynchStateForRefresh(workSpaceFileImpl);
            if (n == ConflictState.UN_MODIFIED) continue;
            hashMap.put(workSpaceFileImpl.getURI(), n);
        }
        objectArray = this.children.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Map map = ((RepositoryContextImpl)objectArray[i]).checkSynchStateForRefresh(bl);
            if (map.size() <= 0) continue;
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private Integer checkSynchState(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        return this.getRepositoryAdapter().checkSynchState(workSpaceFile);
    }

    private Integer checkSynchStateForRefresh(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        WorkSpaceRepositoryAdapter workSpaceRepositoryAdapter = this.getRepositoryAdapter();
        if (workSpaceRepositoryAdapter instanceof WorkSpaceMasterRepositoryAdapter) {
            return ((WorkSpaceMasterRepositoryAdapter)workSpaceRepositoryAdapter).checkSynchStateForRefresh(workSpaceFile);
        }
        return workSpaceRepositoryAdapter.checkSynchState(workSpaceFile);
    }

    void clearAll() {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            repositoryContextImpl.clearAll();
        }
        this.setState(WorkSpaceContextState.NONE);
        this.clearLocalFile(null);
    }

    private void clearLocalFile(List list) {
        if (list == null) {
            this.getAllFiles().clear();
        } else {
            this.getAllFiles().removeAll(list);
        }
        this.fullFileList = false;
    }

    void finalizeAll() throws WorkSpaceException {
        ArrayList<RepositoryContextImpl> arrayList = new ArrayList<RepositoryContextImpl>();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            if (repositoryContextImpl.getState().equals(WorkSpaceContextState.NONE)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CHILD: " + repositoryContextImpl.getURI() + " is NONE!!");
                }
                arrayList.add(repositoryContextImpl);
                this.getChildTypeMap((String)repositoryContextImpl.getType().getName()).map.remove(repositoryContextImpl.getName());
            }
            repositoryContextImpl.finalizeAll();
        }
        this.children.removeAll(arrayList);
    }

    public RepositoryContext create(RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create (type: " + repositoryContextType.getName() + ", name: " + string + ")");
        }
        String string2 = this.getAdapter().getChildContextURI(repositoryContextType, string);
        RepositoryContext repositoryContext = this.create(repositoryContextType, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create (type: " + repositoryContextType.getName() + ", name: " + string + ") return: " + repositoryContext);
        }
        return repositoryContext;
    }

    public RepositoryContext create(RepositoryContextType repositoryContextType, String string, String string2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create (type: " + repositoryContextType.getName() + ", name: " + string + ", relativeUri: " + string2 + ")");
        }
        this.workSpace.checkValid();
        RepositoryContextImpl repositoryContextImpl = this.createLocal(repositoryContextType, string, string2);
        repositoryContextImpl.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create (type: " + repositoryContextType.getName() + ", name: " + string + ", relativeUri: " + string2 + ") return: " + repositoryContextImpl);
        }
        return repositoryContextImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RepositoryContextImpl createLocal(RepositoryContextType repositoryContextType, String string, String string2) throws WorkSpaceException {
        ChildrenMap childrenMap = this.getChildTypeMap(repositoryContextType.getName());
        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)childrenMap.map.get(string);
        if (repositoryContextImpl != null) {
            if (repositoryContextImpl.isDeleted()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createLocal, Context: (" + repositoryContextImpl.getState() + ") " + repositoryContextImpl.getURI() + " @" + Integer.toHexString(repositoryContextImpl.hashCode()) + " reusing deleted context.");
                }
                repositoryContextImpl.setState(WorkSpaceContextState.ADDED);
                repositoryContextImpl.initChildTypesToLoad();
                return repositoryContextImpl;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createLocal, Context: (" + repositoryContextImpl.getState() + ") " + repositoryContextImpl.getURI() + " already created.");
            }
            throw WorkSpaceLogger.createException(tc, "WKSP0003E Context {0} already exists", new Object[]{string});
        }
        String string3 = this.getURI().length() > 0 ? this.getURI() + '/' + string2 : string2;
        if (!this.getRepositoryAdapter().exist(this.workSpace, string3)) {
            repositoryContextImpl = new RepositoryContextImpl(this.workSpace, repositoryContextType, string, this);
            childrenMap.map.put(string, repositoryContextImpl);
            this.children.add(repositoryContextImpl);
            repositoryContextImpl.setRelativeURI(string2);
            repositoryContextImpl.setState(WorkSpaceContextState.ADDED);
            this.save(false, false);
            if (!tc.isDebugEnabled()) return repositoryContextImpl;
            Tr.debug(tc, "createLocal, Context: (" + repositoryContextImpl.getState() + ") " + repositoryContextImpl.getURI() + " @" + Integer.toHexString(repositoryContextImpl.hashCode()));
            return repositoryContextImpl;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createLocal, Context: " + string3 + " already exist in master repository.");
        }
        throw WorkSpaceLogger.createException(tc, "WKSP0003E Context {0} already exists", new Object[]{string});
    }

    private RepositoryContextImpl loadLocal(RepositoryContextType repositoryContextType, String string, String string2, boolean bl) throws WorkSpaceException {
        ChildrenMap childrenMap = this.getChildTypeMap(repositoryContextType.getName());
        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)childrenMap.map.get(string);
        if (repositoryContextImpl != null) {
            if (!repositoryContextImpl.isDeleted() && tc.isDebugEnabled()) {
                Tr.debug(tc, " loadLocal,Context: (" + repositoryContextImpl.getState() + ") " + repositoryContextImpl.getURI() + " @" + Integer.toHexString(repositoryContextImpl.hashCode()) + " already loaded.");
            }
        } else {
            String string3 = this.getURI().length() > 0 ? this.getURI() + '/' + string2 : string2;
            if (this.getRepositoryAdapter().exist(this.workSpace, string3)) {
                repositoryContextImpl = new RepositoryContextImpl(this.workSpace, repositoryContextType, string, this);
                childrenMap.map.put(string, repositoryContextImpl);
                this.children.add(repositoryContextImpl);
                repositoryContextImpl.setRelativeURI(string2);
                repositoryContextImpl.setOldState(repositoryContextImpl.getState());
                if (bl) {
                    this.save(false, false);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " loadLocal,Context: (" + repositoryContextImpl.getState() + ") " + repositoryContextImpl.getURI() + " @" + Integer.toHexString(repositoryContextImpl.hashCode()));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, " loadLocal,Context: (" + WorkSpaceContextState.NONE + ") " + string3 + " doesn't exist in master repository.");
            }
        }
        return repositoryContextImpl;
    }

    void setRelativeURI(String string) {
        this.relativeURI = string;
        this.fullPath = null;
        this.fullURI = null;
        this.getWorkSpaceResourceSet().refreshPath();
    }

    public synchronized void delete(String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (" + string + ")");
        }
        this.workSpace.checkValid();
        this.deleteOnly(string);
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete (" + string + ")");
        }
    }

    private synchronized void deleteOnly(String string) throws WorkSpaceException {
        String string2 = string.replace(FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(string2)) {
            this.extractOnly(string2, false);
            this.getWorkSpaceResourceSet().release(string);
            this.notifyChangedOnly(2, string2);
        }
    }

    private WorkSpaceResourceSet getWorkSpaceResourceSet() {
        return (WorkSpaceResourceSet)this.getResourceSet();
    }

    public synchronized void delete(boolean bl) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (deep: " + bl + ")");
        }
        this.workSpace.checkValid();
        this.disableSave();
        this.deleteOnly(bl);
        this.enableSave();
        this.save(bl, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete (deep: " + bl + ")");
        }
    }

    void deleteOnly(boolean bl) throws WorkSpaceException {
        WorkSpaceConstant workSpaceConstant;
        Iterator iterator;
        this.loadContext();
        if (bl) {
            iterator = this.children.iterator();
            while (iterator.hasNext()) {
                workSpaceConstant = (RepositoryContextImpl)iterator.next();
                ((RepositoryContextImpl)workSpaceConstant).deleteOnly(bl);
            }
        }
        this.checkFullList();
        iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            workSpaceConstant = (WorkSpaceFileImpl)iterator.next();
            this.deleteOnly(((WorkSpaceFileImpl)workSpaceConstant).getName());
        }
        this.setState(WorkSpaceContextState.DELETED);
        this.delete();
    }

    private void checkFullList() throws WorkSpaceException {
        if (this.fullFileList) {
            return;
        }
        this.fullFileList = true;
        this.loadContext();
        String[] stringArray = this.getRepositoryAdapter().getCatalog(this.workSpace, this.getURI(), 1, -1);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addLocalFile(stringArray[i]);
        }
    }

    private void addLocalFile(String string) throws WorkSpaceException {
        boolean bl = true;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            if (!string.startsWith(repositoryContextImpl.getRelativeURI())) continue;
            bl = false;
            break;
        }
        if (bl && this.getFileForRebuild(string) == null) {
            this.setFileState(string, WorkSpaceFileState.CLEAN);
        }
    }

    public synchronized void extract(String string, boolean bl) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract (name: " + string + ", overwrite: " + new Boolean(bl) + ")");
        }
        this.workSpace.checkValid();
        this.extractOnly(string, bl);
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract (name: " + string + ", overwrite: " + new Boolean(bl) + ")");
        }
    }

    private synchronized void extractOnly(String string, boolean bl) throws WorkSpaceException {
        WorkSpaceFileImpl workSpaceFileImpl;
        String string2 = string.replace(FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(string2) && (!this.isExtracted(string2) || bl) && (workSpaceFileImpl = this.getFileForRebuild(string2)).getState() != WorkSpaceFileState.ADDED) {
            this.extract(workSpaceFileImpl);
            this.notifyChangedOnly(3, workSpaceFileImpl.getName());
        }
    }

    public synchronized void extract(boolean bl) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract (overwrite: " + new Boolean(bl) + ")");
        }
        this.workSpace.checkValid();
        this.checkFullList();
        Iterator iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)iterator.next();
            this.extractOnly(workSpaceFileImpl.getName(), bl);
        }
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract (overwrite: " + new Boolean(bl) + ")");
        }
    }

    private void extract(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        AdminAuthorizer adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (adminAuthorizer != null && adminAuthorizer.isFineGrainedAdminSecurity() && !adminAuthorizer.checkAccess(workSpaceFile.getURI(), "monitor")) {
            return;
        }
        this.getRepositoryAdapter().extract(workSpaceFile);
    }

    private void setTrace(boolean bl) {
        this.needTrace = bl;
    }

    public Collection findContext(RepositoryContextType repositoryContextType) throws WorkSpaceException {
        if (tc.isEntryEnabled() && this.needTrace) {
            Tr.entry(tc, "findContext (type: " + repositoryContextType.getName() + "), from " + this.getURI());
        }
        ArrayList arrayList = new ArrayList();
        RepositoryContextImpl repositoryContextImpl = null;
        String string = repositoryContextType.getName();
        RepositoryContextType repositoryContextType2 = this.getType();
        Set set = repositoryContextType2.findReachableChildrenTo(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            List list;
            RepositoryContextType repositoryContextType3 = (RepositoryContextType)iterator.next();
            if (repositoryContextType3.getName().equals(string)) {
                list = this.getChildren(repositoryContextType3);
                if (list.size() <= 0) continue;
                arrayList.addAll(list);
                continue;
            }
            list = this.getChildren(repositoryContextType3);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                repositoryContextImpl = (RepositoryContextImpl)iterator2.next();
                repositoryContextImpl.setTrace(false);
                Collection collection = repositoryContextImpl.findContext(repositoryContextType);
                repositoryContextImpl.setTrace(true);
                if (collection.size() <= 0) continue;
                arrayList.addAll(collection);
            }
        }
        if (tc.isEntryEnabled() && this.needTrace) {
            Tr.exit(tc, "findContext (type: " + repositoryContextType.getName() + "), from " + this.getURI() + ", return: " + arrayList);
        }
        return arrayList;
    }

    public Collection findContext(String string, String string2) throws WorkSpaceException {
        if (tc.isEntryEnabled() && this.needTrace) {
            Tr.entry(tc, "findContext (type: " + string + ", name: " + string2 + "), from " + this.getURI());
        }
        ArrayList<RepositoryContextImpl> arrayList = new ArrayList<RepositoryContextImpl>();
        RepositoryContextImpl repositoryContextImpl = null;
        RepositoryContextType repositoryContextType = this.getType();
        Set set = repositoryContextType.findReachableChildrenTo(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RepositoryContextType repositoryContextType2 = (RepositoryContextType)iterator.next();
            if (repositoryContextType2.getName().equals(string)) {
                repositoryContextImpl = (RepositoryContextImpl)this.getChild(repositoryContextType2, string2);
                if (repositoryContextImpl == null) continue;
                arrayList.add(repositoryContextImpl);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "     Found context: " + repositoryContextImpl);
                continue;
            }
            List list = this.getChildren(repositoryContextType2);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                repositoryContextImpl = (RepositoryContextImpl)iterator2.next();
                repositoryContextImpl.setTrace(false);
                arrayList.addAll(repositoryContextImpl.findContext(string, string2));
                repositoryContextImpl.setTrace(true);
            }
        }
        if (tc.isEntryEnabled() && this.needTrace) {
            Tr.exit(tc, "findContext (type: " + string + ", name: " + string2 + "), from " + this.getURI() + ", return: " + arrayList);
        }
        return arrayList;
    }

    public RepositoryContext findContext(String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findContext (uri: " + string + ")");
        }
        RepositoryContext repositoryContext = this.getAdapter().findContext(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findContext (uri: " + string + "), return: " + repositoryContext);
        }
        return repositoryContext;
    }

    public RepositoryContextAdapter getAdapter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdapter");
        }
        if (this.adapter == null) {
            this.adapter = RepositoryContextAdapterManager.getManager().getAdapter(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdapter", this.adapter);
        }
        return this.adapter;
    }

    public List getAllList(boolean bl) {
        ArrayList<WorkSpaceFile> arrayList;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAllList", new Boolean(bl));
            }
            arrayList = new ArrayList<WorkSpaceFile>();
            try {
                this.checkFullList();
                Iterator iterator = this.getAllFiles().iterator();
                while (iterator.hasNext()) {
                    WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
                    if (!this.isAvailable(workSpaceFile)) continue;
                    arrayList.add(workSpaceFile);
                }
                if (bl) {
                    iterator = this.children.iterator();
                    while (iterator.hasNext()) {
                        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
                        List list = repositoryContextImpl.getAllList(bl);
                        if (list.size() <= 0) continue;
                        arrayList.addAll(list);
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception when getting all the files:" + this.getURI(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllList", arrayList);
        }
        return arrayList;
    }

    public RepositoryContext getChild(RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        RepositoryContextImpl repositoryContextImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChild (type: " + repositoryContextType.getName() + ", name: " + string + ")");
        }
        if ((repositoryContextImpl = (RepositoryContextImpl)this.getChildForRebuild(repositoryContextType, string)) != null && repositoryContextImpl.isDeleted()) {
            repositoryContextImpl = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChild (type: " + repositoryContextType.getName() + ", name: " + string + ") return: " + repositoryContextImpl);
        }
        return repositoryContextImpl;
    }

    public RepositoryContext getChildForRebuild(RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        Map map;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildForRebuild (type: " + repositoryContextType.getName() + ", name: " + string + ")");
        }
        ChildrenMap childrenMap = this.getChildTypeMap(repositoryContextType.getName());
        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)childrenMap.map.get(string);
        if (repositoryContextImpl == null && (string2 = (String)(map = this.getAdapter().getChildContextsInRepository(repositoryContextType)).get(string)) != null) {
            repositoryContextImpl = this.loadLocal(repositoryContextType, string, string2, true);
            if (map.size() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getChildForRebuild, for type: " + repositoryContextType.getName() + ", context: " + this.getURI() + " only has one child: " + string2);
                }
                this.setChildTypeToLoaded(childrenMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildForRebuild (type: " + repositoryContextType.getName() + ", name: " + string + ") return: " + repositoryContextImpl);
        }
        return repositoryContextImpl;
    }

    private RepositoryContext getChildForRestore(RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildForRestore (type: " + repositoryContextType.getName() + ", name: " + string + ")");
        }
        ChildrenMap childrenMap = this.getChildTypeMap(repositoryContextType.getName());
        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)childrenMap.map.get(string);
        if (repositoryContextImpl == null) {
            Map map = this.getAdapter().getChildContextsForRestore(repositoryContextType);
            String string2 = (String)map.get(string);
            if (string2 != null) {
                repositoryContextImpl = this.loadLocal(repositoryContextType, string, string2, true);
                if (map.size() == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getChildForRestore, for type: " + repositoryContextType.getName() + ", context: " + this.getURI() + " only has one child: " + string2);
                    }
                    if (this.getState().equals(WorkSpaceContextState.UPDATED_LOADED) || this.getState().equals(WorkSpaceContextState.UPDATED_UNLOADED)) {
                        this.setChildTypeToLoaded(childrenMap);
                    }
                }
            } else {
                string2 = this.getAdapter().getChildContextURI(repositoryContextType, string);
                repositoryContextImpl = this.createLocal(repositoryContextType, string, string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildForRestore (type: " + repositoryContextType.getName() + ", name: " + string + ") return: " + repositoryContextImpl);
        }
        return repositoryContextImpl;
    }

    private void setChildTypeToLoaded(ChildrenMap childrenMap) {
        childrenMap.full = true;
        --this.childTypesToLoad;
        if (this.childTypesToLoad == 0) {
            this.setState(WorkSpaceContextState.UPDATED_LOADED);
        } else if (this.childTypesToLoad < 0 && tc.isDebugEnabled()) {
            Tr.debug(tc, " setChildTypeToLoaded, childTypesToLoad is less than 0.");
        }
    }

    public List getChildren() {
        ArrayList<RepositoryContextImpl> arrayList = new ArrayList<RepositoryContextImpl>();
        try {
            this.loadContext();
        }
        catch (WorkSpaceException workSpaceException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getChildren", arrayList);
            }
            return arrayList;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            if (repositoryContextImpl.isDeleted()) continue;
            arrayList.add(repositoryContextImpl);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, " --    Found child: (" + repositoryContextImpl.getState() + ") " + repositoryContextImpl + " @" + Integer.toHexString(repositoryContextImpl.hashCode()));
        }
        return arrayList;
    }

    public List getChildren(RepositoryContextType repositoryContextType) {
        ArrayList<RepositoryContextImpl> arrayList = new ArrayList<RepositoryContextImpl>();
        try {
            this.loadContext(repositoryContextType, true);
        }
        catch (WorkSpaceException workSpaceException) {
            return arrayList;
        }
        Iterator iterator = this.getChildTypeMap((String)repositoryContextType.getName()).map.values().iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            if (repositoryContextImpl.isDeleted()) continue;
            arrayList.add(repositoryContextImpl);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, " ##    Found child: (" + repositoryContextImpl.getState() + ") " + repositoryContextImpl + " @" + Integer.toHexString(repositoryContextImpl.hashCode()));
        }
        return arrayList;
    }

    private List getLoadedChildren() {
        return this.children;
    }

    boolean isDeleted() {
        return this.getState().equals(WorkSpaceContextState.DELETED) || this.getState().equals(WorkSpaceContextState.NONE);
    }

    private ChildrenMap getChildTypeMap(String string) {
        ChildrenMap childrenMap = (ChildrenMap)this.childTypeMap.get(string);
        if (childrenMap == null) {
            childrenMap = new ChildrenMap();
            this.childTypeMap.put(string, childrenMap);
        }
        return childrenMap;
    }

    public WorkSpaceRepositoryAdapter getRepositoryAdapter() throws WorkSpaceException {
        return this.workSpace.getRepositoryAdapter();
    }

    private WorkSpaceCatalogManager getCatalogManager() {
        return this.workSpace.getCatalogManager();
    }

    public boolean contentsChangedInRepository() throws WorkSpaceException {
        return this.getDeltaChangesInRepository().size() > 0;
    }

    public Map getDeltaChangesInRepository() throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeltaChangesInRepository");
        }
        Map map = this.getCatalogManager().getDeltaChangesInRepository(this);
        Map map2 = this.checkSynchState(true);
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Integer n = (Integer)map2.get(string);
            if (n == ConflictState.ADDED) {
                map.put(string, WorkSpaceFileState.ADDED);
                continue;
            }
            if (n == ConflictState.REMOVED) {
                map.put(string, WorkSpaceFileState.DELETED);
                continue;
            }
            if (n != ConflictState.MODIFIED) continue;
            map.put(string, WorkSpaceFileState.UPDATED);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeltaChangesInRepository", map);
        }
        return map;
    }

    private RepositoryContextType getContextType(String string) {
        return this.getMetaData().getContextType(string);
    }

    private WorkSpaceFileImpl getFileForRebuild(String string) {
        WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)this.files.get(string);
        return workSpaceFileImpl;
    }

    public WorkSpaceFile getFile(String string) {
        if (this.isAvailable(string)) {
            return this.getFileForRebuild(string);
        }
        return null;
    }

    public Set getFiles() {
        HashSet<String> hashSet;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getFiles");
            }
            hashSet = new HashSet<String>();
            try {
                this.checkFullList();
                Iterator iterator = this.getAllFiles().iterator();
                while (iterator.hasNext()) {
                    WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
                    if (!this.isAvailable(workSpaceFile)) continue;
                    hashSet.add(workSpaceFile.getName());
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception when getting all the files: " + this.getURI(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFiles", hashSet);
        }
        return hashSet;
    }

    Collection getAllFiles() {
        return this.files.values();
    }

    private void getFiles(boolean bl, Map[] mapArray, Map map) throws WorkSpaceException {
        this.getFilesOnly(bl, mapArray, map);
        this.save(bl, false);
    }

    private void getFilesOnly(boolean bl, Map[] mapArray, Map map) throws WorkSpaceException {
        Iterator iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)iterator.next();
            this.collectFile((WorkSpaceFile)workSpaceFileImpl, mapArray, map);
        }
        if (bl) {
            iterator = this.children.iterator();
            while (iterator.hasNext()) {
                RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
                repositoryContextImpl.getFilesOnly(bl, mapArray, map);
            }
        }
    }

    private void collectFile(WorkSpaceFile workSpaceFile, Map[] mapArray, Map map) throws WorkSpaceException {
        if (workSpaceFile.getState() == WorkSpaceFileState.ADDED) {
            this.collectFile(workSpaceFile, mapArray[0], map);
        } else if (workSpaceFile.getState() == WorkSpaceFileState.UPDATED) {
            this.collectFile(workSpaceFile, mapArray[1], map);
        } else if (workSpaceFile.getState() == WorkSpaceFileState.DELETED) {
            this.collectFile(workSpaceFile, mapArray[2], map);
        }
    }

    private void collectFile(WorkSpaceFile workSpaceFile, Map map, Map map2) throws WorkSpaceException {
        if (map2.containsKey(workSpaceFile.getURI())) {
            Integer n = (Integer)map2.get(workSpaceFile.getURI());
            if (n == ConflictResolution.OVER_WRITE) {
                map.put(workSpaceFile, n);
            } else if (n == ConflictResolution.DISCARD) {
                if (workSpaceFile.getState() == WorkSpaceFileState.ADDED) {
                    this.setFileState(workSpaceFile.getName(), WorkSpaceFileState.NONE);
                } else {
                    this.setFileState(workSpaceFile.getName(), WorkSpaceFileState.CLEAN);
                }
            }
        } else {
            map.put(workSpaceFile, null);
        }
    }

    private RepositoryMetaData getMetaData() {
        return this.workSpace.getMetaData();
    }

    public List getModifiedList(boolean bl) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = this.getAllFiles().iterator();
        while (object3.hasNext()) {
            object2 = (WorkSpaceFile)object3.next();
            object = object2.getState();
            if (object != WorkSpaceFileState.ADDED && object != WorkSpaceFileState.UPDATED && object != WorkSpaceFileState.DELETED) continue;
            arrayList.add(object2);
        }
        if (bl) {
            object2 = this.children.iterator();
            while (object2.hasNext()) {
                object = (RepositoryContextImpl)object2.next();
                object3 = ((RepositoryContextImpl)object).getModifiedList(bl);
                if (object3.size() <= 0) continue;
                arrayList.addAll((Collection<Object>)object3);
            }
        }
        return arrayList;
    }

    public String getName() {
        return this.data.getName();
    }

    public RepositoryContext getParentContext() {
        return this.parent;
    }

    public RepositoryContext getParent() {
        return this.parent;
    }

    public String getPath() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPath");
        }
        if (this.fullPath == null) {
            StringBuffer stringBuffer = new StringBuffer(this.workSpace.getPath());
            String string = this.getURI().replace('/', FILE_SEPERATOR_CHAR);
            if (stringBuffer.length() > 0 && string.length() > 0) {
                stringBuffer.append(FILE_SEPERATOR);
            }
            stringBuffer.append(string);
            this.fullPath = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPath", this.fullPath);
        }
        return this.fullPath;
    }

    public String getURI() {
        if (this.fullURI == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getParentContext() != null) {
                stringBuffer.append(this.getParentContext().getURI());
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.getRelativeURI());
            this.fullURI = stringBuffer.toString();
        }
        return this.fullURI;
    }

    String getRelativeURI() {
        return this.relativeURI;
    }

    public String getProperty(String string) {
        return this.data.getProperty(string);
    }

    public Enumeration getPropertyNames() {
        return this.data.getPropertyNames();
    }

    public Integer getState() {
        return this.data.getState();
    }

    private void setState(Integer n) {
        if (tc.isDebugEnabled() && this.data.getState() >= 0) {
            Tr.debug(tc, "  setState,Context: " + this.data.getState() + ">" + n + " " + this.getURI());
        }
        this.data.setState(n);
    }

    public Integer getOldState() {
        return this.data.getOldState();
    }

    private void setOldState(Integer n) {
        if (tc.isDebugEnabled() && this.data.getOldState() >= 0) {
            Tr.debug(tc, "  setOldState,Context: " + this.data.getOldState() + ">" + n + " " + this.getURI());
        }
        this.data.setOldState(n);
    }

    private void initChildTypesToLoad() {
        this.childTypesToLoad = this.type.getChildContextTypes().size();
    }

    public RepositoryContextType getType() {
        return this.type;
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    private boolean isSpecialXML(String string) {
        boolean bl = false;
        if (string.endsWith("deployment.xml") || string.endsWith("serverindex.xml")) {
            bl = true;
        }
        return bl;
    }

    public boolean isAvailable(String string) {
        boolean bl;
        boolean bl2 = this.isSpecialXML(string);
        if (tc.isEntryEnabled() && bl2) {
            Tr.entry(tc, "isAvailable(String), Context: " + this.getPath() + ", File: " + string);
        }
        WorkSpaceFileImpl workSpaceFileImpl = this.getFileForRebuild(string);
        if (tc.isDebugEnabled() && bl2) {
            Tr.debug(tc, "isAvailable(String), WorkSpaceFile: " + workSpaceFileImpl);
        }
        if (bl = this.isAvailable(workSpaceFileImpl)) {
            if (tc.isEntryEnabled() && bl2) {
                Tr.exit(tc, "isAvailable(String), Context: " + this.getPath() + ", File: " + string + ", Available: " + bl);
            }
            return true;
        }
        if (workSpaceFileImpl == null && !this.fullFileList) {
            bl = this.checkExist(string);
        }
        if (tc.isEntryEnabled() && bl2) {
            Tr.exit(tc, "isAvailable(String), Context: " + this.getPath() + ", File: " + string + ", Available: " + bl + ", fullFileList: " + this.fullFileList);
        }
        return bl;
    }

    private boolean isAvailable(WorkSpaceFile workSpaceFile) {
        boolean bl;
        boolean bl2 = bl = workSpaceFile != null && workSpaceFile.getState() != WorkSpaceFileState.NONE && workSpaceFile.getState() != WorkSpaceFileState.DELETED;
        if (workSpaceFile != null) {
            boolean bl3 = this.isSpecialXML(workSpaceFile.toString());
            if (tc.isDebugEnabled() && bl3) {
                Tr.debug(tc, "isAvailable(WorkSpaceFile),   File: " + workSpaceFile + ", State: " + workSpaceFile.getState());
            }
        }
        return bl;
    }

    private boolean checkExist(String string) {
        boolean bl;
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer(this.getURI());
            if (stringBuffer.length() > 0 && string.length() > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string.replace(FILE_SEPERATOR_CHAR, '/'));
            bl = false;
            try {
                bl = this.getRepositoryAdapter().exist(this.workSpace, stringBuffer.toString());
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Check exist error:" + stringBuffer, exception);
            }
        }
        boolean bl2 = this.isSpecialXML(string);
        if (tc.isDebugEnabled() && bl2) {
            Tr.debug(tc, "checkExist(String),     File: " + stringBuffer + ", Exist (in master config): " + bl);
        }
        if (bl) {
            this.setFileState(string, WorkSpaceFileState.CLEAN);
        }
        return bl;
    }

    public boolean isExtracted(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExtracted (fileName: " + string + ")");
        }
        boolean bl = false;
        if (this.isAvailable(string)) {
            Integer n = this.getFileForRebuild(string).getState();
            boolean bl2 = bl = n != WorkSpaceFileState.CLEAN;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isExtracted (fileName: " + string + ") return: " + new Boolean(bl));
        }
        return bl;
    }

    public void notifyChanged(int n, String string) throws WorkSpaceException {
        this.notifyChangedOnly(n, string);
        this.save(false, false);
    }

    private void notifyChangedOnly(int n, String string) throws WorkSpaceException {
        WorkSpaceFile workSpaceFile = null;
        int n2 = 0;
        String string2 = string.replace(FILE_SEPERATOR_CHAR, '/');
        if (n == 0) {
            if (!this.isAvailable(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + string2 + " to " + this.getURI());
                }
                workSpaceFile = this.setFileState(string2, WorkSpaceFileState.ADDED);
                n2 = 20;
                this.systemModifyingCheck(this.getURI() + '/' + string2);
            }
        } else if (n == 2) {
            if (this.isAvailable(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing " + string2 + " from " + this.getURI());
                }
                workSpaceFile = this.setFileState(string2, WorkSpaceFileState.DELETED);
                n2 = 21;
                this.delete(workSpaceFile);
                this.systemModifyingCheck(this.getURI() + '/' + string2);
            }
        } else if (n == 1) {
            if (this.isAvailable(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating " + string2 + " from " + this.getURI());
                }
                workSpaceFile = this.setFileState(string2, WorkSpaceFileState.UPDATED);
                n2 = 22;
                this.systemModifyingCheck(this.getURI() + '/' + string2);
            }
        } else if (n == 3 && this.isAvailable(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracted " + string2 + " from " + this.getURI());
            }
            workSpaceFile = this.setFileState(string2, WorkSpaceFileState.EXTRACTED);
            n2 = 23;
        }
        if (workSpaceFile != null) {
            this.workSpace.notify(new WorkSpaceEventImpl(workSpaceFile, n2));
        }
    }

    private void delete(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        this.getRepositoryAdapter().delete(workSpaceFile);
    }

    private void delete() throws WorkSpaceException {
        this.getRepositoryAdapter().delete(this);
    }

    public synchronized void notifyChanged(int n, List list) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyChanged", new Object[]{new Integer(n), list});
        }
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                this.notifyChangedOnly(n, (String)list.get(i));
            }
        }
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyChanged");
        }
    }

    public synchronized void release(boolean bl) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release (deep: " + new Boolean(bl) + ")");
        }
        if (!bl) {
            throw new UnsupportedOperationException();
        }
        this.workSpace.checkValid();
        this.disableSave();
        this.releaseOnly(bl);
        this.enableSave();
        this.save(bl, false);
        this.clearMe(bl);
        String string = this.workSpace.getSessionId();
        SystemModifiedFiles.RemoveFileSet(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release (deep: " + new Boolean(bl) + ")");
        }
    }

    void releaseOnly(boolean bl) throws WorkSpaceException {
        Object object;
        Object object2;
        if (bl) {
            object2 = this.children.iterator();
            while (object2.hasNext()) {
                object = (RepositoryContextImpl)object2.next();
                ((RepositoryContextImpl)object).releaseOnly(bl);
            }
        }
        this.resetAdapterNotifier(false);
        try {
            object = this.getAllFiles().iterator();
            while (object.hasNext()) {
                object2 = (WorkSpaceFileImpl)object.next();
                this.release((WorkSpaceFileImpl)object2, false);
            }
            this.workSpace.notify(new WorkSpaceEventImpl(this, 11));
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0005E Error while releasing context {0}-{1}", new Object[]{this.getName(), exception}, exception);
        }
        finally {
            Integer n = this.getState();
            Integer n2 = this.getOldState();
            if (n.equals(WorkSpaceContextState.ADDED)) {
                if (n2.equals(WorkSpaceContextState.NONE)) {
                    this.setState(WorkSpaceContextState.DELETED);
                } else {
                    this.setState(n2);
                }
            } else if (n.equals(WorkSpaceContextState.DELETED) && !n2.equals(WorkSpaceContextState.NONE)) {
                this.setState(n2);
            }
            this.clearLocalFile(null);
            this.resetAdapterNotifier(true);
        }
    }

    private synchronized void releaseInSynch(boolean bl) throws WorkSpaceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Releasing context(s) after synch ..., deep: " + bl);
        }
        if (!bl) {
            throw new UnsupportedOperationException();
        }
        this.workSpace.checkValid();
        this.disableSave();
        this.releaseInSynchOnly(bl);
        this.enableSave();
        this.save(bl, true);
        this.clearMe(bl);
    }

    private void releaseInSynchOnly(boolean bl) throws WorkSpaceException {
        Object object;
        Object object2;
        if (bl) {
            object2 = this.children.iterator();
            while (object2.hasNext()) {
                object = (RepositoryContextImpl)object2.next();
                super.releaseInSynchOnly(bl);
            }
        }
        this.resetAdapterNotifier(false);
        try {
            object = this.getAllFiles().iterator();
            while (object.hasNext()) {
                object2 = (WorkSpaceFileImpl)object.next();
                this.release((WorkSpaceFileImpl)object2, false);
            }
            this.workSpace.notify(new WorkSpaceEventImpl(this, 11));
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0005E Error while releasing context {0}-{1}", new Object[]{this.getName(), exception}, exception);
        }
        finally {
            this.clearLocalFile(null);
            this.resetAdapterNotifier(true);
        }
    }

    private void clearMe(boolean bl) throws WorkSpaceException {
        Object object;
        Object object2;
        if (bl) {
            object2 = this.children.iterator();
            while (object2.hasNext()) {
                object = (RepositoryContextImpl)object2.next();
                ((RepositoryContextImpl)object).clearMe(bl);
            }
        }
        object2 = this.getURI();
        if (!this.getRepositoryAdapter().exist(this.workSpace, (String)object2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Context " + (String)object2 + " is gone from master repository. Setting context state to DELETED");
            }
            this.setState(WorkSpaceContextState.DELETED);
        } else if (this.getState().equals(WorkSpaceContextState.UPDATED_LOADED) || this.getState().equals(WorkSpaceContextState.ADDED)) {
            this.setState(WorkSpaceContextState.UPDATED_UNLOADED);
        }
        this.initChildTypesToLoad();
        Iterator iterator = this.childTypeMap.values().iterator();
        while (iterator.hasNext()) {
            object = (ChildrenMap)iterator.next();
            ((ChildrenMap)object).full = false;
        }
    }

    void resetAdapterNotifier(boolean bl) {
        this.getWorkSpaceResourceSet().setAdapterNotifier(bl);
    }

    public synchronized void releaseUnchanged(boolean bl, boolean bl2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseUnchanged (deep: " + new Boolean(bl) + ", keep: " + new Boolean(bl2) + ")");
        }
        this.workSpace.checkValid();
        this.disableSave();
        this.releaseUnchangedOnly(bl, bl2);
        this.enableSave();
        this.save(bl, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseUnchanged (deep: " + new Boolean(bl) + ", keep: " + new Boolean(bl2) + ")");
        }
    }

    void releaseUnchangedOnly(boolean bl, boolean bl2) throws WorkSpaceException {
        WorkSpaceConstant workSpaceConstant;
        Object object;
        if (bl) {
            object = this.children.iterator();
            while (object.hasNext()) {
                workSpaceConstant = (RepositoryContextImpl)object.next();
                ((RepositoryContextImpl)workSpaceConstant).releaseUnchangedOnly(bl, bl2);
            }
        }
        this.resetAdapterNotifier(false);
        object = new ArrayList();
        try {
            Iterator iterator = this.getAllFiles().iterator();
            while (iterator.hasNext()) {
                workSpaceConstant = (WorkSpaceFileImpl)iterator.next();
                if (((WorkSpaceFileImpl)workSpaceConstant).getState() == WorkSpaceFileState.EXTRACTED) {
                    this.release((WorkSpaceFileImpl)workSpaceConstant, bl2);
                }
                if (((WorkSpaceFileImpl)workSpaceConstant).getState() != WorkSpaceFileState.CLEAN && ((WorkSpaceFileImpl)workSpaceConstant).getState() != WorkSpaceFileState.NONE && (((WorkSpaceFileImpl)workSpaceConstant).getState() != WorkSpaceFileState.EXTRACTED || bl2)) continue;
                object.add(workSpaceConstant);
            }
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0005E Error while releasing context {0}-{1}", new Object[]{this.getName(), exception}, exception);
        }
        finally {
            this.clearLocalFile((List)object);
            this.resetAdapterNotifier(true);
        }
    }

    private void release(WorkSpaceFileImpl workSpaceFileImpl, boolean bl) throws WorkSpaceException {
        this.getWorkSpaceResourceSet().release(workSpaceFileImpl.getName());
        if (!bl) {
            this.release(workSpaceFileImpl);
            this.workSpace.notify(new WorkSpaceEventImpl(workSpaceFileImpl, 24));
        }
    }

    private void release(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        this.getRepositoryAdapter().release(workSpaceFile);
    }

    void remove() throws WorkSpaceException {
        this.delete(true);
    }

    public String removeProperty(String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProperty (name: " + string + ")");
        }
        String string2 = this.data.removeProperty(string);
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProperty (name: " + string + ") return: " + string2);
        }
        return string2;
    }

    void restore() throws WorkSpaceException {
        this.disableSave();
        String string = this.getRepositoryAdapter().restore(this);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "~");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                Object object;
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.indexOf("=");
                if (n2 == -1) continue;
                String string3 = string2.substring(0, n2);
                String string4 = "";
                if (n2 + 1 < string2.length()) {
                    string4 = string2.substring(n2 + 1);
                }
                if (string3.equals("data")) {
                    this.data.restore(string4);
                    continue;
                }
                if (string3.equals("uri")) {
                    this.relativeURI = string4;
                    continue;
                }
                if (string3.equals("file")) {
                    n2 = string4.indexOf("[");
                    if (n2 == -1) continue;
                    String string5 = string4.substring(0, n2);
                    object = this.setFileState(string5, WorkSpaceFileState.CLEAN);
                    ((WorkSpaceFileImpl)object).restore(string4);
                    if (object.getState() == WorkSpaceFileState.CLEAN || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "   Restore file tokenValue = " + string4 + ", File state: " + object.getState());
                    continue;
                }
                if (!string3.equals("child") || (n2 = string4.indexOf("[")) == -1 || (n = string4.indexOf("[", n2 + 1)) == -1) continue;
                object = string4.substring(0, n2);
                String string6 = string4.substring(n2 + 1, n);
                String string7 = string4.substring(n + 1);
                RepositoryContextType repositoryContextType = this.getContextType(string6);
                if (repositoryContextType == null) {
                    throw WorkSpaceLogger.createException(tc, "WKSP0021E Error getting context type: {0}.", new Object[]{string6});
                }
                RepositoryContext repositoryContext = this.getChildForRestore(repositoryContextType, (String)object);
                if (repositoryContext == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unable to restore child context, type: " + repositoryContextType + ", name: " + (String)object + ", from " + this.getURI());
                    continue;
                }
                ((RepositoryContextImpl)repositoryContext).restore();
            }
        }
        this.enableSave();
    }

    void save(boolean bl, boolean bl2) throws WorkSpaceException {
        if (!this.isEnableSave()) {
            return;
        }
        Integer n = this.getState();
        if (bl2) {
            this.setOldState(n);
        }
        if (n.equals(WorkSpaceContextState.ADDED) || n.equals(WorkSpaceContextState.DELETED) || n.equals(WorkSpaceContextState.UPDATED_LOADED) || n.equals(WorkSpaceContextState.UPDATED_UNLOADED)) {
            this.getRepositoryAdapter().save(this);
            if (bl) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
                    repositoryContextImpl.save(true, bl2);
                }
            }
        }
    }

    private WorkSpaceFile setFileState(String string, Integer n) {
        String string2;
        WorkSpaceFileImpl workSpaceFileImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFileState: " + string + ", " + n);
        }
        if ((workSpaceFileImpl = this.getFileForRebuild(string2 = string.replace(FILE_SEPERATOR_CHAR, '/'))) == null) {
            workSpaceFileImpl = new WorkSpaceFileImpl(this, string2);
            this.files.put(string2, workSpaceFileImpl);
        }
        if (workSpaceFileImpl.getState() == WorkSpaceFileState.ADDED) {
            if (n == WorkSpaceFileState.UPDATED) {
                n = workSpaceFileImpl.getState();
            } else if (n == WorkSpaceFileState.DELETED) {
                n = WorkSpaceFileState.NONE;
            }
        } else if (workSpaceFileImpl.getState() == WorkSpaceFileState.DELETED) {
            if (n == WorkSpaceFileState.ADDED) {
                n = WorkSpaceFileState.UPDATED;
            }
        } else if (workSpaceFileImpl.getState() == WorkSpaceFileState.UPDATED && n == WorkSpaceFileState.EXTRACTED) {
            n = WorkSpaceFileState.UPDATED;
        }
        workSpaceFileImpl.setState(n);
        return workSpaceFileImpl;
    }

    protected void setParent(RepositoryContext repositoryContext) {
        this.parent = repositoryContext;
    }

    public void setProperty(String string, String string2) throws WorkSpaceException {
        this.data.setProperty(string, string2);
        this.save(false, false);
    }

    public synchronized void synch(Map map) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "synch", map);
        }
        this.workSpace.checkValid();
        Map[] mapArray = new HashMap[3];
        for (int i = 0; i < 3; ++i) {
            mapArray[i] = new HashMap();
        }
        this.getFiles(true, mapArray, map);
        this.removeUnauthorizedFiles(mapArray);
        this.zosValidation(mapArray);
        Session session = new Session(this.workSpace.getUserName(), true);
        String string = session.toString();
        SystemModifiedFiles.createThreadLocalFileSet(string);
        this.update(mapArray);
        SystemModifiedFiles.RemoveFileSet(string);
        this.workSpace.notify(new WorkSpaceEventImpl(this, 12));
        for (int i = 0; i < 3; ++i) {
            Iterator iterator = mapArray[i].keySet().iterator();
            while (iterator.hasNext()) {
                this.workSpace.notify(new WorkSpaceEventImpl((WorkSpaceFile)iterator.next(), 25));
            }
        }
        this.releaseInSynch(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "synch");
        }
    }

    public String getPersistData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPersistData ()");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("data");
        stringBuffer.append("=");
        stringBuffer.append(this.data.getPersistData());
        stringBuffer.append("~");
        stringBuffer.append("uri");
        stringBuffer.append("~");
        stringBuffer.append(this.getRelativeURI());
        Iterator iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)iterator.next();
            stringBuffer.append("~");
            stringBuffer.append("file");
            stringBuffer.append("=");
            stringBuffer.append(workSpaceFileImpl.getPersistData());
        }
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            stringBuffer.append("~");
            stringBuffer.append("child");
            stringBuffer.append("=");
            stringBuffer.append(repositoryContextImpl.getName());
            stringBuffer.append("[");
            stringBuffer.append(repositoryContextImpl.getType().getName());
            stringBuffer.append("[");
            stringBuffer.append(repositoryContextImpl.getRelativeURI());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPersistData " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private void update(Map[] mapArray) throws WorkSpaceException {
        this.getRepositoryAdapter().update(mapArray);
    }

    public String toString() {
        return this.getURI();
    }

    public void dumpContextTree(RepositoryContextImpl repositoryContextImpl, ContextCount contextCount) {
        int n = contextCount.getTotal();
        if (n == 0) {
            System.out.println(">>> --- [Context] vvv -----------------------------");
        }
        this.dumpContext(repositoryContextImpl, n);
        Iterator iterator = repositoryContextImpl.getLoadedChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl2 = (RepositoryContextImpl)iterator.next();
            if (repositoryContextImpl2.isDeleted()) continue;
            contextCount.increase();
            this.dumpContextTree(repositoryContextImpl2, contextCount);
        }
        if (n == 0) {
            System.out.println(">>> --- [Context] ^^^------------------------------");
        }
    }

    public void dumpContext(RepositoryContextImpl repositoryContextImpl, int n) {
        String string = "@" + Integer.toHexString(repositoryContextImpl.hashCode());
        System.out.println(">>> (" + n + ")" + "\n\t Ctx State: (" + repositoryContextImpl.getState() + ")" + ", Type: " + repositoryContextImpl.getType().getName() + ", Context..: " + string + " " + repositoryContextImpl.getName() + "\n\t Parent...: " + repositoryContextImpl.getParent() + ", Workspace: " + repositoryContextImpl.getWorkSpace() + "\n\t FullURI..: " + repositoryContextImpl.getURI() + "\n\t Relative.: " + repositoryContextImpl.getRelativeURI() + "\n\t FullPath.: " + repositoryContextImpl.getPath());
    }

    public void dumpContextTypeTree(RepositoryContextType repositoryContextType, boolean bl, String string, ContextCount contextCount) {
        int n = contextCount.getTotal();
        if (n == 0) {
            System.out.println(">>> --- [Context Type] vvv ------------------------");
        }
        string = string + "   ";
        this.dumpContextType(repositoryContextType, bl, string, n);
        Iterator iterator = repositoryContextType.getChildContextTypes().iterator();
        while (iterator.hasNext()) {
            RepositoryContextType repositoryContextType2 = (RepositoryContextType)iterator.next();
            contextCount.increase();
            this.dumpContextTypeTree(repositoryContextType2, bl, string, contextCount);
        }
        if (n == 0) {
            if (!bl) {
                System.out.println("");
            }
            System.out.println(">>> --- [Context Type] ^^^ ------------------------");
        }
    }

    public void dumpContextType(RepositoryContextType repositoryContextType, boolean bl, String string, int n) {
        String string2 = "";
        if (bl) {
            Iterator iterator = repositoryContextType.getChildDocumentTypes().iterator();
            while (iterator.hasNext()) {
                RepositoryDocumentType repositoryDocumentType = (RepositoryDocumentType)iterator.next();
                string2 = string2 + "\n\t\t File: " + repositoryDocumentType.getFilePattern() + "\t\t - " + repositoryDocumentType.getDisplayName();
            }
            System.out.println(">>> (" + n + ")" + "\n\t Name.....: " + repositoryContextType.getName() + "\n\t Child Doc: " + string2);
        } else if (repositoryContextType.getName().equals("")) {
            System.out.print("\n\t Context type: " + string + "ROOT");
        } else {
            System.out.print("\n\t Context type: " + string + repositoryContextType.getName());
        }
    }

    public OutputStream getOutputStream(String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream (name: " + string + ")");
        }
        OutputStream outputStream = null;
        String string2 = string.replace(FILE_SEPERATOR_CHAR, '/');
        this.extract(string2, false);
        int n = this.isAvailable(string2) ? 1 : 0;
        this.notifyChanged(n, string2);
        WorkSpaceFileImpl workSpaceFileImpl = this.getFileForRebuild(string2);
        try {
            File file = new File(workSpaceFileImpl.getURI());
            WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)this.getWorkSpace();
            FileAccessorUtil.makeDir(workSpaceImpl.getFileAccessor(), file.getParentFile().getPath());
            outputStream = FileAccessorUtil.getOutputStream(workSpaceImpl.getFileAccessor(), workSpaceFileImpl.getURI());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0015E Unable to get OutputStream for {0} --{1}", new Object[]{string2}, fileNotFoundException);
        }
        catch (IOException iOException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0015E Unable to get OutputStream for {0} --{1}", new Object[]{string2}, iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream (name: " + string + ")", outputStream);
        }
        return outputStream;
    }

    public InputStream getInputStream(String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream (name: " + string + ")");
        }
        InputStream inputStream = null;
        String string2 = string.replace(FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(string2)) {
            this.extract(string2, false);
            try {
                WorkSpaceFileImpl workSpaceFileImpl = this.getFileForRebuild(string2);
                WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)this.getWorkSpace();
                inputStream = FileAccessorUtil.getInputStream(workSpaceImpl.getFileAccessor(), workSpaceFileImpl.getURI());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0014E Unable to get InputStream for {0} --{1}", new Object[]{string}, fileNotFoundException);
            }
            catch (IOException iOException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0014E Unable to get InputStream for {0} --{1}", new Object[]{string}, iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream (name: " + string + ")", inputStream);
        }
        return inputStream;
    }

    private void zosValidation(Map[] mapArray) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "zosValidation");
        }
        WorkSpaceFile workSpaceFile = null;
        ResourceSet resourceSet = null;
        RepositoryContext repositoryContext = null;
        Server server2 = null;
        ProcessDef processDef = null;
        String string = "server.xml";
        String string2 = null;
        String string3 = null;
        Object var10_10 = null;
        int n = -1;
        Iterator iterator = mapArray[1].keySet().iterator();
        while (iterator.hasNext()) {
            server2 = null;
            processDef = null;
            workSpaceFile = (WorkSpaceFile)iterator.next();
            string2 = workSpaceFile.getURI();
            n = string2.indexOf("/server.xml");
            if (n <= -1) continue;
            string3 = string2.substring(0, n);
            try {
                Object object;
                repositoryContext = this.workSpace.findContext(string3);
                resourceSet = repositoryContext.getResourceSet();
                Resource resource = resourceSet.createResource(URI.createURI((String)string));
                resource.load(new HashMap());
                EList eList = resource.getContents();
                Iterator iterator2 = eList.iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    if (!(object instanceof Server)) continue;
                    server2 = (Server)object;
                    break;
                }
                if (server2 == null) continue;
                object = server2.getProcessDefinitions().iterator();
                while (object.hasNext()) {
                    processDef = (ProcessDef)object.next();
                    if (processDef == null || processDef.getProcessType() == null || !processDef.getProcessType().equalsIgnoreCase("Servant") && !processDef.getProcessType().equalsIgnoreCase("Adjunct")) continue;
                    this.validateJobNames(processDef);
                }
            }
            catch (Exception exception) {
                if (exception instanceof WorkSpaceException) {
                    throw (WorkSpaceException)exception;
                }
                throw WorkSpaceLogger.createException(tc, "WKSP0100E An error occurred getting a resource object during z/OS validation --{0}.", new Object[]{exception}, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zosValidation");
        }
    }

    private void validateJobNames(ProcessDef processDef) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateJobNames");
        }
        String string = null;
        Iterator iterator = null;
        int n = -1;
        int n2 = 0;
        iterator = processDef.getStartCommandArgs().iterator();
        while (iterator.hasNext()) {
            string = ((String)iterator.next()).toLowerCase();
            n = string.indexOf("jobname");
            if (n <= -1) continue;
            for (n2 = n + 7; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
            String string2 = MessageFormat.format(this.resBundle.getString("error.zos.invalid.jobname"), processDef.getProcessType());
            ZosValidationException zosValidationException = new ZosValidationException(string2);
            if (n2 == string.length() || string.charAt(n2) != '=') {
                Tr.error(tc, "error.zos.invalid.jobname", new Object[]{processDef.getProcessType()});
                throw new WorkSpaceException(string2, zosValidationException);
            }
            for (n2 = n = n2 + 1; n2 < string.length() && string.charAt(n2) != ','; ++n2) {
            }
            String string3 = string.substring(n, n2).trim();
            if (string3 != null && !string3.equals("") && string3.indexOf("<insert jobname here>") <= -1 && !this.isJobNameEqualToAnyServerShortName(string3, null)) continue;
            Tr.error(tc, "error.zos.invalid.jobname", new Object[]{processDef.getProcessType()});
            throw new WorkSpaceException(string2, zosValidationException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateJobNames");
        }
    }

    private boolean isJobNameEqualToAnyServerShortName(String string, RepositoryContext repositoryContext) {
        RepositoryContext repositoryContext2 = repositoryContext;
        try {
            Object object;
            Object object2;
            Object object3;
            if (repositoryContext2 == null && (object3 = (object2 = this.workSpace.findContext((object = RepositoryMetaDataFactory.getRepositoryMetaData()).getContextType("cells"))).iterator()).hasNext()) {
                repositoryContext2 = (RepositoryContext)object3.next();
            }
            object = repositoryContext2.getType().getName();
            object2 = null;
            object3 = repositoryContext2.getChildren();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                RepositoryContext repositoryContext3 = (RepositoryContext)iterator.next();
                if (!repositoryContext3.getType().getName().equalsIgnoreCase("nodes")) continue;
                object2 = repositoryContext3;
                RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers");
                Collection collection = object2.findContext(repositoryContextType);
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    RepositoryContext repositoryContext4 = (RepositoryContext)iterator2.next();
                    ResourceSet resourceSet = repositoryContext4.getResourceSet();
                    Resource resource = null;
                    Object var15_17 = null;
                    String string2 = "server.xml";
                    try {
                        if (!repositoryContext4.isExtracted(string2)) {
                            repositoryContext4.extract(string2, false);
                        }
                        resource = resourceSet.createResource(URI.createURI((String)string2));
                        resource.load(new HashMap());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    EList eList = resource.getContents();
                    Iterator iterator3 = eList.iterator();
                    Server server2 = null;
                    while (iterator3.hasNext()) {
                        Object e2 = iterator3.next();
                        if (!(e2 instanceof Server)) continue;
                        server2 = (Server)e2;
                        break;
                    }
                    if (server2.getShortName() == null || !server2.getShortName().toString().equalsIgnoreCase(string)) continue;
                    return true;
                }
            }
        }
        catch (WorkSpaceException workSpaceException) {
            workSpaceException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private void removeUnauthorizedFiles(Map[] mapArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUnauthorizedFiles: " + mapArray);
        }
        Session session = new Session(this.workSpace.getUserName(), true);
        String string = session.toString();
        Set set = SystemModifiedFiles.getFileSet(string);
        AdminAuthorizer adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (adminAuthorizer != null && adminAuthorizer.isFineGrainedAdminSecurity()) {
            for (int i = 0; i < 3; ++i) {
                Iterator iterator = mapArray[i].keySet().iterator();
                while (iterator.hasNext()) {
                    WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
                    if (adminAuthorizer == null || adminAuthorizer.checkAccess(workSpaceFile.getURI(), "configurator")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Now checking if this file (" + workSpaceFile.getURI() + ") is in the exception list for files accessed while runningAsSystem");
                    }
                    if (set == null || set.contains(workSpaceFile.getURI())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removing " + workSpaceFile.getURI() + "from the fileLists");
                    }
                    iterator.remove();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUnauthorizedFiles: " + mapArray);
        }
    }

    private void systemModifyingCheck(String string) {
        AdminAuthorizer adminAuthorizer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "systemModifyingCheck: " + string);
        }
        if ((adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer()) != null && adminAuthorizer.runningAsSystem()) {
            Session session = new Session(this.workSpace.getUserName(), true);
            String string2 = session.toString();
            SystemModifiedFiles.addFile(string2, string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "adding file (" + string + ") to SystemModifiedFiles for session id: " + string2);
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "systemModifyingCheck: not running as system. ");
        }
    }

    private class ChildrenMap {
        boolean full = false;
        HashMap map = new HashMap();

        private ChildrenMap() {
        }
    }

    public class ContextCount {
        private int total = 0;

        int getTotal() {
            return this.total;
        }

        void increase() {
            ++this.total;
        }

        void decrease() {
            --this.total;
        }
    }
}

