/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SystemModifiedFiles {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(SystemModifiedFiles.class);
    private static HashMap systemModifiedFilesMap = new HashMap();
    private static ThreadLocal filesSystemModifiedInSession = null;

    public static synchronized void addFile(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFile(session: " + string + " file: " + string2 + " )");
        }
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            return;
        }
        HashSet<String> hashSet = (HashSet<String>)systemModifiedFilesMap.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            systemModifiedFilesMap.put(string, hashSet);
        }
        hashSet.add(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFile -- systemModifiedFilesMap: " + systemModifiedFilesMap);
        }
    }

    public static synchronized Set getFileSet(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileList for session: " + string);
        }
        if (string == null || string.equals("")) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "systemModifiedFilesMap: " + systemModifiedFilesMap);
        }
        HashSet hashSet = (HashSet)systemModifiedFilesMap.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileList for session (" + string + ") :" + hashSet);
        }
        return hashSet;
    }

    public static synchronized ThreadLocal createThreadLocalFileSet(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createThreadLocalFileSet for session: " + string);
        }
        if (string == null || string.equals("")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createThreadLocalFileSet returns null for empty or null sessionId");
            }
            return null;
        }
        final HashSet hashSet = (HashSet)systemModifiedFilesMap.get(string);
        if (hashSet == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createThreadLocalFileSet returns null as none is found in systemModifiedFilesMap: " + systemModifiedFilesMap);
            }
            return null;
        }
        filesSystemModifiedInSession = new ThreadLocal(){

            protected synchronized Object initialValue() {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ThreadLocal.initialValue(): " + hashSet);
                }
                return hashSet;
            }
        };
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createThreadLocalFileSet for session (" + string + ") :" + filesSystemModifiedInSession);
        }
        return filesSystemModifiedInSession;
    }

    public static synchronized ThreadLocal getThreadLocalFileSet() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getThreadLocalFileSet: " + filesSystemModifiedInSession);
        }
        return filesSystemModifiedInSession;
    }

    public static synchronized void RemoveFileSet(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RemoveFileSet: " + string);
        }
        HashSet hashSet = (HashSet)systemModifiedFilesMap.remove(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed " + hashSet);
            Tr.debug(tc, "Setting filesSystemModifiedInSession to null from " + filesSystemModifiedInSession);
        }
        filesSystemModifiedInSession = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RemoveFileSet");
        }
    }
}

