/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceManagerMBean;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class WorkSpaceManagerImpl
implements WorkSpaceManager,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpaceManagerImpl.class);
    private Map workspaces = Collections.synchronizedMap(new HashMap());
    private Object removeWorkSpacesLock = new Object();
    private boolean init = false;
    private ClassLoader classLoader = null;
    private WorkSpaceManagerMBean mbean = WorkSpaceManagerMBean.getInstance();
    boolean _selfCorrection = true;

    private String getProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        return string2;
    }

    private WorkSpaceImpl createWorkSpace(Properties properties) throws WorkSpaceException {
        boolean bl;
        Object object;
        String string = this.getProperty(properties, "workspace.user.id");
        String string2 = this.getProperty(properties, "workspace.cleanup.disable");
        String string3 = this.getProperty(properties, "workspace.session.id");
        String string4 = this.getProperty(properties, "workspace.user.root");
        String string5 = this.getProperty(properties, "workspace.root");
        String string6 = this.getProperty(properties, "workspace.metadata.root");
        String string7 = this.getProperty(properties, "workspace.repository.adapter");
        FileAccessor fileAccessor = (FileAccessor)properties.get("workspace.file.accessor");
        String string8 = "Call stack info of createWorkSpace(prop), workspace id " + string + ":     " + this.getCallStack();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string8);
        }
        WorkSpaceImpl workSpaceImpl = new WorkSpaceImpl(string);
        this.workspaces.put(string, workSpaceImpl);
        if (string5 != null) {
            workSpaceImpl.setPath(string5);
        } else if (string4 != null) {
            workSpaceImpl.setUserRoot(string4);
        }
        if (fileAccessor == null) {
            object = new File(workSpaceImpl.getPath());
            fileAccessor = new DefaultFileAccessor((File)object);
        }
        if (string2 != null && string2.equals("true")) {
            workSpaceImpl.setDisableCleanup();
        }
        if (fileAccessor != null) {
            workSpaceImpl.setFileAccessor(fileAccessor);
        }
        if (string6 != null) {
            workSpaceImpl.setMetaData(RepositoryMetaDataFactory.getFactory().getMetaData(string6));
        }
        if (string7 == null) {
            string7 = "com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create workspace [WorkSpaceManagerImpl.createWorkSpace(prop)]... \n\t WorkspaceUserPath: " + workSpaceImpl.getUserPath() + "\n\t WorkspacePath ...: " + workSpaceImpl.getPath() + "\n\t repositoryAdapter: " + string7);
        }
        try {
            object = (WorkSpaceRepositoryAdapter)this.getInstanceOfType(string7);
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0019E Error getting repository adapter {0} --{1}", new Object[]{string7, exception}, exception);
        }
        object.initialize(properties);
        if (object instanceof WorkSpaceMasterRepositoryAdapter && (bl = ((WorkSpaceMasterRepositoryAdapter)object).isSelfCorrection()) != this._selfCorrection) {
            this._selfCorrection = bl;
            WorkSpaceLogger.logAudit(tc, "WKSP0500I Workspace configuration consistency check is {0}.", new Object[]{new Boolean(bl)});
        }
        workSpaceImpl.setRepositoryAdapter((WorkSpaceRepositoryAdapter)object);
        workSpaceImpl.setCallerInfo(string8);
        workSpaceImpl.setSessionId(string3);
        workSpaceImpl.restore();
        WorkSpaceManagerImpl workSpaceManagerImpl = this;
        if (workSpaceManagerImpl.mbean.isActive()) {
            this.mbean.workSpaceCreated(workSpaceImpl);
        }
        return workSpaceImpl;
    }

    public WorkSpace getWorkSpace(String string) throws WorkSpaceException {
        return this.getWorkSpace(string, null);
    }

    public WorkSpace getWorkSpace(String string, String string2) throws WorkSpaceException {
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("workspace.user.id", string);
        }
        if (string2 != null) {
            properties.setProperty("workspace.session.id", string2);
        }
        return this.getWorkSpace(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkSpace createUniqueWorkSpace(Properties properties) throws WorkSpaceException {
        String string = properties.getProperty("workspace.user.id");
        String string2 = properties.getProperty("workspace.session.id");
        boolean bl = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpace, UserID: " + string + ", SessionID: " + string2);
        }
        WorkSpaceImpl workSpaceImpl = null;
        Map map = this.workspaces;
        synchronized (map) {
            workSpaceImpl = (WorkSpaceImpl)this.workspaces.get(string);
            if (workSpaceImpl == null) {
                workSpaceImpl = this.createWorkSpace(properties);
            } else if (!workSpaceImpl.isValid()) {
                if (bl) {
                    Tr.debug(tc, "WorkSpace is previously released.");
                }
                workSpaceImpl = this.createWorkSpace(properties);
            } else if (!workSpaceImpl.ofSession(string2) && string2 != null) {
                if (bl) {
                    Tr.debug(tc, "WorkSpace is not previously released.");
                }
                workSpaceImpl.unsetSessionId();
                workSpaceImpl = this.createWorkSpace(properties);
            } else {
                if (bl) {
                    Tr.debug(tc, "The same sessionId share the same WorkSpace.");
                }
                workSpaceImpl = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpace, WS: " + workSpaceImpl);
        }
        return workSpaceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkSpace getWorkSpace(Properties properties) throws WorkSpaceException {
        String string = properties.getProperty("workspace.user.id");
        String string2 = properties.getProperty("workspace.session.id");
        boolean bl = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpace, UserID: " + string + ", SessionID: " + string2);
        }
        WorkSpaceImpl workSpaceImpl = null;
        Map map = this.workspaces;
        synchronized (map) {
            workSpaceImpl = (WorkSpaceImpl)this.workspaces.get(string);
            if (workSpaceImpl == null) {
                workSpaceImpl = this.createWorkSpace(properties);
            } else if (!workSpaceImpl.isValid()) {
                if (bl) {
                    Tr.debug(tc, "WorkSpace is previously released.");
                }
                workSpaceImpl = this.createWorkSpace(properties);
            } else if (!workSpaceImpl.ofSession(string2) && string2 != null) {
                if (bl) {
                    Tr.debug(tc, "WorkSpace is not previously released.");
                }
                workSpaceImpl.unsetSessionId();
                workSpaceImpl = this.createWorkSpace(properties);
            } else if (bl) {
                Tr.debug(tc, "The same sessionId share the same WorkSpace.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpace, WS: " + workSpaceImpl);
        }
        return workSpaceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWorkSpace(String string, String string2) throws WorkSpaceException {
        WorkSpaceImpl workSpaceImpl = null;
        String string3 = "Call stack info of releaseWorkSpace(string, string):     " + this.getCallStack();
        Map map = this.workspaces;
        synchronized (map) {
            workSpaceImpl = (WorkSpaceImpl)this.workspaces.get(string);
        }
        if (workSpaceImpl != null && workSpaceImpl.isValid()) {
            if (workSpaceImpl.ofSession(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "releaseWorkSpace, UserID: " + string + ", SessionID: " + string2 + ", " + string3);
                }
                workSpaceImpl.unsetSessionId();
                map = this.workspaces;
                synchronized (map) {
                    this.workspaces.remove(string);
                }
                WorkSpaceManagerImpl workSpaceManagerImpl = this;
                if (workSpaceManagerImpl.mbean.isActive()) {
                    this.mbean.workSpaceRemoved(string);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "releaseWorkSpace, Wrong SessionID: " + string2);
            }
        }
    }

    public void releaseWorkSpace(String string) throws WorkSpaceException {
        this.releaseWorkSpace(string, null);
    }

    public void removeWorkSpace(String string) throws WorkSpaceException {
        this.removeWorkSpace(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkSpace(String string, String string2) throws WorkSpaceException {
        WorkSpaceImpl workSpaceImpl = null;
        String string3 = "Call stack info of removeWorkSpace(string, string):     " + this.getCallStack();
        Object object = this.removeWorkSpacesLock;
        synchronized (object) {
            workSpaceImpl = (WorkSpaceImpl)this.workspaces.get(string);
        }
        if (workSpaceImpl != null) {
            if (workSpaceImpl.ofSession(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeWorkSpace, UserID: " + string + ", SessionID: " + string2 + " " + string3);
                }
                workSpaceImpl.remove();
                workSpaceImpl.unsetSessionId();
                object = this.workspaces;
                synchronized (object) {
                    this.workspaces.remove(string);
                }
                WorkSpaceManagerImpl workSpaceManagerImpl = this;
                if (workSpaceManagerImpl.mbean.isActive()) {
                    this.mbean.workSpaceRemoved(string);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeWorkSpace, Wrong SessionID: " + string2);
            }
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = ExtClassLoader.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getClassLoader, extClassLoader: " + this.classLoader);
            }
        }
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getClassLoader, contextClassLoader: " + this.classLoader);
            }
        }
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getClassLoader, classLoader: " + this.classLoader);
            }
        }
        return this.classLoader;
    }

    Class getClassOfType(String string) throws Exception {
        Object var2_2 = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClassOfType, className: " + string);
        }
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            return Class.forName(string, true, this.getClassLoader());
        }
    }

    private Object getInstanceOfType(String string) throws Exception {
        Class clazz = this.getClassOfType(string);
        return clazz.newInstance();
    }

    private String getCallStack() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = "";
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = string + "    " + stackTraceElementArray[i] + "\n";
        }
        return string;
    }
}

